/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.reliability2.store;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.naming.NamingException;
import weblogic.kernel.KernelStatus;
import weblogic.store.PersistentStoreException;
import weblogic.wsee.persistence.StoreException;
import weblogic.wsee.reliability2.saf.DestinationSequenceSAFMap;
import weblogic.wsee.reliability2.sequence.DestinationSequence;
import weblogic.wsee.reliability2.store.DestinationSequenceStore;
import weblogic.wsee.reliability2.store.SequenceStore;
import weblogic.wsee.reliability2.store.TimedSequenceMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DestinationSequenceMap
extends TimedSequenceMap<DestinationSequence> {
    private DestinationSequenceSAFMap _safMap = KernelStatus.isServer() ? new DestinationSequenceSAFMap() : null;

    @Override
    protected SequenceStore<DestinationSequence> getOrCreateSequenceStore(String string) throws StoreException {
        return DestinationSequenceStore.getOrCreateStore(string, this);
    }

    @Override
    public int size() {
        int n = super.size();
        if (this._safMap != null) {
            n += this._safMap.size();
        }
        return n;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean containsKey(Object object) {
        return super.containsKey(object) || this._safMap != null && this._safMap.containsKey(object);
    }

    @Override
    public boolean containsValue(Object object) {
        if (super.containsValue(object)) {
            return true;
        }
        throw new IllegalStateException("Not supported");
    }

    @Override
    public DestinationSequence get(Object object) {
        if (!(object instanceof String)) {
            return null;
        }
        String string = (String)object;
        if (super.containsKey(string)) {
            return (DestinationSequence)super.get(string);
        }
        if (this._safMap == null) {
            return null;
        }
        return this._safMap.get(string);
    }

    @Override
    protected DestinationSequence internalPut(String string, DestinationSequence destinationSequence, SequenceStore<DestinationSequence> sequenceStore) {
        if (destinationSequence.isNonBuffered()) {
            return super.internalPut(string, destinationSequence, sequenceStore);
        }
        if (this._safMap == null) {
            throw new IllegalStateException("Persistent DestinationSequence detected, but SAF is not available");
        }
        String string2 = sequenceStore.getNextPhysicalStoreName();
        destinationSequence.setPhysicalStoreName(string2);
        return this._safMap.put(string, destinationSequence);
    }

    @Override
    public boolean startupSequence(DestinationSequence destinationSequence) {
        if (destinationSequence.isNonBuffered()) {
            return super.startupSequence(destinationSequence);
        }
        destinationSequence.startup();
        return true;
    }

    @Override
    public boolean shutdownSequence(DestinationSequence destinationSequence) {
        if (destinationSequence != null) {
            if (destinationSequence.isNonBuffered()) {
                return super.shutdownSequence(destinationSequence);
            }
            destinationSequence.shutdown();
            return true;
        }
        return super.shutdownSequence(destinationSequence);
    }

    @Override
    public DestinationSequence remove(Object object) {
        String string = (String)object;
        DestinationSequence destinationSequence = this.get(string);
        if (destinationSequence != null && !destinationSequence.isNonBuffered()) {
            return this._safMap.remove(object);
        }
        return (DestinationSequence)super.remove(object);
    }

    @Override
    public void putAll(Map<? extends String, ? extends DestinationSequence> map) {
        throw new IllegalStateException("Not supported");
    }

    @Override
    public void clear() {
        throw new IllegalStateException("Not supported");
    }

    @Override
    public Set<String> keySet() {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.addAll(super.keySet());
        if (this._safMap != null) {
            hashSet.addAll(this._safMap.keySet());
        }
        return hashSet;
    }

    @Override
    public Collection<DestinationSequence> values() {
        Set<String> set = this.keySet();
        ArrayList<DestinationSequence> arrayList = new ArrayList<DestinationSequence>(set.size());
        for (String string : set) {
            DestinationSequence destinationSequence = this.get(string);
            if (destinationSequence == null) continue;
            arrayList.add(destinationSequence);
        }
        return arrayList;
    }

    @Override
    public Set<Map.Entry<String, DestinationSequence>> entrySet() {
        throw new IllegalStateException("Not supported");
    }
}

