/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.reliability2.store;

import com.sun.xml.ws.api.message.Message;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import weblogic.wsee.reliability2.api.ReliabilityErrorContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReliabilityErrorContextImpl
implements ReliabilityErrorContext {
    private boolean _requestSpecific;
    private String _operationName;
    private Message _message;
    private List<Throwable> _faults;
    private String _faultSummaryMessage;
    private Map<String, Serializable> _userRequestContextProperties;

    public ReliabilityErrorContextImpl(boolean bl, String string, Message message, List<Throwable> list, String string2, Map<String, Serializable> map) {
        this._requestSpecific = bl;
        this._operationName = string;
        this._message = message;
        this._faults = list;
        this._faultSummaryMessage = string2;
        this._userRequestContextProperties = map;
    }

    @Override
    public boolean isRequestSpecific() {
        return this._requestSpecific;
    }

    @Override
    public String getOperationName() {
        this.verifyRequestSpecific();
        return this._operationName;
    }

    private void verifyRequestSpecific() {
        if (!this._requestSpecific) {
            throw new IllegalStateException("Not request specific");
        }
    }

    @Override
    public XMLStreamReader getRequestStreamReader() throws XMLStreamException {
        this.verifyRequestSpecific();
        return this._message.readPayload();
    }

    @Override
    public <T> T getRequest(JAXBContext jAXBContext, Class<T> clazz) throws JAXBException, XMLStreamException {
        this.verifyRequestSpecific();
        Unmarshaller unmarshaller = jAXBContext.createUnmarshaller();
        XMLStreamReader xMLStreamReader = this._message.readPayload();
        return (T)unmarshaller.unmarshal(xMLStreamReader, clazz).getValue();
    }

    @Override
    public List<Throwable> getFaults() {
        return this._faults;
    }

    @Override
    public String getFaultSummaryMessage() {
        return this._faultSummaryMessage;
    }

    @Override
    public Map<String, Serializable> getUserRequestContextProperties() {
        return this._userRequestContextProperties;
    }
}

