/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.reliability2.store;

import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import weblogic.management.configuration.WebServiceLogicalStoreMBean;
import weblogic.management.configuration.WebServiceMBean;
import weblogic.management.configuration.WebServicePersistenceMBean;
import weblogic.wsee.WseeRmLogger;
import weblogic.wsee.config.WebServiceMBeanFactory;
import weblogic.wsee.persistence.LogicalStore;
import weblogic.wsee.persistence.LogicalStoreListChangeListener;
import weblogic.wsee.persistence.Storable;
import weblogic.wsee.persistence.StoreException;
import weblogic.wsee.reliability2.sequence.Sequence;
import weblogic.wsee.reliability2.store.SequenceStore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SequenceMap<S extends Sequence>
implements Map<String, S> {
    private static final Logger LOGGER = Logger.getLogger(SequenceMap.class.getName());
    private ReentrantReadWriteLock _storesLock = new ReentrantReadWriteLock(false);
    private List<SequenceStore<S>> _stores = new ArrayList<SequenceStore<S>>();
    private PropertyChangeListener _sequenceListener;

    public void setSequenceListener(PropertyChangeListener propertyChangeListener) {
        this._sequenceListener = propertyChangeListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getLogicalStoreNames() {
        try {
            this._storesLock.readLock().lock();
            HashSet<String> hashSet = new HashSet<String>();
            for (SequenceStore<S> sequenceStore : this._stores) {
                hashSet.add(sequenceStore.getName());
            }
            HashSet<String> hashSet2 = hashSet;
            return hashSet2;
        }
        finally {
            this._storesLock.readLock().unlock();
        }
    }

    protected abstract SequenceStore<S> getOrCreateSequenceStore(String var1) throws StoreException;

    public void recover() throws StoreException {
        WebServiceLogicalStoreMBean[] webServiceLogicalStoreMBeanArray;
        WebServiceMBean webServiceMBean = WebServiceMBeanFactory.getInstance();
        WebServicePersistenceMBean webServicePersistenceMBean = webServiceMBean.getWebServicePersistence();
        for (WebServiceLogicalStoreMBean webServiceLogicalStoreMBean : webServiceLogicalStoreMBeanArray = webServicePersistenceMBean.getWebServiceLogicalStores()) {
            this.handleLogicalStoreAdded(webServiceLogicalStoreMBean.getName());
        }
        LogicalStore.addLogicalStoreListChangeListener(new LogicalStoreListChangeListener(){

            public void logicalStoreAdded(String string) {
                try {
                    SequenceMap.this.handleLogicalStoreAdded(string);
                }
                catch (Exception exception) {
                    WseeRmLogger.logUnexpectedException((String)exception.toString(), (Throwable)exception);
                }
            }

            public void logicalStorePreRemoval(String string) {
                try {
                    SequenceMap.this.handleLogicalStorePreRemoval(string);
                }
                catch (Exception exception) {
                    WseeRmLogger.logUnexpectedException((String)exception.toString(), (Throwable)exception);
                }
            }

            public void logicalStoreRemoved(String string) {
                try {
                    SequenceMap.this.handleLogicalStoreRemoved(string);
                }
                catch (Exception exception) {
                    WseeRmLogger.logUnexpectedException((String)exception.toString(), (Throwable)exception);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleLogicalStoreAdded(String string) throws StoreException {
        try {
            this._storesLock.writeLock().lock();
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("SequenceMap handling newly added logical store: " + string);
            }
            SequenceStore<S> sequenceStore = this.getOrCreateSequenceStore(string);
            this._stores.add(sequenceStore);
            if (LOGGER.isLoggable(Level.FINE)) {
                this.dumpLogicalStoreNames("Added");
                this.dumpSequences();
            }
        }
        finally {
            this._storesLock.writeLock().unlock();
        }
    }

    protected void handleLogicalStorePreRemoval(String string) throws StoreException {
        SequenceStore<S> sequenceStore;
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Handling pre-removal tasks for logical store: " + string);
        }
        if ((sequenceStore = this.getOrCreateSequenceStore(string)) != null) {
            String[] stringArray;
            Set set = sequenceStore.keySet();
            for (String string2 : stringArray = set.toArray(new String[set.size()])) {
                sequenceStore.remove(string2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleLogicalStoreRemoved(String string) throws StoreException {
        try {
            this._storesLock.writeLock().lock();
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("SequenceMap handling newly removed logical store: " + string);
            }
            SequenceStore<S> sequenceStore = null;
            for (SequenceStore<S> sequenceStore2 : this._stores) {
                if (!sequenceStore2.getName().equals(string)) continue;
                sequenceStore = sequenceStore2;
                break;
            }
            if (sequenceStore != null) {
                this._stores.remove(sequenceStore);
            }
            if (LOGGER.isLoggable(Level.FINE)) {
                this.dumpLogicalStoreNames("Removed");
                this.dumpSequences();
            }
        }
        finally {
            this._storesLock.writeLock().unlock();
        }
    }

    private void dumpLogicalStoreNames(String string) {
        Set<String> set = this.getLogicalStoreNames();
        StringBuffer stringBuffer = new StringBuffer();
        for (String string2 : set) {
            stringBuffer.append(string2).append(", ");
        }
        LOGGER.fine("SequenceMap " + this + " has these logical stores after one was " + string + ": " + stringBuffer.toString());
    }

    private void dumpSequences() {
        if (LOGGER.isLoggable(Level.FINER)) {
            Set<String> set = this.keySet();
            StringBuffer stringBuffer = new StringBuffer();
            for (String string : set) {
                Object object = this.get(string);
                if (object == null) continue;
                stringBuffer.append("   ").append(object.getClass().getSimpleName()).append(": ").append(string).append(" - ").append(((Sequence)object).getLogicalStoreName()).append("\n");
            }
            LOGGER.finer("Current " + this + " Sequences:\n" + stringBuffer.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finalize() throws Throwable {
        Exception exception = null;
        try {
            this._storesLock.writeLock().lock();
            for (SequenceStore<S> sequenceStore : this._stores) {
                try {
                    sequenceStore.close();
                }
                catch (Exception exception2) {
                    exception = exception2;
                }
            }
        }
        finally {
            this._storesLock.writeLock().unlock();
        }
        super.finalize();
        if (exception != null) {
            throw exception;
        }
    }

    public SequenceStore<S> getSequenceStoreForSequence(S s) {
        String string = ((Sequence)s).getLogicalStoreName();
        if (string == null) {
            throw new IllegalStateException("Sequence with ID " + ((Sequence)s).getId() + " didn't have a logical store name assigned to it!");
        }
        try {
            this._storesLock.readLock().lock();
            for (SequenceStore<S> sequenceStore : this._stores) {
                if (!sequenceStore.getName().equals(string)) continue;
                SequenceStore<S> sequenceStore2 = sequenceStore;
                return sequenceStore2;
            }
            throw new IllegalStateException("Sequence with ID " + ((Sequence)s).getId() + " refers to a logical store name for which we have no associated physical store: " + string);
        }
        finally {
            this._storesLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        int n = 0;
        try {
            this._storesLock.readLock().lock();
            for (SequenceStore<S> sequenceStore : this._stores) {
                n += sequenceStore.size();
            }
            int n2 = n;
            return n2;
        }
        finally {
            this._storesLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isEmpty() {
        try {
            this._storesLock.readLock().lock();
            for (SequenceStore<S> sequenceStore : this._stores) {
                if (!sequenceStore.isEmpty()) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this._storesLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsKey(Object object) {
        try {
            this._storesLock.readLock().lock();
            for (SequenceStore<S> sequenceStore : this._stores) {
                if (!sequenceStore.containsKey(object)) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this._storesLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsValue(Object object) {
        try {
            this._storesLock.readLock().lock();
            for (SequenceStore<S> sequenceStore : this._stores) {
                if (!sequenceStore.containsValue(object)) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this._storesLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public S get(Object object) {
        try {
            this._storesLock.readLock().lock();
            for (SequenceStore<S> sequenceStore : this._stores) {
                String string;
                if (!sequenceStore.containsKey(string = (String)object)) continue;
                Storable storable = sequenceStore.get(object);
                return (S)storable;
            }
            Iterator<SequenceStore<S>> iterator = null;
            return (S)iterator;
        }
        finally {
            this._storesLock.readLock().unlock();
        }
    }

    @Override
    public S put(String string, S s) {
        boolean bl;
        SequenceStore<S> sequenceStore = this.getSequenceStoreForSequence(s);
        Object object = this.get(string);
        boolean bl2 = bl = object == null;
        if (bl) {
            this.adding(s);
        } else {
            this.updating(s);
        }
        this.internalPut(string, s, sequenceStore);
        if (bl) {
            this.added(s);
        } else {
            this.updated(s, object);
        }
        if (((Sequence)s).isNonBuffered()) {
            ((Sequence)s).getAndClearPendingRequests();
        }
        return (S)object;
    }

    protected S internalPut(String string, S s, SequenceStore<S> sequenceStore) {
        return sequenceStore.put(string, s);
    }

    protected void adding(S s) {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Adding " + s);
        }
    }

    protected void added(S s) {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Added " + s);
        }
        this.startupSequence(s);
    }

    protected void updating(S s) {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Updating " + s);
        }
    }

    protected void updated(S s, S s2) {
        if (s2 != s) {
            ((Sequence)s2).setMasterInstance(false);
            ((Sequence)s).setMasterInstance(true);
            ((Sequence)s).copyPropertyChangeListeners((Sequence)s2);
        } else if (!((Sequence)s).isMasterInstance()) {
            ((Sequence)s).setMasterInstance(true);
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Updated " + s);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public S remove(Object object) {
        Object object2 = this.get(object);
        if (object2 == null) {
            return (S)object2;
        }
        this.removing(object2);
        try {
            this._storesLock.readLock().lock();
            for (SequenceStore<S> sequenceStore : this._stores) {
                String string;
                if (!sequenceStore.containsKey(string = (String)object)) continue;
                sequenceStore.remove(object);
                break;
            }
        }
        finally {
            this._storesLock.readLock().unlock();
        }
        this.removed(object2);
        return (S)object2;
    }

    protected void removing(S s) {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Removing " + s);
        }
        this.shutdownSequence(s);
        ((Sequence)s).destroy();
    }

    protected void removed(S s) {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Removed " + s);
        }
    }

    boolean startupSequence(S s) {
        if (s != null) {
            ((Sequence)s).setMasterInstance(true);
            if (this._sequenceListener != null) {
                ((Sequence)s).addPropertyChangeListener(this._sequenceListener);
            }
            ((Sequence)s).startup();
            return true;
        }
        return false;
    }

    boolean shutdownSequence(S s) {
        if (s != null) {
            ((Sequence)s).shutdown();
            if (this._sequenceListener != null) {
                ((Sequence)s).removePropertyChangeListener(this._sequenceListener);
            }
            ((Sequence)s).setMasterInstance(false);
            return true;
        }
        return false;
    }

    @Override
    public void putAll(Map<? extends String, ? extends S> map) {
        for (String string : map.keySet()) {
            Sequence sequence = (Sequence)map.get(string);
            this.put(string, (S)sequence);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        try {
            this._storesLock.readLock().lock();
            for (SequenceStore<S> sequenceStore : this._stores) {
                sequenceStore.clear();
            }
        }
        finally {
            this._storesLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<String> keySet() {
        try {
            this._storesLock.readLock().lock();
            HashSet hashSet = new HashSet();
            for (SequenceStore<S> sequenceStore : this._stores) {
                hashSet.addAll(sequenceStore.keySet());
            }
            HashSet hashSet2 = hashSet;
            return hashSet2;
        }
        finally {
            this._storesLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<S> values() {
        try {
            this._storesLock.readLock().lock();
            LinkedList linkedList = new LinkedList();
            for (SequenceStore<S> sequenceStore : this._stores) {
                linkedList.addAll(sequenceStore.values());
            }
            LinkedList linkedList2 = linkedList;
            return linkedList2;
        }
        finally {
            this._storesLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<Map.Entry<String, S>> entrySet() {
        try {
            this._storesLock.readLock().lock();
            HashSet hashSet = new HashSet();
            for (SequenceStore<S> sequenceStore : this._stores) {
                hashSet.addAll(sequenceStore.entrySet());
            }
            HashSet hashSet2 = hashSet;
            return hashSet2;
        }
        finally {
            this._storesLock.readLock().unlock();
        }
    }
}

