/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.reliability2.store;

import java.util.logging.Level;
import java.util.logging.Logger;
import weblogic.wsee.jaxws.framework.WsUtil;
import weblogic.wsee.persistence.LogicalStore;
import weblogic.wsee.persistence.StoreConnection;
import weblogic.wsee.persistence.StoreException;
import weblogic.wsee.reliability2.sequence.Sequence;
import weblogic.wsee.reliability2.store.SequenceMap;
import weblogic.wsee.reliability2.store.SequenceStoreConnection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SequenceStore<S extends Sequence>
extends LogicalStore<String, S> {
    private static final Logger LOGGER = Logger.getLogger(SequenceStore.class.getName());
    private SequenceMap<S> _parentMap;

    protected SequenceStore() {
    }

    void setParentMap(SequenceMap<S> sequenceMap) {
        this._parentMap = sequenceMap;
    }

    protected SequenceStore(String string, String string2) throws StoreException {
        this(string, string2, true);
    }

    protected SequenceStore(String string, String string2, boolean bl) throws StoreException {
        super(string, string2, bl);
    }

    public SequenceStoreConnection createStoreConnection(String string, String string2) throws StoreException {
        return new SequenceStoreConnection(this.getName(), string, string2);
    }

    @Override
    public boolean addPhysicalStore(String string) throws StoreException {
        if (super.addPhysicalStore(string) && this._parentMap != null) {
            return this.addPhysicalStoreToParentMap(string);
        }
        return false;
    }

    private boolean addPhysicalStoreToParentMap(String string) {
        StoreConnection storeConnection = this.getStoreConnectionInternal(string);
        if (storeConnection == null) {
            return false;
        }
        for (String string2 : storeConnection.keySet()) {
            Sequence sequence = (Sequence)storeConnection.get(string2);
            if (this._parentMap.get(sequence.getId()) == null) continue;
            this._parentMap.startupSequence(sequence);
        }
        return true;
    }

    @Override
    public StoreConnection<String, S> removePhysicalStore(String string) throws StoreException {
        StoreConnection storeConnection;
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("RM SequenceStore '" + this.getName() + "' Removing physical store '" + string + "'");
        }
        if ((storeConnection = this.getStoreConnectionInternal(string)) == null) {
            return storeConnection;
        }
        for (String string2 : storeConnection.keySet()) {
            Object object = this._parentMap.get(string2);
            if (object == null) continue;
            this._parentMap.shutdownSequence(object);
        }
        return super.removePhysicalStore(string);
    }

    @Override
    public S get(Object object) {
        return (S)((Sequence)super.get(object));
    }

    @Override
    public S put(String string, S s) {
        if (string == null) {
            String string2 = this.getNextPhysicalStoreName();
            string = WsUtil.generateRoutableUUID(string2);
            ((Sequence)s).setId(string);
            ((Sequence)s).setPhysicalStoreName(string2);
        }
        return (S)((Sequence)super.put(string, s));
    }

    @Override
    public S remove(Object object) {
        Sequence sequence = (Sequence)super.remove(object);
        if (sequence != null) {
            sequence.destroy();
        }
        return (S)sequence;
    }
}

