/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.reliability2.store;

import com.sun.xml.ws.api.message.Packet;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.security.AccessController;
import java.util.Arrays;
import java.util.List;
import java.util.SortedSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.security.service.SecurityServiceManager;
import weblogic.wsee.WseeRmLogger;
import weblogic.wsee.jaxws.framework.WsUtil;
import weblogic.wsee.persistence.StoreException;
import weblogic.wsee.reliability.MessageRange;
import weblogic.wsee.reliability2.api.SequenceState;
import weblogic.wsee.reliability2.sequence.SourceMessageInfo;
import weblogic.wsee.reliability2.sequence.SourceSequence;
import weblogic.wsee.reliability2.store.SequenceStore;
import weblogic.wsee.reliability2.store.SourceSequenceSendRequest;
import weblogic.wsee.reliability2.store.SourceSequenceSenderFactory;
import weblogic.wsee.reliability2.store.SourceSequenceStore;
import weblogic.wsee.reliability2.store.TimedSequenceMap;
import weblogic.wsee.sender.api.ConversationNotFoundException;
import weblogic.wsee.sender.api.ConversationOptions;
import weblogic.wsee.sender.api.ConversationStatusCallback;
import weblogic.wsee.sender.api.Preferences;
import weblogic.wsee.sender.api.Resources;
import weblogic.wsee.sender.api.SendingService;
import weblogic.wsee.sender.api.SendingServiceException;
import weblogic.wsee.sender.api.SendingServiceFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SourceSequenceMap
extends TimedSequenceMap<SourceSequence> {
    private static final Logger LOGGER = Logger.getLogger(SourceSequenceMap.class.getName());
    private SourceSequenceSenderFactory _senderFactory = new SourceSequenceSenderFactory(this);
    private static final AuthenticatedSubject KERNEL_ID = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());

    @Override
    public void setSequenceTimerListener(TimedSequenceMap.SequenceTimerListener sequenceTimerListener) {
        super.setSequenceTimerListener(new SequenceTimerListenerWrapper(sequenceTimerListener));
    }

    @Override
    protected SequenceStore<SourceSequence> getOrCreateSequenceStore(String string) throws StoreException {
        return SourceSequenceStore.getOrCreateStore(string, this);
    }

    @Override
    protected void added(SourceSequence sourceSequence) {
        super.added(sourceSequence);
        if (sourceSequence.isNonBuffered()) {
            return;
        }
        try {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Adding new conversation " + sourceSequence.getId() + " to sender");
            }
            this.addOrContinueConversationForSequence(sourceSequence, true);
            this.updateConversationForSequence(sourceSequence);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.toString(), exception);
        }
    }

    @Override
    boolean startupSequence(SourceSequence sourceSequence) {
        super.startupSequence(sourceSequence);
        sourceSequence.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getPropertyName().equals("State") && propertyChangeEvent.getOldValue() == SequenceState.CREATING && propertyChangeEvent.getNewValue() == SequenceState.CREATED && SourceSequenceMap.this._senderFactory != null) {
                    SourceSequence sourceSequence = (SourceSequence)propertyChangeEvent.getSource();
                    SourceSequenceMap.this._senderFactory.sequenceCreated(sourceSequence.getId());
                }
            }
        });
        if (sourceSequence.isNonBuffered()) {
            return true;
        }
        try {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Continuing conversation " + sourceSequence.getId() + " with sender");
            }
            this.addOrContinueConversationForSequence(sourceSequence, false);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.toString(), exception);
        }
        return true;
    }

    @Override
    protected void updated(SourceSequence sourceSequence, SourceSequence sourceSequence2) {
        super.updated(sourceSequence, sourceSequence2);
        if (sourceSequence.isNonBuffered()) {
            return;
        }
        try {
            this.updateConversationForSequence(sourceSequence);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.toString(), exception);
        }
    }

    private static AuthenticatedSubject getCurrentSubject() {
        AuthenticatedSubject authenticatedSubject = SecurityServiceManager.getCurrentSubject((AuthenticatedSubject)KERNEL_ID);
        return authenticatedSubject;
    }

    private void updateConversationForSequence(SourceSequence sourceSequence) throws SendingServiceException {
        if (SecurityServiceManager.isKernelIdentity((AuthenticatedSubject)SourceSequenceMap.getCurrentSubject())) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Bypassing update of sender conversation : " + sourceSequence.getId() + " destination Id: " + sourceSequence.getDestinationId() + " because we were invoked from a system thread, not a user thread. Only user threads can update the sender conversation.");
            }
            return;
        }
        if (SequenceState.isTerminalState(sourceSequence.getState())) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Bypassing update of sender conversation : " + sourceSequence.getId() + " destination Id: " + sourceSequence.getDestinationId() + " because it is in a terminal state: " + (Object)((Object)sourceSequence.getState()));
            }
            return;
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Updating current ack ranges to sender conversation : " + sourceSequence.getId() + " destination Id: " + sourceSequence.getDestinationId());
        }
        this.handleCurrentAckRanges(sourceSequence);
        List list = sourceSequence.getAndClearPendingRequests();
        if (SequenceState.isTerminalState(sourceSequence.getState())) {
            if (list.size() > 0 && LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Rejecting " + list.size() + " pending requests for sender conversation : " + sourceSequence.getId() + " destination Id: " + sourceSequence.getDestinationId() + " because the sequence is in a terminal state: " + (Object)((Object)sourceSequence.getState()));
            }
        } else {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Adding pending requests to sender conversation : " + sourceSequence.getId() + " destination Id: " + sourceSequence.getDestinationId());
            }
            for (SourceMessageInfo sourceMessageInfo : list) {
                Packet packet = sourceMessageInfo.getRequestPacket();
                if (packet == null) continue;
                this.storeSendRequest(sourceSequence, sourceMessageInfo);
            }
        }
    }

    private void addOrContinueConversationForSequence(SourceSequence sourceSequence, boolean bl) throws SendingServiceException {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine((bl ? "Adding" : "Continuing") + " conversation " + sourceSequence + " with sender");
        }
        SendingService sendingService = this.getSendingServiceForSequence(sourceSequence);
        ConversationOptions conversationOptions = new ConversationOptions();
        conversationOptions.setBaseRetransmissionInterval(sourceSequence.getBaseRetransmissionInterval());
        conversationOptions.setExpires(sourceSequence.getExpires());
        conversationOptions.setExponentialBackoffEnabled(sourceSequence.isExponentialBackoffEnabled());
        conversationOptions.setIdleTimeout(sourceSequence.getIdleTimeout());
        conversationOptions.setInOrder(sourceSequence.getDeliveryAssurance().isInOrder());
        Resources resources = new Resources(this._senderFactory, conversationOptions);
        try {
            boolean bl2 = sendingService.conversationExists(sourceSequence.getId());
            if (bl) {
                if (!bl2) {
                    sendingService.addConversation(sourceSequence.getId(), resources);
                } else {
                    sendingService.continueConversation(sourceSequence.getId(), resources);
                }
            } else if (!bl2) {
                sendingService.continueConversation(sourceSequence.getId(), resources);
            }
        }
        catch (Throwable throwable) {
            try {
                ConversationStatusCallback conversationStatusCallback = resources.getSenderFactory().getStatusCallback(sourceSequence.getId());
                if (conversationStatusCallback != null) {
                    conversationStatusCallback.conversationNotStarted(sourceSequence.getId(), Arrays.asList(throwable));
                } else {
                    if (LOGGER.isLoggable(Level.INFO)) {
                        LOGGER.log(Level.INFO, throwable.toString(), throwable);
                    }
                    WseeRmLogger.logUnexpectedException((String)throwable.toString(), (Throwable)throwable);
                }
            }
            catch (Throwable throwable2) {
                if (LOGGER.isLoggable(Level.INFO)) {
                    LOGGER.log(Level.INFO, throwable.toString(), throwable);
                }
                WseeRmLogger.logUnexpectedException((String)throwable.toString(), (Throwable)throwable2);
            }
        }
    }

    @Override
    boolean shutdownSequence(SourceSequence sourceSequence) {
        block5: {
            if (sourceSequence != null && !sourceSequence.isNonBuffered()) {
                try {
                    SendingService sendingService = this.getSendingServiceForSequence(sourceSequence);
                    sendingService.stopConversation(sourceSequence.getId());
                }
                catch (SendingServiceException sendingServiceException) {
                    boolean bl = false;
                    if (WsUtil.hasRootCause(sendingServiceException, ConversationNotFoundException.class) && SequenceState.isTerminalState(sourceSequence.getState())) {
                        if (LOGGER.isLoggable(Level.FINE)) {
                            LOGGER.fine("Ignoring failure to find conversation during stop of sender conversation: " + sourceSequence.getId() + " destination Id: " + sourceSequence.getDestinationId() + " because it is in a terminal state: " + (Object)((Object)sourceSequence.getState()));
                        }
                        bl = true;
                    }
                    if (bl) break block5;
                    WseeRmLogger.logUnexpectedException((String)sendingServiceException.toString(), (Throwable)sendingServiceException);
                }
            }
        }
        return super.shutdownSequence(sourceSequence);
    }

    private void storeSendRequest(SourceSequence sourceSequence, SourceMessageInfo sourceMessageInfo) throws SendingServiceException {
        if (sourceSequence.getEndpointEpr() == null || sourceSequence.getEndpointEpr().isAnonymous()) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Bypassing buffering of request message " + sourceMessageInfo.getMessageNum() + " msgId " + sourceMessageInfo.getMessageId() + " because it has a null endpoint/to address");
            }
            return;
        }
        SendingService sendingService = this.getSendingServiceForSequence(sourceSequence);
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Storing request message " + sourceMessageInfo.getMessageNum() + " as SendRequest on conversation: " + sourceSequence.getId() + " destination Id: " + sourceSequence.getDestinationId() + " message Id: " + sourceMessageInfo.getMessageId());
        }
        if (LOGGER.isLoggable(Level.WARNING) && (sourceMessageInfo.getRequestPacket() == null || sourceMessageInfo.getRequestPacket().getMessage() == null)) {
            LOGGER.warning("Storing null/empty request message " + sourceMessageInfo.getMessageNum() + " as SendRequest on conversation: " + sourceSequence.getId() + " destination Id: " + sourceSequence.getDestinationId() + " message Id: " + sourceMessageInfo.getMessageId());
        }
        SourceSequenceSendRequest sourceSequenceSendRequest = new SourceSequenceSendRequest(sourceMessageInfo);
        sendingService.addRequest(sourceSequence.getId(), sourceSequenceSendRequest);
    }

    private SendingService getSendingServiceForSequence(SourceSequence sourceSequence) throws SendingServiceException {
        Preferences preferences = new Preferences();
        preferences.setLogicalStoreName(sourceSequence.getLogicalStoreName());
        return SendingServiceFactory.getSendingService(preferences);
    }

    private void handleCurrentAckRanges(SourceSequence sourceSequence) throws SendingServiceException {
        SendingService sendingService = this.getSendingServiceForSequence(sourceSequence);
        SortedSet<MessageRange> sortedSet = sourceSequence.getAckRanges();
        for (MessageRange messageRange : sortedSet) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Ack'ing requests " + messageRange.lowerBounds + "->" + messageRange.upperBounds + " on conversation " + sourceSequence.getId() + " with sender");
            }
            sendingService.acknowledgeRequests(sourceSequence.getId(), messageRange.lowerBounds, messageRange.upperBounds);
        }
    }

    private class SequenceTimerListenerWrapper
    implements TimedSequenceMap.SequenceTimerListener {
        private TimedSequenceMap.SequenceTimerListener _listener;

        private SequenceTimerListenerWrapper(TimedSequenceMap.SequenceTimerListener sequenceTimerListener) {
            this._listener = sequenceTimerListener;
        }

        public void sequenceExpiration(String string) {
            SourceSequence sourceSequence = (SourceSequence)SourceSequenceMap.this.get(string);
            this._listener.sequenceExpiration(string);
            this.notifySequenceTerminated(sourceSequence);
        }

        public void idleTimeout(String string) {
            SourceSequence sourceSequence = (SourceSequence)SourceSequenceMap.this.get(string);
            this._listener.sequenceExpiration(string);
            this.notifySequenceTerminated(sourceSequence);
        }

        private void notifySequenceTerminated(SourceSequence sourceSequence) {
            block5: {
                if (sourceSequence == null) {
                    return;
                }
                try {
                    SendingService sendingService = SourceSequenceMap.this.getSendingServiceForSequence(sourceSequence);
                    sendingService.cancelConversation(sourceSequence.getId());
                }
                catch (SendingServiceException sendingServiceException) {
                    boolean bl = false;
                    if (WsUtil.hasRootCause(sendingServiceException, ConversationNotFoundException.class)) {
                        if (LOGGER.isLoggable(Level.FINE)) {
                            LOGGER.fine("Ignoring failure to find conversation during cancel of sender conversation: " + sourceSequence.getId() + " destination Id: " + sourceSequence.getDestinationId() + " because it is in a terminal state: " + (Object)((Object)sourceSequence.getState()));
                        }
                        bl = true;
                    }
                    if (bl) break block5;
                    WseeRmLogger.logUnexpectedException((String)sendingServiceException.toString(), (Throwable)sendingServiceException);
                }
            }
        }
    }
}

