/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.reliability2.store;

import com.sun.xml.ws.api.message.Packet;
import java.io.Serializable;
import weblogic.wsee.WseeRmLogger;
import weblogic.wsee.jaxws.persistence.PersistentMessage;
import weblogic.wsee.jaxws.persistence.PersistentMessageFactory;
import weblogic.wsee.reliability.WsrmConstants;
import weblogic.wsee.reliability2.sequence.SourceMessageInfo;
import weblogic.wsee.reliability2.sequence.SourceSequence;
import weblogic.wsee.reliability2.sequence.SourceSequenceManager;
import weblogic.wsee.sender.api.AbstractSendRequest;

public class SourceSequenceSendRequest
extends AbstractSendRequest {
    private static final long serialVersionUID = 1L;
    private SourceMessageInfo _msgInfo;
    private PersistentMessage _payload;

    public SourceSequenceSendRequest(SourceMessageInfo sourceMessageInfo) {
        super((Serializable)((Object)sourceMessageInfo.getMessageId()));
        this._msgInfo = sourceMessageInfo;
        this.createPayload();
    }

    private void createPayload() {
        Packet packet = this._msgInfo.getRequestPacket();
        this._payload = PersistentMessageFactory.getInstance().createMessageFromPacket(this._msgInfo.getMessageId(), packet);
    }

    public String getConversationName() {
        return this._msgInfo.getSequenceId();
    }

    public void setConversationName(String string) {
    }

    public long getSequenceNumber() {
        return this._msgInfo.getMessageNum();
    }

    public void setSequenceNumber(long l) {
    }

    public long getTimestamp() {
        return this._msgInfo.getTimestamp();
    }

    public void setTimestamp(long l) {
    }

    public Serializable getPayload() {
        return this._payload;
    }

    public String getMessageId() {
        return this._msgInfo.getMessageId();
    }

    public String getObjectId() {
        return this.getMessageId();
    }

    public boolean hasExplicitExpiration() {
        SourceSequence sourceSequence = this.getSequence();
        return sourceSequence == null || sourceSequence.hasExplicitExpiration();
    }

    private SourceSequence getSequence() {
        try {
            return SourceSequenceManager.getInstance().getSequence(WsrmConstants.RMVersion.RM_11, this._msgInfo.getSequenceId(), true);
        }
        catch (Exception exception) {
            WseeRmLogger.logUnexpectedException((String)exception.toString(), (Throwable)exception);
            throw new RuntimeException(exception.toString(), exception);
        }
    }

    public boolean isExpired() {
        SourceSequence sourceSequence = this.getSequence();
        return sourceSequence == null || sourceSequence.isExpired();
    }

    public SourceMessageInfo getMsgInfo() {
        return this._msgInfo;
    }
}

