/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.reliability2.store;

import com.sun.xml.ws.api.message.Header;
import com.sun.xml.ws.api.message.Message;
import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.api.pipe.Fiber;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFault;
import javax.xml.soap.SOAPMessage;
import javax.xml.ws.AsyncHandler;
import javax.xml.ws.Dispatch;
import javax.xml.ws.Response;
import javax.xml.ws.Service;
import javax.xml.ws.soap.SOAPFaultException;
import weblogic.wsee.WseeRmLogger;
import weblogic.wsee.jaxws.persistence.PersistentMessage;
import weblogic.wsee.jaxws.persistence.PersistentMessageFactory;
import weblogic.wsee.jaxws.tubeline.TubelineSpliceFactory;
import weblogic.wsee.reliability.headers.SequenceHeader;
import weblogic.wsee.reliability2.api.ReliabilityErrorContext;
import weblogic.wsee.reliability2.api.ReliabilityErrorListener;
import weblogic.wsee.reliability2.api.SequenceState;
import weblogic.wsee.reliability2.api_internal.WsrmLifecycleEvent;
import weblogic.wsee.reliability2.api_internal.WsrmLifecycleEventListenerRegistry;
import weblogic.wsee.reliability2.exception.WsrmException;
import weblogic.wsee.reliability2.exception.WsrmExceptionUtil;
import weblogic.wsee.reliability2.headers.WsrmHeaderFactory;
import weblogic.wsee.reliability2.property.WsrmPropertyBag;
import weblogic.wsee.reliability2.sequence.SourceMessageInfo;
import weblogic.wsee.reliability2.sequence.SourceOfferSequence;
import weblogic.wsee.reliability2.sequence.SourceSequence;
import weblogic.wsee.reliability2.sequence.SourceSequenceManager;
import weblogic.wsee.reliability2.store.ReliabilityErrorContextImpl;
import weblogic.wsee.reliability2.store.SenderDispatchFactory;
import weblogic.wsee.reliability2.store.SourceSequenceSendRequest;
import weblogic.wsee.reliability2.store.SourceSequenceSenderFactory;
import weblogic.wsee.reliability2.tube.DispatchFactory;
import weblogic.wsee.reliability2.tube.DispatchFactoryNotReadyException;
import weblogic.wsee.reliability2.tube.Sender;
import weblogic.wsee.reliability2.tube.WsrmTubeUtils;
import weblogic.wsee.sender.api.ConversationStatusCallback;
import weblogic.wsee.sender.api.ConversationStatusCallbackNotReadyException;
import weblogic.wsee.sender.api.PermanentSendException;
import weblogic.wsee.sender.api.SendException;
import weblogic.wsee.sender.api.SendRequest;
import weblogic.wsee.sender.api.Sender;
import weblogic.wsee.sender.api.SenderNotReadyException;
import weblogic.wsee.sender.api.SendingServiceException;
import weblogic.wsee.util.AccessException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SourceSequenceSender
implements weblogic.wsee.sender.api.Sender {
    private static final Logger LOGGER = Logger.getLogger(SourceSequenceSender.class.getName());
    private SourceSequenceSenderFactory _factory;
    private SourceSequence _seq;
    private Sender.ConversationCallback _callback;
    private ConversationStatusCallback _statusCallback;
    private int _skipCreateSequenceSendCount = 0;

    public SourceSequenceSender(SourceSequenceSenderFactory sourceSequenceSenderFactory, SourceSequence sourceSequence) {
        if (sourceSequence == null) {
            throw new IllegalStateException("Null sequence passed to SourceSequenceSender!!");
        }
        this._factory = sourceSequenceSenderFactory;
        this._seq = sourceSequence;
        this._statusCallback = new StatusCallback();
    }

    @Override
    public void setConversationCallback(Sender.ConversationCallback conversationCallback) {
        this.checkClosed();
        this._callback = conversationCallback;
    }

    public ConversationStatusCallback getConversationStatusCallback() {
        this.checkClosed();
        return this._statusCallback;
    }

    private void checkClosed() {
        if (this._seq == null) {
            throw new IllegalStateException("Attempt to use closed SourceSequenceSender!!");
        }
    }

    void notifySequenceCreated() {
        this._callback.conversationReady();
    }

    void notifySequenceClosed() {
    }

    @Override
    public synchronized Sender.SendResult send(SendRequest sendRequest) throws SendException {
        Sender.SendResult sendResult;
        this.checkClosed();
        try {
            Object object;
            boolean bl = this._seq instanceof SourceOfferSequence;
            TubelineSpliceFactory.DispatchFactory dispatchFactory = this.getSenderDispatchKey().resolveForSplice();
            DispatchFactory dispatchFactory2 = this.getSenderDispatchKey().resolve();
            this.checkSequenceCreated(dispatchFactory2);
            if (bl && (object = this._seq.getDestinationId()) != null) {
                System.setProperty("pseudo.offer.seq.id.for.testing", (String)object);
            }
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Sending request " + sendRequest + " on sender conversation name: " + this._seq.getId());
            }
            if (bl) {
                WsrmLifecycleEventListenerRegistry.getInstance().notifyEventType(WsrmLifecycleEvent.Type.SERV_OUT_BEFORE_SEND_RESPONSE);
            } else {
                WsrmLifecycleEventListenerRegistry.getInstance().notifyEventType(WsrmLifecycleEvent.Type.CLIENT_OUT_BEFORE_SEND_REQUEST);
            }
            object = (PersistentMessage)sendRequest.getPayload();
            Packet packet = WsrmTubeUtils.createPacketFromPersistentMessage((PersistentMessage)object, this._seq.getAddressingVersion(), this._seq.getSoapVersion());
            WsrmPropertyBag wsrmPropertyBag = WsrmPropertyBag.propertySetRetriever.getFromPacket(packet);
            this.updatePacket(this._seq, wsrmPropertyBag, packet);
            sendResult = this.sendRequestAndHandleResponse(sendRequest, bl, dispatchFactory, (PersistentMessage)object, packet);
        }
        catch (SenderNotReadyException senderNotReadyException) {
            throw senderNotReadyException;
        }
        catch (SendException sendException) {
            throw sendException;
        }
        catch (Exception exception) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, exception.toString(), exception);
            }
            throw new SendException(exception.toString(), exception);
        }
        return sendResult;
    }

    private Sender.SendResult sendRequestAndHandleResponse(SendRequest sendRequest, boolean bl, TubelineSpliceFactory.DispatchFactory dispatchFactory, PersistentMessage persistentMessage, Packet packet) throws SendException {
        Object object;
        Dispatch<Packet> dispatch;
        Sender.SendResult sendResult = Sender.SendResult.SUCCESS;
        if (bl) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Getting RESPONSE Dispatch to dispatch response message with msgId " + sendRequest.getMessageId() + " msgNum " + sendRequest.getSequenceNumber() + " conversation " + sendRequest.getConversationName());
            }
            dispatch = dispatchFactory.createResponseDispatch(this._seq.getEndpointEpr(), Packet.class, Service.Mode.MESSAGE);
        } else {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Getting Dispatch to dispatch message with msgId " + sendRequest.getMessageId() + " msgNum " + sendRequest.getSequenceNumber() + " conversation " + sendRequest.getConversationName());
            }
            object = (TubelineSpliceFactory.ClientDispatchFactory)dispatchFactory;
            dispatch = object.createPostSpliceDispatch(this._seq.getEndpointEpr(), Packet.class, Service.Mode.MESSAGE);
        }
        try {
            WsrmTubeUtils.addPiggybackHeaders(packet, this._seq.getEndpointEpr().getAddress(), this._seq.getAddressingVersion(), this._seq.getSoapVersion());
        }
        catch (Exception exception) {
            throw new SendException(exception.toString(), exception);
        }
        Sender.setInvokePropertiesOntoDispatch(SourceSequenceManager.getInstance().getSenderInvokeProperties(this._seq, packet), dispatch);
        dispatch.getRequestContext().put("weblogic.wsee.jaxws.async.PersistentContext", persistentMessage.getContext().getContextPropertyMap());
        packet.soapAction = object = packet.getMessage().getHeaders().getAction(this._seq.getAddressingVersion(), this._seq.getSoapVersion());
        dispatch.getRequestContext().put("javax.xml.ws.soap.http.soapaction.uri", object);
        SourceSequenceSendRequest sourceSequenceSendRequest = (SourceSequenceSendRequest)sendRequest;
        SourceMessageInfo sourceMessageInfo = sourceSequenceSendRequest.getMsgInfo();
        SourceMessageInfo.ClientInvokeInfo clientInvokeInfo = sourceMessageInfo.getClientInvokeInfo();
        if (!bl && clientInvokeInfo != null && clientInvokeInfo.impliesSuspendedRequestFiber()) {
            sendResult = this.sendRequestAndHandleResponseForSuspendedFiber(sendRequest, packet, sourceSequenceSendRequest, sourceMessageInfo, clientInvokeInfo, dispatch);
        } else if (!bl) {
            sendResult = this.sendRequestAndHandleResponseForAsyncClientHandler(sendRequest, packet, sourceSequenceSendRequest, dispatch, sendResult);
        } else {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Dispatching one-way response msgId " + sendRequest.getMessageId() + " msgNum " + sendRequest.getSequenceNumber() + " conversation " + sendRequest.getConversationName());
            }
            sendResult = this.dispatchServiceSideResponseAndCaptureErrors(dispatch, sourceSequenceSendRequest.getMsgInfo(), packet);
        }
        return sendResult;
    }

    private Sender.SendResult sendRequestAndHandleResponseForAsyncClientHandler(SendRequest sendRequest, Packet packet, final SourceSequenceSendRequest sourceSequenceSendRequest, Dispatch<Packet> dispatch, Sender.SendResult sendResult) {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Sending A-sync (AsyncClientHandlerFeature) msgId " + sendRequest.getMessageId() + " msgNum " + sendRequest.getSequenceNumber() + " conversation " + sendRequest.getConversationName());
        }
        try {
            dispatch.getRequestContext().put("weblogic.wsee.jaxws.client.async.SendErrorOnlyAsyncHandler", Boolean.TRUE);
            dispatch.invokeAsync((Object)packet, (AsyncHandler)new AsyncHandler<Packet>(){

                public void handleResponse(Response<Packet> response) {
                    try {
                        Packet packet = (Packet)response.get();
                        if (packet != null && packet.getMessage() != null) {
                            SourceSequenceSender.this.dispatchAsyncTransportResponse(packet);
                        }
                        SourceSequenceSender.this._callback.sendSucceeded(sourceSequenceSendRequest.getSequenceNumber());
                    }
                    catch (Throwable throwable) {
                        Throwable throwable2 = SourceSequenceSender.checkForPermanentSendFailure(throwable);
                        SourceSequenceSender.this._callback.sendFailed(sourceSequenceSendRequest.getMsgInfo().getMessageNum(), throwable2);
                    }
                }
            });
            sendResult = Sender.SendResult.IN_PROCESS;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = SourceSequenceSender.checkForPermanentSendFailure(throwable);
            this._callback.sendFailed(sourceSequenceSendRequest.getMsgInfo().getMessageNum(), throwable2);
        }
        return sendResult;
    }

    private void dispatchAsyncTransportResponse(Packet packet) throws PermanentSendException {
        final String string = packet.getMessage().getHeaders().getMessageID(this._seq.getAddressingVersion(), this._seq.getSoapVersion());
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Dispatching MC Transport response for msg ID: " + string);
        }
        TubelineSpliceFactory.DispatchFactory dispatchFactory = this.getSenderDispatchKey().resolveForSplice();
        Dispatch<Packet> dispatch = dispatchFactory.createResponseDispatch(this._seq.getEndpointEpr(), Packet.class, Service.Mode.MESSAGE);
        this.copyPacketPropsToDispatch(dispatch, packet);
        dispatch.invokeAsync((Object)packet, (AsyncHandler)new AsyncHandler<Packet>(){

            public void handleResponse(Response<Packet> response) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("Got indication that pre-splice portion of response processing is complete for msg ID: " + string);
                }
            }
        });
    }

    private Sender.SendResult sendRequestAndHandleResponseForSuspendedFiber(final SendRequest sendRequest, Packet packet, final SourceSequenceSendRequest sourceSequenceSendRequest, SourceMessageInfo sourceMessageInfo, SourceMessageInfo.ClientInvokeInfo clientInvokeInfo, Dispatch<Packet> dispatch) throws PermanentSendException {
        Sender.SendResult sendResult;
        if (clientInvokeInfo.getSuspendedRequestFiber() == null) {
            throw new PermanentSendException("Attempt to send a request from a suspended fiber AFTER having received a response or permanent failure for that request. The msgId is " + sourceMessageInfo.getMessageId());
        }
        if (clientInvokeInfo.isSyncMEP() && !clientInvokeInfo.isOneWay()) {
            try {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("Sending SYNC msgId " + sendRequest.getMessageId() + " msgNum " + sendRequest.getSequenceNumber() + " conversation " + sendRequest.getConversationName());
                }
                Packet packet2 = (Packet)dispatch.invoke((Object)packet);
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("Received SYNC response for request msgId " + sendRequest.getMessageId() + " msgNum " + sendRequest.getSequenceNumber() + " conversation " + sendRequest.getConversationName());
                }
                this.handleResponseForSuspendedFiber(sourceSequenceSendRequest.getMsgInfo(), packet2);
                sendResult = Sender.SendResult.SUCCESS;
            }
            catch (Throwable throwable) {
                this.handleFailureForSuspendedFiber(sourceSequenceSendRequest.getMsgInfo(), throwable);
                sendResult = Sender.SendResult.FAILURE;
            }
        } else if (clientInvokeInfo.isOneWay()) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Sending OneWay msgId " + sendRequest.getMessageId() + " msgNum " + sendRequest.getSequenceNumber() + " conversation " + sendRequest.getConversationName());
            }
            try {
                dispatch.invokeOneWay((Object)packet);
                Packet packet3 = packet.createClientResponse(null);
                this.handleResponseForSuspendedFiber(sourceSequenceSendRequest.getMsgInfo(), packet3);
                sendResult = Sender.SendResult.SUCCESS;
            }
            catch (Throwable throwable) {
                this.handleFailureForSuspendedFiber(sourceSequenceSendRequest.getMsgInfo(), throwable);
                sendResult = Sender.SendResult.FAILURE;
            }
        } else {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Sending A-sync w/AsyncHandler(AsyncHandler) msgId " + sendRequest.getMessageId() + " msgNum " + sendRequest.getSequenceNumber() + " conversation " + sendRequest.getConversationName());
            }
            dispatch.invokeAsync((Object)packet, (AsyncHandler)new AsyncHandler<Packet>(){

                public void handleResponse(Response<Packet> response) {
                    SourceSequenceSender.this._callback.sendSucceeded(sourceSequenceSendRequest.getSequenceNumber());
                    try {
                        Packet packet = (Packet)response.get();
                        if (LOGGER.isLoggable(Level.FINE)) {
                            LOGGER.fine("Received AsyncHandler(AsyncHandler) response for request msgId " + sendRequest.getMessageId() + " msgNum " + sendRequest.getSequenceNumber() + " conversation " + sendRequest.getConversationName());
                        }
                        SourceSequenceSender.this.handleResponseForSuspendedFiber(sourceSequenceSendRequest.getMsgInfo(), packet);
                    }
                    catch (Throwable throwable) {
                        SourceSequenceSender.this.handleFailureForSuspendedFiber(sourceSequenceSendRequest.getMsgInfo(), throwable);
                    }
                }
            });
            sendResult = Sender.SendResult.IN_PROCESS;
        }
        return sendResult;
    }

    private Sender.SendResult dispatchServiceSideResponseAndCaptureErrors(Dispatch<Packet> dispatch, final SourceMessageInfo sourceMessageInfo, Packet packet) {
        boolean bl = !((SourceOfferSequence)this._seq).isMainSequenceNonBuffered() && ((SourceOfferSequence)this._seq).getMainSequenceDeliveryAssurance().isInOrder();
        this.copyPacketPropsToDispatch(dispatch, packet);
        if (bl) {
            try {
                Response response = dispatch.invokeAsync((Object)packet);
                Packet packet2 = (Packet)response.get();
                this.captureServiceSideResponseErrors(sourceMessageInfo.getMessageNum(), packet2, null);
                return Sender.SendResult.SUCCESS;
            }
            catch (Throwable throwable) {
                this.captureServiceSideResponseErrors(sourceMessageInfo.getMessageNum(), null, throwable);
                return Sender.SendResult.FAILURE;
            }
        }
        dispatch.invokeAsync((Object)packet, (AsyncHandler)new AsyncHandler<Packet>(){

            public void handleResponse(Response<Packet> response) {
                SourceSequenceSender.this._callback.sendSucceeded(sourceMessageInfo.getMessageNum());
                try {
                    Packet packet = (Packet)response.get();
                    SourceSequenceSender.this.captureServiceSideResponseErrors(sourceMessageInfo.getMessageNum(), packet, null);
                }
                catch (Throwable throwable) {
                    SourceSequenceSender.this.captureServiceSideResponseErrors(sourceMessageInfo.getMessageNum(), null, throwable);
                }
            }
        });
        return Sender.SendResult.IN_PROCESS;
    }

    private void captureServiceSideResponseErrors(long l, Packet packet, Throwable throwable) {
        if (packet != null && packet.getMessage() != null && packet.getMessage().isFault()) {
            try {
                SOAPMessage sOAPMessage = packet.getMessage().readAsSOAPMessage();
                SOAPBody sOAPBody = sOAPMessage.getSOAPBody();
                SOAPFault sOAPFault = sOAPBody.getFault();
                throwable = new SOAPFaultException(sOAPFault);
            }
            catch (Exception exception) {
                WseeRmLogger.logUnexpectedException((String)exception.toString(), (Throwable)exception);
            }
        }
        if (throwable != null) {
            throwable = SourceSequenceSender.checkForPermanentSendFailure(throwable);
            this._callback.sendFailed(l, throwable);
        }
    }

    public static Throwable checkForPermanentSendFailure(Throwable throwable) {
        if (throwable instanceof PermanentSendException) {
            return throwable;
        }
        if (WsrmExceptionUtil.isPermanentSendFailure(throwable)) {
            throwable = new PermanentSendException(throwable.toString(), throwable);
        }
        return throwable;
    }

    private void copyPacketPropsToDispatch(Dispatch<Packet> dispatch, Packet packet) {
        dispatch.getRequestContext().putAll(packet.invocationProperties);
        dispatch.getRequestContext().put("weblogic.wsee.jaxws.async.PersistentContext", packet.persistentContext);
    }

    private void handleResponseForSuspendedFiber(SourceMessageInfo sourceMessageInfo, Packet packet) {
        Fiber fiber;
        WsrmPropertyBag wsrmPropertyBag = WsrmPropertyBag.propertySetRetriever.getFromPacket(packet);
        wsrmPropertyBag.setResponseToSuspendedFiber(true);
        SourceMessageInfo.ClientInvokeInfo clientInvokeInfo = sourceMessageInfo.getClientInvokeInfo();
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Handling response for suspended fiber on msgId " + sourceMessageInfo.getMessageId() + " ClientInvokeInfo: " + clientInvokeInfo);
        }
        if ((fiber = sourceMessageInfo.getClientInvokeInfo().getAndClearSuspendedRequestFiber()) != null) {
            fiber.resumeAndReturn(packet, this._seq.getDeliveryAssurance().isInOrder());
        } else if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("IGNORING duplicate response for suspended fiber on msgId " + sourceMessageInfo.getMessageId() + " ClientInvokeInfo: " + clientInvokeInfo);
        }
    }

    private void handleFailureForSuspendedFiber(SourceMessageInfo sourceMessageInfo, Throwable throwable) {
        throwable = SourceSequenceSender.checkForPermanentSendFailure(throwable);
        if (this._callback.sendFailed(sourceMessageInfo.getMessageNum(), throwable)) {
            Fiber fiber;
            SourceMessageInfo.ClientInvokeInfo clientInvokeInfo = sourceMessageInfo.getClientInvokeInfo();
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Handling permanent failure for suspended fiber on msgId " + sourceMessageInfo.getMessageId() + " ClientInvokeInfo: " + clientInvokeInfo);
            }
            if ((fiber = sourceMessageInfo.getClientInvokeInfo().getAndClearSuspendedRequestFiber()) != null) {
                fiber.resumeAndThrow(throwable, this._seq.getDeliveryAssurance().isInOrder());
            } else if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("IGNORING duplicate permanent failure for suspended fiber on msgId " + sourceMessageInfo.getMessageId() + " ClientInvokeInfo: " + clientInvokeInfo);
            }
        }
    }

    private void checkSequenceCreated(DispatchFactory dispatchFactory) throws SOAPException, WsrmException, SendException {
        if (this._seq.getState() == SequenceState.NEW || this._seq.getState() == SequenceState.CREATING) {
            if (this._skipCreateSequenceSendCount > 0) {
                --this._skipCreateSequenceSendCount;
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("SourceSequenceSender skipping one send after having sent CreateSequence on sequence " + this._seq.getId() + " in state " + (Object)((Object)this._seq.getState()));
                }
                throw new SenderNotReadyException("SourceSequence " + this._seq + " has not completed the handshake process (CreateSequenceResponse) yet");
            }
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("SourceSequenceSender forcing CreateSequence ahead of send on sequence " + this._seq.getId() + " in state " + (Object)((Object)this._seq.getState()));
            }
            WsrmTubeUtils.sendCreateSequenceMsg(this._seq, dispatchFactory, new Sender.SendFailureCallback(){

                public void sendFailed(Throwable throwable) {
                    throwable = SourceSequenceSender.checkForPermanentSendFailure(throwable);
                    SourceSequenceSender.this._callback.conversationFailedToStart(throwable);
                }
            });
            this._skipCreateSequenceSendCount = 2;
            throw new SenderNotReadyException("SourceSequence " + this._seq + " has not completed the handshake process (CreateSequenceResponse) yet");
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("SourceSequenceSender clearing 'skip count' for CreateSequence on sequence " + this._seq.getId() + " in state " + (Object)((Object)this._seq.getState()));
        }
        this._skipCreateSequenceSendCount = 0;
    }

    private SenderDispatchFactory.Key getSenderDispatchKey() throws PermanentSendException {
        if (this._seq.getSenderDispatchKey() == null) {
            throw new PermanentSendException("No WS-RM Sender Dispatch Factory key found in SourceSequence: " + this._seq);
        }
        return this._seq.getSenderDispatchKey();
    }

    @Override
    public synchronized void close() throws SendException {
        if (this._seq == null) {
            return;
        }
        this._callback = null;
        this._factory.senderClosed(this._seq.getId());
        this._seq = null;
    }

    private void updatePacket(SourceSequence sourceSequence, WsrmPropertyBag wsrmPropertyBag, Packet packet) throws WsrmException {
        if (wsrmPropertyBag.getOutboundMsgNeedsDestSeqId()) {
            SequenceHeader sequenceHeader = WsrmHeaderFactory.getInstance().getHeaderFromPacket(SequenceHeader.class, packet);
            sequenceHeader.setSequenceId(sourceSequence.getDestinationId());
            wsrmPropertyBag.setOutboundMsgNeedsDestSeqId(false);
            packet.getMessage().getHeaders().addOrReplace((Header)sequenceHeader);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class StatusCallback
    implements ConversationStatusCallback {
        private StatusCallback() {
        }

        @Override
        public void deliveryFailure(SendRequest sendRequest, List<Throwable> list) throws SendingServiceException {
            try {
                ReliabilityErrorListener reliabilityErrorListener = SourceSequenceSender.this.getSenderDispatchKey().findErrorListener();
                SourceSequenceSendRequest sourceSequenceSendRequest = (SourceSequenceSendRequest)sendRequest;
                if (reliabilityErrorListener == null) {
                    Fiber fiber;
                    Object object;
                    SourceMessageInfo sourceMessageInfo = sourceSequenceSendRequest.getMsgInfo();
                    if (sourceMessageInfo != null && (object = sourceMessageInfo.getClientInvokeInfo()) != null && ((SourceMessageInfo.ClientInvokeInfo)object).impliesSuspendedRequestFiber() && (fiber = ((SourceMessageInfo.ClientInvokeInfo)object).getAndClearSuspendedRequestFiber()) != null) {
                        fiber.resumeAndThrow(list.get(0), true);
                        return;
                    }
                    object = SourceSequenceSender.this._seq.getId() + " - " + sendRequest.getMessageId();
                    object = this.getErrorMessage((String)object, list);
                    WseeRmLogger.logNoErrorListenerProvided((String)SourceSequenceSender.this.getSenderDispatchKey().toString(), (String)object);
                    return;
                }
                Packet packet = new Packet();
                PersistentMessageFactory.getInstance().setMessageIntoPacket((PersistentMessage)sourceSequenceSendRequest.getPayload(), packet);
                WsrmPropertyBag wsrmPropertyBag = WsrmPropertyBag.propertySetRetriever.getFromPacket(packet);
                String string = wsrmPropertyBag.getOutboundWsdlOperationName();
                ReliabilityErrorContext reliabilityErrorContext = this.createReliabilityErrorContextImpl(true, string, packet.getMessage(), packet.persistentContext, list);
                reliabilityErrorListener.onReliabilityError(reliabilityErrorContext);
            }
            catch (PermanentSendException permanentSendException) {
                throw new SendingServiceException(permanentSendException.toString(), permanentSendException);
            }
            catch (IllegalStateException illegalStateException) {
                throw new SendingServiceException(illegalStateException.toString(), illegalStateException);
            }
            catch (DispatchFactoryNotReadyException dispatchFactoryNotReadyException) {
                throw new ConversationStatusCallbackNotReadyException(dispatchFactoryNotReadyException.toString(), dispatchFactoryNotReadyException);
            }
        }

        private String getErrorMessage(String string, List<Throwable> list) {
            StringBuffer stringBuffer = new StringBuffer(string);
            stringBuffer.append("\n");
            for (Throwable throwable : list) {
                throwable = this.unwrapError(throwable);
                stringBuffer.append("\n").append(throwable.toString());
            }
            return stringBuffer.toString();
        }

        private Throwable unwrapError(Throwable throwable) {
            Throwable throwable2 = throwable;
            for (Throwable throwable3 = throwable; throwable3 != null; throwable3 = throwable3.getCause()) {
                if (!(throwable3 instanceof PermanentSendException) && !(throwable3 instanceof AccessException)) continue;
                throwable2 = throwable3;
                break;
            }
            return throwable2;
        }

        private ReliabilityErrorContext createReliabilityErrorContextImpl(boolean bl, String string, Message message, Map<String, Serializable> map, List<Throwable> list) {
            String string2 = this.getErrorMessage("", list);
            return new ReliabilityErrorContextImpl(bl, string, message, list, string2, map);
        }

        @Override
        public void conversationClosed(String string, List<Throwable> list) throws SendingServiceException {
            try {
                ReliabilityErrorListener reliabilityErrorListener = SourceSequenceSender.this.getSenderDispatchKey().findErrorListener();
                if (reliabilityErrorListener == null) {
                    String string2 = SourceSequenceSender.this._seq.getId();
                    string2 = this.getErrorMessage(string2, list);
                    WseeRmLogger.logNoErrorListenerProvided((String)SourceSequenceSender.this.getSenderDispatchKey().toString(), (String)string2);
                    return;
                }
                Map map = (Map)SourceSequenceManager.getInstance().getSenderInvokeProperties(SourceSequenceSender.this._seq, (Packet)null).get("weblogic.wsee.jaxws.async.PersistentContext");
                ReliabilityErrorContext reliabilityErrorContext = this.createReliabilityErrorContextImpl(false, null, null, map, list);
                reliabilityErrorListener.onReliabilityError(reliabilityErrorContext);
            }
            catch (PermanentSendException permanentSendException) {
                throw new SendingServiceException(permanentSendException.toString(), permanentSendException);
            }
            catch (IllegalStateException illegalStateException) {
                throw new SendingServiceException(illegalStateException.toString(), illegalStateException);
            }
            catch (DispatchFactoryNotReadyException dispatchFactoryNotReadyException) {
                throw new ConversationStatusCallbackNotReadyException(dispatchFactoryNotReadyException.toString(), dispatchFactoryNotReadyException);
            }
        }

        @Override
        public void conversationNotStarted(String string, List<Throwable> list) throws SendingServiceException {
            this.conversationClosed(string, list);
        }
    }
}

