/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.reliability2.store;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import weblogic.wsee.reliability2.sequence.SourceSequence;
import weblogic.wsee.reliability2.store.SourceSequenceMap;
import weblogic.wsee.reliability2.store.SourceSequenceSender;
import weblogic.wsee.sender.api.ConversationStatusCallback;
import weblogic.wsee.sender.api.Sender;
import weblogic.wsee.sender.api.SenderFactory;
import weblogic.wsee.sender.api.SendingServiceException;

public class SourceSequenceSenderFactory
implements SenderFactory {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = Logger.getLogger(SourceSequenceSenderFactory.class.getName());
    private transient Map<String, SourceSequenceSender> _seqIdToSenderMap;
    private transient SourceSequenceMap _parentMap;
    private final List<String> _seqIdList;
    private final Object _seqMonitor = "SeqLock";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        Object object = this._seqMonitor;
        synchronized (object) {
            objectOutputStream.defaultWriteObject();
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this._seqIdToSenderMap = new HashMap<String, SourceSequenceSender>();
        for (String string : this._seqIdList) {
            SourceSequence sourceSequence = (SourceSequence)this._parentMap.get(string);
            SourceSequenceSender sourceSequenceSender = new SourceSequenceSender(this, sourceSequence);
            this._seqIdToSenderMap.put(string, sourceSequenceSender);
            if (!LOGGER.isLoggable(Level.FINE)) continue;
            LOGGER.fine("SourceSequenceSenderFactory recreated sender for seq: " + string + ". Current sender count: " + this._seqIdToSenderMap.size());
        }
    }

    SourceSequenceSenderFactory(SourceSequenceMap sourceSequenceMap) {
        this._parentMap = sourceSequenceMap;
        this._seqIdList = new LinkedList<String>();
        this._seqIdToSenderMap = new HashMap<String, SourceSequenceSender>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void senderClosed(String string) {
        Object object = this._seqMonitor;
        synchronized (object) {
            if (this._seqIdToSenderMap.remove(string) != null && LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("SourceSequenceSenderFactory removed sender for seq: " + string + ". Remaining sender count: " + this._seqIdToSenderMap.size());
            }
            this._seqIdList.remove(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sequenceCreated(String string) {
        SourceSequenceSender sourceSequenceSender;
        Object object = this._seqMonitor;
        synchronized (object) {
            sourceSequenceSender = this._seqIdToSenderMap.get(string);
        }
        if (sourceSequenceSender != null) {
            sourceSequenceSender.notifySequenceCreated();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Sender createSender(String string) throws SendingServiceException {
        SourceSequenceSender sourceSequenceSender;
        Object object = this._seqMonitor;
        synchronized (object) {
            sourceSequenceSender = this._seqIdToSenderMap.get(string);
        }
        if (sourceSequenceSender != null) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("SourceSequenceSenderFactory returning existing sender for seq: " + string);
            }
            return sourceSequenceSender;
        }
        object = (SourceSequence)this._parentMap.get(string);
        sourceSequenceSender = new SourceSequenceSender(this, (SourceSequence)object);
        Object object2 = this._seqMonitor;
        synchronized (object2) {
            this._seqIdToSenderMap.put(string, sourceSequenceSender);
            this._seqIdList.add(string);
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("SourceSequenceSenderFactory created new sender for seq: " + string);
        }
        return sourceSequenceSender;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConversationStatusCallback getStatusCallback(String string) throws SendingServiceException {
        SourceSequenceSender sourceSequenceSender;
        Object object = this._seqMonitor;
        synchronized (object) {
            sourceSequenceSender = this._seqIdToSenderMap.get(string);
        }
        return sourceSequenceSender != null ? sourceSequenceSender.getConversationStatusCallback() : null;
    }
}

