/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.reliability2.store;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import weblogic.timers.Timer;
import weblogic.timers.TimerListener;
import weblogic.timers.TimerManager;
import weblogic.timers.TimerManagerFactory;
import weblogic.wsee.WseeRmLogger;
import weblogic.wsee.reliability2.api.SequenceState;
import weblogic.wsee.reliability2.sequence.Sequence;
import weblogic.wsee.reliability2.store.SequenceMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TimedSequenceMap<S extends Sequence>
extends SequenceMap<S> {
    private static final Logger LOGGER = Logger.getLogger(TimedSequenceMap.class.getName());
    private static final TimerManager _timerMgr;
    private static final boolean LOCK_FAIRNESS = false;
    private final Map<String, SequenceTimerInfo> _seqIdToTimerInfoMap = new HashMap<String, SequenceTimerInfo>();
    private ReentrantReadWriteLock _seqIdToTimerInfoMapLock = new ReentrantReadWriteLock(false);
    private SequenceTimerListener _sequenceTimerListener;

    public void setSequenceTimerListener(SequenceTimerListener sequenceTimerListener) {
        this._sequenceTimerListener = sequenceTimerListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    boolean startupSequence(S s) {
        if (super.startupSequence(s)) {
            block5: {
                if (this._sequenceTimerListener == null) {
                    throw new IllegalStateException("Attempt to add timed sequence before calling setSequenceTimerListener");
                }
                try {
                    this._seqIdToTimerInfoMapLock.writeLock().lock();
                    if (!this._seqIdToTimerInfoMap.containsKey(((Sequence)s).getId())) break block5;
                    boolean bl = true;
                    Object var5_3 = null;
                    this._seqIdToTimerInfoMapLock.writeLock().unlock();
                    return bl;
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    this._seqIdToTimerInfoMapLock.writeLock().unlock();
                    throw throwable;
                }
            }
            SequenceTimerInfo sequenceTimerInfo = new SequenceTimerInfo(this, s, this._sequenceTimerListener);
            this._seqIdToTimerInfoMap.put(((Sequence)s).getId(), sequenceTimerInfo);
            Object var5_4 = null;
            this._seqIdToTimerInfoMapLock.writeLock().unlock();
            sequenceTimerInfo.startAll();
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    boolean shutdownSequence(S s) {
        if (s != null) {
            SequenceTimerInfo sequenceTimerInfo;
            try {
                this._seqIdToTimerInfoMapLock.writeLock().lock();
                sequenceTimerInfo = this._seqIdToTimerInfoMap.remove(((Sequence)s).getId());
                Object var4_3 = null;
                this._seqIdToTimerInfoMapLock.writeLock().unlock();
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                this._seqIdToTimerInfoMapLock.writeLock().unlock();
                throw throwable;
            }
            if (sequenceTimerInfo != null) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("Shutting down " + ((Sequence)s).getId());
                }
                sequenceTimerInfo.cancelAll();
            }
        }
        return super.shutdownSequence(s);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void updated(S s, S s2) {
        SequenceTimerInfo sequenceTimerInfo;
        super.updated(s, s2);
        try {
            this._seqIdToTimerInfoMapLock.writeLock().lock();
            sequenceTimerInfo = this._seqIdToTimerInfoMap.get(((Sequence)s).getId());
            Object var5_4 = null;
            this._seqIdToTimerInfoMapLock.writeLock().unlock();
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this._seqIdToTimerInfoMapLock.writeLock().unlock();
            throw throwable;
        }
        if (sequenceTimerInfo != null) {
            sequenceTimerInfo.resetIdleTimer();
        }
    }

    @Override
    protected void removing(S s) {
        if (((Sequence)s).getState() != SequenceState.TERMINATING && ((Sequence)s).getState() != SequenceState.TERMINATED) {
            this.timedSequenceForciblyExpired(s);
        }
        super.removing(s);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void timedSequenceForciblyExpired(S s) {
        SequenceTimerInfo sequenceTimerInfo;
        try {
            this._seqIdToTimerInfoMapLock.writeLock().lock();
            sequenceTimerInfo = this._seqIdToTimerInfoMap.get(((Sequence)s).getId());
            Object var4_3 = null;
            this._seqIdToTimerInfoMapLock.writeLock().unlock();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this._seqIdToTimerInfoMapLock.writeLock().unlock();
            throw throwable;
        }
        if (sequenceTimerInfo != null) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Forcibly expiring " + s);
            }
            try {
                sequenceTimerInfo._listener.sequenceExpiration(((Sequence)s).getId());
            }
            catch (Exception exception) {
                WseeRmLogger.logUnexpectedException((String)exception.toString(), (Throwable)exception);
            }
        }
    }

    static {
        TimerManagerFactory timerManagerFactory = TimerManagerFactory.getTimerManagerFactory();
        _timerMgr = timerManagerFactory.getDefaultTimerManager();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SequenceTimerInfo {
        private S _seq;
        private SequenceTimerListener _listener;
        private Timer _lifeTimer;
        private Timer _idleTimer;
        final /* synthetic */ TimedSequenceMap this$0;

        public SequenceTimerInfo(S s, SequenceTimerListener sequenceTimerListener) {
            this.this$0 = var1_1;
            this._seq = s;
            this._listener = sequenceTimerListener;
        }

        public synchronized void startAll() {
            this.setLifeTimer();
            this.resetIdleTimer();
        }

        private void setLifeTimer() {
            if (this._lifeTimer != null) {
                throw new IllegalStateException("Cannot reset a lifetime timer");
            }
            long l = ((Sequence)this._seq).getExpires().getTimeInMillis(new Date(((Sequence)this._seq).getTimestamp())) + ((Sequence)this._seq).getTimestamp();
            if ((l -= System.currentTimeMillis()) < 0L) {
                this.cancelAll();
                this._listener.sequenceExpiration(((Sequence)this._seq).getId());
            } else {
                this._lifeTimer = _timerMgr.schedule(new TimerListener(){

                    public void timerExpired(Timer timer) {
                        SequenceTimerInfo.this.cancelAll();
                        SequenceTimerInfo.this._listener.sequenceExpiration(SequenceTimerInfo.this._seq.getId());
                    }
                }, l);
            }
        }

        public synchronized void resetIdleTimer() {
            if (this._idleTimer != null) {
                this._idleTimer.cancel();
            }
            if (((Sequence)this._seq).getIdleTimeout() == null) {
                return;
            }
            long l = ((Sequence)this._seq).getIdleTimeout().getTimeInMillis(new Date(((Sequence)this._seq).getLastActivityTime())) + ((Sequence)this._seq).getLastActivityTime() - System.currentTimeMillis();
            if (l < 0L) {
                this.cancelAll();
                this._listener.idleTimeout(((Sequence)this._seq).getId());
            } else {
                this._idleTimer = _timerMgr.schedule(new TimerListener(){

                    public void timerExpired(Timer timer) {
                        SequenceTimerInfo.this.cancelAll();
                        SequenceTimerInfo.this._listener.idleTimeout(SequenceTimerInfo.this._seq.getId());
                    }
                }, l);
            }
        }

        public synchronized void cancelAll() {
            if (this._lifeTimer != null) {
                this._lifeTimer.cancel();
                this._lifeTimer = null;
            }
            if (this._idleTimer != null) {
                this._idleTimer.cancel();
                this._idleTimer = null;
            }
        }
    }

    public static interface SequenceTimerListener {
        public void sequenceExpiration(String var1);

        public void idleTimeout(String var1);
    }
}

