/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.reliability2.tube;

import com.sun.xml.ws.api.server.WSEndpoint;
import com.sun.xml.ws.server.WSEndpointImpl;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import weblogic.wsee.WseeRmLogger;
import weblogic.wsee.jaxws.spi.ClientIdentityRegistry;
import weblogic.wsee.jaxws.tubeline.TubelineSpliceFactory;
import weblogic.wsee.reliability2.tube.DispatchFactory;
import weblogic.wsee.reliability2.tube.DispatchFactoryNotReadyException;
import weblogic.wsee.reliability2.tube.WsrmClientDispatchFactory;
import weblogic.wsee.reliability2.tube.WsrmServerDispatchFactory;

public class DispatchFactoryResolver {
    private static final ReentrantReadWriteLock _clientDispatchFactoryRegistryLock = new ReentrantReadWriteLock(false);
    private static final Map<String, SpliceDispatchFactoryHandle<TubelineSpliceFactory.ClientDispatchFactory>> _clientDispatchFactoryRegistry = new HashMap<String, SpliceDispatchFactoryHandle<TubelineSpliceFactory.ClientDispatchFactory>>();
    private static final ReentrantReadWriteLock _serverDispatchFactoryRegistryLock = new ReentrantReadWriteLock(false);
    private static final Map<String, SpliceDispatchFactoryHandle<TubelineSpliceFactory.DispatchFactory>> _serverDispatchFactoryRegistry = new HashMap<String, SpliceDispatchFactoryHandle<TubelineSpliceFactory.DispatchFactory>>();
    private static final Logger LOGGER = Logger.getLogger(DispatchFactoryResolver.class.getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerClientDispatchFactory(String string, TubelineSpliceFactory.ClientDispatchFactory clientDispatchFactory) {
        try {
            _clientDispatchFactoryRegistryLock.writeLock().lock();
            SpliceDispatchFactoryHandle<TubelineSpliceFactory.ClientDispatchFactory> spliceDispatchFactoryHandle = _clientDispatchFactoryRegistry.get(string);
            if (spliceDispatchFactoryHandle == null) {
                spliceDispatchFactoryHandle = new SpliceDispatchFactoryHandle(string);
            }
            spliceDispatchFactoryHandle.registerFactory(clientDispatchFactory);
            _clientDispatchFactoryRegistry.put(string, spliceDispatchFactoryHandle);
        }
        finally {
            _clientDispatchFactoryRegistryLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TubelineSpliceFactory.ClientDispatchFactory getClientDispatchFactory(String string) {
        try {
            _clientDispatchFactoryRegistryLock.readLock().lock();
            SpliceDispatchFactoryHandle<TubelineSpliceFactory.ClientDispatchFactory> spliceDispatchFactoryHandle = _clientDispatchFactoryRegistry.get(string);
            TubelineSpliceFactory.ClientDispatchFactory clientDispatchFactory = spliceDispatchFactoryHandle != null ? spliceDispatchFactoryHandle.getFactory() : null;
            return clientDispatchFactory;
        }
        finally {
            _clientDispatchFactoryRegistryLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TubelineSpliceFactory.ClientDispatchFactory unregisterClientDispatchFactory(String string) {
        try {
            _clientDispatchFactoryRegistryLock.writeLock().lock();
            SpliceDispatchFactoryHandle<TubelineSpliceFactory.ClientDispatchFactory> spliceDispatchFactoryHandle = _clientDispatchFactoryRegistry.get(string);
            if (spliceDispatchFactoryHandle == null) {
                TubelineSpliceFactory.ClientDispatchFactory clientDispatchFactory = null;
                return clientDispatchFactory;
            }
            if (spliceDispatchFactoryHandle.unregisterFactory()) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("Un-registered ClientDispatchFactory for client '" + string + "' resulting in 0 refCount. Physically removing this DispatchFactory");
                }
                _clientDispatchFactoryRegistry.remove(string);
            }
            TubelineSpliceFactory.ClientDispatchFactory clientDispatchFactory = spliceDispatchFactoryHandle.getFactory();
            return clientDispatchFactory;
        }
        finally {
            _clientDispatchFactoryRegistryLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerServerDispatchFactory(String string, TubelineSpliceFactory.DispatchFactory dispatchFactory) {
        try {
            _serverDispatchFactoryRegistryLock.writeLock().lock();
            SpliceDispatchFactoryHandle<TubelineSpliceFactory.DispatchFactory> spliceDispatchFactoryHandle = _serverDispatchFactoryRegistry.get(string);
            if (spliceDispatchFactoryHandle == null) {
                spliceDispatchFactoryHandle = new SpliceDispatchFactoryHandle(string);
            }
            spliceDispatchFactoryHandle.registerFactory(dispatchFactory);
            _serverDispatchFactoryRegistry.put(string, spliceDispatchFactoryHandle);
        }
        finally {
            _serverDispatchFactoryRegistryLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TubelineSpliceFactory.DispatchFactory getServerDispatchFactory(String string) {
        try {
            _serverDispatchFactoryRegistryLock.readLock().lock();
            SpliceDispatchFactoryHandle<TubelineSpliceFactory.DispatchFactory> spliceDispatchFactoryHandle = _serverDispatchFactoryRegistry.get(string);
            TubelineSpliceFactory.DispatchFactory dispatchFactory = spliceDispatchFactoryHandle != null ? spliceDispatchFactoryHandle.getFactory() : null;
            return dispatchFactory;
        }
        finally {
            _serverDispatchFactoryRegistryLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TubelineSpliceFactory.DispatchFactory unregisterServerDispatchFactory(String string) {
        try {
            _serverDispatchFactoryRegistryLock.writeLock().lock();
            SpliceDispatchFactoryHandle<TubelineSpliceFactory.DispatchFactory> spliceDispatchFactoryHandle = _serverDispatchFactoryRegistry.get(string);
            if (spliceDispatchFactoryHandle == null) {
                TubelineSpliceFactory.DispatchFactory dispatchFactory = null;
                return dispatchFactory;
            }
            if (spliceDispatchFactoryHandle.unregisterFactory()) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("Un-registered DispatchFactory for endpoint '" + string + "' resulting in 0 refCount. Physically removing this DispatchFactory");
                }
                _serverDispatchFactoryRegistry.remove(string);
            }
            TubelineSpliceFactory.DispatchFactory dispatchFactory = spliceDispatchFactoryHandle.getFactory();
            return dispatchFactory;
        }
        finally {
            _serverDispatchFactoryRegistryLock.writeLock().unlock();
        }
    }

    public static class ServerSideKey
    extends BaseKey {
        private static final long serialVersionUID = 1L;

        public ServerSideKey() {
        }

        public ServerSideKey(String string) {
            super((Serializable)((Object)string));
        }

        protected void startListening() {
        }

        protected void stopListening() {
        }

        public DispatchFactory resolve() {
            WSEndpointImpl wSEndpointImpl = this.resolveEndpoint();
            WsrmServerDispatchFactory wsrmServerDispatchFactory = new WsrmServerDispatchFactory(wSEndpointImpl);
            return wsrmServerDispatchFactory;
        }

        public TubelineSpliceFactory.DispatchFactory resolveForSplice() {
            this.resolveEndpoint();
            return DispatchFactoryResolver.getServerDispatchFactory((String)((Object)this._id));
        }

        private WSEndpointImpl resolveEndpoint() {
            WSEndpointImpl wSEndpointImpl = (WSEndpointImpl)WSEndpoint.getEndpoint((String)((String)((Object)this._id)));
            if (wSEndpointImpl == null) {
                throw new IllegalStateException("No WSEndpoint with id: " + this._id);
            }
            return wSEndpointImpl;
        }
    }

    public static class ClientSideKey
    extends BaseKey {
        private static final long serialVersionUID = 1L;
        private transient ClientIdentityRegistry.Listener _clientIdListener;

        private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
            objectOutputStream.defaultWriteObject();
        }

        private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
            objectInputStream.defaultReadObject();
            this.initTransients();
        }

        public ClientSideKey() {
        }

        public ClientSideKey(String string) {
            super((Serializable)((Object)string));
            this.initTransients();
        }

        private void initTransients() {
            this._clientIdListener = new ClientIdentityRegistry.Listener(){

                public void clientIdentityRegistered(String string) {
                }

                public void clientIdentityBeforeUnregister(String string) {
                    ClientSideKey.this.notifyDispose();
                }
            };
        }

        protected void startListening() {
            ClientIdentityRegistry.addClientIdentityListener((String)((Object)this._id), this._clientIdListener);
        }

        protected void stopListening() {
            ClientIdentityRegistry.removeClientIdentityListener((String)((Object)this._id), this._clientIdListener);
        }

        public DispatchFactory resolve() {
            this.verifyClientIdentity();
            WsrmClientDispatchFactory wsrmClientDispatchFactory = new WsrmClientDispatchFactory((String)((Object)this._id));
            return wsrmClientDispatchFactory;
        }

        public TubelineSpliceFactory.ClientDispatchFactory resolveForSplice() {
            this.verifyClientIdentity();
            TubelineSpliceFactory.ClientDispatchFactory clientDispatchFactory = DispatchFactoryResolver.getClientDispatchFactory((String)((Object)this._id));
            return clientDispatchFactory;
        }

        private void verifyClientIdentity() {
            ClientIdentityRegistry.ClientInfo clientInfo = ClientIdentityRegistry.getClientInfo((String)((Object)this._id));
            if (clientInfo == null) {
                throw new DispatchFactoryNotReadyException("No client with client identity '" + this._id + "' has been registered yet");
            }
            if (!clientInfo.isInitialized()) {
                throw new DispatchFactoryNotReadyException("Client identity '" + this._id + "' has been registered, but is not yet fully initialized");
            }
        }
    }

    private static abstract class BaseKey
    implements Key {
        private static final long serialVersionUID = 1L;
        private transient List<LifecycleListener> _listeners;
        protected transient String _serializableVersion;
        protected Serializable _id;

        private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
            this._serializableVersion = "10.3.6";
            objectOutputStream.writeObject(this._serializableVersion);
            objectOutputStream.defaultWriteObject();
        }

        private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
            this._serializableVersion = (String)objectInputStream.readObject();
            objectInputStream.defaultReadObject();
        }

        public BaseKey() {
        }

        protected BaseKey(Serializable serializable) {
            this._id = serializable;
        }

        public Serializable getId() {
            return this._id;
        }

        protected abstract void startListening();

        protected abstract void stopListening();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addLifecycleListener(LifecycleListener lifecycleListener) {
            BaseKey baseKey = this;
            synchronized (baseKey) {
                if (this._listeners == null) {
                    this._listeners = new ArrayList<LifecycleListener>();
                }
                if (!this._listeners.contains(lifecycleListener)) {
                    this._listeners.add(lifecycleListener);
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.fine("DispatchFactory.Key " + this + " added LifecycleListener " + lifecycleListener + ". Current listener count: " + this._listeners.size());
                    }
                    if (this._listeners.size() == 1) {
                        this.startListening();
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeLifecycleListener(LifecycleListener lifecycleListener) {
            BaseKey baseKey = this;
            synchronized (baseKey) {
                if (this._listeners == null) {
                    return;
                }
                this._listeners.remove(lifecycleListener);
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("DispatchFactory.Key " + this + " removed LifecycleListener " + lifecycleListener + ". Remaining listener count: " + this._listeners.size());
                }
                if (this._listeners.size() < 1) {
                    this.stopListening();
                    this._listeners = null;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void notifyDispose() {
            LifecycleListener[] lifecycleListenerArray;
            Object object = this;
            synchronized (object) {
                if (this._listeners == null || this._listeners.size() < 1) {
                    return;
                }
                lifecycleListenerArray = this._listeners.toArray(new LifecycleListener[this._listeners.size()]);
            }
            try {
                object = this.resolve();
            }
            catch (Exception exception) {
                WseeRmLogger.logUnexpectedException((String)exception.toString(), (Throwable)exception);
                return;
            }
            for (LifecycleListener lifecycleListener : lifecycleListenerArray) {
                try {
                    lifecycleListener.onDispatchFactoryDispose((DispatchFactory)object);
                }
                catch (Exception exception) {
                    WseeRmLogger.logUnexpectedException((String)exception.toString(), (Throwable)exception);
                }
            }
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer(super.toString());
            stringBuffer.append(": ").append(this._id);
            return stringBuffer.toString();
        }
    }

    public static interface Key
    extends Serializable {
        public Serializable getId();

        public DispatchFactory resolve();

        public TubelineSpliceFactory.DispatchFactory resolveForSplice();

        public void addLifecycleListener(LifecycleListener var1);

        public void removeLifecycleListener(LifecycleListener var1);
    }

    public static interface LifecycleListener {
        public void onDispatchFactoryDispose(DispatchFactory var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SpliceDispatchFactoryHandle<T extends TubelineSpliceFactory.DispatchFactory> {
        private String _endpointId;
        private int _refCount;
        private T _factory;

        public SpliceDispatchFactoryHandle(String string) {
            this._endpointId = string;
            this._refCount = 0;
        }

        public T registerFactory(T t) {
            T t2 = this._factory;
            this._factory = t;
            ++this._refCount;
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Registered " + this.getFactoryTypeDesc() + " for ID '" + this._endpointId + "' resulting in refCount=" + this._refCount);
            }
            return t2;
        }

        public boolean unregisterFactory() {
            --this._refCount;
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Un-registered " + this.getFactoryTypeDesc() + " for ID '" + this._endpointId + "' resulting in refCount=" + this._refCount);
            }
            return this._refCount < 1;
        }

        public T getFactory() {
            return this._factory;
        }

        public int getRefCount() {
            return this._refCount;
        }

        public String getFactoryTypeDesc() {
            return this._factory.getClass().getSimpleName();
        }
    }
}

