/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.reliability2.tube;

import com.sun.istack.NotNull;
import com.sun.istack.Nullable;
import com.sun.xml.ws.api.SOAPVersion;
import com.sun.xml.ws.api.WSBinding;
import com.sun.xml.ws.api.addressing.AddressingVersion;
import com.sun.xml.ws.api.addressing.WSEndpointReference;
import com.sun.xml.ws.api.message.Header;
import com.sun.xml.ws.api.message.Headers;
import com.sun.xml.ws.api.message.Message;
import java.io.Closeable;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFault;
import javax.xml.soap.SOAPMessage;
import javax.xml.ws.AsyncHandler;
import javax.xml.ws.Dispatch;
import javax.xml.ws.Response;
import javax.xml.ws.soap.SOAPFaultException;
import weblogic.wsee.WseeRmLogger;
import weblogic.wsee.reliability2.tube.DispatchFactory;
import weblogic.wsee.reliability2.tube.WsrmServerDispatchFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Sender {
    private static final Logger LOGGER = Logger.getLogger(Sender.class.getName());
    @NotNull
    private DispatchFactory _dispatchFactory;

    public Sender(@NotNull DispatchFactory dispatchFactory) {
        this._dispatchFactory = dispatchFactory;
    }

    public void send(@NotNull Message message, @Nullable String string, @NotNull WSEndpointReference wSEndpointReference, @Nullable WSEndpointReference wSEndpointReference2) throws Exception {
        this.send(message, string, wSEndpointReference, wSEndpointReference2, null);
    }

    public void send(@NotNull Message message, @Nullable String string, @NotNull WSEndpointReference wSEndpointReference, @Nullable WSEndpointReference wSEndpointReference2, @NotNull Map<String, Object> map) throws Exception {
        this.send(message, string, wSEndpointReference, wSEndpointReference2, map, false);
    }

    public void send(@NotNull Message message, @Nullable String string, @NotNull WSEndpointReference wSEndpointReference, @Nullable WSEndpointReference wSEndpointReference2, @NotNull Map<String, Object> map, boolean bl) throws Exception {
        this.send(message, string, wSEndpointReference, wSEndpointReference2, map, bl, false);
    }

    public void send(@NotNull Message message, @Nullable String string, @NotNull WSEndpointReference wSEndpointReference, @Nullable WSEndpointReference wSEndpointReference2, @NotNull Map<String, Object> map, boolean bl, boolean bl2) throws Exception {
        this.send(message, string, wSEndpointReference, wSEndpointReference2, map, bl, bl2, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(@NotNull Message message, @Nullable String string, @NotNull WSEndpointReference wSEndpointReference, @Nullable WSEndpointReference wSEndpointReference2, @NotNull Map<String, Object> map, boolean bl, boolean bl2, SendFailureCallback sendFailureCallback) throws Exception {
        block24: {
            if (map == null) {
                throw new IllegalArgumentException("invokeProps cannot be null");
            }
            if (wSEndpointReference2 == null) {
                throw new IllegalArgumentException("replyTo cannot be null");
            }
            Dispatch<Message> dispatch = this._dispatchFactory.createDispatch(wSEndpointReference, Message.class);
            if (this._dispatchFactory instanceof WsrmServerDispatchFactory) {
                message.getHeaders().addOrReplace(Headers.create((QName)wSEndpointReference.getVersion().toTag, (String)wSEndpointReference.getAddress()));
            }
            AddressingVersion addressingVersion = wSEndpointReference.getVersion();
            SOAPVersion sOAPVersion = ((WSBinding)dispatch.getBinding()).getSOAPVersion();
            try {
                Object object;
                Sender.setInvokePropertiesOntoDispatch(map, dispatch);
                if (string == null) {
                    string = message.getHeaders().getAction(addressingVersion, sOAPVersion);
                }
                dispatch.getRequestContext().put("javax.xml.ws.soap.http.soapaction.uri", string);
                if (!wSEndpointReference2.isAnonymous()) {
                    object = wSEndpointReference2.createHeader(wSEndpointReference2.getVersion().replyToTag);
                    message.getHeaders().addOrReplace((Header)object);
                }
                wSEndpointReference.addReferenceParameters(message.getHeaders());
                if (wSEndpointReference2.isAnonymous()) {
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.fine("Sender doing SYNC send of message with action: " + string + " on dispatch: " + dispatch);
                    }
                    if (bl2) {
                        object = null;
                        dispatch.invokeOneWay((Object)message);
                    } else {
                        object = (Message)dispatch.invoke((Object)message);
                    }
                    this.handleResponse(string, addressingVersion, sOAPVersion, (Message)object, dispatch);
                    break block24;
                }
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("Sender doing *async* send of message with action: " + string + " on dispatch: " + dispatch);
                }
                if (bl && !bl2) {
                    object = new ResponseHolder();
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.fine("Sender is blocking until we get the result of action '" + string + "' from service at address: " + wSEndpointReference.getAddress() + " on dispatch: " + dispatch);
                    }
                    Object object2 = object;
                    synchronized (object2) {
                        dispatch.invokeAsync((Object)message, (AsyncHandler)new ForceSyncAsyncHandler((ResponseHolder)object));
                        while (((ResponseHolder)object).response == null) {
                            try {
                                object.wait();
                            }
                            catch (Exception exception) {
                                WseeRmLogger.logUnexpectedException((String)exception.toString(), (Throwable)exception);
                            }
                        }
                    }
                    this.handleResponseMessage(string, addressingVersion, sOAPVersion, ((ResponseHolder)object).response, dispatch, true);
                    break block24;
                }
                if (bl2) {
                    dispatch.invokeOneWay((Object)message);
                } else {
                    object = new InternalAsyncHandler(string, addressingVersion, sOAPVersion, null, sendFailureCallback);
                    dispatch.invokeAsync((Object)message, (AsyncHandler)object);
                }
            }
            catch (Exception exception) {
                String string2 = "Error sending ";
                String string3 = message.getHeaders().getMessageID(addressingVersion, sOAPVersion);
                if (string3 != null) {
                    string2 = string2 + "msgId '" + string3 + "' ";
                }
                string2 = string2 + "action '" + string + "' to '" + wSEndpointReference.getAddress() + "': " + exception.toString();
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, string2, exception);
                }
                throw exception;
            }
        }
    }

    public static void setInvokePropertiesOntoDispatch(Map<String, Object> map, Dispatch dispatch) {
        for (String string : map.keySet()) {
            Object object = map.get(string);
            try {
                if ("javax.xml.ws.soap.http.soapaction.uri".equals(string) && (object == null || ((String)object).length() < 1)) continue;
                dispatch.getRequestContext().put(string, object);
            }
            catch (Exception exception) {
                if (!LOGGER.isLoggable(Level.FINE)) continue;
                LOGGER.log(Level.FINE, exception.toString(), exception);
            }
        }
    }

    private void handleResponseMessage(String string, AddressingVersion addressingVersion, SOAPVersion sOAPVersion, Response<Message> response, Dispatch<Message> dispatch, boolean bl) throws Exception {
        try {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Processing Response<Message> (in Sender) to action '" + string + "'. Will now attempt to extract the actual response.");
            }
            Message message = (Message)response.get();
            this.handleResponse(string, addressingVersion, sOAPVersion, message, dispatch);
        }
        catch (Exception exception) {
            if (bl) {
                throw exception;
            }
            if (LOGGER.isLoggable(Level.WARNING)) {
                LOGGER.log(Level.WARNING, exception.toString(), exception);
            }
            WseeRmLogger.logUnexpectedException((String)exception.toString(), (Throwable)exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleResponse(String string, AddressingVersion addressingVersion, SOAPVersion sOAPVersion, Message message, Dispatch<Message> dispatch) throws SOAPException {
        try {
            if (message != null) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("Processing response (in Sender) to action '" + string + "'");
                }
                if (message.isFault()) {
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.fine("Processing fault (in Sender) to action '" + string + "'");
                    }
                    SOAPMessage sOAPMessage = message.readAsSOAPMessage();
                    SOAPBody sOAPBody = sOAPMessage.getSOAPBody();
                    SOAPFault sOAPFault = sOAPBody.getFault();
                    throw new SOAPFaultException(sOAPFault);
                }
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("Sender IGNORING non-fault response after async send of message with action: " + string);
                    LOGGER.fine("Sender IGNORING non-fault response with action: " + message.getHeaders().getAction(addressingVersion, sOAPVersion));
                }
            }
            Object var10_9 = null;
            this.closeDispatch(dispatch);
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            this.closeDispatch(dispatch);
            throw throwable;
        }
    }

    private void closeDispatch(Dispatch<Message> dispatch) {
        if (dispatch != null) {
            try {
                ((Closeable)dispatch).close();
            }
            catch (Exception exception) {
                if (LOGGER.isLoggable(Level.WARNING)) {
                    LOGGER.log(Level.WARNING, exception.toString(), exception);
                }
                WseeRmLogger.logUnexpectedException((String)exception.toString(), (Throwable)exception);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class InternalAsyncHandler
    implements AsyncHandler<Message> {
        private String useAction;
        private AddressingVersion av;
        private SOAPVersion sv;
        private Dispatch<Message> useDispatch;
        private SendFailureCallback _callback;

        public InternalAsyncHandler(String string, AddressingVersion addressingVersion, SOAPVersion sOAPVersion, Dispatch<Message> dispatch, SendFailureCallback sendFailureCallback) {
            this.useAction = string;
            this.av = addressingVersion;
            this.sv = sOAPVersion;
            this.sv = sOAPVersion;
            this.useDispatch = dispatch;
            this._callback = sendFailureCallback;
        }

        public void handleResponse(Response<Message> response) {
            block3: {
                try {
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.fine("Sender just received a response indicator for action '" + this.useAction + "' on dispatch: " + this.useDispatch);
                    }
                    Sender.this.handleResponseMessage(this.useAction, this.av, this.sv, (Response<Message>)response, (Dispatch<Message>)this.useDispatch, true);
                }
                catch (Exception exception) {
                    if (this._callback == null) break block3;
                    this._callback.sendFailed(exception);
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ForceSyncAsyncHandler
    implements AsyncHandler<Message> {
        private ResponseHolder _holder;

        public ForceSyncAsyncHandler(ResponseHolder responseHolder) {
            this._holder = responseHolder;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleResponse(Response<Message> response) {
            ResponseHolder responseHolder = this._holder;
            synchronized (responseHolder) {
                this._holder.response = response;
                this._holder.notify();
            }
        }
    }

    private static class ResponseHolder {
        Response<Message> response;

        private ResponseHolder() {
        }
    }

    public static interface SendFailureCallback {
        public void sendFailed(Throwable var1);
    }
}

