/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.reliability2.tube;

import com.sun.xml.ws.api.SOAPVersion;
import com.sun.xml.ws.api.addressing.AddressingVersion;
import com.sun.xml.ws.api.message.Header;
import com.sun.xml.ws.api.message.HeaderList;
import com.sun.xml.ws.api.message.Message;
import com.sun.xml.ws.api.message.Messages;
import com.sun.xml.ws.api.message.Packet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import weblogic.wsee.jaxws.cluster.spi.RoutingInfo;
import weblogic.wsee.jaxws.cluster.spi.RoutingInfoFinder;
import weblogic.wsee.jaxws.cluster.spi.RoutingInfoFinderRegistry;
import weblogic.wsee.jaxws.framework.WsUtil;
import weblogic.wsee.reliability.WsrmConstants;
import weblogic.wsee.reliability.handshake.CloseSequenceMsg;
import weblogic.wsee.reliability.handshake.EndOfLifeSequenceMsg;
import weblogic.wsee.reliability.handshake.TerminateSequenceMsg;
import weblogic.wsee.reliability.handshake.WsrmHandshakeMsg;
import weblogic.wsee.reliability.headers.SequenceHeader;
import weblogic.wsee.reliability.headers.WsrmHeader;
import weblogic.wsee.reliability2.exception.WsrmException;
import weblogic.wsee.reliability2.headers.WsrmHeaderFactory;

public class SequenceIDRoutingInfoFinder
implements RoutingInfoFinder {
    private static final Logger LOGGER = Logger.getLogger(SequenceIDRoutingInfoFinder.class.getName());
    private static boolean _didRegister = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerIfNeeded() {
        Class<SequenceIDRoutingInfoFinder> clazz = SequenceIDRoutingInfoFinder.class;
        synchronized (SequenceIDRoutingInfoFinder.class) {
            if (!_didRegister) {
                _didRegister = true;
                SequenceIDRoutingInfoFinder sequenceIDRoutingInfoFinder = new SequenceIDRoutingInfoFinder();
                RoutingInfoFinderRegistry.getInstance().addFinder(sequenceIDRoutingInfoFinder);
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    public void setUsageMode(RoutingInfoFinder.UsageMode usageMode) {
    }

    public int getFinderPriority() {
        return 100;
    }

    public RoutingInfo findRoutingInfo(HeaderList headerList) throws Exception {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Searching headers for routing info");
        }
        for (WsrmConstants.RMVersion rMVersion : WsrmConstants.RMVersion.values()) {
            SOAPVersion[] sOAPVersionArray = WsrmHeader.getQName(SequenceHeader.class, rMVersion);
            Header header = headerList.get((QName)sOAPVersionArray, false);
            if (header == null) continue;
            return this.handleSequenceHeader(header);
        }
        for (WsrmConstants.RMVersion rMVersion : AddressingVersion.values()) {
            for (SOAPVersion sOAPVersion : SOAPVersion.values()) {
                String string = headerList.getAction((AddressingVersion)rMVersion, sOAPVersion);
                if (string == null || !WsrmConstants.Action.matchesAnyActionAndRMVersion(string)) continue;
                return this.handleRmAction(string);
            }
        }
        return null;
    }

    public RoutingInfo findRoutingInfoFromSoapBody(RoutingInfo routingInfo, Packet packet) throws Exception {
        Object object;
        Message message = packet.getMessage();
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Finding RM routing info from SOAP body on action: " + routingInfo.getName());
        }
        WsrmConstants.Action.VersionInfo versionInfo = WsrmConstants.Action.getVersionInfo(routingInfo.getName());
        String string = null;
        switch (versionInfo.action) {
            case TERMINATE_SEQUENCE: {
                object = new TerminateSequenceMsg(versionInfo.rmVersion);
                try {
                    this.readSoapBodyIntoHandshakeMessage(packet, message, (WsrmHandshakeMsg)object);
                }
                catch (SOAPException sOAPException) {
                    throw new WsrmException(sOAPException.toString(), sOAPException);
                }
                string = ((EndOfLifeSequenceMsg)object).getSequenceId();
                break;
            }
            case CLOSE_SEQUENCE: {
                object = new CloseSequenceMsg(versionInfo.rmVersion);
                try {
                    this.readSoapBodyIntoHandshakeMessage(packet, message, (WsrmHandshakeMsg)object);
                }
                catch (SOAPException sOAPException) {
                    throw new WsrmException(sOAPException.toString(), sOAPException);
                }
                string = ((EndOfLifeSequenceMsg)object).getSequenceId();
                break;
            }
        }
        if (string != null) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Found routable seq ID from SOAP body action: " + (Object)((Object)versionInfo.action) + " seq: " + string);
            }
            if ((object = WsUtil.getStoreNameFromRoutableUUID(string)) != null) {
                return new RoutingInfo((String)object, RoutingInfo.Type.PHYSICAL_STORE_NAME);
            }
        }
        return null;
    }

    private void readSoapBodyIntoHandshakeMessage(Packet packet, Message message, WsrmHandshakeMsg wsrmHandshakeMsg) throws SOAPException {
        SOAPMessage sOAPMessage = message.readAsSOAPMessage();
        wsrmHandshakeMsg.readMsg(sOAPMessage);
        message = Messages.create((SOAPMessage)sOAPMessage);
        packet.setMessage(message);
    }

    private RoutingInfo handleRmAction(String string) throws WsrmException {
        RoutingInfo routingInfo;
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Found a WS-RM action value: " + string + ". Looking for alternate headers/body with routing info");
        }
        WsrmConstants.Action.VersionInfo versionInfo = WsrmConstants.Action.getVersionInfo(string);
        switch (versionInfo.action) {
            case TERMINATE_SEQUENCE: 
            case CLOSE_SEQUENCE: {
                routingInfo = new RoutingInfo(string, RoutingInfo.Type.NEED_BODY);
                break;
            }
            default: {
                routingInfo = null;
            }
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("RM finder found " + (routingInfo != null ? "routing info " + routingInfo : "no routing info") + " from action message: " + string);
        }
        return routingInfo;
    }

    private RoutingInfo handleSequenceHeader(Header header) throws WsrmException {
        String string;
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Found sequence header " + header.getLocalPart() + " for routing info");
        }
        SequenceHeader sequenceHeader = WsrmHeaderFactory.getInstance().createWsrmHeaderFromHeader(SequenceHeader.class, header);
        String string2 = sequenceHeader.getSequenceId();
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Found sequence header with seq " + string2 + ". Looking for routing info");
        }
        if ((string = WsUtil.getStoreNameFromRoutableUUID(string2)) != null) {
            return new RoutingInfo(string, RoutingInfo.Type.PHYSICAL_STORE_NAME);
        }
        return null;
    }
}

