/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.reliability2.tube;

import com.sun.istack.NotNull;
import com.sun.xml.ws.api.WSService;
import com.sun.xml.ws.api.addressing.WSEndpointReference;
import com.sun.xml.ws.client.WSServiceDelegate;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.ws.Dispatch;
import javax.xml.ws.Service;
import javax.xml.ws.WebServiceFeature;
import weblogic.wsee.jaxws.spi.AsyncHandlerAllowedInternalFeature;
import weblogic.wsee.jaxws.spi.ClientIdentityRegistry;
import weblogic.wsee.reliability2.exception.WsrmException;
import weblogic.wsee.reliability2.tube.DispatchFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WsrmClientDispatchFactory
implements DispatchFactory {
    private static final Logger LOGGER = Logger.getLogger(WsrmClientDispatchFactory.class.getName());
    private String _clientId;

    public WsrmClientDispatchFactory(String string) {
        this._clientId = string;
    }

    @Override
    public <T> Dispatch<T> createDispatch(@NotNull WSEndpointReference wSEndpointReference, @NotNull Class<T> clazz) throws Exception {
        ClientIdentityRegistry.ClientInfo clientInfo;
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Creating equivalent dispatch for client identity: " + this._clientId);
        }
        if (!(clientInfo = ClientIdentityRegistry.getRequiredClientInfo(this._clientId)).isInitialized()) {
            throw new WsrmException("DispatchFactory cannot be used until client identity '" + this._clientId + "' has been initialized");
        }
        Service.Mode mode = Service.Mode.MESSAGE;
        WSServiceDelegate wSServiceDelegate = clientInfo.getOriginalConfig().getService();
        Dispatch<T> dispatch = ClientIdentityRegistry.getEquivalentDispatch(this._clientId, clazz, mode, (WSService)wSServiceDelegate, wSEndpointReference, new WebServiceFeature[]{new AsyncHandlerAllowedInternalFeature()});
        return dispatch;
    }
}

