/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.reliability2.tube;

import com.sun.xml.ws.api.WSBinding;
import com.sun.xml.ws.api.pipe.ClientTubeAssemblerContext;
import java.lang.ref.WeakReference;
import java.util.Map;
import java.util.SortedSet;
import javax.xml.ws.BindingProvider;
import weblogic.wsee.WseeRmLogger;
import weblogic.wsee.jaxws.spi.ClientInstance;
import weblogic.wsee.policy.framework.PolicyException;
import weblogic.wsee.reliability.MessageRange;
import weblogic.wsee.reliability.WsrmConstants;
import weblogic.wsee.reliability2.api.SequenceState;
import weblogic.wsee.reliability2.api.WsrmClient;
import weblogic.wsee.reliability2.exception.WsrmException;
import weblogic.wsee.reliability2.policy.WsrmPolicyHelper;
import weblogic.wsee.reliability2.property.WsrmInvocationPropertyBag;
import weblogic.wsee.reliability2.sequence.SourceMessageInfo;
import weblogic.wsee.reliability2.sequence.SourceSequence;
import weblogic.wsee.reliability2.sequence.SourceSequenceManager;
import weblogic.wsee.reliability2.sequence.UnknownSourceSequenceException;
import weblogic.wsee.reliability2.tube.WsrmClientDispatchFactory;
import weblogic.wsee.reliability2.tube.WsrmClientRuntimeFeature;
import weblogic.wsee.reliability2.tube.WsrmTubeUtils;
import weblogic.wsee.reliability2.tube.processors.TerminateSequenceProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WsrmClientImpl
implements WsrmClient {
    public static final String CLIENT_CURRENT_SEQUENCE_ID_PROP_NAME = "weblogic.wsee.reliability2.client.CurrentSequenceID";
    private BindingProvider _port;
    private WsrmTubeUtils _tubeUtil;

    public WsrmClientImpl(BindingProvider bindingProvider, WsrmClientRuntimeFeature wsrmClientRuntimeFeature) throws PolicyException {
        ClientTubeAssemblerContext clientTubeAssemblerContext = wsrmClientRuntimeFeature.getContext();
        WSBinding wSBinding = clientTubeAssemblerContext.getBinding();
        this._port = bindingProvider;
        WsrmPolicyHelper wsrmPolicyHelper = new WsrmPolicyHelper(wsrmClientRuntimeFeature.getPort());
        this._tubeUtil = new WsrmTubeUtils(true, wSBinding, clientTubeAssemblerContext.getWsdlModel(), wsrmPolicyHelper, new WsrmClientDispatchFactory(this.getClientId()), clientTubeAssemblerContext, null);
    }

    @Override
    public void dispose() {
        try {
            SequenceState sequenceState = this.getSequenceState();
            if (sequenceState != null && sequenceState == SequenceState.CREATED) {
                this.terminateSequence();
            }
        }
        catch (Exception exception) {
            WseeRmLogger.logUnexpectedException((String)exception.toString(), (Throwable)exception);
        }
    }

    private <T> T getProperty(String string, Class<T> clazz) {
        WsrmInvocationPropertyBag wsrmInvocationPropertyBag = this.getRmInvokeProps();
        if (wsrmInvocationPropertyBag.containsProp(string)) {
            Object object = wsrmInvocationPropertyBag.getProp(string);
            if (object != null && clazz.isAssignableFrom(object.getClass())) {
                return (T)object;
            }
            return null;
        }
        wsrmInvocationPropertyBag = this.getRmInvokePropsFromResponseContext();
        if (wsrmInvocationPropertyBag != null) {
            Object object = wsrmInvocationPropertyBag.getProp(string);
            if (object != null && clazz.isAssignableFrom(object.getClass())) {
                return (T)object;
            }
            return null;
        }
        return null;
    }

    private WsrmInvocationPropertyBag getRmInvokeProps() {
        WsrmInvocationPropertyBag wsrmInvocationPropertyBag = this.getRmInvokePropsFromRequestContext();
        if (wsrmInvocationPropertyBag == null) {
            wsrmInvocationPropertyBag = this.getRmInvokePropsFromResponseContext();
        }
        return wsrmInvocationPropertyBag;
    }

    @Override
    public void reset() {
        ClientInstance clientInstance;
        this.setSequenceId(null);
        WsrmInvocationPropertyBag wsrmInvocationPropertyBag = this.getRmInvokeProps();
        wsrmInvocationPropertyBag.setFinalMsgFlag(false);
        wsrmInvocationPropertyBag.setMostRecentMsgNum(0L);
        WeakReference weakReference = (WeakReference)this._port.getRequestContext().get("weblogic.wsee.jaxws.spi.ClientInstanceWeakRef");
        ClientInstance clientInstance2 = clientInstance = weakReference != null ? (ClientInstance)weakReference.get() : null;
        if (clientInstance != null) {
            clientInstance.getProps().remove(CLIENT_CURRENT_SEQUENCE_ID_PROP_NAME);
        }
    }

    @Override
    public String getId() {
        WeakReference weakReference = (WeakReference)this._port.getRequestContext().get("weblogic.wsee.jaxws.spi.ClientInstanceWeakRef");
        return ((ClientInstance)weakReference.get()).getId().toString();
    }

    private String getClientId() {
        WeakReference weakReference = (WeakReference)this._port.getRequestContext().get("weblogic.wsee.jaxws.spi.ClientInstanceWeakRef");
        return ((ClientInstance)weakReference.get()).getId().getClientId();
    }

    @Override
    public String getSequenceId() {
        return this.getRmInvokePropsFromRequestContext().getSequenceId();
    }

    @Override
    public SequenceState getSequenceState() {
        String string = this.getSequenceId();
        if (string == null) {
            return null;
        }
        SourceSequence sourceSequence = null;
        try {
            sourceSequence = SourceSequenceManager.getInstance().getSequence(WsrmConstants.RMVersion.latest(), string, true);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return sourceSequence != null ? sourceSequence.getState() : null;
    }

    @Override
    public void setSequenceId(String string) {
        WsrmInvocationPropertyBag wsrmInvocationPropertyBag = this.getRmInvokePropsFromRequestContext();
        wsrmInvocationPropertyBag.setSequenceId(string);
    }

    @Override
    public void requestAcknowledgement() throws WsrmException {
        SourceSequence sourceSequence = this.getSequence();
        WsrmTubeUtils.sendAcknowledgementRequest(sourceSequence, this._tubeUtil.getDispatchFactory());
    }

    @Override
    public SortedSet<MessageRange> getAckRanges() throws UnknownSourceSequenceException {
        SourceSequence sourceSequence = this.getSequence();
        SortedSet<MessageRange> sortedSet = sourceSequence.getAckRanges();
        return sortedSet;
    }

    @Override
    public long getMostRecentMessageNumber() {
        Long l = this.getProperty("weblogic.wsee.reliability2.MostRecentMsgNum", Long.class);
        if (l == null) {
            return -1L;
        }
        return l;
    }

    @Override
    public SourceMessageInfo getMessageInfo(long l) throws UnknownSourceSequenceException {
        SourceSequence sourceSequence = this.getSequence();
        SourceMessageInfo sourceMessageInfo = (SourceMessageInfo)sourceSequence.getRequest(l);
        return sourceMessageInfo;
    }

    @Override
    public void setFinalMessage() {
        WsrmInvocationPropertyBag wsrmInvocationPropertyBag = this.getRmInvokeProps();
        wsrmInvocationPropertyBag.setFinalMsgFlag(true);
    }

    @Override
    public void closeSequence() throws WsrmException {
        SourceSequence sourceSequence = this.getSequence();
        WsrmTubeUtils.sendCloseSequence(sourceSequence, this._tubeUtil.getDispatchFactory());
    }

    @Override
    public void sendWsrm10EmptyLastMessage() throws WsrmException {
        SourceSequence sourceSequence = this.getSequence();
        if (sourceSequence.getRmVersion() != WsrmConstants.RMVersion.RM_10) {
            return;
        }
        TerminateSequenceProcessor.sendEmptyLastMessage(sourceSequence);
    }

    @Override
    public void terminateSequence() throws WsrmException {
        SourceSequence sourceSequence = this.getSequence();
        WsrmTubeUtils.sendTerminateSequence(sourceSequence, this._tubeUtil.getDispatchFactory());
    }

    private SourceSequence getSequence() throws UnknownSourceSequenceException {
        String string = this.getSequenceId();
        SourceSequence sourceSequence = SourceSequenceManager.getInstance().getSequence(WsrmConstants.RMVersion.latest(), string, false);
        return sourceSequence;
    }

    private WsrmInvocationPropertyBag getRmInvokePropsFromRequestContext() {
        Map map = this._port.getRequestContext();
        WsrmInvocationPropertyBag wsrmInvocationPropertyBag = (WsrmInvocationPropertyBag)map.get(WsrmInvocationPropertyBag.key);
        if (wsrmInvocationPropertyBag == null) {
            wsrmInvocationPropertyBag = new WsrmInvocationPropertyBag(map);
            map.put(WsrmInvocationPropertyBag.key, wsrmInvocationPropertyBag);
        }
        return wsrmInvocationPropertyBag;
    }

    private WsrmInvocationPropertyBag getRmInvokePropsFromResponseContext() {
        Map map = this._port.getResponseContext();
        if (map == null) {
            return null;
        }
        WsrmInvocationPropertyBag wsrmInvocationPropertyBag = (WsrmInvocationPropertyBag)map.get(WsrmInvocationPropertyBag.key);
        if (wsrmInvocationPropertyBag == null) {
            wsrmInvocationPropertyBag = new WsrmInvocationPropertyBag(map);
            map.put(WsrmInvocationPropertyBag.key, wsrmInvocationPropertyBag);
        }
        return wsrmInvocationPropertyBag;
    }
}

