/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.reliability2.tube;

import com.sun.istack.Nullable;
import java.lang.ref.WeakReference;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.ws.BindingProvider;
import weblogic.wsee.WseeRmLogger;
import weblogic.wsee.jaxws.spi.ClientInstance;
import weblogic.wsee.jaxws.spi.ClientInstanceIdentity;
import weblogic.wsee.reliability.WsrmConstants;
import weblogic.wsee.reliability2.api.SequenceState;
import weblogic.wsee.reliability2.api.WsrmClient;
import weblogic.wsee.reliability2.api.WsrmClientFactory;
import weblogic.wsee.reliability2.property.WsrmInvocationPropertyBag;
import weblogic.wsee.reliability2.sequence.SourceSequence;
import weblogic.wsee.reliability2.sequence.SourceSequenceManager;
import weblogic.wsee.reliability2.tube.processors.TerminateSequenceProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WsrmClientRuntime {
    private static final Logger LOGGER = Logger.getLogger(WsrmClientRuntime.class.getName());
    @Nullable
    private WeakReference<ClientInstance> _clientInstanceRef;
    private String _seqId;
    private ClientInstanceListener _clientInstanceListener;

    public WsrmClientRuntime(@Nullable WeakReference<ClientInstance> weakReference) {
        this._clientInstanceRef = weakReference;
    }

    public String getSequenceId() {
        return this._seqId;
    }

    public ClientInstanceIdentity getClientInstanceId() {
        return this._clientInstanceRef != null ? ((ClientInstance)this._clientInstanceRef.get()).getId() : null;
    }

    public void internalSetSequenceId(String string) {
        if (string != null && this._seqId == null || string == null && this._seqId != null || string != null && !string.equals(this._seqId)) {
            this._seqId = string;
            this.internalSyncClientInstanceAndSequenceId();
        }
    }

    private void internalSyncClientInstanceAndSequenceId() {
        ClientInstance clientInstance;
        ClientInstance clientInstance2 = clientInstance = this._clientInstanceRef != null ? (ClientInstance)this._clientInstanceRef.get() : null;
        if (this._clientInstanceListener != null && clientInstance != null) {
            clientInstance.removeClientInstanceListener(this._clientInstanceListener);
            this._clientInstanceListener = null;
        }
        if (clientInstance != null) {
            if (this._seqId != null) {
                this._clientInstanceListener = new ClientInstanceListener(this._seqId);
                clientInstance.addClientInstanceListener(this._clientInstanceListener);
            }
            Map map = ((BindingProvider)clientInstance.getInstance()).getRequestContext();
            WsrmInvocationPropertyBag wsrmInvocationPropertyBag = WsrmInvocationPropertyBag.getFromMap(map);
            wsrmInvocationPropertyBag.internalSetSequenceId(this._seqId);
        }
    }

    private class ClientInstanceListener
    implements ClientInstance.Listener {
        private String _seqId;

        private ClientInstanceListener(String string) {
            this._seqId = string;
        }

        public void clientInstanceClosing(ClientInstance clientInstance) {
            try {
                SourceSequence sourceSequence = (SourceSequence)SourceSequenceManager.getInstance().getSequence(WsrmConstants.RMVersion.latest(), this._seqId);
                if (sourceSequence == null || sourceSequence.getState() == SequenceState.TERMINATING || sourceSequence.getState() == SequenceState.TERMINATED) {
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.fine("Client instance " + clientInstance + " has been closed, but the RM sequence on it does not require termination, no action required");
                    }
                    return;
                }
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("Setting final message number on source sequence " + this._seqId + " because it has been closed by the client");
                }
                TerminateSequenceProcessor.setSentFinalMessage(sourceSequence, sourceSequence.getMaxMessageNum());
            }
            catch (Exception exception) {
                if (LOGGER.isLoggable(Level.WARNING)) {
                    LOGGER.log(Level.WARNING, exception.toString(), exception);
                }
                WseeRmLogger.logUnexpectedException((String)exception.toString(), (Throwable)exception);
            }
        }

        public void clientInstanceRecycled(ClientInstance clientInstance) {
            WsrmClient wsrmClient = WsrmClientFactory.getWsrmClientFromPort(clientInstance.getInstance());
            wsrmClient.reset();
        }
    }
}

