/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.reliability2.tube;

import com.sun.istack.NotNull;
import com.sun.istack.Nullable;
import com.sun.xml.ws.api.WSBinding;
import com.sun.xml.ws.api.WSService;
import com.sun.xml.ws.api.model.wsdl.WSDLPort;
import com.sun.xml.ws.api.pipe.ClientTubeAssemblerContext;
import java.io.Serializable;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import weblogic.jws.jaxws.client.ClientIdentityFeature;
import weblogic.jws.jaxws.client.async.AsyncClientHandlerFeature;
import weblogic.wsee.jaxws.client.async.AsyncClientHandlerMarkerFeature;
import weblogic.wsee.jaxws.persistence.ClientInstanceProperties;
import weblogic.wsee.jaxws.persistence.PersistenceConfig;
import weblogic.wsee.jaxws.spi.ClientIdentityRegistry;
import weblogic.wsee.jaxws.spi.ClientInstance;
import weblogic.wsee.jaxws.spi.ClientInstanceIdentity;
import weblogic.wsee.reliability2.api.WsrmClientInitFeature;
import weblogic.wsee.reliability2.exception.WsrmException;
import weblogic.wsee.reliability2.tube.WsrmTubelineDeploymentListener;
import weblogic.wsee.ws.WsPort;

public class WsrmClientRuntimeFeature
extends WsrmClientInitFeature {
    private static final Logger LOGGER = Logger.getLogger(WsrmClientRuntimeFeature.class.getName());
    private static String ID = "WS-RM Client Feature";
    private String _clientId;
    private ClientTubeAssemblerContext _context;

    public WsrmClientRuntimeFeature(String string, ClientTubeAssemblerContext clientTubeAssemblerContext, WsrmClientInitFeature wsrmClientInitFeature) {
        super(wsrmClientInitFeature);
        this._clientId = string;
        this._context = clientTubeAssemblerContext;
    }

    public WsrmClientRuntimeFeature(String string, ClientTubeAssemblerContext clientTubeAssemblerContext) {
        super(true);
        this._clientId = string;
        this._context = clientTubeAssemblerContext;
    }

    public String getID() {
        return ID;
    }

    ClientTubeAssemblerContext getContext() {
        return this._context;
    }

    public String getClientId() {
        return this._clientId;
    }

    public void setClientId(String string) {
        this._clientId = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String loadClientCurrentSequenceId(@NotNull ClientInstance clientInstance) {
        if (clientInstance.getProps() == null) {
            return null;
        }
        Map<String, Serializable> map = clientInstance.getProps();
        synchronized (map) {
            return (String)((Object)clientInstance.getProps().get("weblogic.wsee.reliability2.client.CurrentSequenceID"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeClientCurrentSequenceId(@NotNull ClientInstance clientInstance, String string) {
        if (clientInstance.getId() == null) {
            return;
        }
        ClientIdentityFeature clientIdentityFeature = ClientIdentityRegistry.getClientIdentityFeature(clientInstance.getId().getClientId());
        if (clientIdentityFeature != null && clientIdentityFeature.getType() == ClientIdentityFeature.Type.CUSTOMER) {
            Map<String, Serializable> map;
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Storing current sequence " + string + " into client props for client instance: " + clientInstance.getId());
            }
            Map<String, Serializable> map2 = map = clientInstance.getProps();
            synchronized (map2) {
                map.put("weblogic.wsee.reliability2.client.CurrentSequenceID", (Serializable)((Object)string));
            }
            clientInstance.saveProps();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeClientCurrentSequenceId(ClientInstanceIdentity clientInstanceIdentity) {
        if (clientInstanceIdentity != null) {
            Map<String, Serializable> map;
            PersistenceConfig.Client client;
            ClientInstanceProperties clientInstanceProperties;
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Removing client-side knowledge of current sequence ID for client instance: " + clientInstanceIdentity);
            }
            if ((clientInstanceProperties = (ClientInstanceProperties)ClientInstanceProperties.getStoreMap((client = PersistenceConfig.getClientConfig(this._context)).getLogicalStoreName()).get(clientInstanceIdentity)) == null) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("Client didn't know about a current sequence. Client was: " + clientInstanceIdentity);
                }
                return;
            }
            Map<String, Serializable> map2 = map = clientInstanceProperties.getPropertyMap();
            synchronized (map2) {
                String string = (String)((Object)map.remove("weblogic.wsee.reliability2.client.CurrentSequenceID"));
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("Client has stored seq ID " + string + ". Client was: " + clientInstanceIdentity);
                }
                if (map.isEmpty()) {
                    ClientInstanceProperties.getStoreMap(client.getLogicalStoreName()).remove(clientInstanceIdentity);
                } else {
                    ClientInstanceProperties.getStoreMap(client.getLogicalStoreName()).put(clientInstanceIdentity, clientInstanceProperties);
                }
            }
        }
    }

    public void setNonBufferedAfterInit(boolean bl) throws WsrmException {
        WSBinding wSBinding = this.getBinding();
        if (!(bl || wSBinding.isFeatureEnabled(AsyncClientHandlerFeature.class) || wSBinding.isFeatureEnabled(AsyncClientHandlerMarkerFeature.class))) {
            throw new WsrmException("Cannot enable RM buffering without first adding AsyncClientHandlerFeature to Port/Dispatch");
        }
        this.setNonBufferedSource(bl);
    }

    WSService getService() {
        return this._context.getService();
    }

    public WSBinding getBinding() {
        return this._context.getBinding();
    }

    public WSDLPort getWsdlPort() {
        return this._context.getWsdlModel();
    }

    @Nullable
    public WsPort getPort() {
        return WsrmTubelineDeploymentListener.getWsPort(this._context);
    }

    public QName getPortName() {
        WsPort wsPort = this.getPort();
        return wsPort != null ? wsPort.getWsdlPort().getName() : null;
    }

    public static WsrmClientRuntimeFeature getFromBinding(WSBinding wSBinding) {
        WsrmClientRuntimeFeature wsrmClientRuntimeFeature = (WsrmClientRuntimeFeature)wSBinding.getFeature(WsrmClientRuntimeFeature.class);
        return wsrmClientRuntimeFeature;
    }
}

