/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.reliability2.tube;

import com.sun.istack.NotNull;
import com.sun.istack.Nullable;
import com.sun.xml.ws.api.SOAPVersion;
import com.sun.xml.ws.api.WSBinding;
import com.sun.xml.ws.api.addressing.AddressingVersion;
import com.sun.xml.ws.api.addressing.WSEndpointReference;
import com.sun.xml.ws.api.message.Header;
import com.sun.xml.ws.api.message.Message;
import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.api.model.wsdl.WSDLPort;
import com.sun.xml.ws.api.pipe.ClientTubeAssemblerContext;
import com.sun.xml.ws.api.pipe.Fiber;
import com.sun.xml.ws.api.pipe.NextAction;
import com.sun.xml.ws.api.pipe.Tube;
import com.sun.xml.ws.api.pipe.TubeCloner;
import com.sun.xml.ws.api.pipe.helper.AbstractFilterTubeImpl;
import com.sun.xml.ws.message.RelatesToHeader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import weblogic.j2ee.descriptor.wl.PortInfoBean;
import weblogic.j2ee.descriptor.wl.PropertyNamevalueBean;
import weblogic.j2ee.descriptor.wl.ServiceReferenceDescriptionBean;
import weblogic.jws.jaxws.client.ClientIdentityFeature;
import weblogic.wsee.WseeRmLogger;
import weblogic.wsee.jaxws.client.async.AsyncTransportProviderPropertyBag;
import weblogic.wsee.jaxws.spi.WLSServiceDelegate;
import weblogic.wsee.reliability.faults.WsrmFaultException;
import weblogic.wsee.reliability2.api_internal.WsrmLifecycleEvent;
import weblogic.wsee.reliability2.api_internal.WsrmLifecycleEventListenerRegistry;
import weblogic.wsee.reliability2.exception.WsrmAbortSendException;
import weblogic.wsee.reliability2.exception.WsrmException;
import weblogic.wsee.reliability2.policy.WsrmPolicyHelper;
import weblogic.wsee.reliability2.property.WsrmConfig;
import weblogic.wsee.reliability2.property.WsrmInvocationPropertyBag;
import weblogic.wsee.reliability2.saf.WsrmSAFDispatchFactory;
import weblogic.wsee.reliability2.sequence.DestinationSequence;
import weblogic.wsee.reliability2.sequence.DestinationSequenceManager;
import weblogic.wsee.reliability2.sequence.SequenceIdFactory;
import weblogic.wsee.reliability2.sequence.SourceSequence;
import weblogic.wsee.reliability2.sequence.SourceSequenceManager;
import weblogic.wsee.reliability2.tube.DispatchFactoryResolver;
import weblogic.wsee.reliability2.tube.Sender;
import weblogic.wsee.reliability2.tube.WsrmClientDispatchFactory;
import weblogic.wsee.reliability2.tube.WsrmClientRuntimeFeature;
import weblogic.wsee.reliability2.tube.WsrmTubeUtils;
import weblogic.wsee.reliability2.tube.WsrmTubelineDeploymentListener;
import weblogic.wsee.ws.WsPort;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WsrmClientTube
extends AbstractFilterTubeImpl
implements SequenceIdFactory {
    private static final Logger LOGGER = Logger.getLogger(WsrmClientTube.class.getName());
    private ClientTubeAssemblerContext _context;
    private WsrmClientRuntimeFeature _wsrmClientFeature;
    private WSBinding _binding;
    private WSDLPort _wsdlPort;
    private WsrmPolicyHelper _policyHelper;
    @Nullable
    private WLSServiceDelegate _service;
    private WsrmClientDispatchFactory _dispatchFactory;
    private WsrmTubeUtils _tubeUtil;

    public WsrmClientTube(Tube tube, ClientTubeAssemblerContext clientTubeAssemblerContext) {
        super(tube);
        WSBinding wSBinding = clientTubeAssemblerContext.getBinding();
        WsPort wsPort = WsrmTubelineDeploymentListener.getWsPort(clientTubeAssemblerContext);
        WsrmPolicyHelper wsrmPolicyHelper = new WsrmPolicyHelper(wsPort);
        WLSServiceDelegate wLSServiceDelegate = null;
        if (clientTubeAssemblerContext.getService() instanceof WLSServiceDelegate) {
            wLSServiceDelegate = (WLSServiceDelegate)clientTubeAssemblerContext.getService();
        }
        this.commonConstructorCode(clientTubeAssemblerContext, wSBinding, clientTubeAssemblerContext.getWsdlModel(), wsrmPolicyHelper, wLSServiceDelegate);
    }

    public WsrmClientTube(WsrmClientTube wsrmClientTube, TubeCloner tubeCloner) {
        super((AbstractFilterTubeImpl)wsrmClientTube, tubeCloner);
        this.commonConstructorCode(wsrmClientTube._context, wsrmClientTube._binding, wsrmClientTube._wsdlPort, wsrmClientTube._policyHelper, wsrmClientTube._service);
    }

    private void commonConstructorCode(ClientTubeAssemblerContext clientTubeAssemblerContext, WSBinding wSBinding, WSDLPort wSDLPort, WsrmPolicyHelper wsrmPolicyHelper, WLSServiceDelegate wLSServiceDelegate) {
        this._context = clientTubeAssemblerContext;
        this._binding = wSBinding;
        this._wsrmClientFeature = (WsrmClientRuntimeFeature)this._binding.getFeature(WsrmClientRuntimeFeature.class);
        this._wsdlPort = wSDLPort;
        this._policyHelper = wsrmPolicyHelper;
        this._service = wLSServiceDelegate;
        if (this._wsrmClientFeature == null) {
            throw new IllegalStateException("No WsrmClientRuntimeFeature");
        }
        this._dispatchFactory = new WsrmClientDispatchFactory(this._wsrmClientFeature.getClientId());
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("WsrmClientTube created for port " + (wSDLPort != null ? wSDLPort.getName() : null));
            WsrmConfig.Source source = WsrmConfig.getSource(this._context, null, false);
            LOGGER.fine("WsrmClientTube: RM Source Config:\n" + source);
        }
        this._tubeUtil = new WsrmTubeUtils(true, this._binding, this._wsdlPort, this._policyHelper, this._dispatchFactory, this._context, null);
    }

    public void preDestroy() {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Destroying WsrmClientTube with client ID: " + (this._wsrmClientFeature != null ? this._wsrmClientFeature.getClientId() : null));
        }
        ClientIdentityFeature clientIdentityFeature = (ClientIdentityFeature)this._binding.getFeature(ClientIdentityFeature.class);
        DispatchFactoryResolver.unregisterClientDispatchFactory(clientIdentityFeature.getClientId());
        if (this.next != null) {
            this.next.preDestroy();
        }
    }

    @NotNull
    public NextAction processRequest(@NotNull Packet packet) {
        try {
            WsrmTubeUtils.OutboundMessageResult outboundMessageResult = this._tubeUtil.processOutboundMessage(packet, this, packet.endpointAddress.toString());
            if (outboundMessageResult.messageBuffered) {
                if (outboundMessageResult.messageInfo.getClientInvokeInfo().impliesSuspendedRequestFiber()) {
                    return this.doSuspend();
                }
                return this.doReturnWith(packet.createClientResponse(null));
            }
            if (outboundMessageResult.messageAborted) {
                return this.doReturnWith(packet.createClientResponse(null));
            }
            NextAction nextAction = new NextAction();
            nextAction.invokeAsync(this.next, packet);
            return nextAction;
        }
        catch (WsrmAbortSendException wsrmAbortSendException) {
            packet.setMessage(null);
            return this.doReturnWith(packet);
        }
        catch (WsrmException wsrmException) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "WsrmClientTube processRequest failed: " + wsrmException.toString(), wsrmException);
            }
            if ((packet = this._tubeUtil.handleOutboundException(packet, wsrmException)) != null) {
                return this.doReturnWith(packet);
            }
            throw new RuntimeException(wsrmException.toString(), wsrmException);
        }
        catch (Exception exception) {
            if (LOGGER.isLoggable(Level.SEVERE)) {
                LOGGER.log(Level.SEVERE, "WsrmClientTube processRequest failed: " + exception.toString(), exception);
            }
            WsrmException wsrmException = new WsrmException(exception.toString(), exception);
            wsrmException.fillInStackTrace();
            packet = this._tubeUtil.handleOutboundException(packet, wsrmException);
            if (packet != null) {
                return this.doReturnWith(packet);
            }
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new RuntimeException(exception.toString(), exception);
        }
    }

    @NotNull
    public NextAction processResponse(@NotNull Packet packet) {
        NextAction nextAction = this.doReturnWith(packet);
        try {
            if (packet.getMessage() != null) {
                WsrmLifecycleEventListenerRegistry.getInstance().notifyEventType(WsrmLifecycleEvent.Type.CLIENT_IN_RESPONSE);
            }
            WsrmTubeUtils.InboundMessageResult inboundMessageResult = this._tubeUtil.processInboundMessage(packet);
            if (inboundMessageResult.needSuspendOnCurrentFiber) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("Suspending fiber at the request of inbound message processing");
                }
                nextAction = this.doSuspend();
                Fiber.current().addListener(inboundMessageResult.currentFiberSuspendingCallback);
            } else {
                if (inboundMessageResult.message != null && inboundMessageResult.rmFault != null) {
                    throw new WsrmFaultException(inboundMessageResult.rmFault);
                }
                if (inboundMessageResult.message != null) {
                    nextAction = this.handleResponseToInboundMessage(packet, inboundMessageResult);
                } else if (inboundMessageResult.handled) {
                    packet.setMessage(null);
                    nextAction = this.doReturnWith(packet);
                }
            }
        }
        catch (Exception exception) {
            if (LOGGER.isLoggable(Level.SEVERE)) {
                LOGGER.log(Level.SEVERE, "WsrmClientTube processResponse failed: " + exception.toString(), exception);
            }
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new RuntimeException(exception.toString(), exception);
        }
        return nextAction;
    }

    private NextAction handleResponseToInboundMessage(Packet packet, WsrmTubeUtils.InboundMessageResult inboundMessageResult) throws WsrmException, SOAPException, IOException {
        String string;
        String string2;
        String string3;
        if (LOGGER.isLoggable(Level.FINE)) {
            string3 = this.getMessageInfoString(packet.getMessage());
            string2 = this.getMessageInfoString(inboundMessageResult.message);
            LOGGER.fine("WsrmClientTube sending response '" + string2 + "' to inbound message!: " + string3);
        }
        string3 = packet.getMessage().getHeaders().getReplyTo(this._binding.getAddressingVersion(), this._binding.getSOAPVersion());
        string2 = packet.getMessage();
        if (string3 != null && !string3.isAnonymous()) {
            if (packet.transportBackChannel != null) {
                packet.transportBackChannel.close();
            }
            this.sendResponseToInboundMessage((Message)string2, inboundMessageResult, (WSEndpointReference)string3);
        } else {
            string = this.getMessageInfoString((Message)string2);
            String string4 = this.getMessageInfoString(inboundMessageResult.message);
            if (packet.getSatellite(AsyncTransportProviderPropertyBag.class) != null) {
                Packet packet2 = packet.createClientResponse(inboundMessageResult.message);
                AsyncTransportProviderPropertyBag asyncTransportProviderPropertyBag = AsyncTransportProviderPropertyBag.propertySetRetriever.getFromPacket(packet);
                asyncTransportProviderPropertyBag.setResponsePacket(packet2);
                if (LOGGER.isLoggable(Level.FINE)) {
                    String string5 = "Incoming Response: '" + string + "' - Outgoing Secondary Response: '" + string4 + "' - " + inboundMessageResult.message.toString();
                    LOGGER.fine("Set secondary response packet: " + string5);
                    LOGGER.fine("Incoming Response Contents: " + this.dumpMessage((Message)string2));
                    LOGGER.fine("Outgoing Secondary Response Contents: " + this.dumpMessage(inboundMessageResult.message));
                }
            } else {
                String string6 = "Incoming Response: '" + string + "' - Outgoing Secondary Response: '" + string4 + "' - " + inboundMessageResult.message.toString();
                if (LOGGER.isLoggable(Level.FINE)) {
                    String string7 = WseeRmLogger.logAttemptedSecondaryClientSideResponseFailedLoggable((String)string6, (String)"Anonymous ReplyTo").getMessage();
                    LOGGER.fine(string7);
                    LOGGER.fine("Incoming Response Contents: " + this.dumpMessage((Message)string2));
                    LOGGER.fine("Outgoing Secondary Response Contents: " + this.dumpMessage(inboundMessageResult.message));
                }
                WseeRmLogger.logAttemptedSecondaryClientSideResponseFailedLoggable((String)string6, (String)"Anonymous ReplyTo").log();
            }
        }
        string = new NextAction();
        string.abortResponse(packet);
        return string;
    }

    private String dumpMessage(Message message) throws SOAPException, IOException {
        if (message == null) {
            return "null";
        }
        SOAPMessage sOAPMessage = message.readAsSOAPMessage();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        sOAPMessage.writeTo((OutputStream)byteArrayOutputStream);
        return new String(byteArrayOutputStream.toByteArray());
    }

    private void sendResponseToInboundMessage(final Message message, final WsrmTubeUtils.InboundMessageResult inboundMessageResult, final WSEndpointReference wSEndpointReference) throws WsrmException {
        final WSEndpointReference wSEndpointReference2 = this._binding.getAddressingVersion().anonymousEpr;
        this.addRelatedIdToResponseMsg(message, inboundMessageResult);
        Runnable runnable = new Runnable(){

            public void run() {
                Sender sender = new Sender(WsrmClientTube.this._dispatchFactory);
                try {
                    HashMap<String, Object> hashMap = null;
                    if (inboundMessageResult.seq instanceof SourceSequence) {
                        hashMap = SourceSequenceManager.getInstance().getSenderInvokeProperties((SourceSequence)inboundMessageResult.seq, (Packet)null);
                    } else if (inboundMessageResult.seq instanceof DestinationSequence) {
                        hashMap = DestinationSequenceManager.getInstance().getSenderInvokeProperties((DestinationSequence)inboundMessageResult.seq, (Packet)null);
                    }
                    if (LOGGER.isLoggable(Level.FINE)) {
                        String string = WsrmClientTube.this.getMessageInfoString(message);
                        String string2 = WsrmClientTube.this.getMessageInfoString(inboundMessageResult.message);
                        String string3 = "Incoming Response: '" + string + "' - Outgoing Secondary Response: '" + string2 + "' - " + inboundMessageResult.message.toString();
                        LOGGER.fine("Delivering response to inbound response message: " + string3);
                        LOGGER.fine("Incoming Response Contents: " + WsrmClientTube.this.dumpMessage(message));
                        LOGGER.fine("Outgoing Secondary Response Contents: " + WsrmClientTube.this.dumpMessage(inboundMessageResult.message));
                    }
                    sender.send(inboundMessageResult.message, null, wSEndpointReference, wSEndpointReference2, hashMap != null ? hashMap : new HashMap<String, Object>(), false, true);
                }
                catch (Exception exception) {
                    String string = WsrmClientTube.this.getMessageInfoString(message);
                    String string4 = WsrmClientTube.this.getMessageInfoString(inboundMessageResult.message);
                    String string5 = "Incoming Response: '" + string + "' - Outgoing Secondary Response: '" + string4 + "' - " + inboundMessageResult.message.toString();
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.fine("%% Encountered exception while trying to send secondary response. Details of response/secondary-response and exception follow");
                        LOGGER.fine("%% Response details: " + string5);
                        LOGGER.log(Level.FINE, "%% Exception details: ", exception);
                    }
                    WseeRmLogger.logUnexpectedException((String)(string5 + " - " + exception.toString()), (Throwable)exception);
                    WseeRmLogger.logAttemptedSecondaryClientSideResponseFailedLoggable((String)string5, (String)exception.toString()).log();
                }
            }
        };
        runnable.run();
    }

    private void addRelatedIdToResponseMsg(Message message, WsrmTubeUtils.InboundMessageResult inboundMessageResult) {
        AddressingVersion addressingVersion = this._binding.getAddressingVersion();
        SOAPVersion sOAPVersion = this._binding.getSOAPVersion();
        if (addressingVersion != null && inboundMessageResult.message.getHeaders().getRelatesTo(addressingVersion, sOAPVersion) == null) {
            String string = message.getHeaders().getMessageID(addressingVersion, sOAPVersion);
            RelatesToHeader relatesToHeader = new RelatesToHeader(addressingVersion.relatesToTag, string);
            inboundMessageResult.message.getHeaders().addOrReplace((Header)relatesToHeader);
        }
    }

    private String getMessageInfoString(Message message) {
        String string = message.getHeaders().getAction(this._binding.getAddressingVersion(), this._binding.getSOAPVersion());
        String string2 = message.getHeaders().getMessageID(this._binding.getAddressingVersion(), this._binding.getSOAPVersion());
        String string3 = message.getHeaders().getRelatesTo(this._binding.getAddressingVersion(), this._binding.getSOAPVersion());
        return "Action: " + string + " Msg ID: " + string2 + " RelatesTo: " + string3;
    }

    @NotNull
    public NextAction processException(@NotNull Throwable throwable) {
        return this.doThrow(throwable);
    }

    public AbstractFilterTubeImpl copy(TubeCloner tubeCloner) {
        return new WsrmClientTube(this, tubeCloner);
    }

    @Override
    public SequenceIdFactory.Info getSequenceId(String string, boolean bl, Packet packet) {
        SequenceIdFactory.Info info = new SequenceIdFactory.Info();
        WsrmInvocationPropertyBag wsrmInvocationPropertyBag = this.getRmInvokeProps(packet);
        info.id = wsrmInvocationPropertyBag.getSequenceId();
        boolean bl2 = info.preExisting = info.id != null;
        if (info.id != null || !bl) {
            // empty if block
        }
        WsrmClientRuntimeFeature wsrmClientRuntimeFeature = WsrmClientRuntimeFeature.getFromBinding(this._binding);
        info.safDispatchKey = new WsrmSAFDispatchFactory.ClientSideKey(wsrmClientRuntimeFeature.getClientId());
        return info;
    }

    private WsrmInvocationPropertyBag getRmInvokeProps(Packet packet) {
        WsrmInvocationPropertyBag wsrmInvocationPropertyBag = (WsrmInvocationPropertyBag)packet.invocationProperties.get(WsrmInvocationPropertyBag.key);
        if (wsrmInvocationPropertyBag == null) {
            wsrmInvocationPropertyBag = new WsrmInvocationPropertyBag();
            packet.invocationProperties.put(WsrmInvocationPropertyBag.key, wsrmInvocationPropertyBag);
        }
        return wsrmInvocationPropertyBag;
    }

    public static Map<String, Object> getInvokePropsForClient(String string, @Nullable WLSServiceDelegate wLSServiceDelegate) {
        PortInfoBean[] portInfoBeanArray;
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        if (wLSServiceDelegate == null) {
            return hashMap;
        }
        ServiceReferenceDescriptionBean serviceReferenceDescriptionBean = wLSServiceDelegate.getServiceReferenceDescription();
        if (serviceReferenceDescriptionBean != null && (portInfoBeanArray = serviceReferenceDescriptionBean.getPortInfos()) != null) {
            for (PortInfoBean portInfoBean : portInfoBeanArray) {
                PropertyNamevalueBean[] propertyNamevalueBeanArray;
                if (!portInfoBean.getPortName().equals(string) || (propertyNamevalueBeanArray = portInfoBean.getStubProperties()) == null) continue;
                for (PropertyNamevalueBean propertyNamevalueBean : propertyNamevalueBeanArray) {
                    hashMap.put(propertyNamevalueBean.getName(), propertyNamevalueBean.getValue());
                }
            }
        }
        return hashMap;
    }
}

