/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.reliability2.tube;

import com.sun.istack.NotNull;
import com.sun.istack.Nullable;
import com.sun.xml.ws.addressing.WsaPropertyBag;
import com.sun.xml.ws.api.WSBinding;
import com.sun.xml.ws.api.addressing.WSEndpointReference;
import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.api.model.wsdl.WSDLPort;
import com.sun.xml.ws.api.pipe.Fiber;
import com.sun.xml.ws.api.pipe.NextAction;
import com.sun.xml.ws.api.pipe.ServerTubeAssemblerContext;
import com.sun.xml.ws.api.pipe.Tube;
import com.sun.xml.ws.api.pipe.TubeCloner;
import com.sun.xml.ws.api.pipe.helper.AbstractFilterTubeImpl;
import com.sun.xml.ws.api.server.WSEndpoint;
import com.sun.xml.ws.server.WSEndpointImpl;
import java.util.logging.Level;
import java.util.logging.Logger;
import weblogic.j2ee.descriptor.wl.PortComponentBean;
import weblogic.j2ee.descriptor.wl.ReliabilityConfigBean;
import weblogic.wsee.buffer2.api.common.BufferingFeature;
import weblogic.wsee.jaxws.tubeline.TubelineSpliceFactory;
import weblogic.wsee.reliability2.exception.WsrmAbortSendException;
import weblogic.wsee.reliability2.exception.WsrmException;
import weblogic.wsee.reliability2.policy.WsrmPolicyHelper;
import weblogic.wsee.reliability2.property.WsrmConfig;
import weblogic.wsee.reliability2.property.WsrmInvocationPropertyBag;
import weblogic.wsee.reliability2.property.WsrmPropertyBag;
import weblogic.wsee.reliability2.saf.WsrmSAFDispatchFactory;
import weblogic.wsee.reliability2.sequence.SequenceIdFactory;
import weblogic.wsee.reliability2.tube.AbstractWsrmTube;
import weblogic.wsee.reliability2.tube.DispatchFactoryResolver;
import weblogic.wsee.reliability2.tube.WsrmServerDispatchFactory;
import weblogic.wsee.reliability2.tube.WsrmTubeUtils;
import weblogic.wsee.reliability2.tube.WsrmTubelineDeploymentListener;
import weblogic.wsee.ws.WsPort;

public class WsrmServerTube
extends AbstractWsrmTube {
    private static final Logger LOGGER = Logger.getLogger(WsrmServerTube.class.getName());
    private ServerTubeAssemblerContext _context;
    private WSEndpointImpl _endpoint;
    private WSBinding _binding;
    private WSDLPort _wsdlPort;
    private WsPort _wsPort;
    private WsrmPolicyHelper _policyHelper;
    @Nullable
    private ReliabilityConfigBean _rmConfig;
    private WsrmTubeUtils _tubeUtil;
    private TubelineSpliceFactory.DispatchFactory _spliceDispatchFactory;

    public WsrmServerTube(Tube tube, ServerTubeAssemblerContext serverTubeAssemblerContext, TubelineSpliceFactory.DispatchFactory dispatchFactory) {
        super(tube);
        WSEndpoint wSEndpoint = serverTubeAssemblerContext.getEndpoint();
        WSBinding wSBinding = serverTubeAssemblerContext.getEndpoint().getBinding();
        WsPort wsPort = WsrmTubelineDeploymentListener.getWsPort(serverTubeAssemblerContext);
        WsrmPolicyHelper wsrmPolicyHelper = new WsrmPolicyHelper(wsPort);
        PortComponentBean portComponentBean = wsPort.getPortComponent();
        ReliabilityConfigBean reliabilityConfigBean = portComponentBean != null ? portComponentBean.getReliabilityConfig() : null;
        this.commonConstructorCode(serverTubeAssemblerContext, wSEndpoint, wSBinding, serverTubeAssemblerContext.getWsdlModel(), wsPort, wsrmPolicyHelper, reliabilityConfigBean, dispatchFactory);
    }

    public WsrmServerTube(WsrmServerTube wsrmServerTube, TubeCloner tubeCloner) {
        super(wsrmServerTube, tubeCloner);
        this.commonConstructorCode(wsrmServerTube._context, (WSEndpoint)wsrmServerTube._endpoint, wsrmServerTube._binding, wsrmServerTube._wsdlPort, wsrmServerTube._wsPort, wsrmServerTube._policyHelper, wsrmServerTube._rmConfig, wsrmServerTube._spliceDispatchFactory);
    }

    private void commonConstructorCode(ServerTubeAssemblerContext serverTubeAssemblerContext, WSEndpoint wSEndpoint, WSBinding wSBinding, WSDLPort wSDLPort, WsPort wsPort, WsrmPolicyHelper wsrmPolicyHelper, ReliabilityConfigBean reliabilityConfigBean, TubelineSpliceFactory.DispatchFactory dispatchFactory) {
        this._context = serverTubeAssemblerContext;
        this._endpoint = (WSEndpointImpl)wSEndpoint;
        this._binding = wSBinding;
        this._wsdlPort = wSDLPort;
        this._wsPort = wsPort;
        this._policyHelper = wsrmPolicyHelper;
        this._rmConfig = reliabilityConfigBean;
        this._spliceDispatchFactory = dispatchFactory;
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("WsrmServerTube created for port " + (wSDLPort != null ? wSDLPort.getName() : null));
            WsrmConfig.Destination destination = WsrmConfig.getDestination(this._context, null, false);
            LOGGER.fine("WsrmServerTube: RM Destination Config:\n" + destination);
        }
        this._tubeUtil = new WsrmTubeUtils(false, this._binding, this._wsdlPort, this._policyHelper, new WsrmServerDispatchFactory(this._endpoint), null, this._context);
        this._tubeUtil.setEndpoint(this._endpoint);
    }

    @NotNull
    public NextAction processRequest(@NotNull Packet packet) {
        try {
            WsrmTubeUtils.InboundMessageResult inboundMessageResult = this._tubeUtil.processInboundMessage(packet);
            if (inboundMessageResult.needSuspendOnCurrentFiber) {
                Fiber.current().addListener(inboundMessageResult.currentFiberSuspendingCallback);
                return this.doSuspend(this.next);
            }
            if (inboundMessageResult.message != null && inboundMessageResult.rmFault == null) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("WsrmServerTube handling response after processInboundMessage");
                }
                String string = inboundMessageResult.message.getHeaders().getAction(this._binding.getAddressingVersion(), this._binding.getSOAPVersion());
                Packet packet2 = packet.createServerResponse(inboundMessageResult.message, this._binding.getAddressingVersion(), this._binding.getSOAPVersion(), string);
                packet2.soapAction = string;
                packet2.put("javax.xml.ws.soap.http.soapaction.uri", (Object)string);
                return this.processResponse(packet2);
            }
            if (inboundMessageResult.handled) {
                return this.doReturnWith(packet.createServerResponse(null, this._binding.getAddressingVersion(), this._binding.getSOAPVersion(), null));
            }
        }
        catch (RuntimeException runtimeException) {
            if (LOGGER.isLoggable(Level.SEVERE)) {
                LOGGER.log(Level.SEVERE, "WsrmServerTube processRequest failed: " + runtimeException.toString(), runtimeException);
            }
            throw runtimeException;
        }
        catch (Exception exception) {
            if (LOGGER.isLoggable(Level.SEVERE)) {
                LOGGER.log(Level.SEVERE, "WsrmServerTube processRequest failed: " + exception.toString(), exception);
            }
            throw new RuntimeException(exception.toString(), exception);
        }
        return this.doInvoke(this.next, packet);
    }

    @NotNull
    public NextAction processResponse(@NotNull Packet packet) {
        try {
            String string = packet.getMessage() == null ? this._binding.getAddressingVersion().anonymousUri : packet.getMessage().getHeaders().getTo(this._binding.getAddressingVersion(), this._binding.getSOAPVersion());
            WsrmTubeUtils.OutboundMessageResult outboundMessageResult = this._tubeUtil.processOutboundMessage(packet, new MySequenceIdFactory(), string);
            if (outboundMessageResult.messageBuffered || outboundMessageResult.messageAborted) {
                packet.setMessage(null);
            }
        }
        catch (WsrmAbortSendException wsrmAbortSendException) {
            packet.setMessage(null);
            return this.doReturnWith(packet);
        }
        catch (WsrmException wsrmException) {
            if (LOGGER.isLoggable(Level.SEVERE)) {
                LOGGER.log(Level.SEVERE, "WsrmServerTube processResponse failed: " + wsrmException.toString(), wsrmException);
            }
            if ((packet = this._tubeUtil.handleOutboundException(packet, wsrmException)) != null) {
                return this.doReturnWith(packet);
            }
            throw new RuntimeException(wsrmException.toString(), wsrmException);
        }
        catch (Exception exception) {
            if (LOGGER.isLoggable(Level.SEVERE)) {
                LOGGER.log(Level.SEVERE, "WsrmServerTube processResponse failed: " + exception.toString(), exception);
            }
            WsrmException wsrmException = new WsrmException(exception.toString(), exception);
            wsrmException.fillInStackTrace();
            packet = this._tubeUtil.handleOutboundException(packet, wsrmException);
            if (packet != null) {
                return this.doReturnWith(packet);
            }
            return this.doThrow(exception);
        }
        return this.doReturnWith(packet);
    }

    @NotNull
    public NextAction processException(@NotNull Throwable throwable) {
        return super.processException(throwable);
    }

    public void preDestroy() {
        ServerTubeAssemblerContext serverTubeAssemblerContext = this._tubeUtil.getServerContext();
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("WsrmServerTube preDestroy() unRegistering BufferingFeature. ");
        }
        BufferingFeature.unRegisterBufferingFeature(serverTubeAssemblerContext);
        DispatchFactoryResolver.unregisterServerDispatchFactory(this._context.getEndpoint().getEndpointId());
        if (this.next != null) {
            this.next.preDestroy();
        }
    }

    public AbstractFilterTubeImpl copy(TubeCloner tubeCloner) {
        return new WsrmServerTube(this, tubeCloner);
    }

    private class MySequenceIdFactory
    implements SequenceIdFactory {
        public SequenceIdFactory.Info getSequenceId(String string, boolean bl, Packet packet) {
            WsrmInvocationPropertyBag wsrmInvocationPropertyBag;
            WsrmPropertyBag wsrmPropertyBag = WsrmPropertyBag.propertySetRetriever.getFromPacket(packet);
            SequenceIdFactory.Info info = new SequenceIdFactory.Info();
            info.id = wsrmPropertyBag.getOutboundSequenceId();
            boolean bl2 = info.preExisting = info.id != null;
            if (info.id == null && !bl) {
                WSEndpointReference wSEndpointReference;
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("WsrmServerTube.MySequenceIdFactory.getSequenceId: Offer sequence is not found.");
                }
                if ((wSEndpointReference = (wsrmInvocationPropertyBag = (WsaPropertyBag)packet.getSatellite(WsaPropertyBag.class)).getReplyToFromRequest()) == null || wSEndpointReference.isAnonymous()) {
                    throw new RuntimeException("ReplyTo EPR found anonymous in the request. No offer scenario is not supported for this case.");
                }
            }
            if (info.id == null) {
                wsrmInvocationPropertyBag = (WsrmInvocationPropertyBag)packet.invocationProperties.get(WsrmInvocationPropertyBag.key);
                info.id = wsrmInvocationPropertyBag.getSequenceId();
            }
            info.safDispatchKey = new WsrmSAFDispatchFactory.ServerSideKey(WsrmServerTube.this._endpoint.getEndpointId());
            return info;
        }
    }
}

