/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.reliability2.tube;

import com.sun.istack.NotNull;
import com.sun.istack.Nullable;
import com.sun.xml.ws.addressing.WsaPropertyBag;
import com.sun.xml.ws.api.PropertySet;
import com.sun.xml.ws.api.SOAPVersion;
import com.sun.xml.ws.api.WSBinding;
import com.sun.xml.ws.api.addressing.AddressingVersion;
import com.sun.xml.ws.api.addressing.OneWayFeature;
import com.sun.xml.ws.api.addressing.WSEndpointReference;
import com.sun.xml.ws.api.message.Header;
import com.sun.xml.ws.api.message.HeaderList;
import com.sun.xml.ws.api.message.Message;
import com.sun.xml.ws.api.message.Messages;
import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.api.model.wsdl.WSDLBoundOperation;
import com.sun.xml.ws.api.model.wsdl.WSDLOperation;
import com.sun.xml.ws.api.model.wsdl.WSDLPort;
import com.sun.xml.ws.api.model.wsdl.WSDLPortType;
import com.sun.xml.ws.api.pipe.ClientTubeAssemblerContext;
import com.sun.xml.ws.api.pipe.Fiber;
import com.sun.xml.ws.api.pipe.ServerTubeAssemblerContext;
import com.sun.xml.ws.api.server.TransportBackChannel;
import com.sun.xml.ws.api.server.WSEndpoint;
import com.sun.xml.ws.message.StringHeader;
import com.sun.xml.ws.server.WSEndpointImpl;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.net.URI;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLSession;
import javax.servlet.http.HttpServletRequest;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import javax.xml.stream.XMLStreamException;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.WebServiceFeature;
import javax.xml.ws.wsaddressing.W3CEndpointReference;
import org.w3c.dom.Element;
import weblogic.jws.jaxws.client.ClientIdentityFeature;
import weblogic.jws.jaxws.client.async.AsyncClientTransportFeature;
import weblogic.kernel.KernelStatus;
import weblogic.management.runtime.WseeBasePortRuntimeMBean;
import weblogic.utils.encoders.BASE64Encoder;
import weblogic.wsee.WseeRmLogger;
import weblogic.wsee.addressing.EndpointReference;
import weblogic.wsee.jaxws.client.async.AsyncResponseEndpoint;
import weblogic.wsee.jaxws.client.async.AsyncTransportProviderPropertyBag;
import weblogic.wsee.jaxws.cluster.spi.PhysicalStoreNameHeader;
import weblogic.wsee.jaxws.framework.WsUtil;
import weblogic.wsee.jaxws.persistence.PersistentMessage;
import weblogic.wsee.jaxws.persistence.PersistentMessageFactory;
import weblogic.wsee.jaxws.persistence.PersistentRequestContext;
import weblogic.wsee.jaxws.spi.ClientIdentityRegistry;
import weblogic.wsee.jaxws.spi.ClientInstance;
import weblogic.wsee.jaxws.spi.ClientInstanceIdentity;
import weblogic.wsee.mc.api.McFeature;
import weblogic.wsee.monitoring.WseePortRuntimeMBeanImpl;
import weblogic.wsee.monitoring.WseeWsrmRuntimeMBeanImpl;
import weblogic.wsee.policy.framework.NormalizedExpression;
import weblogic.wsee.policy.framework.PolicyAssertion;
import weblogic.wsee.policy.framework.PolicyException;
import weblogic.wsee.reliability.WsrmConstants;
import weblogic.wsee.reliability.WsrmSecurityContext;
import weblogic.wsee.reliability.faults.IllegalRMVersionFaultException;
import weblogic.wsee.reliability.faults.SecurityMismatchFaultException;
import weblogic.wsee.reliability.faults.SequenceFaultException;
import weblogic.wsee.reliability.faults.SequenceFaultMsg;
import weblogic.wsee.reliability.faults.SequenceFaultMsgFactory;
import weblogic.wsee.reliability.faults.SequenceTerminatedFaultMsg;
import weblogic.wsee.reliability.faults.UnknownSequenceFaultMsg;
import weblogic.wsee.reliability.faults.WSRMRequiredFaultMsg;
import weblogic.wsee.reliability.faults.WsrmFaultException;
import weblogic.wsee.reliability.faults.WsrmFaultMsg;
import weblogic.wsee.reliability.handshake.CloseSequenceMsg;
import weblogic.wsee.reliability.handshake.CreateSequenceMsg;
import weblogic.wsee.reliability.handshake.SequenceOffer;
import weblogic.wsee.reliability.handshake.TerminateSequenceMsg;
import weblogic.wsee.reliability.headers.AckRequestedHeader;
import weblogic.wsee.reliability.headers.AcknowledgementHeader;
import weblogic.wsee.reliability.headers.SequenceHeader;
import weblogic.wsee.reliability.headers.UsesSequenceSSLHeader;
import weblogic.wsee.reliability.headers.UsesSequenceSTRHeader;
import weblogic.wsee.reliability.headers.WsrmHeader;
import weblogic.wsee.reliability.policy11.RM11Assertion;
import weblogic.wsee.reliability2.api.SequenceState;
import weblogic.wsee.reliability2.api_internal.WsrmLifecycleEvent;
import weblogic.wsee.reliability2.api_internal.WsrmLifecycleEventListenerRegistry;
import weblogic.wsee.reliability2.compat.Rpc2WsUtil;
import weblogic.wsee.reliability2.exception.WsrmAbortSendException;
import weblogic.wsee.reliability2.exception.WsrmException;
import weblogic.wsee.reliability2.exception.WsrmUnsupportedConfigurationException;
import weblogic.wsee.reliability2.headers.WsrmHeaderFactory;
import weblogic.wsee.reliability2.policy.WsrmPolicyHelper;
import weblogic.wsee.reliability2.property.WsrmConfig;
import weblogic.wsee.reliability2.property.WsrmInvocationPropertyBag;
import weblogic.wsee.reliability2.property.WsrmPropertyBag;
import weblogic.wsee.reliability2.sequence.CreateSequencePostSecurityTokenCallback;
import weblogic.wsee.reliability2.sequence.DestinationMessageInfo;
import weblogic.wsee.reliability2.sequence.DestinationOfferSequence;
import weblogic.wsee.reliability2.sequence.DestinationSequence;
import weblogic.wsee.reliability2.sequence.DestinationSequenceManager;
import weblogic.wsee.reliability2.sequence.Sequence;
import weblogic.wsee.reliability2.sequence.SequenceIdFactory;
import weblogic.wsee.reliability2.sequence.SourceMessageInfo;
import weblogic.wsee.reliability2.sequence.SourceOfferSequence;
import weblogic.wsee.reliability2.sequence.SourceSequence;
import weblogic.wsee.reliability2.sequence.SourceSequenceManager;
import weblogic.wsee.reliability2.sequence.UnknownSequenceException;
import weblogic.wsee.reliability2.sequence.UnknownSourceSequenceException;
import weblogic.wsee.reliability2.store.SenderDispatchFactory;
import weblogic.wsee.reliability2.tube.DispatchFactory;
import weblogic.wsee.reliability2.tube.DispatchFactoryResolver;
import weblogic.wsee.reliability2.tube.Sender;
import weblogic.wsee.reliability2.tube.SequenceIDRoutingInfoFinder;
import weblogic.wsee.reliability2.tube.WsrmClientRuntimeFeature;
import weblogic.wsee.reliability2.tube.processors.CloseSequenceResponseProcessor;
import weblogic.wsee.reliability2.tube.processors.MessageProcessor;
import weblogic.wsee.reliability2.tube.processors.MessageProcessorFactory;
import weblogic.wsee.reliability2.tube.processors.TerminateSequenceProcessor;
import weblogic.wsee.reliability2.tube.processors.TerminateSequenceResponseProcessor;
import weblogic.wsee.security.wssc.sct.SCCredential;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WsrmTubeUtils {
    private static final Logger LOGGER = Logger.getLogger(WsrmTubeUtils.class.getName());
    private WSBinding _binding;
    private AddressingVersion _addrVersion;
    private SOAPVersion _soapVersion;
    private WSDLPort _wsdlPort;
    @Nullable
    private WsrmPolicyHelper _policyHelper;
    private DispatchFactory _dispatchFactory;
    private WSEndpointImpl _endpoint;
    @Nullable
    private ClientTubeAssemblerContext _clientContext;
    @Nullable
    private ServerTubeAssemblerContext _serverContext;
    private boolean _clientSide;
    private boolean _seqTerminatedFlag;
    private static BASE64Encoder _base64 = new BASE64Encoder();

    public WsrmTubeUtils(boolean bl, @NotNull WSBinding wSBinding, @NotNull WSDLPort wSDLPort, @Nullable WsrmPolicyHelper wsrmPolicyHelper, @NotNull DispatchFactory dispatchFactory, @Nullable ClientTubeAssemblerContext clientTubeAssemblerContext, @Nullable ServerTubeAssemblerContext serverTubeAssemblerContext) {
        this._clientSide = bl;
        this._binding = wSBinding;
        this._addrVersion = wSBinding.getAddressingVersion();
        this._soapVersion = wSBinding.getSOAPVersion();
        this._wsdlPort = wSDLPort;
        this._policyHelper = wsrmPolicyHelper;
        this._dispatchFactory = dispatchFactory;
        this._clientContext = clientTubeAssemblerContext;
        this._serverContext = serverTubeAssemblerContext;
        SequenceIDRoutingInfoFinder.registerIfNeeded();
    }

    @NotNull
    public WSBinding getBinding() {
        return this._binding;
    }

    @NotNull
    public WSDLPort getWsdlPort() {
        return this._wsdlPort;
    }

    @Nullable
    public WsrmPolicyHelper getPolicyHelper() {
        return this._policyHelper;
    }

    @Nullable
    public ServerTubeAssemblerContext getServerContext() {
        return this._serverContext;
    }

    @NotNull
    public DispatchFactory getDispatchFactory() {
        return this._dispatchFactory;
    }

    public void setEndpoint(WSEndpointImpl wSEndpointImpl) {
        this._endpoint = wSEndpointImpl;
    }

    public WSEndpointImpl getEndpoint() {
        return this._endpoint;
    }

    public static SequenceFaultMsg getRmFaultFromMessage(Packet packet) throws SOAPException {
        SequenceFaultMsg sequenceFaultMsg;
        Message message = packet.getMessage();
        if (message == null || !message.isFault()) {
            return null;
        }
        SOAPMessage sOAPMessage = null;
        try {
            sOAPMessage = message.readAsSOAPMessage(packet);
            sequenceFaultMsg = SequenceFaultMsgFactory.getInstance().parseSoapFault(sOAPMessage);
            message.consume();
        }
        catch (SequenceFaultException sequenceFaultException) {
            if (sOAPMessage != null) {
                message = Messages.create((SOAPMessage)sOAPMessage);
                packet.setMessage(message);
            }
            return null;
        }
        return sequenceFaultMsg;
    }

    public InboundMessageResult processInboundMessage(Packet packet) throws WsrmException, XMLStreamException, PolicyException {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Incoming packet security: " + WsrmTubeUtils.dumpSecuritySSLOnPacket(packet) + " " + WsrmTubeUtils.dumpSecuritySCTOnPacket(packet));
        }
        InboundMessageResult inboundMessageResult = new InboundMessageResult();
        inboundMessageResult.handled = false;
        inboundMessageResult.message = null;
        inboundMessageResult.seq = null;
        this._seqTerminatedFlag = false;
        WsrmPropertyBag wsrmPropertyBag = WsrmPropertyBag.propertySetRetriever.getFromPacket(packet);
        if (wsrmPropertyBag.getInternalReceive()) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Detected an 'internal receive' message. Ignoring it.");
            }
            return inboundMessageResult;
        }
        WsrmInvocationPropertyBag.flagPersistentPropsOnPacket(packet);
        WsrmPropertyBag.flagPersistentPropsOnPacket(packet);
        SourceSequence sourceSequence = WsrmTubeUtils.getOutboundSourceSequenceForPacket(packet);
        if (sourceSequence != null) {
            this.updateSecurityPropertiesIntoSequence(packet, sourceSequence);
        }
        inboundMessageResult.seq = sourceSequence;
        Message message = packet.getMessage();
        if (message == null) {
            return inboundMessageResult;
        }
        AddressingVersion addressingVersion = this._binding.getAddressingVersion();
        SOAPVersion sOAPVersion = this._binding.getSOAPVersion();
        String string = message.getHeaders().getAction(addressingVersion, sOAPVersion);
        if (string == null && (string = packet.soapAction) == null) {
            string = "";
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Processing inbound message with action: " + string);
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Checking inbound action '" + string + "' against all possible RM actions: " + WsrmConstants.Action.dumpAllActionsForAllRMVersions());
        }
        if (!WsrmConstants.Action.matchesAnyActionAndRMVersion(string)) {
            WsrmFaultMsg wsrmFaultMsg = WsrmTubeUtils.handlePossibleRmFault(packet);
            if (wsrmFaultMsg == null) {
                if (!string.equals(WsUtil.getSOAPFaultAction(this._binding.getAddressingVersion()))) {
                    inboundMessageResult = this.processInboundSequenceMessage(packet);
                }
            } else {
                inboundMessageResult.handled = true;
                inboundMessageResult.message = message;
                inboundMessageResult.rmFault = wsrmFaultMsg;
            }
        } else {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Processing inbound WS-RM action: " + string);
            }
            WsrmConstants.Action.VersionInfo versionInfo = WsrmConstants.Action.getVersionInfo(string);
            MessageProcessor messageProcessor = MessageProcessorFactory.createProcessorForAction(versionInfo.action, this);
            messageProcessor.handleInbound(packet, versionInfo.rmVersion, inboundMessageResult);
            inboundMessageResult.handled = true;
        }
        if (!this._seqTerminatedFlag) {
            this.handleInboundPiggybackRmHeaders(packet, inboundMessageResult.needSuspendOnCurrentFiber);
        }
        return inboundMessageResult;
    }

    private static WsrmFaultMsg handlePossibleRmFault(Packet packet) throws WsrmException {
        SequenceFaultMsg sequenceFaultMsg;
        try {
            sequenceFaultMsg = WsrmTubeUtils.getRmFaultFromMessage(packet);
        }
        catch (Exception exception) {
            throw new WsrmException(exception.toString(), exception);
        }
        if (sequenceFaultMsg != null) {
            SourceSequenceManager.getInstance().handleRmFault(sequenceFaultMsg);
            DestinationSequenceManager.getInstance().handleRmFault(sequenceFaultMsg);
        }
        return sequenceFaultMsg;
    }

    public void setOutboundSequence(Packet packet, Sequence sequence) {
        WsrmPropertyBag wsrmPropertyBag = WsrmPropertyBag.propertySetRetriever.getFromPacket(packet);
        wsrmPropertyBag.setOutboundSequenceId(sequence.getId());
    }

    public void setOutboundSequenceId(Packet packet, String string) {
        WsrmPropertyBag wsrmPropertyBag = WsrmPropertyBag.propertySetRetriever.getFromPacket(packet);
        wsrmPropertyBag.setOutboundSequenceId(string);
    }

    public void setInboundSequence(Packet packet, Sequence sequence) {
        WsrmPropertyBag wsrmPropertyBag = WsrmPropertyBag.propertySetRetriever.getFromPacket(packet);
        wsrmPropertyBag.setInboundSequenceId(sequence.getId());
    }

    public InboundMessageResult processInboundSequenceMessage(Packet packet) {
        Serializable serializable;
        InboundMessageResult inboundMessageResult = new InboundMessageResult();
        inboundMessageResult.message = null;
        inboundMessageResult.handled = false;
        Message message = packet.getMessage();
        WsrmConfig.Destination destination = WsrmConfig.getDestination(this._serverContext, packet, this._clientSide);
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Inbound sequence message config:\n" + destination.toString());
        }
        Header header = null;
        for (WsrmConstants.RMVersion rMVersion : WsrmConstants.RMVersion.values()) {
            serializable = WsrmHeader.getQName(SequenceHeader.class, rMVersion);
            header = message.getHeaders().get((QName)serializable, true);
            if (header != null) break;
        }
        if (header == null) {
            if (destination.isReliable() && !destination.getRmAssertion().isOptional()) {
                WsrmConstants.RMVersion rMVersion = destination.getRmVersion();
                if (rMVersion == WsrmConstants.RMVersion.RM_10) {
                    throw new RuntimeException("This endpoint requires reliable messaging");
                }
                WSRMRequiredFaultMsg wSRMRequiredFaultMsg = new WSRMRequiredFaultMsg(rMVersion);
                try {
                    inboundMessageResult.message = Rpc2WsUtil.createMessageFromFaultMessage(wSRMRequiredFaultMsg, this._binding.getAddressingVersion(), this._binding.getSOAPVersion());
                    inboundMessageResult.handled = true;
                }
                catch (Exception exception) {
                    WseeRmLogger.logUnexpectedException((String)exception.toString(), (Throwable)exception);
                    throw new RuntimeException(exception.toString(), exception);
                }
            }
            return inboundMessageResult;
        }
        WsrmPropertyBag wsrmPropertyBag = WsrmPropertyBag.propertySetRetriever.getFromPacket(packet);
        wsrmPropertyBag.capturePersistentPropsFromJaxWsRi(this._binding.getAddressingVersion());
        WSDLBoundOperation wSDLBoundOperation = packet.getMessage().getOperation(this._wsdlPort);
        if (wSDLBoundOperation != null) {
            wsrmPropertyBag.setInboundWsdlOperationName(wSDLBoundOperation.getName().getLocalPart());
        }
        String string = message.getHeaders().getMessageID(this._binding.getAddressingVersion(), this._binding.getSOAPVersion());
        wsrmPropertyBag.setInboundMessageId(string);
        boolean bl = packet.getMessage().isOneWay(this.getWsdlPort());
        if (bl) {
            serializable = packet.keepTransportBackChannelOpen();
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("RM is hijacking the TransportBackChannel (to allow response to oneway method) for msgId=" + string);
            }
            wsrmPropertyBag.setTransportBackChannel((TransportBackChannel)serializable);
        }
        try {
            WSEndpointReference wSEndpointReference;
            DestinationSequence wsrmFaultException;
            serializable = WsrmHeaderFactory.getInstance().createWsrmHeaderFromHeader(SequenceHeader.class, header);
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Handling inbound sequence message with msg id " + string + ", seq " + ((SequenceHeader)serializable).getSequenceId() + " and msg num " + ((SequenceHeader)serializable).getMessageNumber());
            }
            if ((wsrmFaultException = DestinationSequenceManager.getInstance().getSequence(((WsrmHeader)serializable).getRmVersion(), ((SequenceHeader)serializable).getSequenceId(), !this._clientSide)) == null) {
                return inboundMessageResult;
            }
            if (!(wsrmFaultException.isNonBuffered() || (wSEndpointReference = packet.getMessage().getHeaders().getReplyTo(wsrmFaultException.getAddressingVersion(), wsrmFaultException.getSoapVersion())) != null && !wSEndpointReference.isAnonymous() || this._clientSide)) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("ERROR:  Terminate Sequence and throw WsrmUnsupportedConfigurationException after Error:  Attempt to execute a WS-RM Buffered Service with a message sent using Synchronous HTTP Transport with a WS-Addressing ReplyTo Header value of anonymous.  The WS-RM Buffered Service can only be invoked via messages sent using Asynchronous HTTP Transport with a non-anonymous WS-Addressing ReplyTo Header.");
                }
                WsrmConstants.RMVersion rMVersion = destination.getRmVersion();
                TerminateSequenceProcessor.forceTerminateSequence(wsrmFaultException, rMVersion, 1L);
                this._seqTerminatedFlag = true;
                throw new WsrmUnsupportedConfigurationException(rMVersion, ((SequenceHeader)serializable).getSequenceId(), this._clientSide, "Error:  Attempt to execute a WS-RM Buffered Service with a message sent using Synchronous HTTP Transport with a WS-Addressing ReplyTo Header value of anonymous.  The WS-RM Buffered Service can only be invoked via messages sent using Asynchronous HTTP Transport with a non-anonymous WS-Addressing ReplyTo Header.  If you are using a WebLogic client check to be sure that it is using the AsyncClientTransportFeature with Asynchronous Transport.");
            }
            WsrmTubeUtils.validateSecurityOnInboundPacket(wsrmFaultException, packet);
            wSEndpointReference = wsrmFaultException.getOffer() != null ? wsrmFaultException.getOffer().getId() : null;
            wsrmPropertyBag.setInboundSequenceId(wsrmFaultException.getId());
            wsrmPropertyBag.setOutboundSequenceId((String)wSEndpointReference);
            wsrmPropertyBag.setInboundEndpointAddress(wsrmFaultException.getHostEpr().getAddress());
            DestinationSequenceManager.HandleSequenceMessageResult handleSequenceMessageResult = DestinationSequenceManager.getInstance().handleSequenceMessage((SequenceHeader)serializable, packet, this._binding.getAddressingVersion(), this._binding.getSOAPVersion(), bl);
            DestinationMessageInfo destinationMessageInfo = handleSequenceMessageResult.msgInfo;
            inboundMessageResult.needSuspendOnCurrentFiber = handleSequenceMessageResult.needSuspendOnCurrentFiber;
            inboundMessageResult.currentFiberSuspendingCallback = handleSequenceMessageResult.currentFiberSuspendingCallback;
            if (destinationMessageInfo != null && wsrmFaultException.getRmVersion() == WsrmConstants.RMVersion.RM_10 && destinationMessageInfo.isEmptyLastMessage()) {
                inboundMessageResult.handled = true;
                WSEndpointReference wSEndpointReference2 = packet.getMessage().getHeaders().getReplyTo(wsrmFaultException.getAddressingVersion(), wsrmFaultException.getSoapVersion());
                if ((wsrmFaultException.getAcksToEpr() == null || wsrmFaultException.getAcksToEpr().isAnonymous()) && (wSEndpointReference2 == null || wSEndpointReference2.isAnonymous())) {
                    inboundMessageResult.message = Messages.createEmpty((SOAPVersion)wsrmFaultException.getSoapVersion());
                    String string2 = WsrmConstants.Action.ACK.getActionURI(WsrmConstants.RMVersion.RM_10);
                    StringHeader stringHeader = new StringHeader(wsrmFaultException.getAddressingVersion().actionTag, string2);
                    inboundMessageResult.message.getHeaders().add((Header)stringHeader);
                } else {
                    inboundMessageResult.message = null;
                }
            } else if (!wsrmFaultException.isNonBuffered()) {
                inboundMessageResult.message = null;
                inboundMessageResult.handled = true;
            } else if (destinationMessageInfo == null) {
                inboundMessageResult.message = null;
                inboundMessageResult.handled = true;
            }
        }
        catch (WsrmException wsrmException) {
            inboundMessageResult.message = WsrmTubeUtils.handleInboundException(wsrmException, this._addrVersion, this._soapVersion);
        }
        catch (WsrmFaultException wsrmFaultException) {
            inboundMessageResult.message = WsrmTubeUtils.handleInboundException(wsrmFaultException, this._addrVersion, this._soapVersion);
        }
        return inboundMessageResult;
    }

    public static Message handleInboundException(Exception exception, AddressingVersion addressingVersion, SOAPVersion sOAPVersion) {
        Message message;
        if (exception instanceof UnknownSequenceException) {
            UnknownSequenceException unknownSequenceException = (UnknownSequenceException)exception;
            UnknownSequenceFaultMsg unknownSequenceFaultMsg = new UnknownSequenceFaultMsg(unknownSequenceException.getRmVersion());
            unknownSequenceFaultMsg.setSequenceId(unknownSequenceException.getSequenceId());
            try {
                message = Rpc2WsUtil.createMessageFromFaultMessage(unknownSequenceFaultMsg, addressingVersion, sOAPVersion);
            }
            catch (Exception exception2) {
                WseeRmLogger.logUnexpectedException((String)exception.toString(), (Throwable)exception);
                WseeRmLogger.logUnexpectedException((String)exception2.toString(), (Throwable)exception2);
                message = null;
            }
        } else if (exception instanceof WsrmUnsupportedConfigurationException) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Process " + exception.getClass().getName() + " with message '" + exception.getMessage() + "'");
            }
            WsrmUnsupportedConfigurationException wsrmUnsupportedConfigurationException = (WsrmUnsupportedConfigurationException)exception;
            SequenceTerminatedFaultMsg sequenceTerminatedFaultMsg = new SequenceTerminatedFaultMsg(wsrmUnsupportedConfigurationException.getRMVersion(), wsrmUnsupportedConfigurationException.isClient());
            sequenceTerminatedFaultMsg.setReason(wsrmUnsupportedConfigurationException.getMessage());
            sequenceTerminatedFaultMsg.setSequenceId(wsrmUnsupportedConfigurationException.getSequenceId());
            try {
                message = Rpc2WsUtil.createMessageFromFaultMessage(sequenceTerminatedFaultMsg, addressingVersion, sOAPVersion);
            }
            catch (Exception exception3) {
                WseeRmLogger.logUnexpectedException((String)exception.toString(), (Throwable)exception);
                WseeRmLogger.logUnexpectedException((String)exception3.toString(), (Throwable)exception3);
                message = null;
            }
        } else if (exception instanceof WsrmFaultException && ((WsrmFaultException)exception).getWsrmFaultMsg() != null) {
            WsrmFaultException wsrmFaultException = (WsrmFaultException)exception;
            WsrmFaultMsg wsrmFaultMsg = wsrmFaultException.getWsrmFaultMsg();
            try {
                message = Rpc2WsUtil.createMessageFromFaultMessage(wsrmFaultMsg, addressingVersion, sOAPVersion);
            }
            catch (Exception exception4) {
                WseeRmLogger.logUnexpectedException((String)exception.toString(), (Throwable)exception);
                WseeRmLogger.logUnexpectedException((String)exception4.toString(), (Throwable)exception4);
                message = null;
            }
        } else {
            try {
                message = WsUtil.createMessageFromThrowable(exception, addressingVersion, sOAPVersion);
            }
            catch (Exception exception5) {
                WseeRmLogger.logUnexpectedException((String)exception.toString(), (Throwable)exception);
                WseeRmLogger.logUnexpectedException((String)exception5.toString(), (Throwable)exception5);
                message = null;
            }
        }
        return message;
    }

    Packet handleOutboundException(Packet packet, WsrmException wsrmException) {
        for (Throwable throwable = wsrmException; throwable != null; throwable = throwable.getCause()) {
            Packet packet2;
            if (!(throwable instanceof WsrmException) || (packet2 = this.internalHandleOutboundException(packet, (WsrmException)throwable)) == null) continue;
            return packet2;
        }
        return null;
    }

    private Packet internalHandleOutboundException(Packet packet, WsrmException wsrmException) {
        Packet packet2 = null;
        if (wsrmException instanceof UnknownSequenceException) {
            UnknownSequenceException unknownSequenceException = (UnknownSequenceException)wsrmException;
            UnknownSequenceFaultMsg unknownSequenceFaultMsg = new UnknownSequenceFaultMsg(unknownSequenceException.getRmVersion());
            unknownSequenceFaultMsg.setSequenceId(unknownSequenceException.getSequenceId());
            try {
                Message message = Rpc2WsUtil.createMessageFromFaultMessage(unknownSequenceFaultMsg, this._addrVersion, this._soapVersion);
                packet2 = packet.createServerResponse(message, this._addrVersion, this._soapVersion, WsUtil.getSOAPFaultAction(this._addrVersion));
            }
            catch (Exception exception) {
                WseeRmLogger.logUnexpectedException((String)exception.toString(), (Throwable)exception);
            }
        }
        return packet2;
    }

    public String getMessageID(Message message) throws WsrmException {
        String string = message.getHeaders().getMessageID(this._addrVersion, this._soapVersion);
        if (string == null || string.length() < 1) {
            throw new WsrmException(WseeRmLogger.logNullMessageIDLoggable().getMessage());
        }
        return string;
    }

    public static Sequence doInitialSetupForAction(String string, boolean bl, String string2, WsrmConstants.RMVersion rMVersion, Packet packet) throws WsrmException {
        Sequence sequence;
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.finer("Setting up for action '" + string + "' on " + (bl ? "source" : "destination") + " side seq: " + string2);
        }
        if (rMVersion != (sequence = bl ? SourceSequenceManager.getInstance().getSequence(rMVersion, string2, false) : DestinationSequenceManager.getInstance().getSequence(rMVersion, string2, false)).getRmVersion()) {
            throw new IllegalRMVersionFaultException(string2, rMVersion, sequence.getRmVersion());
        }
        WsrmTubeUtils.validateSecurityOnInboundPacket(sequence, packet);
        return sequence;
    }

    public static void validateSecurityOnInboundPacket(Sequence sequence, Packet packet) {
        WsrmSecurityContext wsrmSecurityContext = sequence.getSecurityContext();
        if (packet != null) {
            if (wsrmSecurityContext.isSecureWithSSL() && KernelStatus.isServer()) {
                byte[] byArray;
                String string = null;
                if (LOGGER.isLoggable(Level.FINE)) {
                    string = "Packet (" + WsrmTubeUtils.dumpSecuritySSLOnPacket(packet) + ") against sequence (" + WsrmTubeUtils.dumpSecuritySSL(wsrmSecurityContext.getSSLSessionId(), wsrmSecurityContext.getSSLCertChain()) + ")";
                    LOGGER.fine("Validating SSL Security On " + string);
                }
                if (!Arrays.equals(byArray = WsrmTubeUtils.getSSLSessionId(packet), wsrmSecurityContext.getSSLSessionId()) && !WsrmTubeUtils.compareSSLProperties(wsrmSecurityContext, packet)) {
                    if (LOGGER.isLoggable(Level.FINER)) {
                        LOGGER.fine("SSL Security Mismatch Detected!: " + string);
                    }
                    throw new SecurityMismatchFaultException(sequence.getId(), sequence.getRmVersion(), true);
                }
            } else if (wsrmSecurityContext.isSecure()) {
                SCCredential sCCredential = WsrmTubeUtils.getSCCredential(packet);
                String string = null;
                if (LOGGER.isLoggable(Level.FINE)) {
                    string = "Packet (" + WsrmTubeUtils.dumpSecuritySCTOnPacket(packet) + ") against sequence (" + WsrmTubeUtils.dumpSecuritySCT(wsrmSecurityContext.getSCCredential()) + ")";
                    LOGGER.fine("Validating SCT Security On " + string);
                }
                boolean bl = packet.getMessage() != null && packet.getMessage().getHeaders().getRelatesTo(sequence.getAddressingVersion(), sequence.getSoapVersion()) != null;
                boolean bl2 = false;
                if (!(bl || sCCredential != null && sCCredential.equals(wsrmSecurityContext.getSCCredential()))) {
                    bl2 = true;
                }
                if (bl2 && LOGGER.isLoggable(Level.FINER)) {
                    LOGGER.fine("SCT Security Mismatch Detected!: " + string);
                }
            }
        }
    }

    private static boolean compareSSLProperties(WsrmSecurityContext wsrmSecurityContext, Packet packet) {
        X509Certificate[] x509CertificateArray = wsrmSecurityContext.getSSLCertChain();
        X509Certificate[] x509CertificateArray2 = WsrmTubeUtils.getSSLCertChain(packet);
        if (x509CertificateArray == null) {
            return true;
        }
        if (x509CertificateArray2 == null) {
            return false;
        }
        if (x509CertificateArray.length == x509CertificateArray2.length) {
            for (int i = 0; i < x509CertificateArray.length; ++i) {
                X509Certificate x509Certificate = x509CertificateArray[i];
                X509Certificate x509Certificate2 = x509CertificateArray2[i];
                if (WsrmTubeUtils.compareCerts(x509Certificate, x509Certificate2)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private static boolean compareCerts(X509Certificate x509Certificate, X509Certificate x509Certificate2) {
        return x509Certificate == null && x509Certificate2 == null || WsrmTubeUtils.getCertKey(x509Certificate).equals(WsrmTubeUtils.getCertKey(x509Certificate2));
    }

    private static String getCertKey(X509Certificate x509Certificate) {
        return x509Certificate.getIssuerX500Principal().getName() + x509Certificate.getSerialNumber();
    }

    public WsrmSecurityContext getWsrmSecurityContext(PolicyAssertion policyAssertion, Packet packet) throws WsrmException {
        WsrmSecurityContext wsrmSecurityContext;
        try {
            wsrmSecurityContext = this._policyHelper.createSecurityContext(policyAssertion);
            wsrmSecurityContext.newInitializedMap();
            wsrmSecurityContext.update(packet);
        }
        catch (Exception exception) {
            throw new WsrmException(exception.toString(), exception);
        }
        return wsrmSecurityContext;
    }

    private void handleInboundPiggybackRmHeaders(Packet packet, boolean bl) throws WsrmException {
        if (packet == null || packet.getMessage() == null) {
            return;
        }
        Message message = packet.getMessage();
        String string = null;
        if (this._binding.getAddressingVersion() != null) {
            string = message.getHeaders().getMessageID(this._binding.getAddressingVersion(), this._binding.getSOAPVersion());
        }
        WsrmConstants.RMVersion[] rMVersionArray = WsrmConstants.RMVersion.values();
        HeaderList headerList = message.getHeaders();
        for (WsrmConstants.RMVersion rMVersion : rMVersionArray) {
            Object object;
            QName qName = WsrmConstants.Element.ACK.getQName(rMVersion);
            Iterator iterator = headerList.getHeaders(qName, true);
            while (iterator.hasNext()) {
                object = WsrmHeaderFactory.getInstance().createWsrmHeaderFromHeader(AcknowledgementHeader.class, (Header)iterator.next());
                this.handleAckHeader((AcknowledgementHeader)object, bl);
            }
            qName = WsrmConstants.Element.ACK_REQUESTED.getQName(rMVersion);
            object = headerList.getHeaders(qName, true);
            while (object.hasNext()) {
                AckRequestedHeader ackRequestedHeader = WsrmHeaderFactory.getInstance().createWsrmHeaderFromHeader(AckRequestedHeader.class, (Header)object.next());
                this.handleAckRequestedHeader(ackRequestedHeader, string);
            }
        }
    }

    public void handleAckRequestedHeader(AckRequestedHeader ackRequestedHeader, String string) throws WsrmException {
        DestinationSequenceManager.getInstance().handleAckRequest(ackRequestedHeader, string);
    }

    public void handleAckHeader(AcknowledgementHeader acknowledgementHeader, boolean bl) throws WsrmException {
        final SourceSequence sourceSequence = SourceSequenceManager.getInstance().getSequence(acknowledgementHeader.getRmVersion(), acknowledgementHeader.getSequenceId(), true);
        if (sourceSequence != null) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("** Handling ack header: " + acknowledgementHeader);
            }
        } else {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("** IGNORING ack header for unknown source sequence " + acknowledgementHeader.getSequenceId());
            }
            return;
        }
        boolean bl2 = sourceSequence.isComplete();
        SourceSequenceManager.getInstance().handleAck(acknowledgementHeader, sourceSequence);
        if (!bl2 && sourceSequence.isComplete()) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("** Found final ack, and starting terminate process with source sequence " + sourceSequence.getId());
            }
            if (bl) {
                final Fiber.CompletionCallback completionCallback = Fiber.current().getCompletionCallback();
                Fiber.current().setCompletionCallback(new Fiber.CompletionCallback(){

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public void onCompletion(@NotNull Packet packet) {
                        try {
                            try {
                                WsrmTubeUtils.sendTerminateSequence(sourceSequence, WsrmTubeUtils.this._dispatchFactory);
                            }
                            catch (WsrmException wsrmException) {
                                if (!LOGGER.isLoggable(Level.SEVERE)) throw new RuntimeException(wsrmException.toString(), wsrmException);
                                LOGGER.log(Level.SEVERE, "sendTerminateSequence failed: " + wsrmException.toString(), wsrmException);
                                throw new RuntimeException(wsrmException.toString(), wsrmException);
                            }
                            Object var4_2 = null;
                            if (completionCallback == null) return;
                        }
                        catch (Throwable throwable) {
                            Object var4_3 = null;
                            if (completionCallback == null) throw throwable;
                            completionCallback.onCompletion(packet);
                            throw throwable;
                        }
                        completionCallback.onCompletion(packet);
                    }

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public void onCompletion(@NotNull Throwable throwable) {
                        try {
                            try {
                                WsrmTubeUtils.sendTerminateSequence(sourceSequence, WsrmTubeUtils.this._dispatchFactory);
                            }
                            catch (WsrmException wsrmException) {
                                if (!LOGGER.isLoggable(Level.SEVERE)) throw new RuntimeException(wsrmException.toString(), wsrmException);
                                LOGGER.log(Level.SEVERE, "sendTerminateSequence failed: " + wsrmException.toString(), wsrmException);
                                throw new RuntimeException(wsrmException.toString(), wsrmException);
                            }
                            Object var4_2 = null;
                            if (completionCallback == null) return;
                        }
                        catch (Throwable throwable2) {
                            Object var4_3 = null;
                            if (completionCallback == null) throw throwable2;
                            completionCallback.onCompletion(throwable);
                            throw throwable2;
                        }
                        completionCallback.onCompletion(throwable);
                    }
                });
            } else {
                WsrmTubeUtils.sendTerminateSequence(sourceSequence, this._dispatchFactory);
            }
        }
    }

    public static void addPiggybackHeaders(Packet packet, String string, AddressingVersion addressingVersion, SOAPVersion sOAPVersion) throws WsrmException {
        Object object222;
        List list = SourceSequenceManager.getInstance().getSequencesForPiggybackEndpoint(string);
        for (Object object222 : list) {
            if (!WsrmTubeUtils.piggybackHeadersForSequenceOntoPacket((Sequence)object222, packet, addressingVersion, sOAPVersion)) continue;
            SourceSequenceManager.getInstance().updateSequence((SourceSequence)object222);
        }
        List list2 = DestinationSequenceManager.getInstance().getSequencesForPiggybackEndpoint(string);
        object222 = list2.iterator();
        while (object222.hasNext()) {
            DestinationSequence object = (DestinationSequence)object222.next();
            if (!WsrmTubeUtils.piggybackHeadersForSequenceOntoPacket(object, packet, addressingVersion, sOAPVersion)) continue;
            DestinationSequenceManager.getInstance().updateSequence(object);
        }
        boolean bl = false;
        for (AddressingVersion addressingVersion2 : AddressingVersion.values()) {
            if (!addressingVersion2.anonymousUri.equals(string)) continue;
            bl = true;
            break;
        }
        if (!bl) {
            return;
        }
        Sequence sequence = WsrmTubeUtils.getRelatedSequenceForAnonymousOutgoingPacket(packet);
        if (sequence != null && WsrmTubeUtils.piggybackHeadersForSequenceOntoPacket(sequence, packet, addressingVersion, sOAPVersion)) {
            if (sequence instanceof SourceSequence) {
                SourceSequenceManager.getInstance().updateSequence((SourceSequence)sequence);
            } else {
                DestinationSequenceManager.getInstance().updateSequence((DestinationSequence)sequence);
            }
        }
    }

    private static boolean piggybackHeadersForSequenceOntoPacket(Sequence sequence, Packet packet, AddressingVersion addressingVersion, SOAPVersion sOAPVersion) throws WsrmException {
        boolean bl = false;
        List<WsrmHeader> list = sequence.getAndClearPiggybackHeaders();
        if (list.size() > 0) {
            WsrmTubeUtils.ensureMessageInPacket(packet, WsrmTubeUtils.getFallbackActionForSequence(sequence), addressingVersion, sOAPVersion);
            ArrayList<WsrmHeader> arrayList = new ArrayList<WsrmHeader>(list);
            for (WsrmHeader wsrmHeader : list) {
                if (packet.getMessage().getHeaders().get(wsrmHeader.getName(), false) != null) continue;
                bl = true;
                arrayList.remove(wsrmHeader);
                packet.getMessage().getHeaders().addOrReplace((Header)wsrmHeader);
            }
            if (arrayList.size() > 0) {
                sequence.putBackUnusedPiggybackHeaders(arrayList);
            }
        }
        return bl;
    }

    private static String getFallbackActionForSequence(Sequence sequence) {
        return WsrmConstants.Action.ACK.getActionURI(sequence.getRmVersion());
    }

    private static void ensureMessageInPacket(Packet packet, String string, AddressingVersion addressingVersion, SOAPVersion sOAPVersion) throws WsrmException {
        Message message = packet.getMessage();
        if (message == null) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("!! Created an empty body outbound message to hold piggyback headers. Action is: " + string);
            }
            try {
                message = WsUtil.createEmptyMessage(string, addressingVersion, sOAPVersion);
                packet.setMessage(message);
            }
            catch (Exception exception) {
                throw new WsrmException(exception.toString(), exception);
            }
        }
    }

    @Nullable
    private static Sequence getRelatedSequenceForAnonymousOutgoingPacket(Packet packet) throws UnknownSequenceException {
        Sequence sequence = WsrmTubeUtils.getAssociatedSequenceForAnonymousOutgoingPacket(packet);
        if (sequence == null) {
            return null;
        }
        Sequence sequence2 = WsrmTubeUtils.getRelatedAnonymousSequence(sequence);
        return sequence2;
    }

    @Nullable
    private static Sequence getRelatedAnonymousSequence(Sequence sequence) {
        DestinationSequence destinationSequence = null;
        if (sequence instanceof SourceOfferSequence) {
            destinationSequence = ((SourceOfferSequence)sequence).getMainSequence();
        } else if (sequence instanceof SourceSequence) {
            destinationSequence = ((SourceSequence)sequence).getOffer();
        } else if (sequence instanceof DestinationSequence) {
            destinationSequence = (DestinationSequence)sequence;
        }
        return destinationSequence != null && (destinationSequence.getAcksToEpr() == null || destinationSequence.getAcksToEpr().isAnonymous()) ? destinationSequence : null;
    }

    @Nullable
    private static Sequence getAssociatedSequenceForAnonymousOutgoingPacket(Packet packet) throws UnknownSequenceException {
        WsrmPropertyBag wsrmPropertyBag = WsrmPropertyBag.propertySetRetriever.getFromPacket(packet);
        String string = wsrmPropertyBag.getOutboundSequenceId();
        if (string == null && packet.getMessage() == null) {
            string = wsrmPropertyBag.getInboundSequenceId();
        }
        if (string == null) {
            return null;
        }
        Sequence sequence = SourceSequenceManager.getInstance().getSequence(WsrmConstants.RMVersion.latest(), string, true);
        if (sequence == null) {
            sequence = DestinationSequenceManager.getInstance().getSequence(WsrmConstants.RMVersion.latest(), string, true);
        }
        return sequence;
    }

    public static void sendTerminateSequence(SourceSequence sourceSequence, DispatchFactory dispatchFactory) throws WsrmException {
        if (!sourceSequence.getState().isValidTransition(SequenceState.TERMINATING)) {
            return;
        }
        try {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("** Sending TerminateSequence on source sequence " + sourceSequence.getId());
            }
            TerminateSequenceMsg terminateSequenceMsg = WsrmTubeUtils.createTerminateSequenceMessage(sourceSequence);
            String string = Rpc2WsUtil.getSOAPActionFromHandshakeMessage(terminateSequenceMsg);
            Message message = Rpc2WsUtil.createMessageFromHandshakeMessage(terminateSequenceMsg, sourceSequence.getAddressingVersion(), sourceSequence.getSoapVersion());
            WsUtil.getOrSetMessageID(message, sourceSequence.getAddressingVersion(), sourceSequence.getSoapVersion(), sourceSequence.getPhysicalStoreName());
            WSEndpointReference wSEndpointReference = sourceSequence.getEndpointEpr();
            if (wSEndpointReference.isAnonymous()) {
                if (sourceSequence.getRmVersion().isLaterThanOrEqualTo(WsrmConstants.RMVersion.RM_11)) {
                    if (sourceSequence.getOffer() != null) {
                        sourceSequence.getOffer().addFinalAckToMessage(message);
                    }
                    sourceSequence.setState(SequenceState.TERMINATING);
                    TerminateSequenceResponseProcessor.forceAnonymousTerminateSequenceResponse((SourceOfferSequence)sourceSequence);
                }
            } else {
                WSEndpointReference wSEndpointReference2 = WsrmTubeUtils.calculateReplyToForSourceSequence(sourceSequence);
                Sender sender = new Sender(dispatchFactory);
                Map<String, Object> map = SourceSequenceManager.getInstance().getSenderInvokeProperties(sourceSequence, (Packet)null);
                sender.send(message, string, wSEndpointReference, wSEndpointReference2, map);
            }
        }
        catch (Exception exception) {
            throw new WsrmException(exception.toString(), exception);
        }
    }

    public static WSEndpointReference calculateReplyToForSourceSequence(SourceSequence sourceSequence) {
        WSEndpointReference wSEndpointReference = null;
        if (sourceSequence instanceof SourceOfferSequence) {
            wSEndpointReference = sourceSequence.getAcksToEpr();
        } else {
            ClientInstanceIdentity clientInstanceIdentity = sourceSequence.getCreatingClientInstanceId();
            if (clientInstanceIdentity != null) {
                wSEndpointReference = WsrmTubeUtils.getReplyToForClient(clientInstanceIdentity.getClientId(), sourceSequence.isUsingSsl());
            }
            if (wSEndpointReference == null) {
                wSEndpointReference = sourceSequence.getAcksToEpr();
            }
        }
        return wSEndpointReference;
    }

    private static WSEndpointReference getReplyToForClient(String string, boolean bl) {
        ClientIdentityRegistry.ClientInfo clientInfo = ClientIdentityRegistry.getClientInfo(string);
        if (clientInfo == null) {
            throw new IllegalArgumentException("No client with identity '" + string + "' has been registered");
        }
        WSEndpointReference wSEndpointReference = null;
        OneWayFeature oneWayFeature = (OneWayFeature)clientInfo.getOriginalConfig().getFeatures().get(OneWayFeature.class);
        if (oneWayFeature == null) {
            AsyncClientTransportFeature asyncClientTransportFeature = (AsyncClientTransportFeature)clientInfo.getOriginalConfig().getFeatures().get(AsyncClientTransportFeature.class);
            if (asyncClientTransportFeature != null) {
                wSEndpointReference = new WSEndpointReference(asyncClientTransportFeature.getEndpointReference(W3CEndpointReference.class, new Element[0]));
            }
        } else {
            wSEndpointReference = oneWayFeature.getReplyTo(bl);
        }
        return wSEndpointReference;
    }

    public static TerminateSequenceMsg createTerminateSequenceMessage(SourceSequence sourceSequence) throws WsrmException {
        if (sourceSequence.getDestinationId() == null) {
            String string = WsrmTubeUtils.getCurrentMethod();
            throw new WsrmException(WseeRmLogger.logCannotInteractWithPendingSequenceLoggable((String)string, (String)sourceSequence.getId()).getMessage());
        }
        TerminateSequenceMsg terminateSequenceMsg = new TerminateSequenceMsg(sourceSequence.getRmVersion(), sourceSequence.getDestinationId());
        terminateSequenceMsg.setLastMsgNumber(sourceSequence.getMaxMessageNum());
        terminateSequenceMsg.setMustUnderstand(true);
        return terminateSequenceMsg;
    }

    public static void sendCloseSequence(SourceSequence sourceSequence, DispatchFactory dispatchFactory) throws WsrmException {
        if (!sourceSequence.getRmVersion().isLaterThanOrEqualTo(WsrmConstants.RMVersion.RM_11)) {
            return;
        }
        if (!sourceSequence.getState().isValidTransition(SequenceState.CLOSING)) {
            return;
        }
        try {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("** Sending CloseSequence on source sequence " + sourceSequence.getId());
            }
            CloseSequenceMsg closeSequenceMsg = WsrmTubeUtils.createCloseSequenceMessage(sourceSequence);
            String string = Rpc2WsUtil.getSOAPActionFromHandshakeMessage(closeSequenceMsg);
            Message message = Rpc2WsUtil.createMessageFromHandshakeMessage(closeSequenceMsg, sourceSequence.getAddressingVersion(), sourceSequence.getSoapVersion());
            WsUtil.getOrSetMessageID(message, sourceSequence.getAddressingVersion(), sourceSequence.getSoapVersion(), sourceSequence.getPhysicalStoreName());
            WSEndpointReference wSEndpointReference = sourceSequence.getEndpointEpr();
            if (wSEndpointReference.isAnonymous()) {
                CloseSequenceResponseProcessor.forceAnonymousCloseSequenceResponse((SourceOfferSequence)sourceSequence);
            } else {
                Sender sender = new Sender(dispatchFactory);
                Map<String, Object> map = SourceSequenceManager.getInstance().getSenderInvokeProperties(sourceSequence, (Packet)null);
                WSEndpointReference wSEndpointReference2 = WsrmTubeUtils.calculateReplyToForSourceSequence(sourceSequence);
                sender.send(message, string, wSEndpointReference, wSEndpointReference2, map);
            }
        }
        catch (Exception exception) {
            throw new WsrmException(exception.toString(), exception);
        }
    }

    public static CloseSequenceMsg createCloseSequenceMessage(SourceSequence sourceSequence) throws WsrmException {
        if (sourceSequence.getDestinationId() == null) {
            String string = WsrmTubeUtils.getCurrentMethod();
            throw new WsrmException(WseeRmLogger.logCannotInteractWithPendingSequenceLoggable((String)string, (String)sourceSequence.getId()).getMessage());
        }
        CloseSequenceMsg closeSequenceMsg = new CloseSequenceMsg(sourceSequence.getRmVersion(), sourceSequence.getDestinationId());
        closeSequenceMsg.setLastMsgNumber(sourceSequence.getMaxMessageNum());
        closeSequenceMsg.setMustUnderstand(true);
        return closeSequenceMsg;
    }

    public static String getCurrentMethod() {
        StackTraceElement[] stackTraceElementArray = new Exception().getStackTrace();
        return stackTraceElementArray[1].getMethodName();
    }

    public static void sendAcknowledgementRequest(SourceSequence sourceSequence, DispatchFactory dispatchFactory) throws WsrmException {
        if (sourceSequence.getState() != SequenceState.CREATED && sourceSequence.getState() != SequenceState.CLOSING && sourceSequence.getState() != SequenceState.CLOSED) {
            return;
        }
        try {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("** Sending AcknowledgementRequest on source sequence " + sourceSequence.getId());
            }
            AckRequestedHeader ackRequestedHeader = new AckRequestedHeader(sourceSequence.getRmVersion());
            WSEndpointReference wSEndpointReference = sourceSequence.getEndpointEpr();
            if (wSEndpointReference.isAnonymous()) {
                sourceSequence.addPiggybackHeader(ackRequestedHeader);
            } else {
                String string = WsrmConstants.Action.ACK_REQUESTED.getActionURI(sourceSequence.getRmVersion());
                Message message = WsUtil.createEmptyMessage(string, sourceSequence.getAddressingVersion(), sourceSequence.getSoapVersion());
                message.getHeaders().add((Header)ackRequestedHeader);
                WsUtil.getOrSetMessageID(message, sourceSequence.getAddressingVersion(), sourceSequence.getSoapVersion(), sourceSequence.getPhysicalStoreName());
                Sender sender = new Sender(dispatchFactory);
                Map<String, Object> map = SourceSequenceManager.getInstance().getSenderInvokeProperties(sourceSequence, (Packet)null);
                sender.send(message, string, wSEndpointReference, sourceSequence.getAcksToEpr(), map);
            }
        }
        catch (Exception exception) {
            throw new WsrmException(exception.toString(), exception);
        }
    }

    public OutboundMessageResult processOutboundMessage(Packet packet, SequenceIdFactory sequenceIdFactory, String string) throws WsrmException, XMLStreamException, PolicyException {
        Object object;
        String string2;
        DestinationMessageInfo destinationMessageInfo;
        OutboundMessageResult outboundMessageResult = null;
        this.getRmInvokeProps(packet);
        WsrmInvocationPropertyBag.flagPersistentPropsOnPacket(packet);
        WsrmPropertyBag.flagPersistentPropsOnPacket(packet);
        WsrmPropertyBag wsrmPropertyBag = WsrmPropertyBag.propertySetRetriever.getFromPacket(packet);
        Message message = packet.getMessage();
        if (message == null && (destinationMessageInfo = wsrmPropertyBag.getDestMessageInfoFromRequest()) != null) {
            DestinationSequenceManager.getInstance().handleNoResponseSequenceMessage(destinationMessageInfo);
        }
        WsrmTubeUtils.addPiggybackHeaders(packet, string, this._binding.getAddressingVersion(), this._binding.getSOAPVersion());
        message = packet.getMessage();
        destinationMessageInfo = this._binding.getAddressingVersion();
        SOAPVersion sOAPVersion = this._binding.getSOAPVersion();
        String string3 = string2 = message != null ? message.getHeaders().getAction((AddressingVersion)destinationMessageInfo, sOAPVersion) : null;
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Processing outbound action: " + string2);
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Checking outbound action '" + string2 + "' against all possible RM actions: " + WsrmConstants.Action.dumpAllActionsForAllRMVersions());
        }
        if (!WsrmConstants.Action.matchesAnyActionAndRMVersion(string2)) {
            if (WsrmTubeUtils.handlePossibleRmFault(packet) == null) {
                if (string2 != null && !string2.equals(WsUtil.getSOAPFaultAction(this._binding.getAddressingVersion()))) {
                    object = this.getEffectivePolicyForPacket(packet, !this._clientSide);
                    if (object != null) {
                        outboundMessageResult = this.processOutboundSequenceMessage(packet, sequenceIdFactory, string);
                        if (!outboundMessageResult.messageBuffered) {
                            if (!this._clientSide && packet.invocationProperties.get("weblogic.wsee.policy.effectiveResponsePolicy") == null) {
                                packet.invocationProperties.put("weblogic.wsee.policy.effectiveResponsePolicy", object);
                            } else if (this._clientSide && packet.invocationProperties.get("weblogic.wsee.policy.effectiveRequestPolicy") == null) {
                                packet.invocationProperties.put("weblogic.wsee.policy.effectiveRequestPolicy", object);
                            }
                        }
                    } else if (LOGGER.isLoggable(Level.FINE)) {
                        String string4 = packet.getMessage().getHeaders().getMessageID(this._binding.getAddressingVersion(), this._binding.getSOAPVersion());
                        LOGGER.fine("Failed to find policy for outbound message with msg id " + string4 + ". SKIPPING!");
                    }
                } else if (!this._clientSide) {
                    wsrmPropertyBag.restorePersistentPropsIntoJaxWsRi(this._binding.getAddressingVersion(), this._binding.getSOAPVersion());
                }
            }
        } else {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Processing outbound WS-RM action: " + string2);
            }
            if (!this._clientSide) {
                object = (WsaPropertyBag)packet.getSatellite(WsaPropertyBag.class);
                if (object == null) {
                    object = new WsaPropertyBag((AddressingVersion)destinationMessageInfo, sOAPVersion, packet);
                    packet.addSatellite((PropertySet)object);
                }
                if (packet.get((Object)"com.sun.xml.ws.addressing.WsaPropertyBag.ReplyToFromRequest") == null) {
                    packet.put("com.sun.xml.ws.addressing.WsaPropertyBag.ReplyToFromRequest", packet.invocationProperties.remove("com.sun.xml.ws.addressing.WsaPropertyBag.ReplyToFromRequest"));
                    packet.put("com.sun.xml.ws.addressing.WsaPropertyBag.FaultToFromRequest", packet.invocationProperties.remove("com.sun.xml.ws.addressing.WsaPropertyBag.FaultToFromRequest"));
                }
            }
            object = WsrmConstants.Action.getVersionInfo(string2);
            MessageProcessor messageProcessor = MessageProcessorFactory.createProcessorForAction(((WsrmConstants.Action.VersionInfo)object).action, this);
            if (!messageProcessor.processOutbound(packet, ((WsrmConstants.Action.VersionInfo)object).rmVersion, sequenceIdFactory, string)) {
                outboundMessageResult = new OutboundMessageResult();
                outboundMessageResult.messageAborted = true;
            }
        }
        if (message != null) {
            WsUtil.getOrSetMessageID(message, this._binding.getAddressingVersion(), this._binding.getSOAPVersion());
        }
        if (outboundMessageResult == null) {
            outboundMessageResult = new OutboundMessageResult();
            outboundMessageResult.messageBuffered = false;
        }
        if (!outboundMessageResult.messageBuffered && !outboundMessageResult.messageAborted && (object = WsrmTubeUtils.getOutboundSourceSequenceForPacket(packet)) != null) {
            SourceSequenceManager.getInstance().setInvokePropertiesOntoPacket(object, packet);
        }
        if (wsrmPropertyBag.getTransportBackChannel() != null) {
            packet.transportBackChannel = wsrmPropertyBag.getTransportBackChannel();
            wsrmPropertyBag.setTransportBackChannel(null);
        }
        return outboundMessageResult;
    }

    static void initializeInboundMessage(Packet packet) throws WsrmException {
        Sequence<?> sequence = WsrmTubeUtils.getSequenceForPacket(packet);
        if (sequence instanceof SourceSequence) {
            SourceSequenceManager.getInstance().setInvokePropertiesOntoPacket((SourceSequence)sequence, packet);
        } else if (sequence instanceof DestinationSequence) {
            DestinationSequenceManager.getInstance().setInvokePropertiesOntoPacket((DestinationSequence)sequence, packet);
        }
    }

    public static SCCredential getSCCredential(Packet packet) {
        SCCredential sCCredential = null;
        if (packet.proxy != null) {
            sCCredential = (SCCredential)packet.proxy.getRequestContext().get("weblogic.wsee.wssc.sct");
        }
        if (sCCredential == null) {
            sCCredential = (SCCredential)packet.invocationProperties.get("weblogic.wsee.wssc.sct");
        }
        return sCCredential;
    }

    public static byte[] getSSLSessionId(Packet packet) {
        if (packet == null || !packet.supports((Object)"javax.xml.ws.servlet.request")) {
            return null;
        }
        HttpServletRequest httpServletRequest = (HttpServletRequest)packet.get((Object)"javax.xml.ws.servlet.request");
        SSLSession sSLSession = (SSLSession)httpServletRequest.getAttribute("weblogic.servlet.request.sslsession");
        return sSLSession != null ? sSLSession.getId() : null;
    }

    public static boolean isSSLRequest(Packet packet) {
        if (packet == null || !packet.supports((Object)"javax.xml.ws.servlet.request")) {
            return false;
        }
        HttpServletRequest httpServletRequest = (HttpServletRequest)packet.get((Object)"javax.xml.ws.servlet.request");
        return httpServletRequest.isSecure();
    }

    public static X509Certificate[] getSSLCertChain(Packet packet) {
        if (packet == null || !packet.supports((Object)"javax.xml.ws.servlet.request")) {
            return null;
        }
        HttpServletRequest httpServletRequest = (HttpServletRequest)packet.get((Object)"javax.xml.ws.servlet.request");
        return (X509Certificate[])httpServletRequest.getAttribute("javax.servlet.request.X509Certificate");
    }

    private static String dumpSecuritySSLOnPacket(Packet packet) {
        if (packet == null || !packet.supports((Object)"javax.xml.ws.servlet.request")) {
            return null;
        }
        HttpServletRequest httpServletRequest = (HttpServletRequest)packet.get((Object)"javax.xml.ws.servlet.request");
        SSLSession sSLSession = (SSLSession)httpServletRequest.getAttribute("weblogic.servlet.request.sslsession");
        X509Certificate[] x509CertificateArray = (X509Certificate[])httpServletRequest.getAttribute("javax.servlet.request.X509Certificate");
        return WsrmTubeUtils.dumpSecuritySSL(sSLSession != null ? sSLSession.getId() : null, x509CertificateArray);
    }

    public static String dumpSecuritySSL(byte[] byArray, X509Certificate[] x509CertificateArray) {
        StringBuffer stringBuffer = new StringBuffer();
        String string = byArray != null ? _base64.encodeBuffer(byArray) : null;
        stringBuffer.append("SSLSessionID=").append(string);
        stringBuffer.append(" ");
        stringBuffer.append("X509Certificates=");
        if (x509CertificateArray == null) {
            stringBuffer.append("null");
        } else {
            stringBuffer.append("[");
            for (X509Certificate x509Certificate : x509CertificateArray) {
                stringBuffer.append(x509Certificate);
                stringBuffer.append(",");
            }
            stringBuffer.deleteCharAt(stringBuffer.length() - 1);
            stringBuffer.append("]");
        }
        return stringBuffer.toString();
    }

    public static String dumpSSLSessionId(byte[] byArray) {
        return byArray != null ? _base64.encodeBuffer(byArray) : null;
    }

    private static String dumpSecuritySCTOnPacket(Packet packet) {
        if (packet == null) {
            return "<None>";
        }
        SCCredential sCCredential = WsrmTubeUtils.getSCCredential(packet);
        return WsrmTubeUtils.dumpSecuritySCT(sCCredential);
    }

    public static String dumpSecuritySCT(SCCredential sCCredential) {
        if (sCCredential == null) {
            return "<None>";
        }
        return "SCCredential=" + sCCredential + " ID=" + sCCredential.getIdentifier();
    }

    static void initializeOutboundMessage(Packet packet) throws WsrmException {
        Sequence<?> sequence = WsrmTubeUtils.getSequenceForPacket(packet);
        if (sequence instanceof SourceSequence) {
            SourceSequenceManager.getInstance().setInvokePropertiesOntoPacket((SourceSequence)sequence, packet);
        } else if (sequence instanceof DestinationSequence) {
            DestinationSequenceManager.getInstance().setInvokePropertiesOntoPacket((DestinationSequence)sequence, packet);
        }
    }

    private NormalizedExpression getEffectivePolicyForPacket(Packet packet, boolean bl) throws PolicyException {
        WsrmPropertyBag wsrmPropertyBag = WsrmPropertyBag.propertySetRetriever.getFromPacket(packet);
        WSDLBoundOperation wSDLBoundOperation = packet.getMessage().getOperation(this._wsdlPort);
        String string = wSDLBoundOperation != null ? wSDLBoundOperation.getName().getLocalPart() : (!this._clientSide ? (bl ? wsrmPropertyBag.getInboundWsdlOperationName() : wsrmPropertyBag.getOutboundWsdlOperationName()) : (bl ? wsrmPropertyBag.getOutboundWsdlOperationName() : wsrmPropertyBag.getInboundWsdlOperationName()));
        if (string != null) {
            NormalizedExpression normalizedExpression = bl ? this._policyHelper.getResponseEffectivePolicy(string) : this._policyHelper.getRequestEffectivePolicy(string);
            return normalizedExpression;
        }
        return null;
    }

    private static SourceSequence getOutboundSourceSequenceForPacket(Packet packet) throws UnknownSourceSequenceException {
        WsrmPropertyBag wsrmPropertyBag = WsrmPropertyBag.propertySetRetriever.getFromPacket(packet);
        String string = wsrmPropertyBag.getOutboundSequenceId();
        if (string != null) {
            SourceSequence sourceSequence = SourceSequenceManager.getInstance().getSequence(WsrmConstants.RMVersion.latest(), string, true);
            return sourceSequence;
        }
        return null;
    }

    private static Sequence<?> getSequenceForPacket(Packet packet) throws UnknownSequenceException {
        WsrmPropertyBag wsrmPropertyBag = WsrmPropertyBag.propertySetRetriever.getFromPacket(packet);
        String string = wsrmPropertyBag.getOutboundSequenceId();
        if (string != null) {
            return SourceSequenceManager.getInstance().getSequence(WsrmConstants.RMVersion.latest(), string, true);
        }
        string = wsrmPropertyBag.getInboundSequenceId();
        if (string != null) {
            Sequence sequence = DestinationSequenceManager.getInstance().getSequence(WsrmConstants.RMVersion.latest(), string, true);
            if (sequence == null) {
                sequence = SourceSequenceManager.getInstance().getSequence(WsrmConstants.RMVersion.latest(), string, true);
            }
            return sequence;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OutboundMessageResult processOutboundSequenceMessage(Packet packet, SequenceIdFactory sequenceIdFactory, String string) throws WsrmException {
        OutboundMessageResult outboundMessageResult = new OutboundMessageResult();
        outboundMessageResult.messageBuffered = false;
        try {
            Object object;
            ClientInstance clientInstance;
            WeakReference weakReference;
            boolean bl;
            WsrmPropertyBag wsrmPropertyBag = WsrmPropertyBag.propertySetRetriever.getFromPacket(packet);
            WsrmConfig.Source source = WsrmConfig.getSource(this._serverContext, this._clientContext, packet, !this._clientSide);
            WsrmConstants.RMVersion rMVersion = source.getRmVersion();
            if (rMVersion == null) {
                return outboundMessageResult;
            }
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Outbound sequence message config:\n" + source.toString());
            }
            wsrmPropertyBag.restorePersistentPropsIntoJaxWsRi(this._binding.getAddressingVersion(), this._binding.getSOAPVersion());
            if (packet.soapAction == null) {
                packet.soapAction = packet.getMessage().getHeaders().getAction(this._binding.getAddressingVersion(), this._binding.getSOAPVersion());
            }
            String string2 = packet.getMessage().getHeaders().getMessageID(this._binding.getAddressingVersion(), this._binding.getSOAPVersion());
            String string3 = packet.getMessage().getHeaders().getRelatesTo(this._binding.getAddressingVersion(), this._binding.getSOAPVersion());
            boolean bl2 = bl = string3 != null;
            if (wsrmPropertyBag.getInternalSend()) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("WsrmTubeUtils.processOutboundSequenceMessage detected an internally sent request. Ignoring it to allow it to pass through the rest of the tubeline. Msg id " + string2);
                }
                return outboundMessageResult;
            }
            WSDLBoundOperation wSDLBoundOperation = packet.getMessage().getOperation(this._wsdlPort);
            boolean bl3 = false;
            if (wSDLBoundOperation != null) {
                wsrmPropertyBag.setOutboundWsdlOperationName(wSDLBoundOperation.getName().getLocalPart());
                bl3 = wSDLBoundOperation.getOperation().isOneWay();
            }
            if (bl3) {
                weakReference = packet.getMessage().getHeaders().getReplyTo(this._binding.getAddressingVersion(), this._binding.getSOAPVersion());
                packet.expectReply = weakReference.isAnonymous();
            }
            ClientInstance clientInstance2 = clientInstance = (weakReference = (WeakReference)packet.invocationProperties.get("weblogic.wsee.jaxws.spi.ClientInstanceWeakRef")) != null ? (ClientInstance)weakReference.get() : null;
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Processing outbound sequence message with action '" + packet.soapAction + "' msgId=" + string2 + " clientInstance=" + clientInstance);
            }
            EstablishSequenceForRequestAction establishSequenceForRequestAction = new EstablishSequenceForRequestAction(packet, sequenceIdFactory, string, wsrmPropertyBag, source, rMVersion, string2, bl, clientInstance);
            if (clientInstance != null) {
                object = clientInstance;
                synchronized (object) {
                    establishSequenceForRequestAction = establishSequenceForRequestAction.invoke();
                }
            } else {
                establishSequenceForRequestAction = establishSequenceForRequestAction.invoke();
            }
            if ((object = establishSequenceForRequestAction.getSeq()) == null) {
                return outboundMessageResult;
            }
            WsrmInvocationPropertyBag wsrmInvocationPropertyBag = WsrmInvocationPropertyBag.getFromPacket(packet);
            wsrmInvocationPropertyBag.setSequenceId(((Sequence)object).getId());
            if (object instanceof SourceOfferSequence) {
                WsrmLifecycleEventListenerRegistry.getInstance().notifyEventType(WsrmLifecycleEvent.Type.SERV_IN_MSG_BEFORE_RESPONSE_SEND);
            }
            String string4 = ((Sequence)object).getPhysicalStoreName();
            WsUtil.getOrSetMessageID(packet.getMessage(), this._binding.getAddressingVersion(), this._binding.getSOAPVersion(), string4);
            outboundMessageResult.messageInfo = this.addMessageToSourceSequence(packet, (SourceSequence)object);
            if (((Sequence)object).isNonBuffered()) {
                if (((Sequence)object).getState() == SequenceState.CREATING || ((Sequence)object).getState() == SequenceState.NEW) {
                    throw new WsrmAbortSendException(WseeRmLogger.logSourceSequenceNotReadyToSendLoggable().getMessage());
                }
            } else {
                outboundMessageResult.messageBuffered = true;
            }
        }
        catch (WsrmException wsrmException) {
            throw wsrmException;
        }
        catch (Exception exception) {
            throw new WsrmException(exception.toString(), exception);
        }
        return outboundMessageResult;
    }

    private void registerCurrentSequenceWithMonitoring(Packet packet, SourceSequence sourceSequence) {
        try {
            WseeWsrmRuntimeMBeanImpl wseeWsrmRuntimeMBeanImpl = WsrmTubeUtils.getWsrmRuntimeFromPacket(packet);
            if (wseeWsrmRuntimeMBeanImpl != null) {
                wseeWsrmRuntimeMBeanImpl.addSequenceId(sourceSequence.getId());
                if (sourceSequence.getOffer() != null) {
                    wseeWsrmRuntimeMBeanImpl.addSequenceId(sourceSequence.getOffer().getId());
                }
            }
        }
        catch (Exception exception) {
            if (LOGGER.isLoggable(Level.WARNING)) {
                LOGGER.log(Level.WARNING, exception.toString(), exception);
            }
            WseeRmLogger.logUnexpectedException((String)exception.toString(), (Throwable)exception);
        }
    }

    public void removeClientCurrentSequenceId(ClientInstanceIdentity clientInstanceIdentity) {
        WsrmClientRuntimeFeature wsrmClientRuntimeFeature = WsrmClientRuntimeFeature.getFromBinding(this._binding);
        if (wsrmClientRuntimeFeature != null) {
            wsrmClientRuntimeFeature.removeClientCurrentSequenceId(clientInstanceIdentity);
        }
    }

    private SourceMessageInfo addMessageToSourceSequence(Packet packet, SourceSequence sourceSequence) throws WsrmException {
        String string;
        WsrmInvocationPropertyBag wsrmInvocationPropertyBag = (WsrmInvocationPropertyBag)packet.invocationProperties.get(WsrmInvocationPropertyBag.key);
        if (wsrmInvocationPropertyBag == null) {
            wsrmInvocationPropertyBag = new WsrmInvocationPropertyBag(packet);
            packet.invocationProperties.put(WsrmInvocationPropertyBag.key, wsrmInvocationPropertyBag);
        }
        WsrmPropertyBag wsrmPropertyBag = WsrmPropertyBag.propertySetRetriever.getFromPacket(packet);
        wsrmPropertyBag.setInternalSend(true);
        WsrmConstants.RMVersion rMVersion = sourceSequence.getRmVersion();
        String string2 = sourceSequence.getId();
        SequenceHeader sequenceHeader = WsrmHeaderFactory.getInstance().createEmptyWsrmHeader(SequenceHeader.class, rMVersion);
        sequenceHeader.setMustUnderstand(true);
        long l = sourceSequence.getNextMessageNum(sequenceHeader);
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Processing (stage 2) outbound sequence message with msg id " + packet.getMessage().getHeaders().getMessageID(this._binding.getAddressingVersion(), this._binding.getSOAPVersion()) + ", seq " + string2 + " and msg num " + l);
        }
        if (sourceSequence.getState() != SequenceState.NEW && sourceSequence.getState() != SequenceState.CREATING) {
            string = sourceSequence.getDestinationId();
        } else {
            wsrmPropertyBag.setOutboundMsgNeedsDestSeqId(true);
            string = string2;
        }
        sequenceHeader.setSequenceId(string);
        sequenceHeader.setMessageNumber(l);
        packet.getMessage().getHeaders().add((Header)sequenceHeader);
        SourceMessageInfo sourceMessageInfo = SourceSequenceManager.getInstance().processSequenceMessage(sequenceHeader, packet, this._binding.getAddressingVersion(), this._binding.getSOAPVersion());
        wsrmInvocationPropertyBag.setMostRecentMsgNum(l);
        return sourceMessageInfo;
    }

    private WsrmInvocationPropertyBag getRmInvokeProps(Packet packet) {
        return WsrmInvocationPropertyBag.getFromPacket(packet);
    }

    private DestinationOfferSequence createOfferSequenceIfNeeded(SourceSequence sourceSequence, WsrmConfig.Destination destination, ClientInstance clientInstance) throws WsrmException {
        if (this.checkOfferNeeded(sourceSequence.getRmVersion())) {
            Object object;
            boolean bl;
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Outbound sequence message destination config: " + destination);
            }
            if (!(bl = destination.isNonBufferedDestination())) {
                if (sourceSequence.isNonBuffered()) {
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.fine("Turning off response buffering (setting WsrmConfig.Destination.nonBufferedDestination=true) even though it was requested via config) for offer sequence related to source sequence because the source sequence turned off buffering too");
                    }
                    bl = true;
                }
                if (sourceSequence.getAcksToEpr().isAnonymous()) {
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.fine("Turning off response buffering (setting WsrmConfig.Destination.nonBufferedDestination=true) (even though it was requested via config) for offer sequence related to source sequence because the source sequence is 'anonymous' and will process only synchronous requests and responses");
                    }
                    bl = true;
                }
            }
            if (!bl && clientInstance != null && clientInstance.getCreationInfo() != null) {
                object = clientInstance.getCreationInfo().getFeatures();
                boolean bl2 = false;
                for (WebServiceFeature webServiceFeature : object.values()) {
                    if (!webServiceFeature.getID().equals(McFeature.getMcFeatureIDValue())) continue;
                    bl2 = true;
                    break;
                }
                if (bl2) {
                    bl = true;
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.fine("Client has the Make Connection Feature enabled.  Therefore responses to this client will not be buffered by WS-RM.  The Offer Sequence Destination 'isNonBuffered' configuration value is being forced to 'true'");
                    }
                }
            }
            object = new DestinationOfferSequence(null, destination.getPersistenceConfig().getLogicalStoreName(), sourceSequence.getRmVersion(), sourceSequence.getAddressingVersion(), sourceSequence.getSoapVersion(), sourceSequence.getSecurityContext(), bl);
            ClientIdentityFeature clientIdentityFeature = (ClientIdentityFeature)this._binding.getFeature(ClientIdentityFeature.class);
            if (clientIdentityFeature != null) {
                DispatchFactoryResolver.ClientSideKey clientSideKey = new DispatchFactoryResolver.ClientSideKey(clientIdentityFeature.getClientId());
                ((DestinationSequence)object).setDispatchKey(clientSideKey);
            }
            ((DestinationOfferSequence)object).takeEprsFromSequence(sourceSequence);
            ((Sequence)object).setIncompleteSequenceBehavior(sourceSequence.getIncompleteSequenceBehavior());
            ((Sequence)object).setDeliveryAssurance(sourceSequence.getDeliveryAssurance());
            try {
                ((Sequence)object).setExpires(sourceSequence.getExpires());
                ((Sequence)object).setIdleTimeout(sourceSequence.getIdleTimeout());
                ((DestinationSequence)object).setAckInterval(DatatypeFactory.newInstance().newDuration(destination.getAcknowledgementInterval()));
            }
            catch (Exception exception) {
                WseeRmLogger.logUnexpectedException((String)exception.toString(), (Throwable)exception);
            }
            return object;
        }
        return null;
    }

    protected boolean checkOfferNeeded(WsrmConstants.RMVersion rMVersion) throws WsrmException {
        WSDLPortType wSDLPortType = this._wsdlPort.getBinding().getPortType();
        for (WSDLOperation wSDLOperation : wSDLPortType.getOperations()) {
            NormalizedExpression normalizedExpression;
            if (wSDLOperation.getOutput() == null) continue;
            if (rMVersion == WsrmConstants.RMVersion.RM_10) {
                return true;
            }
            try {
                normalizedExpression = this._policyHelper.getResponseEffectivePolicy(wSDLOperation.getName().getLocalPart());
            }
            catch (Exception exception) {
                throw new WsrmException(exception.toString(), exception);
            }
            RM11Assertion rM11Assertion = (RM11Assertion)normalizedExpression.getPolicyAssertion(RM11Assertion.class);
            if (rM11Assertion != null && rM11Assertion.isOptional()) continue;
            return true;
        }
        return false;
    }

    private boolean updateSecurityPropertiesIntoSequence(Packet packet, SourceSequence sourceSequence) throws WsrmException {
        WsrmLifecycleEventListenerRegistry.getInstance().notifyEventType(WsrmLifecycleEvent.Type.CLIENT_SECURITY_PROPS_BEFORE_SAVE);
        WsrmSecurityContext wsrmSecurityContext = sourceSequence.getSecurityContext();
        boolean bl = wsrmSecurityContext.update(packet);
        if (bl) {
            SourceSequenceManager.getInstance().updateSequence(sourceSequence);
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Updated WsrmSecurityContext object for source sequence: " + sourceSequence.getId());
            }
        } else if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("No WsrmSecurityContext values require updating");
        }
        return bl;
    }

    public static void sendCreateSequenceMsg(SourceSequence sourceSequence, DispatchFactory dispatchFactory, Sender.SendFailureCallback sendFailureCallback) throws SOAPException, WsrmException {
        Object object;
        Object object2;
        Object object3;
        DestinationOfferSequence destinationOfferSequence;
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Sending CreateSequence on seq " + sourceSequence.getId() + " to " + sourceSequence.getEndpointEpr());
        }
        CreateSequenceMsg createSequenceMsg = new CreateSequenceMsg(sourceSequence.getRmVersion());
        EndpointReference endpointReference = WsUtil.createWseeEPRFromWsEPR(sourceSequence.getAcksToEpr());
        createSequenceMsg.setAcksTo(endpointReference);
        createSequenceMsg.setExpires(sourceSequence.getExpires());
        createSequenceMsg.setSecurityTokenReference(null);
        if (sourceSequence.getOffer() != null) {
            destinationOfferSequence = sourceSequence.getOffer();
            object3 = new SequenceOffer(sourceSequence.getRmVersion());
            ((SequenceOffer)object3).setEndpoint(endpointReference);
            ((SequenceOffer)object3).setExpires(destinationOfferSequence.getExpires().toString());
            ((SequenceOffer)object3).setIncompleteSequenceBehavior(destinationOfferSequence.getIncompleteSequenceBehavior());
            ((SequenceOffer)object3).setSequenceId(destinationOfferSequence.getId());
            createSequenceMsg.setOffer((SequenceOffer)object3);
        }
        destinationOfferSequence = Rpc2WsUtil.createMessageFromHandshakeMessage(createSequenceMsg, sourceSequence.getAddressingVersion(), sourceSequence.getSoapVersion());
        object3 = Rpc2WsUtil.getSOAPActionFromHandshakeMessage(createSequenceMsg);
        if (sourceSequence.getCreateSequenceMsgId() == null) {
            WsUtil.getOrSetMessageID((Message)destinationOfferSequence, sourceSequence.getAddressingVersion(), sourceSequence.getSoapVersion(), sourceSequence.getPhysicalStoreName());
        } else {
            object2 = new StringHeader(sourceSequence.getAddressingVersion().messageIDTag, sourceSequence.getCreateSequenceMsgId());
            destinationOfferSequence.getHeaders().addOrReplace((Header)object2);
        }
        object2 = sourceSequence.getSecurityContext();
        WsrmConstants.RMVersion rMVersion = sourceSequence.getRmVersion();
        if (((WsrmSecurityContext)object2).isSecureWithWssc()) {
            if (rMVersion.isLaterThanOrEqualTo(WsrmConstants.RMVersion.RM_11)) {
                destinationOfferSequence.getHeaders().add((Header)new UsesSequenceSTRHeader(rMVersion));
            }
        } else if (((WsrmSecurityContext)object2).isSecureWithSSL() && rMVersion.isLaterThanOrEqualTo(WsrmConstants.RMVersion.RM_11)) {
            destinationOfferSequence.getHeaders().add((Header)new UsesSequenceSSLHeader(rMVersion));
        }
        sourceSequence.setState(SequenceState.CREATING);
        SourceSequenceManager.getInstance().updateSequence(sourceSequence);
        Sender sender = new Sender(dispatchFactory);
        WSEndpointReference wSEndpointReference = sourceSequence.getEndpointEpr();
        WSEndpointReference wSEndpointReference2 = WsrmTubeUtils.calculateReplyToForSourceSequence(sourceSequence);
        boolean bl = sourceSequence.isNonBuffered();
        Map map = null;
        WsrmSecurityContext wsrmSecurityContext = sourceSequence.getSecurityContext();
        try {
            if (wsrmSecurityContext != null) {
                map = wsrmSecurityContext.newInitializedMap();
                CreateSequencePostSecurityTokenCallback.addCallbackToMap(wsrmSecurityContext, map);
                if (LOGGER.isLoggable(Level.FINER)) {
                    LOGGER.finer("\n\n\n======= after setting, securityPropertyMap contains: ");
                    object = map.keySet();
                    int n = object.size();
                    LOGGER.finer("====   " + n + " key-pairs:");
                    Iterator iterator = object.iterator();
                    while (iterator.hasNext()) {
                        Object e = iterator.next();
                        Object v = map.get(e);
                        if (v != null) {
                            LOGGER.finer("====   key='" + e.toString() + "',  val='" + v.toString() + "'");
                            continue;
                        }
                        LOGGER.finer("====   key='" + e.toString() + "',  val=NULL");
                    }
                    LOGGER.finer("======= DONE ======\n\n\n\n");
                }
            }
        }
        catch (PolicyException policyException) {
            throw new WsrmException(policyException.getMessage());
        }
        object = SourceSequenceManager.getInstance().getSenderInvokeProperties(sourceSequence, (Packet)null);
        object.putAll(map);
        try {
            sender.send((Message)destinationOfferSequence, (String)object3, wSEndpointReference, wSEndpointReference2, (Map<String, Object>)object, bl, false, sendFailureCallback);
        }
        catch (Exception exception) {
            throw new WsrmException(exception.toString(), exception);
        }
    }

    public static WSEndpointReference getEndpointReferenceFromIncomingPacket(@NotNull Packet packet, @NotNull WSEndpointImpl wSEndpointImpl) {
        WSEndpointReference wSEndpointReference = null;
        AsyncTransportProviderPropertyBag asyncTransportProviderPropertyBag = AsyncTransportProviderPropertyBag.propertySetRetriever.getFromPacket(packet);
        AsyncResponseEndpoint asyncResponseEndpoint = null;
        if (asyncTransportProviderPropertyBag != null) {
            asyncResponseEndpoint = asyncTransportProviderPropertyBag.getResponseEndpoint();
        }
        if (asyncResponseEndpoint != null) {
            wSEndpointReference = new WSEndpointReference(asyncResponseEndpoint.getEndpointReference());
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("getEndpointReferenceFromIncomingPacket returning client-side async response endpoint EPR: " + wSEndpointReference.getAddress());
            }
        }
        if (wSEndpointReference == null) {
            String string = packet.webServiceContextDelegate.getEPRAddress(packet, (WSEndpoint)wSEndpointImpl);
            String string2 = null;
            if (wSEndpointImpl.getServiceDefinition() != null) {
                string2 = packet.webServiceContextDelegate.getWSDLAddress(packet, (WSEndpoint)wSEndpointImpl);
            }
            Class<W3CEndpointReference> clazz = W3CEndpointReference.class;
            wSEndpointReference = wSEndpointImpl.getWSEndpointReference(clazz, string, string2, new Element[0]);
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("getEndpointReferenceFromIncomingPacket returning service-side endpoint EPR: " + wSEndpointReference.getAddress());
            }
        }
        return wSEndpointReference;
    }

    public static Packet createPacketFromPersistentMessage(PersistentMessage persistentMessage, AddressingVersion addressingVersion, SOAPVersion sOAPVersion) {
        Packet packet = new Packet();
        PersistentMessageFactory.getInstance().setMessageIntoPacket(persistentMessage, packet);
        WsrmPropertyBag wsrmPropertyBag = WsrmPropertyBag.propertySetRetriever.getFromPacket(packet);
        wsrmPropertyBag.restorePersistentPropsIntoJaxWsRi(addressingVersion, sOAPVersion);
        return packet;
    }

    @Nullable
    public static WseeWsrmRuntimeMBeanImpl getWsrmRuntimeFromPacket(Packet packet) {
        if (KernelStatus.isServer()) {
            WseeBasePortRuntimeMBean wseeBasePortRuntimeMBean = WseePortRuntimeMBeanImpl.getFromPacket(packet);
            WseeWsrmRuntimeMBeanImpl wseeWsrmRuntimeMBeanImpl = WsrmTubeUtils.getWsrmRuntimeFromPortRuntime(wseeBasePortRuntimeMBean);
            return wseeWsrmRuntimeMBeanImpl;
        }
        return null;
    }

    private static WseeWsrmRuntimeMBeanImpl getWsrmRuntimeFromPortRuntime(WseeBasePortRuntimeMBean wseeBasePortRuntimeMBean) {
        WseeWsrmRuntimeMBeanImpl wseeWsrmRuntimeMBeanImpl = null;
        try {
            if (wseeBasePortRuntimeMBean != null) {
                wseeWsrmRuntimeMBeanImpl = (WseeWsrmRuntimeMBeanImpl)wseeBasePortRuntimeMBean.getWsrm();
            }
        }
        catch (Exception exception) {
            if (LOGGER.isLoggable(Level.SEVERE)) {
                LOGGER.log(Level.SEVERE, exception.toString(), exception);
            }
            WseeRmLogger.logUnexpectedException((String)exception.toString(), (Throwable)exception);
        }
        return wseeWsrmRuntimeMBeanImpl;
    }

    private boolean isOfferTurnedOff(WsrmClientRuntimeFeature wsrmClientRuntimeFeature) {
        boolean bl = false;
        if (wsrmClientRuntimeFeature != null) {
            bl = wsrmClientRuntimeFeature.isTurnOffOffer();
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("isOfferTurnedOff is returning: " + bl);
        }
        return bl;
    }

    private class EstablishSequenceForRequestAction {
        private Packet _packet;
        private SequenceIdFactory _seqIdFactory;
        private String _endpointAddress;
        private WsrmPropertyBag _rmProps;
        private WsrmConfig.Source _rmSourceConfig;
        private WsrmConstants.RMVersion _rmVersion;
        private String _msgId;
        private boolean _response;
        private ClientInstance _clientInstance;
        private SourceSequence _seq;

        public EstablishSequenceForRequestAction(Packet packet, SequenceIdFactory sequenceIdFactory, String string, WsrmPropertyBag wsrmPropertyBag, WsrmConfig.Source source, WsrmConstants.RMVersion rMVersion, String string2, boolean bl, ClientInstance clientInstance) {
            this._packet = packet;
            this._seqIdFactory = sequenceIdFactory;
            this._endpointAddress = string;
            this._rmProps = wsrmPropertyBag;
            this._rmSourceConfig = source;
            this._rmVersion = rMVersion;
            this._msgId = string2;
            this._response = bl;
            this._clientInstance = clientInstance;
        }

        public SourceSequence getSeq() {
            return this._seq;
        }

        public EstablishSequenceForRequestAction invoke() throws WsrmException, SOAPException {
            AssociateSequenceWithRequestAction associateSequenceWithRequestAction = new AssociateSequenceWithRequestAction(this._packet, this._seqIdFactory, this._endpointAddress, this._rmProps, this._rmSourceConfig, this._rmVersion, this._clientInstance).invoke();
            this._seq = associateSequenceWithRequestAction.getSeq();
            boolean bl = associateSequenceWithRequestAction.isPreExisting();
            String string = associateSequenceWithRequestAction.getSeqId();
            if (this._seq == null) {
                if (bl) {
                    if (WsrmTubeUtils.this._clientSide) {
                        throw new WsrmException(WseeRmLogger.logUsingStaleSequenceLoggable((String)string).getMessage());
                    }
                    return this;
                }
                SetupNewSequenceAction setupNewSequenceAction = new SetupNewSequenceAction(this._packet, this._rmProps, this._rmSourceConfig, this._msgId, this._response, this._clientInstance).invoke();
                this._seq = setupNewSequenceAction.getSeq();
                if (this._seq == null) {
                    return this;
                }
            }
            return this;
        }
    }

    private class AssociateSequenceWithRequestAction {
        private Packet _packet;
        private SequenceIdFactory _seqIdFactory;
        private String _endpointAddress;
        private WsrmPropertyBag _rmProps;
        private WsrmConfig.Source _rmSourceConfig;
        private WsrmConstants.RMVersion _rmVersion;
        private ClientInstance _clientInstance;
        private String _seqId;
        private boolean _preExisting;
        private SourceSequence _seq;

        public AssociateSequenceWithRequestAction(Packet packet, SequenceIdFactory sequenceIdFactory, String string, WsrmPropertyBag wsrmPropertyBag, WsrmConfig.Source source, WsrmConstants.RMVersion rMVersion, ClientInstance clientInstance) {
            this._packet = packet;
            this._seqIdFactory = sequenceIdFactory;
            this._endpointAddress = string;
            this._rmProps = wsrmPropertyBag;
            this._rmSourceConfig = source;
            this._rmVersion = rMVersion;
            this._clientInstance = clientInstance;
        }

        public String getSeqId() {
            return this._seqId;
        }

        public boolean isPreExisting() {
            return this._preExisting;
        }

        public SourceSequence getSeq() {
            return this._seq;
        }

        public AssociateSequenceWithRequestAction invoke() {
            SequenceIdFactory.Info info = this._seqIdFactory.getSequenceId(this._endpointAddress, this._rmSourceConfig.getRmAssertion().isOptional(), this._packet);
            this._seqId = info.id;
            this._preExisting = info.preExisting;
            this._seq = null;
            if (this._seqId == null && this._clientInstance != null) {
                this._seqId = this.loadClientCurrentSequenceId(this._clientInstance);
                if (this._seqId != null) {
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.fine("Found EXISTING sequence ID on conversational client: " + this._seqId);
                    }
                    this._seq = (SourceSequence)SourceSequenceManager.getInstance().getSequence(this._rmVersion, this._seqId);
                    if (this._seq != null) {
                        info.id = this._seqId;
                        info.preExisting = true;
                        WsrmTubeUtils.this.registerCurrentSequenceWithMonitoring(this._packet, this._seq);
                    } else {
                        if (LOGGER.isLoggable(Level.FINE)) {
                            LOGGER.fine("Found sequence ID for NON-EXISTANT sequence on conversational client: " + this._seqId + ". This stored sequence will be ignored.");
                        }
                        WsrmTubeUtils.this.removeClientCurrentSequenceId(this._clientInstance.getId());
                    }
                }
            }
            if (this._seqId != null && this._seq == null) {
                this._seq = (SourceSequence)SourceSequenceManager.getInstance().getSequence(this._rmVersion, this._seqId);
            }
            this._rmProps.setOutboundSequenceId(this._seqId);
            return this;
        }

        private String loadClientCurrentSequenceId(ClientInstance clientInstance) {
            WsrmClientRuntimeFeature wsrmClientRuntimeFeature = WsrmClientRuntimeFeature.getFromBinding(WsrmTubeUtils.this._binding);
            if (wsrmClientRuntimeFeature != null) {
                return wsrmClientRuntimeFeature.loadClientCurrentSequenceId(clientInstance);
            }
            return null;
        }
    }

    private class SetupNewSequenceAction {
        private Packet _packet;
        private WsrmPropertyBag _rmProps;
        private WsrmConfig.Source _rmSourceConfig;
        private String _msgId;
        private boolean _isResponse;
        private ClientInstance _clientInstance;
        private SourceSequence _seq;

        public SetupNewSequenceAction(Packet packet, WsrmPropertyBag wsrmPropertyBag, WsrmConfig.Source source, String string, boolean bl, ClientInstance clientInstance) {
            this._packet = packet;
            this._rmProps = wsrmPropertyBag;
            this._rmSourceConfig = source;
            this._msgId = string;
            this._isResponse = bl;
            this._clientInstance = clientInstance;
        }

        public SourceSequence getSeq() {
            return this._seq;
        }

        public SetupNewSequenceAction invoke() throws WsrmException, SOAPException {
            if (this._rmSourceConfig.getRmAssertion().isOptional()) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    String string = this._rmProps.getOutboundWsdlOperationName() != null ? " (" + this._rmProps.getOutboundWsdlOperationName() + ")" : "";
                    LOGGER.fine("Invoking an RM-optional operation" + string + ", and no reliable sequence has been established for this stub. Treating this as a non-reliable invoke");
                }
                return this;
            }
            WsrmConfig.Destination destination = WsrmConfig.getDestination(WsrmTubeUtils.this._clientContext, this._packet, !WsrmTubeUtils.this._clientSide);
            this._seq = this.createSourceSequence(this._packet, this._isResponse, this._clientInstance, this._rmSourceConfig, destination);
            String string = this._seq.getId();
            WsrmInvocationPropertyBag wsrmInvocationPropertyBag = WsrmTubeUtils.this.getRmInvokeProps(this._packet);
            wsrmInvocationPropertyBag.setSequenceId(string);
            this._rmProps.setOutboundSequenceId(string);
            if (this._clientInstance != null) {
                this._seq.setCreatingClientInstanceId(this._clientInstance.getId());
            }
            if (this._clientInstance != null) {
                this.storeClientCurrentSequenceId(this._clientInstance, string);
            }
            WsrmTubeUtils.this.registerCurrentSequenceWithMonitoring(this._packet, this._seq);
            if (LOGGER.isLoggable(Level.FINE)) {
                if (string != null) {
                    LOGGER.fine("Processing (stage 1) outbound sequence message with msg id " + this._msgId + ", seq " + string);
                } else {
                    LOGGER.fine("Didn't calculate any outbound sequence ID for the message with msg id " + this._msgId + ". This may indicate we're sending non-reliably");
                }
            }
            if (this._seq.isNonBuffered()) {
                WsrmTubeUtils.sendCreateSequenceMsg(this._seq, WsrmTubeUtils.this._dispatchFactory, null);
            }
            return this;
        }

        private void storeClientCurrentSequenceId(ClientInstance clientInstance, String string) {
            WsrmClientRuntimeFeature wsrmClientRuntimeFeature = WsrmClientRuntimeFeature.getFromBinding(WsrmTubeUtils.this._binding);
            if (wsrmClientRuntimeFeature != null) {
                wsrmClientRuntimeFeature.storeClientCurrentSequenceId(clientInstance, string);
            }
        }

        private SourceSequence createSourceSequence(Packet packet, boolean bl, ClientInstance clientInstance, WsrmConfig.Source source, WsrmConfig.Destination destination) throws WsrmException {
            DispatchFactoryResolver.BaseKey baseKey;
            Object object;
            URI uRI;
            String string;
            WsrmPropertyBag wsrmPropertyBag;
            SourceSequence sourceSequence;
            WsrmInvocationPropertyBag wsrmInvocationPropertyBag = WsrmTubeUtils.this.getRmInvokeProps(packet);
            WsrmSecurityContext wsrmSecurityContext = WsrmTubeUtils.this.getWsrmSecurityContext(source.getRmAssertion(), packet);
            boolean bl2 = source.isNonBufferedSource();
            if (!bl2) {
                // empty if block
            }
            PersistentRequestContext persistentRequestContext = clientInstance != null ? new PersistentRequestContext(((BindingProvider)clientInstance.getInstance()).getRequestContext()) : new PersistentRequestContext(packet.invocationProperties);
            DestinationSequence destinationSequence = null;
            if (!bl) {
                sourceSequence = new SourceSequence(null, source.getPersistenceConfig().getLogicalStoreName(), source.getRmVersion(), WsrmTubeUtils.this._binding.getAddressingVersion(), WsrmTubeUtils.this._binding.getSOAPVersion(), wsrmSecurityContext, bl2, persistentRequestContext);
            } else {
                wsrmPropertyBag = WsrmPropertyBag.propertySetRetriever.getFromPacket(packet);
                string = wsrmPropertyBag.getInboundSequenceId();
                if (string != null) {
                    destinationSequence = (DestinationSequence)DestinationSequenceManager.getInstance().getSequence(source.getRmVersion(), string);
                }
                sourceSequence = new SourceOfferSequence(null, source.getPersistenceConfig().getLogicalStoreName(), source.getRmVersion(), WsrmTubeUtils.this._binding.getAddressingVersion(), WsrmTubeUtils.this._binding.getSOAPVersion(), wsrmSecurityContext, destinationSequence, bl2);
                ((SourceOfferSequence)sourceSequence).setHandshaked(true);
            }
            wsrmInvocationPropertyBag.setWsrmVersion(source.getRmVersion());
            wsrmPropertyBag = (WsaPropertyBag)packet.getSatellite(WsaPropertyBag.class);
            if (!bl) {
                uRI = packet.endpointAddress.getURI();
                string = new WSEndpointReference(uRI, WsrmTubeUtils.this._binding.getAddressingVersion());
            } else {
                string = wsrmPropertyBag.getReplyToFromRequest();
            }
            sourceSequence.setEndpointEpr((WSEndpointReference)string);
            uRI = !bl ? packet.getMessage().getHeaders().getReplyTo(WsrmTubeUtils.this._binding.getAddressingVersion(), WsrmTubeUtils.this._binding.getSOAPVersion()) : (destinationSequence != null ? destinationSequence.getHostEpr() : packet.getMessage().getHeaders().getReplyTo(WsrmTubeUtils.this._binding.getAddressingVersion(), WsrmTubeUtils.this._binding.getSOAPVersion()));
            sourceSequence.setAcksToEpr((WSEndpointReference)uRI);
            if (!bl) {
                object = (ClientIdentityFeature)WsrmTubeUtils.this._binding.getFeature(ClientIdentityFeature.class);
                baseKey = new SenderDispatchFactory.ClientSideKey(object.getClientId());
            } else {
                baseKey = new SenderDispatchFactory.ServerSideKey(packet.endpoint.getEndpointId());
            }
            sourceSequence.setSenderDispatchKey((SenderDispatchFactory.Key)((Object)baseKey));
            sourceSequence.setDeliveryAssurance(source.getDeliveryAssurance());
            try {
                sourceSequence.setBaseRetransmissionInterval(DatatypeFactory.newInstance().newDuration(source.getBaseRetransmissionInterval()));
                sourceSequence.setExponentialBackoffEnabled(source.getRetransmissionExponentialBackoff());
                sourceSequence.setExpires(DatatypeFactory.newInstance().newDuration(source.getSequenceExpiration()));
                sourceSequence.setIdleTimeout(DatatypeFactory.newInstance().newDuration(source.getInactivityTimeout()));
            }
            catch (Exception exception) {
                throw new WsrmException(exception.toString(), exception);
            }
            object = null;
            boolean bl3 = false;
            boolean bl4 = false;
            try {
                if (!bl && !WsrmTubeUtils.this.isOfferTurnedOff(WsrmClientRuntimeFeature.getFromBinding(WsrmTubeUtils.this._binding))) {
                    object = WsrmTubeUtils.this.createOfferSequenceIfNeeded(sourceSequence, destination, clientInstance);
                }
                if (object != null) {
                    DestinationSequenceManager.getInstance().addSequence((DestinationSequence)object);
                    bl3 = true;
                    sourceSequence.setOffer((DestinationOfferSequence)object);
                }
                SourceSequenceManager.getInstance().addSequence(sourceSequence);
                bl4 = true;
                if (object != null) {
                    ((DestinationOfferSequence)object).setMainSequence(sourceSequence);
                    DestinationSequenceManager.getInstance().updateSequence((DestinationSequence)object);
                }
                String string2 = sourceSequence.getPhysicalStoreName();
                PhysicalStoreNameHeader physicalStoreNameHeader = new PhysicalStoreNameHeader(string2);
                HeaderList headerList = new HeaderList();
                headerList.add((Header)physicalStoreNameHeader);
                sourceSequence.setAcksToEpr(new WSEndpointReference(sourceSequence.getAcksToEpr(), headerList));
                SourceSequenceManager.getInstance().updateSequence(sourceSequence);
                if (object != null) {
                    ((DestinationOfferSequence)object).takeEprsFromMainSequence();
                    ((DestinationOfferSequence)object).takeFirstRequestContextFromMainSequence();
                    DestinationSequenceManager.getInstance().updateSequence((DestinationSequence)object);
                }
            }
            catch (WsrmException wsrmException) {
                block23: {
                    block22: {
                        if (bl3) {
                            try {
                                DestinationSequenceManager.getInstance().removeSequence(object);
                            }
                            catch (Exception exception) {
                                if (!LOGGER.isLoggable(Level.SEVERE)) break block22;
                                LOGGER.log(Level.SEVERE, exception.toString(), exception);
                            }
                        }
                    }
                    if (bl4) {
                        try {
                            SourceSequenceManager.getInstance().removeSequence(sourceSequence);
                        }
                        catch (Exception exception) {
                            if (!LOGGER.isLoggable(Level.SEVERE)) break block23;
                            LOGGER.log(Level.SEVERE, exception.toString(), exception);
                        }
                    }
                }
                throw wsrmException;
            }
            return sourceSequence;
        }
    }

    public static class OutboundMessageResult {
        public boolean messageBuffered;
        public boolean messageAborted;
        public SourceMessageInfo messageInfo;
    }

    public class InboundMessageResult {
        public boolean handled;
        public Message message;
        public WsrmFaultMsg rmFault;
        public Sequence<?> seq;
        public boolean needSuspendOnCurrentFiber;
        public Fiber.Listener currentFiberSuspendingCallback;
    }
}

