/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.reliability2.tube;

import com.sun.istack.NotNull;
import com.sun.istack.Nullable;
import com.sun.xml.ws.api.WSBinding;
import com.sun.xml.ws.api.addressing.OneWayFeature;
import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.api.model.wsdl.WSDLPort;
import com.sun.xml.ws.api.pipe.ClientTubeAssemblerContext;
import com.sun.xml.ws.api.pipe.NextAction;
import com.sun.xml.ws.api.pipe.ServerTubeAssemblerContext;
import com.sun.xml.ws.api.pipe.Tube;
import com.sun.xml.ws.api.pipe.TubeCloner;
import com.sun.xml.ws.api.pipe.helper.AbstractFilterTubeImpl;
import com.sun.xml.ws.api.pipe.helper.AbstractTubeImpl;
import com.sun.xml.ws.api.server.WSEndpoint;
import com.sun.xml.ws.binding.BindingImpl;
import com.sun.xml.ws.binding.WebServiceFeatureList;
import com.sun.xml.ws.client.SyncStartForAsyncInvokeFeature;
import com.sun.xml.ws.transport.http.server.EndpointImpl;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPException;
import javax.xml.ws.Binding;
import javax.xml.ws.Endpoint;
import javax.xml.ws.WebServiceFeature;
import javax.xml.ws.soap.AddressingFeature;
import weblogic.jws.jaxws.client.ClientIdentityFeature;
import weblogic.jws.jaxws.client.async.AsyncClientTransportFeature;
import weblogic.wsee.WseeRmLogger;
import weblogic.wsee.buffer2.api.common.BufferingFeature;
import weblogic.wsee.buffer2.exception.BufferingException;
import weblogic.wsee.jaxws.framework.jaxrpc.EnvironmentFactory;
import weblogic.wsee.jaxws.framework.jaxrpc.JAXRPCEnvironmentFeature;
import weblogic.wsee.jaxws.spi.ClientInstanceIdentity;
import weblogic.wsee.jaxws.spi.ClientInstanceIdentityFeature;
import weblogic.wsee.jaxws.spi.WLSEndpoint;
import weblogic.wsee.jaxws.tubeline.AbstractTubeFactory;
import weblogic.wsee.jaxws.tubeline.AbstractTubelineSpliceFactory;
import weblogic.wsee.jaxws.tubeline.TubelineAssemblerItem;
import weblogic.wsee.jaxws.tubeline.TubelineDeploymentListener;
import weblogic.wsee.jaxws.tubeline.TubelineSpliceFactory;
import weblogic.wsee.reliability.faults.SequenceFaultException;
import weblogic.wsee.reliability.faults.SequenceFaultMsg;
import weblogic.wsee.reliability2.api.WsrmClientInitFeature;
import weblogic.wsee.reliability2.policy.WsrmPolicyHelper;
import weblogic.wsee.reliability2.property.WsrmConfig;
import weblogic.wsee.reliability2.saf.BufferUtil;
import weblogic.wsee.reliability2.tube.AbstractWsrmTube;
import weblogic.wsee.reliability2.tube.DispatchFactoryResolver;
import weblogic.wsee.reliability2.tube.WsrmClientRuntimeFeature;
import weblogic.wsee.reliability2.tube.WsrmClientTube;
import weblogic.wsee.reliability2.tube.WsrmServerTube;
import weblogic.wsee.reliability2.tube.WsrmTubeUtils;
import weblogic.wsee.ws.WsPort;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WsrmTubelineDeploymentListener
implements TubelineDeploymentListener {
    private static final Logger LOGGER = Logger.getLogger(WsrmTubelineDeploymentListener.class.getName());

    @Override
    public void createClient(ClientTubeAssemblerContext clientTubeAssemblerContext, Set<TubelineAssemblerItem> set) {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Creating WS-RM client tubeline items for " + clientTubeAssemblerContext.getService().getServiceName());
        }
        WsPort wsPort = WsrmTubelineDeploymentListener.getWsPort(clientTubeAssemblerContext);
        WsrmPolicyHelper wsrmPolicyHelper = new WsrmPolicyHelper(wsPort);
        try {
            if (!wsrmPolicyHelper.hasRMPolicy()) {
                return;
            }
        }
        catch (Exception exception) {
            WseeRmLogger.logPolicyProcessingFailedOnClient((Exception)exception);
            return;
        }
        AbstractWsrmTube.addKnownHeaders((Binding)clientTubeAssemblerContext.getBinding());
        AbstractTubelineSpliceFactory abstractTubelineSpliceFactory = new AbstractTubelineSpliceFactory(){

            public Tube createClient(Tube tube, ClientTubeAssemblerContext clientTubeAssemblerContext) {
                WSBinding wSBinding = clientTubeAssemblerContext.getBinding();
                WsrmTubelineDeploymentListener.this.enableClientAddressing(wSBinding);
                WsrmTubelineDeploymentListener.this.enableRmClientFeature(clientTubeAssemblerContext);
                return new WsrmClientTube(tube, clientTubeAssemblerContext);
            }

            public void createSplice(TubelineSpliceFactory.ClientDispatchFactory clientDispatchFactory, ClientTubeAssemblerContext clientTubeAssemblerContext) {
                super.createSplice(clientDispatchFactory, clientTubeAssemblerContext);
                ClientIdentityFeature clientIdentityFeature = (ClientIdentityFeature)clientTubeAssemblerContext.getBinding().getFeature(ClientIdentityFeature.class);
                String string = clientIdentityFeature.getClientId();
                AsyncClientTransportFeature asyncClientTransportFeature = (AsyncClientTransportFeature)clientTubeAssemblerContext.getBinding().getFeature(AsyncClientTransportFeature.class);
                if (asyncClientTransportFeature != null) {
                    MyAsyncEndpointListener myAsyncEndpointListener = new MyAsyncEndpointListener(clientTubeAssemblerContext, asyncClientTransportFeature, clientDispatchFactory);
                    asyncClientTransportFeature.addAsyncEndpointListener((AsyncClientTransportFeature.AsyncEndpointListener)myAsyncEndpointListener);
                    if (asyncClientTransportFeature.isEndpointPublished()) {
                        myAsyncEndpointListener.endpointPublished(asyncClientTransportFeature);
                    }
                } else {
                    DispatchFactoryResolver.registerClientDispatchFactory(string, clientDispatchFactory);
                }
            }
        };
        TubelineAssemblerItem tubelineAssemblerItem = new TubelineAssemblerItem("WsrmClient", abstractTubelineSpliceFactory);
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add("WS_SECURITY_1.1");
        hashSet.add("PRE_WS_SECURITY_POLICY_1.2");
        tubelineAssemblerItem.setGoAfter(hashSet);
        HashSet<String> hashSet2 = new HashSet<String>();
        hashSet2.add("ADDRESSING_HANDLER");
        hashSet2.add("client");
        tubelineAssemblerItem.setGoBefore(hashSet2);
        set.add(tubelineAssemblerItem);
        TubelineAssemblerItem tubelineAssemblerItem2 = new TubelineAssemblerItem("WsrmClientProtocol", new AbstractTubeFactory(){

            public Tube createClient(Tube tube, ClientTubeAssemblerContext clientTubeAssemblerContext) {
                return new WsrmClientProtocolTube(tube);
            }
        });
        tubelineAssemblerItem2.setGoBefore(Collections.singleton("WS_SECURITY_1.1"));
        set.add(tubelineAssemblerItem2);
    }

    private void enableClientAddressing(WSBinding wSBinding) {
        WebServiceFeatureList webServiceFeatureList;
        if (!wSBinding.getFeatures().isEnabled(AddressingFeature.class)) {
            webServiceFeatureList = (WebServiceFeatureList)wSBinding.getFeatures();
            webServiceFeatureList.add((WebServiceFeature)new AddressingFeature(true));
        }
        if (!wSBinding.getFeatures().isEnabled(OneWayFeature.class) && !wSBinding.getFeatures().isEnabled(AsyncClientTransportFeature.class)) {
            webServiceFeatureList = (WebServiceFeatureList)wSBinding.getFeatures();
            webServiceFeatureList.add((WebServiceFeature)new OneWayFeature(true));
        }
    }

    private void enableServerAddressing(WSBinding wSBinding) {
        if (!wSBinding.getFeatures().isEnabled(AddressingFeature.class)) {
            WebServiceFeatureList webServiceFeatureList = (WebServiceFeatureList)wSBinding.getFeatures();
            webServiceFeatureList.add((WebServiceFeature)new AddressingFeature(true));
        }
    }

    private void enableRmClientFeature(ClientTubeAssemblerContext clientTubeAssemblerContext) {
        Object object;
        WsrmClientRuntimeFeature wsrmClientRuntimeFeature;
        Object object2;
        WSBinding wSBinding = clientTubeAssemblerContext.getBinding();
        ClientInstanceIdentityFeature clientInstanceIdentityFeature = (ClientInstanceIdentityFeature)wSBinding.getFeature(ClientInstanceIdentityFeature.class);
        if (clientInstanceIdentityFeature == null) {
            throw new IllegalStateException("No ClientInstanceIdentityFeature on RM enabled tubeline");
        }
        ClientInstanceIdentity clientInstanceIdentity = clientInstanceIdentityFeature.getClientInstanceId();
        if (!wSBinding.getFeatures().isEnabled(WsrmClientInitFeature.class)) {
            if (!wSBinding.getFeatures().isEnabled(WsrmClientRuntimeFeature.class)) {
                object2 = (WebServiceFeatureList)wSBinding.getFeatures();
                wsrmClientRuntimeFeature = new WsrmClientRuntimeFeature(clientInstanceIdentity.getClientId(), clientTubeAssemblerContext);
                object2.add((WebServiceFeature)wsrmClientRuntimeFeature);
            } else {
                wsrmClientRuntimeFeature = (WsrmClientRuntimeFeature)wSBinding.getFeatures().get(WsrmClientRuntimeFeature.class);
            }
        } else if (!wSBinding.getFeatures().isEnabled(WsrmClientRuntimeFeature.class)) {
            object2 = (WsrmClientInitFeature)wSBinding.getFeatures().get(WsrmClientInitFeature.class);
            object = (WebServiceFeatureList)wSBinding.getFeatures();
            wsrmClientRuntimeFeature = new WsrmClientRuntimeFeature(clientInstanceIdentity.getClientId(), clientTubeAssemblerContext, (WsrmClientInitFeature)((Object)object2));
            object.add((WebServiceFeature)wsrmClientRuntimeFeature);
        } else {
            wsrmClientRuntimeFeature = (WsrmClientRuntimeFeature)wSBinding.getFeatures().get(WsrmClientRuntimeFeature.class);
        }
        object2 = (ClientIdentityFeature)wSBinding.getFeatures().get(ClientIdentityFeature.class);
        if (object2 == null || object2.getRawClientId() == null) {
            throw new IllegalStateException(WseeRmLogger.logClientIdentityNotProvidedLoggable().getMessage());
        }
        if (!wSBinding.isFeatureEnabled(WsrmClientRuntimeFeature.class)) {
            ((WebServiceFeatureList)wSBinding.getFeatures()).add((WebServiceFeature)wsrmClientRuntimeFeature);
        }
        if (((WsrmConfig.Common)(object = WsrmConfig.getSource(clientTubeAssemblerContext, null, false))).getDeliveryAssurance().isInOrder()) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Enabling SyncStartForAsyncInvokeFeature for WS-RM client tube to support in-order delivery");
            }
            if (!wSBinding.isFeatureEnabled(SyncStartForAsyncInvokeFeature.class)) {
                SyncStartForAsyncInvokeFeature syncStartForAsyncInvokeFeature = new SyncStartForAsyncInvokeFeature();
                ((WebServiceFeatureList)wSBinding.getFeatures()).add((WebServiceFeature)syncStartForAsyncInvokeFeature);
            }
        }
    }

    @Nullable
    public static WsPort getWsPort(ClientTubeAssemblerContext clientTubeAssemblerContext) {
        EnvironmentFactory environmentFactory = JAXRPCEnvironmentFeature.getFactory(clientTubeAssemblerContext);
        if (environmentFactory == null) {
            return null;
        }
        WSDLPort wSDLPort = environmentFactory.getPort();
        if (wSDLPort == null) {
            return null;
        }
        QName qName = wSDLPort.getName();
        EnvironmentFactory.SingletonService singletonService = environmentFactory.getService();
        if (singletonService == null) {
            return null;
        }
        return singletonService.getPort(qName.getLocalPart());
    }

    @Nullable
    public static WsPort getWsPort(ServerTubeAssemblerContext serverTubeAssemblerContext) {
        EnvironmentFactory environmentFactory = JAXRPCEnvironmentFeature.getFactory(serverTubeAssemblerContext.getEndpoint());
        WSDLPort wSDLPort = environmentFactory.getPort();
        if (wSDLPort == null) {
            return null;
        }
        QName qName = wSDLPort.getName();
        EnvironmentFactory.SingletonService singletonService = environmentFactory.getService();
        if (singletonService == null) {
            return null;
        }
        return singletonService.getPort(qName.getLocalPart());
    }

    @Override
    public void createServer(ServerTubeAssemblerContext serverTubeAssemblerContext, Set<TubelineAssemblerItem> set) {
        WsPort wsPort;
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Creating WS-RM server tubeline items for " + serverTubeAssemblerContext.getEndpoint().getServiceName());
        }
        if ((wsPort = WsrmTubelineDeploymentListener.getWsPort(serverTubeAssemblerContext)) == null) {
            return;
        }
        WsrmPolicyHelper wsrmPolicyHelper = new WsrmPolicyHelper(wsPort);
        try {
            if (!wsrmPolicyHelper.hasRMPolicy()) {
                return;
            }
        }
        catch (Exception exception) {
            WseeRmLogger.logPolicyProcessingFailedOnServer((Exception)exception);
            return;
        }
        AbstractWsrmTube.addKnownHeaders((Binding)serverTubeAssemblerContext.getEndpoint().getBinding());
        AbstractTubelineSpliceFactory abstractTubelineSpliceFactory = new AbstractTubelineSpliceFactory(){
            private TubelineSpliceFactory.DispatchFactory _dispatchFactoryFromSplice;

            public Tube createServer(Tube tube, ServerTubeAssemblerContext serverTubeAssemblerContext) {
                WSBinding wSBinding = serverTubeAssemblerContext.getEndpoint().getBinding();
                WsrmTubelineDeploymentListener.this.enableServerAddressing(wSBinding);
                WsPort wsPort = WsrmTubelineDeploymentListener.getWsPort(serverTubeAssemblerContext);
                if (wsPort == null) {
                    return tube;
                }
                return new WsrmServerTube(tube, serverTubeAssemblerContext, this._dispatchFactoryFromSplice);
            }

            public void createSplice(TubelineSpliceFactory.DispatchFactory dispatchFactory, ServerTubeAssemblerContext serverTubeAssemblerContext) {
                super.createSplice(dispatchFactory, serverTubeAssemblerContext);
                this._dispatchFactoryFromSplice = dispatchFactory;
                WSEndpoint wSEndpoint = serverTubeAssemblerContext.getEndpoint();
                DispatchFactoryResolver.registerServerDispatchFactory(wSEndpoint.getEndpointId(), dispatchFactory);
                WsrmConfig.Destination destination = WsrmConfig.getDestination(serverTubeAssemblerContext, null, false);
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("Server side splice: " + destination.toString());
                }
                if (destination.isNonBufferedDestination()) {
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.fine("setupBufferingFeature:  RM Destination is non-buffered.  Skip BufferingSetup.");
                    }
                    return;
                }
                List<String> list = BufferUtil.getTargetURIs(wSEndpoint);
                for (String string : list) {
                    if (!BufferingFeature.isBufferingFeatureRegistered(string)) continue;
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.fine("Already have a buffering feature registered for one of the target URIs for endpoint " + wSEndpoint.getEndpointId() + ". Ignoring it. Target URI: " + string);
                    }
                    return;
                }
                try {
                    BufferUtil.setupBufferingFeature(serverTubeAssemblerContext, wSEndpoint, dispatchFactory, false, destination);
                }
                catch (BufferingException bufferingException) {
                    throw new RuntimeException(bufferingException);
                }
            }
        };
        TubelineAssemblerItem tubelineAssemblerItem = new TubelineAssemblerItem("WsrmServer", abstractTubelineSpliceFactory);
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add("ADDRESSING_HANDLER");
        hashSet.add("WS_SECURITY_1.1");
        tubelineAssemblerItem.setGoBefore(hashSet);
        HashSet<String> hashSet2 = new HashSet<String>();
        tubelineAssemblerItem.setGoAfter(hashSet2);
        set.add(tubelineAssemblerItem);
        TubelineAssemblerItem tubelineAssemblerItem2 = new TubelineAssemblerItem("WsrmServerProtocol", new AbstractTubeFactory(){

            public Tube createServer(Tube tube, ServerTubeAssemblerContext serverTubeAssemblerContext) {
                return new WsrmServerProtocolTube(tube);
            }
        });
        tubelineAssemblerItem2.setGoBefore(Collections.singleton("WS_SECURITY_1.1"));
        set.add(tubelineAssemblerItem2);
    }

    private static class MyAsyncEndpointListener
    implements AsyncClientTransportFeature.AsyncEndpointListener {
        ClientTubeAssemblerContext _context;
        AsyncClientTransportFeature _feature;
        TubelineSpliceFactory.ClientDispatchFactory _dispatchFactory;

        public MyAsyncEndpointListener(ClientTubeAssemblerContext clientTubeAssemblerContext, AsyncClientTransportFeature asyncClientTransportFeature, TubelineSpliceFactory.ClientDispatchFactory clientDispatchFactory) {
            this._context = clientTubeAssemblerContext;
            this._feature = asyncClientTransportFeature;
            this._dispatchFactory = clientDispatchFactory;
        }

        public void endpointSet(AsyncClientTransportFeature asyncClientTransportFeature) {
            Object object;
            BindingImpl bindingImpl = null;
            if (asyncClientTransportFeature.getEndpoint() instanceof EndpointImpl) {
                object = (EndpointImpl)asyncClientTransportFeature.getEndpoint();
                bindingImpl = (BindingImpl)object.getBinding();
            } else if (asyncClientTransportFeature.getEndpoint() instanceof WLSEndpoint) {
                object = (WLSEndpoint)asyncClientTransportFeature.getEndpoint();
                bindingImpl = (BindingImpl)((WLSEndpoint)((Object)object)).getBinding();
            }
            if (bindingImpl != null) {
                object = bindingImpl.getKnownHeaders();
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("Published endpoint has " + object.size() + " known headers");
                }
            }
            AbstractWsrmTube.addKnownHeaders((Binding)bindingImpl);
        }

        public void endpointPublished(AsyncClientTransportFeature asyncClientTransportFeature) {
            ClientIdentityFeature clientIdentityFeature = (ClientIdentityFeature)this._context.getBinding().getFeature(ClientIdentityFeature.class);
            DispatchFactoryResolver.registerClientDispatchFactory(clientIdentityFeature.getClientId(), this._dispatchFactory);
            WsrmConfig.Destination destination = WsrmConfig.getDestination(this._context, null, false);
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Client side splice: " + destination.toString());
            }
            if (destination.isNonBufferedDestination()) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("setupBufferingFeature:  RM Destination is non-buffered.  Skip BufferingSetup.");
                }
                return;
            }
            Endpoint endpoint = asyncClientTransportFeature.getEndpoint();
            if (endpoint instanceof WLSEndpoint) {
                WLSEndpoint wLSEndpoint = (WLSEndpoint)endpoint;
                WSEndpoint wSEndpoint = wLSEndpoint.getWSEndpoint();
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("Setting up buffering for async response endpoint: " + wSEndpoint.getEndpointId());
                }
                List<String> list = BufferUtil.getTargetURIs(wSEndpoint);
                for (String string : list) {
                    if (!BufferingFeature.isBufferingFeatureRegistered(string)) continue;
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.fine("Already have a buffering feature registered for one of the target URIs for endpoint " + wSEndpoint.getEndpointId() + ". Ignoring it. Target URI: " + string);
                    }
                    return;
                }
                try {
                    BufferUtil.setupBufferingFeature(this._context, wLSEndpoint, (TubelineSpliceFactory.DispatchFactory)this._dispatchFactory, true, destination);
                }
                catch (BufferingException bufferingException) {
                    throw new RuntimeException(bufferingException);
                }
            }
        }

        public void endpointDisposed(AsyncClientTransportFeature asyncClientTransportFeature) {
            asyncClientTransportFeature.removeAsyncEndpointListener((AsyncClientTransportFeature.AsyncEndpointListener)this);
        }
    }

    private static class WsrmServerProtocolTube
    extends AbstractFilterTubeImpl {
        public WsrmServerProtocolTube(Tube tube) {
            super(tube);
        }

        private WsrmServerProtocolTube(WsrmServerProtocolTube wsrmServerProtocolTube, TubeCloner tubeCloner) {
            super((AbstractFilterTubeImpl)wsrmServerProtocolTube, tubeCloner);
        }

        public AbstractTubeImpl copy(TubeCloner tubeCloner) {
            return new WsrmServerProtocolTube(this, tubeCloner);
        }

        @NotNull
        public NextAction processResponse(@NotNull Packet packet) {
            try {
                WsrmTubeUtils.initializeOutboundMessage(packet);
            }
            catch (Throwable throwable) {
                if (throwable instanceof RuntimeException) {
                    throw (RuntimeException)throwable;
                }
                throw new RuntimeException(throwable.toString(), throwable);
            }
            return this.doReturnWith(packet);
        }
    }

    private static class WsrmClientProtocolTube
    extends AbstractFilterTubeImpl {
        public WsrmClientProtocolTube(Tube tube) {
            super(tube);
        }

        private WsrmClientProtocolTube(WsrmClientProtocolTube wsrmClientProtocolTube, TubeCloner tubeCloner) {
            super((AbstractFilterTubeImpl)wsrmClientProtocolTube, tubeCloner);
        }

        public AbstractTubeImpl copy(TubeCloner tubeCloner) {
            return new WsrmClientProtocolTube(this, tubeCloner);
        }

        @NotNull
        public NextAction processResponse(@NotNull Packet packet) {
            try {
                WsrmTubeUtils.initializeInboundMessage(packet);
            }
            catch (Throwable throwable) {
                if (throwable instanceof RuntimeException) {
                    throw (RuntimeException)throwable;
                }
                throw new RuntimeException(throwable.toString(), throwable);
            }
            try {
                SequenceFaultMsg sequenceFaultMsg = WsrmTubeUtils.getRmFaultFromMessage(packet);
                if (sequenceFaultMsg != null) {
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.fine("Found RM Fault in response msg: " + sequenceFaultMsg.toString());
                    }
                    SequenceFaultException sequenceFaultException = new SequenceFaultException(sequenceFaultMsg);
                    NextAction nextAction = new NextAction();
                    nextAction.throwException((Throwable)sequenceFaultException);
                    return nextAction;
                }
            }
            catch (SOAPException sOAPException) {
                NextAction nextAction = new NextAction();
                nextAction.throwExceptionAbortResponse((Throwable)sOAPException);
                return nextAction;
            }
            return this.doReturnWith(packet);
        }
    }
}

