/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.reliability2.tube.processors;

import com.sun.xml.ws.api.message.Header;
import com.sun.xml.ws.api.message.Packet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import weblogic.wsee.reliability.WsrmConstants;
import weblogic.wsee.reliability.headers.AckRequestedHeader;
import weblogic.wsee.reliability2.exception.WsrmException;
import weblogic.wsee.reliability2.headers.WsrmHeaderFactory;
import weblogic.wsee.reliability2.sequence.SequenceIdFactory;
import weblogic.wsee.reliability2.tube.WsrmTubeUtils;
import weblogic.wsee.reliability2.tube.processors.MessageProcessor;

public class AckRequestedProcessor
extends MessageProcessor {
    private static final Logger LOGGER = Logger.getLogger(AckRequestedProcessor.class.getName());

    public AckRequestedProcessor(WsrmTubeUtils wsrmTubeUtils) {
        super(wsrmTubeUtils);
    }

    public boolean processOutbound(Packet packet, WsrmConstants.RMVersion rMVersion, SequenceIdFactory sequenceIdFactory, String string) throws WsrmException {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("** Handling outbound AckRequested, currently no-op");
        }
        return true;
    }

    public void handleInbound(Packet packet, WsrmConstants.RMVersion rMVersion, WsrmTubeUtils.InboundMessageResult inboundMessageResult) throws WsrmException {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("** Handling inbound AckRequested, parsing message");
        }
        QName qName = WsrmConstants.Element.ACK_REQUESTED.getQName(rMVersion);
        Header header = packet.getMessage().getHeaders().get(qName, true);
        if (header != null) {
            String string = null;
            if (this._binding.getAddressingVersion() != null) {
                string = packet.getMessage().getHeaders().getMessageID(this._binding.getAddressingVersion(), this._binding.getSOAPVersion());
            }
            AckRequestedHeader ackRequestedHeader = WsrmHeaderFactory.getInstance().createWsrmHeaderFromHeader(AckRequestedHeader.class, header);
            this._tubeUtil.handleAckRequestedHeader(ackRequestedHeader, string);
        }
        inboundMessageResult.message = null;
    }
}

