/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.reliability2.tube.processors;

import com.sun.xml.ws.api.message.Header;
import com.sun.xml.ws.api.message.Message;
import com.sun.xml.ws.api.message.Packet;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.soap.SOAPException;
import weblogic.wsee.reliability.WsrmConstants;
import weblogic.wsee.reliability.faults.IllegalRMVersionFaultException;
import weblogic.wsee.reliability.handshake.CloseSequenceMsg;
import weblogic.wsee.reliability.handshake.CloseSequenceResponseMsg;
import weblogic.wsee.reliability.handshake.WsrmHandshakeMsg;
import weblogic.wsee.reliability.headers.AcknowledgementHeader;
import weblogic.wsee.reliability.headers.WsrmHeader;
import weblogic.wsee.reliability2.api.SequenceState;
import weblogic.wsee.reliability2.compat.Rpc2WsUtil;
import weblogic.wsee.reliability2.exception.WsrmException;
import weblogic.wsee.reliability2.sequence.DestinationSequence;
import weblogic.wsee.reliability2.sequence.DestinationSequenceManager;
import weblogic.wsee.reliability2.sequence.SequenceIdFactory;
import weblogic.wsee.reliability2.sequence.SourceSequence;
import weblogic.wsee.reliability2.sequence.SourceSequenceManager;
import weblogic.wsee.reliability2.tube.WsrmTubeUtils;
import weblogic.wsee.reliability2.tube.processors.MessageProcessor;

public class CloseSequenceProcessor
extends MessageProcessor {
    private static final Logger LOGGER = Logger.getLogger(CloseSequenceProcessor.class.getName());

    public CloseSequenceProcessor(WsrmTubeUtils wsrmTubeUtils) {
        super(wsrmTubeUtils);
    }

    public boolean processOutbound(Packet packet, WsrmConstants.RMVersion rMVersion, SequenceIdFactory sequenceIdFactory, String string) throws WsrmException {
        CloseSequenceMsg closeSequenceMsg = new CloseSequenceMsg(rMVersion);
        try {
            closeSequenceMsg.readMsg(packet.getMessage().readAsSOAPMessage());
        }
        catch (SOAPException sOAPException) {
            throw new WsrmException(sOAPException.toString(), sOAPException);
        }
        SourceSequence sourceSequence = (SourceSequence)WsrmTubeUtils.doInitialSetupForAction(WsrmConstants.Action.CLOSE_SEQUENCE.getActionURI(rMVersion), true, closeSequenceMsg.getSequenceId(), rMVersion, null);
        if (rMVersion == WsrmConstants.RMVersion.RM_10) {
            throw new IllegalRMVersionFaultException(sourceSequence.getId(), rMVersion, sourceSequence.getRmVersion());
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("** Processed outbound CloseSequence on source sequence " + sourceSequence.getId());
        }
        this._tubeUtil.setOutboundSequence(packet, sourceSequence);
        if (sourceSequence.setState(SequenceState.CLOSING)) {
            SourceSequenceManager.getInstance().updateSequence(sourceSequence);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleInbound(Packet packet, WsrmConstants.RMVersion rMVersion, WsrmTubeUtils.InboundMessageResult inboundMessageResult) {
        Message message = null;
        Message message2 = packet.getMessage();
        try {
            DestinationSequence destinationSequence;
            CloseSequenceMsg closeSequenceMsg = new CloseSequenceMsg(rMVersion);
            closeSequenceMsg.readMsg(message2.readAsSOAPMessage());
            inboundMessageResult.seq = destinationSequence = (DestinationSequence)WsrmTubeUtils.doInitialSetupForAction(WsrmConstants.Element.CLOSE_SEQUENCE.getElementName(), false, closeSequenceMsg.getSequenceId(), rMVersion, packet);
            SequenceState sequenceState = destinationSequence.getState();
            Object object = destinationSequence;
            synchronized (object) {
                if (!sequenceState.isValidTransition(SequenceState.CLOSING)) {
                    inboundMessageResult.message = message;
                    return;
                }
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("** Closing destination sequence " + destinationSequence.getId());
                }
                destinationSequence.setState(SequenceState.CLOSING);
                destinationSequence.setState(SequenceState.CLOSED);
                destinationSequence.addPiggybackAckHeader();
                DestinationSequenceManager.getInstance().updateSequence(destinationSequence);
            }
            object = this.createCloseSequenceResponseMessage(destinationSequence);
            message = Rpc2WsUtil.createMessageFromHandshakeMessage((WsrmHandshakeMsg)object, this._binding.getAddressingVersion(), this._binding.getSOAPVersion());
            this._tubeUtil.setInboundSequence(packet, destinationSequence);
            this._tubeUtil.setOutboundSequence(packet, destinationSequence);
            List<WsrmHeader> list = destinationSequence.getAndClearPiggybackHeaders();
            for (WsrmHeader wsrmHeader : list) {
                if ("SequenceAcknowledgement".equals(wsrmHeader.getLocalPart())) {
                    ((AcknowledgementHeader)wsrmHeader).setFinal(true);
                }
                message.getHeaders().add((Header)wsrmHeader);
            }
        }
        catch (Exception exception) {
            message = WsrmTubeUtils.handleInboundException(exception, this._addrVersion, this._soapVersion);
        }
        inboundMessageResult.message = message;
    }

    private CloseSequenceResponseMsg createCloseSequenceResponseMessage(DestinationSequence destinationSequence) throws WsrmException {
        CloseSequenceResponseMsg closeSequenceResponseMsg = new CloseSequenceResponseMsg(destinationSequence.getRmVersion(), destinationSequence.getId());
        closeSequenceResponseMsg.setMustUnderstand(true);
        return closeSequenceResponseMsg;
    }
}

