/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.reliability2.tube.processors;

import com.sun.xml.ws.api.addressing.WSEndpointReference;
import com.sun.xml.ws.api.message.Header;
import com.sun.xml.ws.api.message.HeaderList;
import com.sun.xml.ws.api.message.Message;
import com.sun.xml.ws.api.message.Packet;
import java.io.Serializable;
import java.security.cert.X509Certificate;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.Duration;
import javax.xml.soap.SOAPException;
import weblogic.kernel.KernelStatus;
import weblogic.wsee.WseeRmLogger;
import weblogic.wsee.addressing.EndpointReference;
import weblogic.wsee.jaxws.cluster.spi.PhysicalStoreNameHeader;
import weblogic.wsee.jaxws.framework.WsUtil;
import weblogic.wsee.mc.api.McFeature;
import weblogic.wsee.monitoring.WseeWsrmRuntimeMBeanImpl;
import weblogic.wsee.reliability.WsrmConstants;
import weblogic.wsee.reliability.WsrmSecurityContext;
import weblogic.wsee.reliability.faults.CreateSequenceRefusedFaultMsg;
import weblogic.wsee.reliability.faults.SequenceFaultException;
import weblogic.wsee.reliability.faults.WsrmFaultException;
import weblogic.wsee.reliability.handshake.CreateSequenceMsg;
import weblogic.wsee.reliability.handshake.CreateSequenceResponseMsg;
import weblogic.wsee.reliability.handshake.SequenceAccept;
import weblogic.wsee.reliability.handshake.SequenceOffer;
import weblogic.wsee.reliability2.api.SequenceState;
import weblogic.wsee.reliability2.api_internal.WsrmLifecycleEvent;
import weblogic.wsee.reliability2.api_internal.WsrmLifecycleEventListenerRegistry;
import weblogic.wsee.reliability2.compat.Rpc2WsUtil;
import weblogic.wsee.reliability2.exception.WsrmException;
import weblogic.wsee.reliability2.property.WsrmConfig;
import weblogic.wsee.reliability2.sequence.DestinationSequence;
import weblogic.wsee.reliability2.sequence.DestinationSequenceManager;
import weblogic.wsee.reliability2.sequence.DuplicateSequenceException;
import weblogic.wsee.reliability2.sequence.SequenceIdFactory;
import weblogic.wsee.reliability2.sequence.SourceOfferSequence;
import weblogic.wsee.reliability2.sequence.SourceSequence;
import weblogic.wsee.reliability2.sequence.SourceSequenceManager;
import weblogic.wsee.reliability2.store.SenderDispatchFactory;
import weblogic.wsee.reliability2.tube.DispatchFactoryResolver;
import weblogic.wsee.reliability2.tube.WsrmTubeUtils;
import weblogic.wsee.reliability2.tube.processors.MessageProcessor;
import weblogic.wsee.security.wssc.sct.SCCredential;

public class CreateSequenceProcessor
extends MessageProcessor {
    private static final Logger LOGGER = Logger.getLogger(CreateSequenceProcessor.class.getName());
    private final Object _inboundLock = "CreateSequenceInboundLock";

    public CreateSequenceProcessor(WsrmTubeUtils wsrmTubeUtils) {
        super(wsrmTubeUtils);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean processOutbound(Packet packet, WsrmConstants.RMVersion rMVersion, SequenceIdFactory sequenceIdFactory, String string) throws WsrmException {
        SourceSequence sourceSequence;
        SequenceIdFactory.Info info = sequenceIdFactory.getSequenceId(string, false, packet);
        String string2 = info.id;
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Processing outbound CreateSequence on source sequence " + info.id);
        }
        WsrmLifecycleEventListenerRegistry.getInstance().notifyEventType(WsrmLifecycleEvent.Type.CLIENT_CREATE_SEQ);
        SourceSequence sourceSequence2 = sourceSequence = SourceSequenceManager.getInstance().getSequence(rMVersion, string2, false);
        synchronized (sourceSequence2) {
            String string3 = packet.getMessage().getHeaders().getMessageID(this._binding.getAddressingVersion(), this._binding.getSOAPVersion());
            if (sourceSequence.getCreateSequenceMsgId() != null && !sourceSequence.getCreateSequenceMsgId().equals(string3)) {
                String string4 = "Trying to send CreateSequence more than once for a single sequence. Msg Id = " + string3 + " originalMsgId = " + sourceSequence.getCreateSequenceMsgId() + " seq " + sourceSequence;
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine(string4);
                }
                throw new WsrmException(string4);
            }
            if (sourceSequence.getCreateSequenceMsgId() == null) {
                sourceSequence.setCreateSequenceMsgId(string3);
                SourceSequenceManager.getInstance().updateSequence(sourceSequence);
            }
        }
        this._tubeUtil.setOutboundSequenceId(packet, string2);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleInbound(Packet packet, WsrmConstants.RMVersion rMVersion, WsrmTubeUtils.InboundMessageResult inboundMessageResult) {
        Message message;
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("** Handling inbound CreateSequence, parsing message");
        }
        WsrmLifecycleEventListenerRegistry.getInstance().notifyEventType(WsrmLifecycleEvent.Type.RECV_CREATE_SEQ);
        try {
            DestinationSequence destinationSequence;
            Message message2 = packet.getMessage();
            String string = this._tubeUtil.getMessageID(message2);
            CreateSequenceMsg createSequenceMsg = new CreateSequenceMsg(rMVersion);
            try {
                createSequenceMsg.readMsg(message2.readAsSOAPMessage());
            }
            catch (SOAPException sOAPException) {
                throw new WsrmException(sOAPException.toString(), sOAPException);
            }
            Object object = this._inboundLock;
            synchronized (object) {
                Serializable serializable;
                boolean bl;
                String string2;
                inboundMessageResult.seq = destinationSequence = (DestinationSequence)DestinationSequenceManager.getInstance().getSequence(rMVersion, string);
                if (destinationSequence != null) {
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.fine("** Got duplicate CreateSequence for destination sequence " + destinationSequence.getId());
                    }
                    inboundMessageResult.message = this.createCreateSequenceResponse(destinationSequence);
                    return;
                }
                SourceOfferSequence sourceOfferSequence = null;
                String string3 = string2 = createSequenceMsg.getOffer() != null ? createSequenceMsg.getOffer().getSequenceId() : null;
                if (string2 != null) {
                    sourceOfferSequence = (SourceOfferSequence)SourceSequenceManager.getInstance().getSequence(rMVersion, string2);
                }
                if (sourceOfferSequence != null) {
                    destinationSequence = sourceOfferSequence.getMainSequence();
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.fine("** Got duplicate CreateSequence for offer sequence " + sourceOfferSequence.getId() + " and destination sequence " + destinationSequence.getId());
                    }
                    if (destinationSequence != null) {
                        inboundMessageResult.message = this.createCreateSequenceResponse(destinationSequence);
                    } else {
                        Message message3;
                        if (LOGGER.isLoggable(Level.FINE)) {
                            LOGGER.fine("** Got duplicate CreateSequence for offer sequence " + sourceOfferSequence.getId() + " but destination sequence is found null");
                        }
                        String string4 = "Duplicate offer sequence id " + sourceOfferSequence.getId() + " detected in the CreateSequence message.";
                        CreateSequenceRefusedFaultMsg createSequenceRefusedFaultMsg = new CreateSequenceRefusedFaultMsg(new Exception(string4), rMVersion);
                        createSequenceRefusedFaultMsg.setReason(string4);
                        WsrmFaultException wsrmFaultException = new WsrmFaultException(createSequenceRefusedFaultMsg);
                        inboundMessageResult.message = message3 = WsrmTubeUtils.handleInboundException(wsrmFaultException, this._addrVersion, this._soapVersion);
                    }
                    return;
                }
                WsrmConfig.Destination destination = WsrmConfig.getDestination(this._tubeUtil.getServerContext(), packet, false);
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("CreateSequenceProcessor: " + destination.toString());
                }
                WsrmConfig.Source source = WsrmConfig.getSource(this._tubeUtil.getServerContext(), null, packet, true);
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("Captured RM source config for later use in async responses");
                    LOGGER.log(Level.FINE, source.toString());
                }
                if (!(bl = destination.isNonBufferedDestination())) {
                    WSEndpointReference wSEndpointReference = packet.getMessage().getHeaders().getReplyTo(this._binding.getAddressingVersion(), this._binding.getSOAPVersion());
                    boolean bl2 = this._binding.isFeatureEnabled(McFeature.class);
                    if (wSEndpointReference == null || wSEndpointReference.isAnonymous()) {
                        if (LOGGER.isLoggable(Level.FINE)) {
                            LOGGER.fine("DestinationSequence turning off buffering (even though it was requested via configuration) for CreateSequence with msg ID '" + string + "' because its ReplyTo was anonymous");
                        }
                        bl = true;
                    } else if (bl2) {
                        if (LOGGER.isLoggable(Level.FINE)) {
                            LOGGER.fine("DestinationSequence turning off buffering (even though it was requested via configuration) for CreateSequence with msg ID '" + string + "' because McFeature is enabled");
                        }
                        bl = true;
                    }
                }
                boolean bl3 = WsrmTubeUtils.isSSLRequest(packet);
                byte[] byArray = WsrmTubeUtils.getSSLSessionId(packet);
                X509Certificate[] x509CertificateArray = WsrmTubeUtils.getSSLCertChain(packet);
                WsrmSecurityContext wsrmSecurityContext = this._tubeUtil.getWsrmSecurityContext(destination.getRmAssertion(), packet);
                if (wsrmSecurityContext.isSecureWithSSL()) {
                    if (KernelStatus.isServer() && !bl3) {
                        throw new SequenceFaultException("SSL Required on CreateSequence");
                    }
                    wsrmSecurityContext.setSSLSessionId(byArray);
                    wsrmSecurityContext.setSSLCertChain(x509CertificateArray);
                } else if (wsrmSecurityContext.isSecure()) {
                    serializable = WsrmTubeUtils.getSCCredential(packet);
                    wsrmSecurityContext.setSCCredential((SCCredential)serializable);
                }
                inboundMessageResult.seq = destinationSequence = new DestinationSequence(null, destination.getPersistenceConfig().getLogicalStoreName(), rMVersion, this._tubeUtil.getBinding().getAddressingVersion(), this._tubeUtil.getBinding().getSOAPVersion(), wsrmSecurityContext, bl);
                serializable = new DispatchFactoryResolver.ServerSideKey(packet.endpoint.getEndpointId());
                destinationSequence.setDispatchKey((DispatchFactoryResolver.Key)serializable);
                try {
                    destinationSequence.setDeliveryAssurance(destination.getDeliveryAssurance());
                }
                catch (Exception exception) {
                    WseeRmLogger.logUnexpectedException((String)exception.toString(), (Throwable)exception);
                }
                try {
                    destinationSequence.setIdleTimeout(DatatypeFactory.newInstance().newDuration(destination.getInactivityTimeout()));
                    destinationSequence.setExpires(DatatypeFactory.newInstance().newDuration(destination.getSequenceExpiration()));
                    destinationSequence.setAckInterval(DatatypeFactory.newInstance().newDuration(destination.getAcknowledgementInterval()));
                }
                catch (Exception exception) {
                    WseeRmLogger.logUnexpectedException((String)exception.toString(), (Throwable)exception);
                }
                SourceOfferSequence sourceOfferSequence2 = this.populateDestinationSequenceFromCreateSequence(packet, createSequenceMsg, rMVersion, destinationSequence, source);
                wsrmSecurityContext.update(packet);
                try {
                    Object object2;
                    if (sourceOfferSequence2 != null) {
                        // empty if block
                    }
                    destinationSequence.setState(SequenceState.CREATING);
                    destinationSequence.setState(SequenceState.CREATED);
                    DestinationSequenceManager.getInstance().addSequence(destinationSequence);
                    String string5 = destinationSequence.getId();
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.fine("** Created NEW destination sequence " + string5 + (sourceOfferSequence2 != null ? " associated with offer seq " + sourceOfferSequence2.getId() : ""));
                    }
                    String string6 = destinationSequence.getPhysicalStoreName();
                    PhysicalStoreNameHeader physicalStoreNameHeader = new PhysicalStoreNameHeader(string6);
                    HeaderList headerList = new HeaderList();
                    headerList.add((Header)physicalStoreNameHeader);
                    WSEndpointReference wSEndpointReference = new WSEndpointReference(destinationSequence.getHostEpr(), headerList);
                    destinationSequence.setHostEpr(wSEndpointReference);
                    DestinationSequenceManager.getInstance().updateSequence(destinationSequence);
                    if (sourceOfferSequence2 != null) {
                        sourceOfferSequence2.setMainSequenceId(destinationSequence.getId());
                        sourceOfferSequence2.takeEprsFromSequence(destinationSequence);
                        if (sourceOfferSequence2.getSecurityContext().isSecureWithSSL()) {
                            sourceOfferSequence2.getSecurityContext().setSSLSessionId(byArray);
                            sourceOfferSequence2.getSecurityContext().setSSLCertChain(x509CertificateArray);
                        }
                        sourceOfferSequence2.setState(SequenceState.CREATING);
                        sourceOfferSequence2.setState(SequenceState.CREATED);
                        SourceSequenceManager.getInstance().addSequence(sourceOfferSequence2);
                    }
                    if (wsrmSecurityContext.isSecureWithSSL()) {
                        wsrmSecurityContext.setSSLSessionId(byArray);
                        wsrmSecurityContext.setSSLCertChain(x509CertificateArray);
                        if (LOGGER.isLoggable(Level.FINE)) {
                            LOGGER.fine("Stored SSL security: " + WsrmTubeUtils.dumpSecuritySSL(byArray, x509CertificateArray) + ") for new sequence: " + destinationSequence);
                        }
                    } else if (wsrmSecurityContext.isSecure()) {
                        object2 = WsrmTubeUtils.getSCCredential(packet);
                        wsrmSecurityContext.setSCCredential((SCCredential)object2);
                        if (LOGGER.isLoggable(Level.FINE)) {
                            LOGGER.fine("Stored SCCredential (" + WsrmTubeUtils.dumpSecuritySCT((SCCredential)object2) + ") for new sequence: " + destinationSequence);
                        }
                    }
                    this._tubeUtil.setInboundSequence(packet, destinationSequence);
                    this._tubeUtil.setOutboundSequence(packet, destinationSequence);
                    try {
                        object2 = WsrmTubeUtils.getWsrmRuntimeFromPacket(packet);
                        if (object2 != null) {
                            ((WseeWsrmRuntimeMBeanImpl)object2).addSequenceId(destinationSequence.getId());
                            if (destinationSequence.getOffer() != null) {
                                ((WseeWsrmRuntimeMBeanImpl)object2).addSequenceId(destinationSequence.getOffer().getId());
                            }
                        }
                    }
                    catch (Exception exception) {
                        if (LOGGER.isLoggable(Level.WARNING)) {
                            LOGGER.log(Level.WARNING, exception.toString(), exception);
                        }
                        WseeRmLogger.logUnexpectedException((String)exception.toString(), (Throwable)exception);
                    }
                }
                catch (DuplicateSequenceException duplicateSequenceException) {
                    WseeRmLogger.logUnexpectedException((String)duplicateSequenceException.toString(), (Throwable)duplicateSequenceException);
                }
            }
            message = this.createCreateSequenceResponse(destinationSequence);
        }
        catch (WsrmException wsrmException) {
            message = WsrmTubeUtils.handleInboundException(wsrmException, this._addrVersion, this._soapVersion);
        }
        inboundMessageResult.message = message;
    }

    private Message createCreateSequenceResponse(DestinationSequence destinationSequence) throws WsrmException {
        SequenceAccept sequenceAccept;
        CreateSequenceResponseMsg createSequenceResponseMsg = new CreateSequenceResponseMsg(destinationSequence.getRmVersion());
        createSequenceResponseMsg.setSequenceId(destinationSequence.getId());
        createSequenceResponseMsg.setExpires(destinationSequence.getExpires());
        createSequenceResponseMsg.setIncompleteSequenceBehavior(destinationSequence.getIncompleteSequenceBehavior());
        if (destinationSequence.getOffer() != null) {
            sequenceAccept = new SequenceAccept(destinationSequence.getRmVersion());
            EndpointReference endpointReference = WsUtil.createWseeEPRFromWsEPR(destinationSequence.getOffer().getAcksToEpr());
            sequenceAccept.setAcksTo(endpointReference);
            createSequenceResponseMsg.setAccept(sequenceAccept);
        }
        try {
            sequenceAccept = Rpc2WsUtil.createMessageFromHandshakeMessage(createSequenceResponseMsg, this._binding.getAddressingVersion(), this._binding.getSOAPVersion());
        }
        catch (SOAPException sOAPException) {
            throw new WsrmException(sOAPException.toString(), sOAPException);
        }
        return sequenceAccept;
    }

    private SourceOfferSequence populateDestinationSequenceFromCreateSequence(Packet packet, CreateSequenceMsg createSequenceMsg, WsrmConstants.RMVersion rMVersion, DestinationSequence destinationSequence, WsrmConfig.Source source) throws WsrmException {
        Message message = packet.getMessage();
        String string = message.getHeaders().getMessageID(this._addrVersion, this._soapVersion);
        destinationSequence.setCreateSequenceMsgId(string);
        EndpointReference endpointReference = createSequenceMsg.getAcksTo();
        WSEndpointReference wSEndpointReference = WsUtil.createWsEPRFromWseeEPR(endpointReference);
        destinationSequence.setAcksToEpr(wSEndpointReference);
        WSEndpointReference wSEndpointReference2 = WsrmTubeUtils.getEndpointReferenceFromIncomingPacket(packet, this._tubeUtil.getEndpoint());
        destinationSequence.setHostEpr(wSEndpointReference2);
        Duration duration = createSequenceMsg.getExpires();
        if (duration != null) {
            destinationSequence.setExpires(duration);
        }
        if (destinationSequence.getRmVersion().isLaterThanOrEqualTo(WsrmConstants.RMVersion.RM_11)) {
            destinationSequence.setIncompleteSequenceBehavior(WsrmConstants.IncompleteSequenceBehavior.NoDiscard);
        }
        SourceOfferSequence sourceOfferSequence = null;
        if (createSequenceMsg.getOffer() != null) {
            WSEndpointReference wSEndpointReference3;
            Object object;
            SequenceOffer sequenceOffer = createSequenceMsg.getOffer();
            WsrmSecurityContext wsrmSecurityContext = this._tubeUtil.getWsrmSecurityContext(source.getRmAssertion(), packet);
            boolean bl = source.isNonBufferedSource();
            if (sequenceOffer.getEndpoint() != null) {
                object = sequenceOffer.getEndpoint();
                wSEndpointReference3 = WsUtil.createWsEPRFromWseeEPR((EndpointReference)object);
            } else {
                wSEndpointReference3 = message.getHeaders().getReplyTo(this._addrVersion, this._soapVersion);
            }
            if (wSEndpointReference3 == null || wSEndpointReference3.isAnonymous()) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("Bypassing buffering on offer sequence " + sequenceOffer.getSequenceId() + " because it has a null endpoint/to address");
                }
                bl = true;
            }
            sourceOfferSequence = new SourceOfferSequence(sequenceOffer.getSequenceId(), source.getPersistenceConfig().getLogicalStoreName(), rMVersion, destinationSequence.getAddressingVersion(), destinationSequence.getSoapVersion(), wsrmSecurityContext, destinationSequence, bl);
            sourceOfferSequence.setEndpointEpr(wSEndpointReference3);
            sourceOfferSequence.takeEprsFromSequence(destinationSequence);
            sourceOfferSequence.setDeliveryAssurance(source.getDeliveryAssurance());
            try {
                sourceOfferSequence.setIdleTimeout(DatatypeFactory.newInstance().newDuration(source.getInactivityTimeout()));
                sourceOfferSequence.setExpires(DatatypeFactory.newInstance().newDuration(source.getSequenceExpiration()));
                sourceOfferSequence.setBaseRetransmissionInterval(DatatypeFactory.newInstance().newDuration(source.getBaseRetransmissionInterval()));
                sourceOfferSequence.setExponentialBackoffEnabled(source.getRetransmissionExponentialBackoff());
            }
            catch (Exception exception) {
                WseeRmLogger.logUnexpectedException((String)exception.toString(), (Throwable)exception);
            }
            if (sequenceOffer.getExpires() != null) {
                try {
                    object = DatatypeFactory.newInstance().newDuration(sequenceOffer.getExpires());
                    sourceOfferSequence.setExpires((Duration)object);
                }
                catch (Exception exception) {
                    throw new WsrmException(exception.toString(), exception);
                }
            }
            if (sequenceOffer.getIncompleteSequenceBehavior() != null) {
                sourceOfferSequence.setIncompleteSequenceBehavior(sequenceOffer.getIncompleteSequenceBehavior());
            }
            object = new SenderDispatchFactory.ServerSideKey(packet.endpoint.getEndpointId());
            sourceOfferSequence.setSenderDispatchKey((SenderDispatchFactory.Key)object);
            destinationSequence.setOffer(sourceOfferSequence);
        }
        return sourceOfferSequence;
    }
}

