/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.reliability2.tube.processors;

import com.sun.xml.ws.api.addressing.WSEndpointReference;
import com.sun.xml.ws.api.message.Header;
import com.sun.xml.ws.api.message.Message;
import com.sun.xml.ws.api.message.Packet;
import java.security.cert.X509Certificate;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.soap.SOAPException;
import weblogic.kernel.Kernel;
import weblogic.wsee.WseeRmLogger;
import weblogic.wsee.jaxws.framework.WsUtil;
import weblogic.wsee.reliability.WsrmConstants;
import weblogic.wsee.reliability.faults.SequenceFaultException;
import weblogic.wsee.reliability.handshake.CreateSequenceResponseMsg;
import weblogic.wsee.reliability.handshake.SequenceAccept;
import weblogic.wsee.reliability2.api.SequenceState;
import weblogic.wsee.reliability2.api_internal.WsrmLifecycleEvent;
import weblogic.wsee.reliability2.api_internal.WsrmLifecycleEventListenerRegistry;
import weblogic.wsee.reliability2.exception.WsrmException;
import weblogic.wsee.reliability2.sequence.DestinationOfferSequence;
import weblogic.wsee.reliability2.sequence.DestinationSequenceManager;
import weblogic.wsee.reliability2.sequence.SequenceIdFactory;
import weblogic.wsee.reliability2.sequence.SourceOfferSequence;
import weblogic.wsee.reliability2.sequence.SourceSequence;
import weblogic.wsee.reliability2.sequence.SourceSequenceManager;
import weblogic.wsee.reliability2.tube.WsrmTubeUtils;
import weblogic.wsee.reliability2.tube.processors.MessageProcessor;

public class CreateSequenceResponseProcessor
extends MessageProcessor {
    private static final Logger LOGGER = Logger.getLogger(CreateSequenceResponseProcessor.class.getName());

    public CreateSequenceResponseProcessor(WsrmTubeUtils wsrmTubeUtils) {
        super(wsrmTubeUtils);
    }

    public boolean processOutbound(Packet packet, WsrmConstants.RMVersion rMVersion, SequenceIdFactory sequenceIdFactory, String string) throws WsrmException {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("** Processing outbound CreateSequenceResponse");
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleInbound(Packet packet, WsrmConstants.RMVersion rMVersion, WsrmTubeUtils.InboundMessageResult inboundMessageResult) {
        Message message = null;
        Message message2 = packet.getMessage();
        WsrmLifecycleEventListenerRegistry.getInstance().notifyEventType(WsrmLifecycleEvent.Type.CLIENT_CREATE_SEQ_RES);
        try {
            String string = message2.getHeaders().getRelatesTo(this._binding.getAddressingVersion(), this._binding.getSOAPVersion());
            SourceSequence sourceSequence = SourceSequenceManager.getInstance().getSequence(WsrmConstants.RMVersion.latest(), string, false);
            String string2 = sourceSequence.getId();
            inboundMessageResult.seq = sourceSequence = (SourceSequence)WsrmTubeUtils.doInitialSetupForAction(WsrmConstants.Element.CREATE_SEQUENCE_RESPONSE.getElementName(), true, string2, rMVersion, null);
            byte[] byArray = WsrmTubeUtils.getSSLSessionId(packet);
            X509Certificate[] x509CertificateArray = WsrmTubeUtils.getSSLCertChain(packet);
            if (sourceSequence.getSecurityContext().isSecureWithSSL()) {
                if (Kernel.isServer() && byArray == null) {
                    throw new SequenceFaultException("SSL Required on CreateSequenceResponse for seq: " + sourceSequence.getId());
                }
            } else if (sourceSequence.getSecurityContext().isSecure()) {
                WsrmTubeUtils.validateSecurityOnInboundPacket(sourceSequence, packet);
            }
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("** Completing handshake with CreateSequenceResponse on source sequence " + sourceSequence.getId());
            }
            SourceSequence sourceSequence2 = sourceSequence;
            synchronized (sourceSequence2) {
                boolean bl;
                boolean bl2 = bl = sourceSequence instanceof SourceOfferSequence && ((SourceOfferSequence)sourceSequence).isHandshaked() || !(sourceSequence instanceof SourceOfferSequence);
                if (bl && sourceSequence.getDestinationId() != null) {
                    inboundMessageResult.message = message;
                    return;
                }
                this.populateSourceSequenceFromCreateSequenceResponse(message2, rMVersion, sourceSequence);
                if (sourceSequence.getSecurityContext().isSecureWithSSL()) {
                    sourceSequence.getSecurityContext().setSSLSessionId(byArray);
                    sourceSequence.getSecurityContext().setSSLCertChain(x509CertificateArray);
                }
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("** Populated/created source sequence. Source ID: " + sourceSequence.getId() + " Dest ID: " + sourceSequence.getDestinationId());
                }
                if (sourceSequence.getOffer() != null) {
                    if (sourceSequence.getOffer().getSecurityContext().isSecureWithSSL()) {
                        sourceSequence.getOffer().getSecurityContext().setSSLSessionId(byArray);
                        sourceSequence.getOffer().getSecurityContext().setSSLCertChain(x509CertificateArray);
                        if (LOGGER.isLoggable(Level.FINE)) {
                            LOGGER.fine("Updated SSLSessionID for offer seq '" + sourceSequence.getOffer().getId() + "' to: " + WsrmTubeUtils.dumpSSLSessionId(byArray));
                        }
                    }
                    sourceSequence.getOffer().setState(SequenceState.CREATING);
                    sourceSequence.getOffer().setState(SequenceState.CREATED);
                    DestinationSequenceManager.getInstance().updateSequence(sourceSequence.getOffer());
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.fine("** Populated/created source sequence with offer. Source ID: " + sourceSequence.getId() + " Dest ID: " + sourceSequence.getDestinationId() + " Offer ID: " + sourceSequence.getOffer().getId());
                    }
                }
                SourceSequenceManager.getInstance().updateSequence(sourceSequence);
                sourceSequence.setState(SequenceState.CREATED);
                SourceSequenceManager.getInstance().updateSequence(sourceSequence);
                WsrmLifecycleEventListenerRegistry.getInstance().notifyEventType(WsrmLifecycleEvent.Type.CLIENT_SEQUENCE_CREATED);
            }
        }
        catch (WsrmException wsrmException) {
            message = WsrmTubeUtils.handleInboundException(wsrmException, this._addrVersion, this._soapVersion);
        }
        inboundMessageResult.message = message;
    }

    private void populateSourceSequenceFromCreateSequenceResponse(Message message, WsrmConstants.RMVersion rMVersion, SourceSequence sourceSequence) throws WsrmException {
        CreateSequenceResponseMsg createSequenceResponseMsg;
        block10: {
            Header header = message.getHeaders().get(sourceSequence.getAddressingVersion().fromTag, false);
            if (header != null) {
                try {
                    createSequenceResponseMsg = header.readAsEPR(sourceSequence.getAddressingVersion());
                    sourceSequence.setEndpointEpr((WSEndpointReference)createSequenceResponseMsg);
                }
                catch (Exception exception) {
                    if (!LOGGER.isLoggable(Level.FINE)) break block10;
                    LOGGER.log(Level.FINE, "Unable to read From header on CreateSequenceResponse: " + exception.toString(), exception);
                }
            }
        }
        createSequenceResponseMsg = new CreateSequenceResponseMsg(rMVersion);
        try {
            createSequenceResponseMsg.readMsg(message.readAsSOAPMessage());
        }
        catch (SOAPException sOAPException) {
            throw new WsrmException(sOAPException.toString(), sOAPException);
        }
        sourceSequence.setDestinationId(createSequenceResponseMsg.getSequenceId());
        if (createSequenceResponseMsg.getExpires() != null) {
            sourceSequence.setExpires(createSequenceResponseMsg.getExpires());
        }
        if (createSequenceResponseMsg.getIncompleteSequenceBehavior() != null) {
            createSequenceResponseMsg.setIncompleteSequenceBehavior(createSequenceResponseMsg.getIncompleteSequenceBehavior());
        }
        if (createSequenceResponseMsg.getAccept() != null) {
            SequenceAccept sequenceAccept = createSequenceResponseMsg.getAccept();
            DestinationOfferSequence destinationOfferSequence = sourceSequence.getOffer();
            if (destinationOfferSequence == null) {
                throw new WsrmException(WseeRmLogger.logGotAcceptWithNoOfferLoggable((String)sourceSequence.getDestinationId()).getMessage());
            }
            WSEndpointReference wSEndpointReference = WsUtil.createWsEPRFromWseeEPR(sequenceAccept.getAcksTo());
            destinationOfferSequence.setAcksToEpr(wSEndpointReference);
        } else {
            sourceSequence.setOffer(null);
        }
    }
}

