/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.reliability2.tube.processors;

import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;
import weblogic.wsee.reliability.WsrmConstants;
import weblogic.wsee.reliability2.tube.WsrmTubeUtils;
import weblogic.wsee.reliability2.tube.processors.AckProcessor;
import weblogic.wsee.reliability2.tube.processors.AckRequestedProcessor;
import weblogic.wsee.reliability2.tube.processors.CloseSequenceProcessor;
import weblogic.wsee.reliability2.tube.processors.CloseSequenceResponseProcessor;
import weblogic.wsee.reliability2.tube.processors.CreateSequenceProcessor;
import weblogic.wsee.reliability2.tube.processors.CreateSequenceResponseProcessor;
import weblogic.wsee.reliability2.tube.processors.LastMessageProcessor;
import weblogic.wsee.reliability2.tube.processors.MessageProcessor;
import weblogic.wsee.reliability2.tube.processors.TerminateSequenceProcessor;
import weblogic.wsee.reliability2.tube.processors.TerminateSequenceResponseProcessor;

public class MessageProcessorFactory {
    private static final Map<WsrmConstants.Action, Class<? extends MessageProcessor>> _processors = new HashMap<WsrmConstants.Action, Class<? extends MessageProcessor>>();

    public static MessageProcessor createProcessorForAction(WsrmConstants.Action action, WsrmTubeUtils wsrmTubeUtils) {
        try {
            Class<? extends MessageProcessor> clazz = _processors.get((Object)action);
            Constructor<? extends MessageProcessor> constructor = clazz.getConstructor(WsrmTubeUtils.class);
            return constructor.newInstance(wsrmTubeUtils);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.toString(), exception);
        }
    }

    static {
        _processors.put(WsrmConstants.Action.ACK, AckProcessor.class);
        _processors.put(WsrmConstants.Action.ACK_REQUESTED, AckRequestedProcessor.class);
        _processors.put(WsrmConstants.Action.CREATE_SEQUENCE, CreateSequenceProcessor.class);
        _processors.put(WsrmConstants.Action.CREATE_SEQUENCE_RESPONSE, CreateSequenceResponseProcessor.class);
        _processors.put(WsrmConstants.Action.CLOSE_SEQUENCE, CloseSequenceProcessor.class);
        _processors.put(WsrmConstants.Action.CLOSE_SEQUENCE_RESPONSE, CloseSequenceResponseProcessor.class);
        _processors.put(WsrmConstants.Action.TERMINATE_SEQUENCE, TerminateSequenceProcessor.class);
        _processors.put(WsrmConstants.Action.TERMINATE_SEQUENCE_RESPONSE, TerminateSequenceResponseProcessor.class);
        _processors.put(WsrmConstants.Action.LAST_MESSAGE, LastMessageProcessor.class);
    }
}

