/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.reliability2.tube.processors;

import com.sun.xml.ws.api.addressing.WSEndpointReference;
import com.sun.xml.ws.api.message.Header;
import com.sun.xml.ws.api.message.Message;
import com.sun.xml.ws.api.message.Packet;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.soap.SOAPException;
import weblogic.wsee.jaxws.framework.WsUtil;
import weblogic.wsee.reliability.WsrmConstants;
import weblogic.wsee.reliability.handshake.TerminateSequenceMsg;
import weblogic.wsee.reliability.handshake.TerminateSequenceResponseMsg;
import weblogic.wsee.reliability.headers.SequenceHeader;
import weblogic.wsee.reliability2.api.SequenceState;
import weblogic.wsee.reliability2.compat.Rpc2WsUtil;
import weblogic.wsee.reliability2.exception.WsrmException;
import weblogic.wsee.reliability2.sequence.DestinationOfferSequence;
import weblogic.wsee.reliability2.sequence.DestinationSequence;
import weblogic.wsee.reliability2.sequence.DestinationSequenceManager;
import weblogic.wsee.reliability2.sequence.SequenceIdFactory;
import weblogic.wsee.reliability2.sequence.SourceOfferSequence;
import weblogic.wsee.reliability2.sequence.SourceSequence;
import weblogic.wsee.reliability2.sequence.SourceSequenceManager;
import weblogic.wsee.reliability2.sequence.UnknownSequenceException;
import weblogic.wsee.reliability2.store.SenderDispatchFactory;
import weblogic.wsee.reliability2.tube.DispatchFactory;
import weblogic.wsee.reliability2.tube.Sender;
import weblogic.wsee.reliability2.tube.WsrmTubeUtils;
import weblogic.wsee.reliability2.tube.processors.MessageProcessor;

public class TerminateSequenceProcessor
extends MessageProcessor {
    private static final Logger LOGGER = Logger.getLogger(TerminateSequenceProcessor.class.getName());

    public TerminateSequenceProcessor(WsrmTubeUtils wsrmTubeUtils) {
        super(wsrmTubeUtils);
    }

    public boolean processOutbound(Packet packet, WsrmConstants.RMVersion rMVersion, SequenceIdFactory sequenceIdFactory, String string) throws WsrmException {
        boolean bl;
        SourceSequence sourceSequence;
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("** Processing outbound TerminateSequence, parsing message");
        }
        TerminateSequenceMsg terminateSequenceMsg = new TerminateSequenceMsg(rMVersion);
        try {
            terminateSequenceMsg.readMsg(packet.getMessage().readAsSOAPMessage());
        }
        catch (SOAPException sOAPException) {
            throw new WsrmException(sOAPException.toString(), sOAPException);
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("** Processing outbound TerminateSequence for source seq: " + terminateSequenceMsg.getSequenceId());
        }
        try {
            sourceSequence = (SourceSequence)WsrmTubeUtils.doInitialSetupForAction(WsrmConstants.Action.TERMINATE_SEQUENCE.getActionURI(rMVersion), true, terminateSequenceMsg.getSequenceId(), rMVersion, null);
        }
        catch (UnknownSequenceException unknownSequenceException) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Aborting outbound TerminateSequence message for seq " + terminateSequenceMsg.getSequenceId() + " due to: " + unknownSequenceException.toString());
            }
            return false;
        }
        if (sourceSequence.getOffer() != null) {
            DestinationOfferSequence destinationOfferSequence = sourceSequence.getOffer();
            destinationOfferSequence.forceDeliverPendingAcks();
        }
        if (rMVersion.isLaterThanOrEqualTo(WsrmConstants.RMVersion.RM_11)) {
            bl = sourceSequence.setState(SequenceState.TERMINATING);
            if (bl) {
                SourceSequenceManager.getInstance().updateSequence(sourceSequence);
            }
        } else {
            sourceSequence.setState(SequenceState.TERMINATING);
            bl = sourceSequence.setState(SequenceState.TERMINATED);
            if (bl) {
                SourceSequenceManager.getInstance().removeSequence(sourceSequence);
            }
        }
        this._tubeUtil.setOutboundSequence(packet, sourceSequence);
        this._tubeUtil.removeClientCurrentSequenceId(sourceSequence.getCreatingClientInstanceId());
        return bl;
    }

    public static void checkForAnonymousOfferSequenceTermination(SourceSequence sourceSequence) throws WsrmException {
        if (sourceSequence.getOffer() == null) {
            return;
        }
        DestinationOfferSequence destinationOfferSequence = sourceSequence.getOffer();
        if (sourceSequence.getAcksToEpr() == null || sourceSequence.getAcksToEpr().isAnonymous()) {
            TerminateSequenceProcessor.forceAnonymousOfferTerminateSequence(destinationOfferSequence, destinationOfferSequence.getRmVersion(), destinationOfferSequence.getMaxMessageNum());
            sourceSequence.setOffer(null);
        }
    }

    public void handleInbound(Packet packet, WsrmConstants.RMVersion rMVersion, WsrmTubeUtils.InboundMessageResult inboundMessageResult) throws WsrmException {
        Message message;
        block11: {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("** Handling inbound TerminateSequence, parsing message");
            }
            message = null;
            Message message2 = packet.getMessage();
            try {
                DestinationSequence destinationSequence;
                TerminateSequenceMsg terminateSequenceMsg = new TerminateSequenceMsg(rMVersion);
                terminateSequenceMsg.readMsg(message2.readAsSOAPMessage());
                try {
                    destinationSequence = (DestinationSequence)WsrmTubeUtils.doInitialSetupForAction(WsrmConstants.Element.TERMINATE_SEQUENCE.getElementName(), false, terminateSequenceMsg.getSequenceId(), rMVersion, null);
                }
                catch (UnknownSequenceException unknownSequenceException) {
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.fine("Ignoring TerminateSequence request for " + terminateSequenceMsg.getSequenceId() + " because it couldn't be found");
                    }
                    inboundMessageResult.handled = true;
                    return;
                }
                inboundMessageResult.seq = destinationSequence;
                TerminateSequenceProcessor.internalTerminateSequence(destinationSequence, rMVersion, terminateSequenceMsg.getLastMsgNumber());
                this._tubeUtil.setInboundSequence(packet, destinationSequence);
                if (destinationSequence.getRmVersion().isLaterThanOrEqualTo(WsrmConstants.RMVersion.RM_11)) {
                    TerminateSequenceResponseMsg terminateSequenceResponseMsg = this.createTerminateSequenceResponseMessage(destinationSequence);
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.fine("Creating outbound response TerminateSequenceResponse for sequence " + destinationSequence + ": " + destinationSequence.getId());
                    }
                    message = Rpc2WsUtil.createMessageFromHandshakeMessage(terminateSequenceResponseMsg, this._binding.getAddressingVersion(), this._binding.getSOAPVersion());
                    this._tubeUtil.setOutboundSequence(packet, destinationSequence);
                    destinationSequence.addFinalAckToMessage(message);
                    break block11;
                }
                if (destinationSequence.getOffer() == null || destinationSequence.getOffer().getEndpointEpr() != null && !destinationSequence.getOffer().getEndpointEpr().isAnonymous()) break block11;
                SourceOfferSequence sourceOfferSequence = destinationSequence.getOffer();
                TerminateSequenceMsg terminateSequenceMsg2 = WsrmTubeUtils.createTerminateSequenceMessage(sourceOfferSequence);
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("Creating outbound response TerminateSequence for sequence " + sourceOfferSequence + ": " + sourceOfferSequence.getId());
                }
                try {
                    message = Rpc2WsUtil.createMessageFromHandshakeMessage(terminateSequenceMsg2, destinationSequence.getAddressingVersion(), destinationSequence.getSoapVersion());
                }
                catch (Exception exception) {
                    throw new WsrmException(exception.toString(), exception);
                }
                this._tubeUtil.setOutboundSequence(packet, sourceOfferSequence);
            }
            catch (Exception exception) {
                message = WsrmTubeUtils.handleInboundException(exception, this._addrVersion, this._soapVersion);
            }
        }
        inboundMessageResult.message = message;
    }

    private TerminateSequenceResponseMsg createTerminateSequenceResponseMessage(DestinationSequence destinationSequence) throws WsrmException {
        TerminateSequenceResponseMsg terminateSequenceResponseMsg = new TerminateSequenceResponseMsg(destinationSequence.getRmVersion(), destinationSequence.getId());
        terminateSequenceResponseMsg.setMustUnderstand(true);
        return terminateSequenceResponseMsg;
    }

    public static void forceAnonymousOfferTerminateSequence(DestinationOfferSequence destinationOfferSequence, WsrmConstants.RMVersion rMVersion, long l) throws WsrmException {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("** FORCING terminate on anonymous destination offer sequence " + destinationOfferSequence.getId());
        }
        TerminateSequenceProcessor.internalTerminateSequence(destinationOfferSequence, rMVersion, l);
    }

    public static void forceTerminateSequence(DestinationSequence destinationSequence, WsrmConstants.RMVersion rMVersion, long l) throws WsrmException {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("** FORCING terminate on destination sequence " + destinationSequence.getId());
        }
        TerminateSequenceProcessor.internalTerminateSequence(destinationSequence, rMVersion, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void internalTerminateSequence(DestinationSequence destinationSequence, WsrmConstants.RMVersion rMVersion, long l) throws WsrmException {
        boolean bl;
        block16: {
            block15: {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("** Terminating destination sequence " + destinationSequence.getId());
                }
                bl = false;
                try {
                    SequenceState sequenceState = destinationSequence.getState();
                    DestinationSequence destinationSequence2 = destinationSequence;
                    synchronized (destinationSequence2) {
                        SourceSequence sourceSequence;
                        if (!sequenceState.isValidTransition(SequenceState.TERMINATING)) {
                            // MONITOREXIT @DISABLED, blocks:[0, 3, 14] lbl9 : MonitorExitStatement: MONITOREXIT : var6_5
                            Object var12_6 = null;
                            if (!bl) return;
                            destinationSequence.setState(SequenceState.CREATED);
                            break block15;
                        }
                        bl = true;
                        destinationSequence.setState(SequenceState.TERMINATING);
                        if (rMVersion.isLaterThanOrEqualTo(WsrmConstants.RMVersion.RM_11)) {
                            destinationSequence.setFinalMessageNum(l);
                        }
                        if (destinationSequence.getOffer() != null) {
                            sourceSequence = destinationSequence.getOffer();
                            if (destinationSequence.hasFinalMessageNum()) {
                                long l2 = destinationSequence.calculateFinalResponseMessageNum();
                                if (l2 >= 0L) {
                                    if (LOGGER.isLoggable(Level.FINE)) {
                                        LOGGER.fine("*** Final message on request sequence " + destinationSequence.getId() + " with sequence number: " + destinationSequence.getFinalMessageNum() + " was mapped to offer sequence " + sourceSequence.getId() + " sequence number " + l2 + ". Enabling auto-terminate.");
                                    }
                                    TerminateSequenceProcessor.enableAutoTerminateForOfferSequence((SourceOfferSequence)sourceSequence, l2);
                                } else if (LOGGER.isLoggable(Level.FINE)) {
                                    LOGGER.fine("*** Final message on request sequence " + destinationSequence.getId() + " with sequence number: " + destinationSequence.getFinalMessageNum() + " could not be mapped to a sequence number on offer sequence " + sourceSequence.getId());
                                }
                            }
                        }
                        destinationSequence.setState(SequenceState.TERMINATED);
                        DestinationSequenceManager.getInstance().updateSequence(destinationSequence);
                        bl = false;
                        DestinationSequenceManager.getInstance().removeSequence(destinationSequence);
                        if (destinationSequence instanceof DestinationOfferSequence && (sourceSequence = ((DestinationOfferSequence)destinationSequence).getMainSequence()) != null) {
                            sourceSequence.setOffer(null);
                        }
                    }
                    break block16;
                }
                catch (Throwable throwable) {
                    Object var12_8 = null;
                    if (!bl) throw throwable;
                    destinationSequence.setState(SequenceState.CREATED);
                    DestinationSequenceManager.getInstance().updateSequence(destinationSequence);
                    throw throwable;
                }
            }
            DestinationSequenceManager.getInstance().updateSequence(destinationSequence);
            return;
        }
        Object var12_7 = null;
        if (!bl) return;
        destinationSequence.setState(SequenceState.CREATED);
        DestinationSequenceManager.getInstance().updateSequence(destinationSequence);
    }

    private static void enableAutoTerminateForOfferSequence(SourceOfferSequence sourceOfferSequence, long l) throws WsrmException {
        if (sourceOfferSequence.getRmVersion() == WsrmConstants.RMVersion.RM_10) {
            if (!sourceOfferSequence.hasFinalMessageNum()) {
                TerminateSequenceProcessor.sendEmptyLastMessage(sourceOfferSequence);
            } else {
                TerminateSequenceProcessor.setSentFinalMessage(sourceOfferSequence, sourceOfferSequence.getFinalMessageNum());
            }
        } else {
            TerminateSequenceProcessor.setSentFinalMessage(sourceOfferSequence, l);
        }
    }

    public static void sendEmptyLastMessage(SourceSequence sourceSequence) throws WsrmException {
        Message message;
        WSEndpointReference wSEndpointReference = sourceSequence.getEndpointEpr();
        if (wSEndpointReference.isAnonymous()) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("** Bypassing requested send of empty last message on anonymous source sequence " + sourceSequence.getId());
            }
            return;
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("** Sending empty last message on source sequence " + sourceSequence.getId());
        }
        String string = WsrmConstants.Action.LAST_MESSAGE.getActionURI(sourceSequence.getRmVersion());
        try {
            message = WsUtil.createEmptyMessage(string, sourceSequence.getAddressingVersion(), sourceSequence.getSoapVersion());
        }
        catch (Exception exception) {
            message = WsUtil.createMessageFromThrowable(exception, sourceSequence.getAddressingVersion(), sourceSequence.getSoapVersion());
        }
        SequenceHeader sequenceHeader = new SequenceHeader(sourceSequence.getRmVersion(), sourceSequence.getDestinationId(), 0L, true);
        long l = sourceSequence.getNextMessageNum(sequenceHeader);
        message.getHeaders().add((Header)sequenceHeader);
        sourceSequence.setFinalMessageNum(l);
        SenderDispatchFactory.Key key = sourceSequence.getSenderDispatchKey();
        if (key == null) {
            WsrmException wsrmException = new WsrmException("No dispatch key set for sequence '" + sourceSequence + "' cannot send empty last message");
            if (LOGGER.isLoggable(Level.WARNING)) {
                LOGGER.warning(wsrmException.toString());
            }
            throw wsrmException;
        }
        DispatchFactory dispatchFactory = key.resolve();
        Sender sender = new Sender(dispatchFactory);
        WSEndpointReference wSEndpointReference2 = WsrmTubeUtils.calculateReplyToForSourceSequence(sourceSequence);
        try {
            Map<String, Object> map = SourceSequenceManager.getInstance().getSenderInvokeProperties(sourceSequence, (Packet)null);
            map.put("weblogic.wsee.reliability2.FinalMessageFlag", true);
            sender.send(message, string, wSEndpointReference, wSEndpointReference2, map);
        }
        catch (Exception exception) {
            throw new WsrmException(exception.toString(), exception);
        }
    }

    public static void setSentFinalMessage(SourceSequence sourceSequence, long l) throws WsrmException {
        sourceSequence.setFinalMessageNum(l);
        TerminateSequenceProcessor.checkForSequenceCompletion(sourceSequence);
    }

    public static void checkForSequenceCompletion(SourceSequence sourceSequence) throws WsrmException {
        if (sourceSequence.hasFinalMessageNum()) {
            boolean bl = SourceSequenceManager.getInstance().syncUpWithAcks(sourceSequence);
            if (bl) {
                SourceSequenceManager.getInstance().updateSequence(sourceSequence);
            }
            if (sourceSequence.isComplete()) {
                DispatchFactory dispatchFactory = sourceSequence.getSenderDispatchKey().resolve();
                WsrmTubeUtils.sendTerminateSequence(sourceSequence, dispatchFactory);
            }
        }
    }
}

