/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.reliability2.tube.processors;

import com.sun.xml.ws.api.message.Message;
import com.sun.xml.ws.api.message.Packet;
import java.util.logging.Level;
import java.util.logging.Logger;
import weblogic.wsee.reliability.WsrmConstants;
import weblogic.wsee.reliability.handshake.TerminateSequenceResponseMsg;
import weblogic.wsee.reliability2.api.SequenceState;
import weblogic.wsee.reliability2.exception.WsrmException;
import weblogic.wsee.reliability2.sequence.SequenceIdFactory;
import weblogic.wsee.reliability2.sequence.SourceOfferSequence;
import weblogic.wsee.reliability2.sequence.SourceSequence;
import weblogic.wsee.reliability2.sequence.SourceSequenceManager;
import weblogic.wsee.reliability2.tube.WsrmTubeUtils;
import weblogic.wsee.reliability2.tube.processors.MessageProcessor;
import weblogic.wsee.reliability2.tube.processors.TerminateSequenceProcessor;

public class TerminateSequenceResponseProcessor
extends MessageProcessor {
    private static final Logger LOGGER = Logger.getLogger(TerminateSequenceResponseProcessor.class.getName());

    public TerminateSequenceResponseProcessor(WsrmTubeUtils wsrmTubeUtils) {
        super(wsrmTubeUtils);
    }

    public boolean processOutbound(Packet packet, WsrmConstants.RMVersion rMVersion, SequenceIdFactory sequenceIdFactory, String string) throws WsrmException {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("** Processing outbound TerminateSequenceResponse, currently no-op");
        }
        return true;
    }

    public void handleInbound(Packet packet, WsrmConstants.RMVersion rMVersion, WsrmTubeUtils.InboundMessageResult inboundMessageResult) {
        Message message = null;
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("** Handling inbound TerminateSequenceResponse, parsing message");
        }
        Message message2 = packet.getMessage();
        try {
            SourceSequence sourceSequence;
            TerminateSequenceResponseMsg terminateSequenceResponseMsg = new TerminateSequenceResponseMsg(rMVersion);
            terminateSequenceResponseMsg.readMsg(message2.readAsSOAPMessage());
            inboundMessageResult.seq = sourceSequence = (SourceSequence)WsrmTubeUtils.doInitialSetupForAction(WsrmConstants.Element.TERMINATE_SEQUENCE_RESPONSE.getElementName(), true, terminateSequenceResponseMsg.getSequenceId(), rMVersion, packet);
            this._tubeUtil.setInboundSequence(packet, sourceSequence);
            TerminateSequenceResponseProcessor.internalTerminateSequenceResponse(sourceSequence);
        }
        catch (Exception exception) {
            message = WsrmTubeUtils.handleInboundException(exception, this._addrVersion, this._soapVersion);
        }
        inboundMessageResult.message = message;
    }

    public static void forceAnonymousTerminateSequenceResponse(SourceOfferSequence sourceOfferSequence) throws WsrmException {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Forcing terminate on anonymous source offer sequence " + sourceOfferSequence.getId());
        }
        TerminateSequenceResponseProcessor.internalTerminateSequenceResponse(sourceOfferSequence);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void internalTerminateSequenceResponse(SourceSequence sourceSequence) throws WsrmException {
        SequenceState sequenceState = sourceSequence.getState();
        SourceSequence sourceSequence2 = sourceSequence;
        synchronized (sourceSequence2) {
            if (!sequenceState.isValidTransition(SequenceState.TERMINATED)) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("Attempted to illegally change state of sequence " + sourceSequence.getId() + " to TERMINATED from " + (Object)((Object)sequenceState));
                }
                return;
            }
            sourceSequence.setState(SequenceState.TERMINATED);
            SourceSequenceManager.getInstance().removeSequence(sourceSequence);
        }
        TerminateSequenceProcessor.checkForAnonymousOfferSequenceTermination(sourceSequence);
    }
}

