/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.runtime;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import weblogic.management.configuration.WebServiceLogicalStoreMBean;
import weblogic.management.configuration.WebServicePersistenceMBean;
import weblogic.management.provider.ManagementService;
import weblogic.management.provider.RuntimeAccess;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.wsee.WseeCoreLogger;
import weblogic.wsee.config.WebServiceMBeanFactory;
import weblogic.wsee.jaxws.cluster.spi.StoreRoutableIDMapService;
import weblogic.wsee.persistence.InMemoryValuesMap;
import weblogic.wsee.persistence.LogicalStore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InMemoryStoreRoutableIDMapper
implements StoreRoutableIDMapService {
    private static final Logger LOGGER = Logger.getLogger(InMemoryStoreRoutableIDMapper.class.getName());
    private static RuntimeAccess _runtimeAccess;
    private ReentrantReadWriteLock _storeListMapLock = new ReentrantReadWriteLock(false);
    private Set<String> _logicalStoreNameSet = new HashSet<String>();
    private Map<String, String> _physicalStoreToServerMap = new HashMap<String, String>(1);

    InMemoryStoreRoutableIDMapper() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startup() {
        WebServicePersistenceMBean webServicePersistenceMBean = WebServiceMBeanFactory.getInstance().getWebServicePersistence();
        webServicePersistenceMBean.addPropertyChangeListener(new LogicalStoreListPropertyChangeListener());
        try {
            this._storeListMapLock.writeLock().lock();
            this._physicalStoreToServerMap.put(InMemoryValuesMap.PHYSICAL_STORE_NAME, _runtimeAccess.getServerName());
            for (WebServiceLogicalStoreMBean webServiceLogicalStoreMBean : webServicePersistenceMBean.getWebServiceLogicalStores()) {
                if (!webServiceLogicalStoreMBean.getPersistenceStrategy().equals("IN_MEMORY")) continue;
                this.handleLogicalStoreAdded(webServiceLogicalStoreMBean);
            }
            Object var7_6 = null;
            this._storeListMapLock.writeLock().unlock();
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this._storeListMapLock.writeLock().unlock();
            throw throwable;
        }
    }

    private void handleLogicalStoreRemoved(String string) {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Web Services runtime removing LogicalStore " + string);
        }
        if (!this._logicalStoreNameSet.contains(string)) {
            return;
        }
        this.handlePhysicalStoreRemoved(string);
        this._logicalStoreNameSet.remove(string);
        LogicalStore.removeStore(string);
    }

    private void handleLogicalStoreAdded(WebServiceLogicalStoreMBean webServiceLogicalStoreMBean) {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Web Services runtime adding LogicalStore " + webServiceLogicalStoreMBean.getName());
        }
        this._logicalStoreNameSet.add(webServiceLogicalStoreMBean.getName());
        LogicalStore.addStore(webServiceLogicalStoreMBean.getName());
        this.handlePhysicalStoreAdded(webServiceLogicalStoreMBean.getName());
    }

    @Override
    public void shutdown() {
        LogicalStore.closeAllStores();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getLocalPhysicalStoresForLogicalStore(String string) {
        try {
            this._storeListMapLock.readLock().lock();
            ArrayList<String> arrayList = new ArrayList<String>();
            if (this._logicalStoreNameSet.contains(string)) {
                arrayList.add(InMemoryValuesMap.PHYSICAL_STORE_NAME);
            }
            ArrayList<String> arrayList2 = arrayList;
            Object var5_4 = null;
            this._storeListMapLock.readLock().unlock();
            return arrayList2;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this._storeListMapLock.readLock().unlock();
            throw throwable;
        }
    }

    @Override
    public String getServerNameForPhysicalStore(String string) {
        return this._physicalStoreToServerMap.get(string);
    }

    private void handlePhysicalStoreAdded(String string) {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("WSEE runtime just detected new physical store added for logical store " + string + ": " + InMemoryValuesMap.PHYSICAL_STORE_NAME);
        }
        List<LogicalStore> list = LogicalStore.getLogicalStores(string);
        for (LogicalStore logicalStore : list) {
            try {
                logicalStore.addPhysicalStore(InMemoryValuesMap.PHYSICAL_STORE_NAME);
            }
            catch (Exception exception) {
                WseeCoreLogger.logUnexpectedException((String)exception.toString(), (Throwable)exception);
            }
        }
        this.notifyServerAddressChange(null);
    }

    private void handlePhysicalStoreRemoved(String string) {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("WSEE runtime just detected physical store removed for logical store " + string + ": " + InMemoryValuesMap.PHYSICAL_STORE_NAME);
        }
        List<LogicalStore> list = LogicalStore.getLogicalStores(string);
        for (LogicalStore logicalStore : list) {
            try {
                logicalStore.removePhysicalStore(InMemoryValuesMap.PHYSICAL_STORE_NAME);
            }
            catch (Exception exception) {
                WseeCoreLogger.logUnexpectedException((String)exception.toString(), (Throwable)exception);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, String> getCurrentRoutableIDToServerMap() throws Exception {
        try {
            this._storeListMapLock.readLock().lock();
            HashMap<String, String> hashMap = new HashMap<String, String>(this._physicalStoreToServerMap);
            Object var3_2 = null;
            this._storeListMapLock.readLock().unlock();
            return hashMap;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this._storeListMapLock.readLock().unlock();
            throw throwable;
        }
    }

    private void notifyServerAddressChange(String string) {
    }

    static {
        AuthenticatedSubject authenticatedSubject = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
        _runtimeAccess = ManagementService.getRuntimeAccess(authenticatedSubject);
    }

    private class LogicalStoreListPropertyChangeListener
    implements PropertyChangeListener {
        private LogicalStoreListPropertyChangeListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (!"WebServiceLogicalStores".equals(propertyChangeEvent.getPropertyName())) {
                return;
            }
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("InMemoryStoreRoutableIDMapper detected a change to the logical stores configured on the local server");
            }
            WebServiceLogicalStoreMBean[] webServiceLogicalStoreMBeanArray = (WebServiceLogicalStoreMBean[])propertyChangeEvent.getNewValue();
            try {
                InMemoryStoreRoutableIDMapper.this._storeListMapLock.writeLock().lock();
                ArrayList<WebServiceLogicalStoreMBean> arrayList = new ArrayList<WebServiceLogicalStoreMBean>();
                ArrayList arrayList2 = new ArrayList(InMemoryStoreRoutableIDMapper.this._logicalStoreNameSet);
                for (WebServiceLogicalStoreMBean webServiceLogicalStoreMBean : webServiceLogicalStoreMBeanArray) {
                    if (!webServiceLogicalStoreMBean.getPersistenceStrategy().equals("IN_MEMORY")) continue;
                    arrayList2.remove(webServiceLogicalStoreMBean.getName());
                    if (InMemoryStoreRoutableIDMapper.this._logicalStoreNameSet.contains(webServiceLogicalStoreMBean.getName())) continue;
                    arrayList.add(webServiceLogicalStoreMBean);
                }
                for (String string : arrayList2) {
                    InMemoryStoreRoutableIDMapper.this.handleLogicalStoreRemoved(string);
                }
                for (WebServiceLogicalStoreMBean webServiceLogicalStoreMBean : arrayList) {
                    InMemoryStoreRoutableIDMapper.this.handleLogicalStoreAdded(webServiceLogicalStoreMBean);
                }
                Object var10_11 = null;
                InMemoryStoreRoutableIDMapper.this._storeListMapLock.writeLock().unlock();
            }
            catch (Throwable throwable) {
                Object var10_12 = null;
                InMemoryStoreRoutableIDMapper.this._storeListMapLock.writeLock().unlock();
                throw throwable;
            }
        }
    }
}

