/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.runtime;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URL;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import weblogic.jms.common.JMSServerUtilities;
import weblogic.jms.extensions.DestinationAvailabilityListener;
import weblogic.jms.extensions.DestinationDetail;
import weblogic.jms.extensions.JMSDestinationAvailabilityHelper;
import weblogic.jms.extensions.RegistrationHandle;
import weblogic.management.configuration.WebServiceLogicalStoreMBean;
import weblogic.management.configuration.WebServiceMBean;
import weblogic.management.configuration.WebServicePersistenceMBean;
import weblogic.management.provider.ManagementService;
import weblogic.management.provider.RuntimeAccess;
import weblogic.protocol.Protocol;
import weblogic.protocol.ProtocolManager;
import weblogic.protocol.URLManager;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.store.PersistentStoreManager;
import weblogic.wsee.WseeCoreLogger;
import weblogic.wsee.WseePersistLogger;
import weblogic.wsee.buffer2.api.wls.BufferingManager_WLS;
import weblogic.wsee.config.WebServiceMBeanFactory;
import weblogic.wsee.jaxws.cluster.spi.ServerNameMapService;
import weblogic.wsee.jaxws.cluster.spi.StoreRoutableIDMapService;
import weblogic.wsee.jaxws.framework.WsUtil;
import weblogic.wsee.persistence.LogicalStore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JMSStoreRoutableIDMapper
implements StoreRoutableIDMapService,
DestinationAvailabilityListener,
ServerNameMapService,
BufferingManager_WLS.UnitOfOrderQueueFinder {
    private static final Logger LOGGER = Logger.getLogger(JMSStoreRoutableIDMapper.class.getName());
    private static final Protocol HTTP_PROTOCOL;
    private static final Protocol HTTPS_PROTOCOL;
    private List<RegistrationHandle> _handles;
    private ReentrantReadWriteLock _storeListMapLock = new ReentrantReadWriteLock(false);
    private Condition _physicalStoreToServerMapInitializedCondition = this._storeListMapLock.writeLock().newCondition();
    private long _lastNotificationTimestamp = -1L;
    private Map<String, LogicalStoreInfo> _logicalStoreNameToInfoMap;
    private Map<String, List<String>> _ddJndiNameToLogicalStoreNameListMap;
    private Map<String, DDInfo> _ddJndiNameToDDInfoMap;
    private Map<String, String> _physicalStoreToServerMap;
    private List<ServerNameMapService.ServerAddressChangeListener> _serverAddressChangeListeners = new ArrayList<ServerNameMapService.ServerAddressChangeListener>();
    private static RuntimeAccess _runtimeAccess;

    JMSStoreRoutableIDMapper() {
        this._handles = new ArrayList<RegistrationHandle>();
        this._logicalStoreNameToInfoMap = new HashMap<String, LogicalStoreInfo>();
        this._physicalStoreToServerMap = new HashMap<String, String>();
        this._ddJndiNameToLogicalStoreNameListMap = new HashMap<String, List<String>>();
        this._ddJndiNameToDDInfoMap = new HashMap<String, DDInfo>();
    }

    @Override
    public ServerNameMapService.ServerAddress getServerAddress(String string) {
        URL uRL;
        Object object;
        URL uRL2 = null;
        try {
            object = URLManager.findURL(string, HTTP_PROTOCOL);
            uRL = new URL((String)object);
        }
        catch (Exception exception) {
            WseeCoreLogger.logUnexpectedException((String)exception.toString(), (Throwable)exception);
            throw new RuntimeException(exception.toString(), exception);
        }
        try {
            object = URLManager.findURL(string, HTTPS_PROTOCOL);
            if (object == null) {
                uRL2 = new URL((String)object);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        object = new ServerNameMapService.ServerAddress();
        ((ServerNameMapService.ServerAddress)object).serverName = string;
        ((ServerNameMapService.ServerAddress)object).host = uRL.getHost();
        ((ServerNameMapService.ServerAddress)object).port = uRL.getPort();
        ((ServerNameMapService.ServerAddress)object).sslPort = uRL2 != null ? uRL2.getPort() : -1;
        return object;
    }

    @Override
    public void addServerAddressChangeListener(ServerNameMapService.ServerAddressChangeListener serverAddressChangeListener) {
        if (!this._serverAddressChangeListeners.contains(serverAddressChangeListener)) {
            this._serverAddressChangeListeners.add(serverAddressChangeListener);
        }
    }

    @Override
    public void removeServerAddressChangeListener(ServerNameMapService.ServerAddressChangeListener serverAddressChangeListener) {
        this._serverAddressChangeListeners.remove(serverAddressChangeListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startup() {
        WebServicePersistenceMBean webServicePersistenceMBean = WebServiceMBeanFactory.getInstance().getWebServicePersistence();
        webServicePersistenceMBean.addPropertyChangeListener(new LogicalStoreListPropertyChangeListener());
        try {
            this._storeListMapLock.writeLock().lock();
            for (WebServiceLogicalStoreMBean webServiceLogicalStoreMBean : webServicePersistenceMBean.getWebServiceLogicalStores()) {
                if (!webServiceLogicalStoreMBean.getPersistenceStrategy().equals("LOCAL_ACCESS_ONLY")) continue;
                this.handleLogicalStoreAdded(webServiceLogicalStoreMBean, JMSDestinationAvailabilityHelper.getInstance());
            }
        }
        finally {
            this._storeListMapLock.writeLock().unlock();
        }
        BufferingManager_WLS.setUnitOfOrderQueueFinder(this);
    }

    private void handleLogicalStoreUpdated(String string, JMSDestinationAvailabilityHelper jMSDestinationAvailabilityHelper) {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Web Services runtime updating LogicalStore " + string);
        }
        LogicalStoreInfo logicalStoreInfo = this._logicalStoreNameToInfoMap.get(string);
        this.handleLogicalStoreRemoved(string);
        this.handleLogicalStoreAdded(logicalStoreInfo._mbean, jMSDestinationAvailabilityHelper);
    }

    private void handleLogicalStoreRemoved(String string) {
        LogicalStoreInfo logicalStoreInfo;
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Web Services runtime removing LogicalStore " + string);
        }
        if ((logicalStoreInfo = this._logicalStoreNameToInfoMap.get(string)) == null) {
            return;
        }
        if (logicalStoreInfo._listener != null) {
            logicalStoreInfo._mbean.removePropertyChangeListener(logicalStoreInfo._listener);
        }
        String string2 = logicalStoreInfo._mbean.getRequestBufferingQueueJndiName();
        this.handleDDJndiNameRemoved(string, string2);
        string2 = logicalStoreInfo._mbean.getResponseBufferingQueueJndiName();
        this.handleDDJndiNameRemoved(string, string2);
        for (StoreAndServerNamePair storeAndServerNamePair : logicalStoreInfo.getPhysicalStoreList()) {
            this.handlePhysicalStoreRemoved(string, storeAndServerNamePair, false);
        }
        this._logicalStoreNameToInfoMap.remove(string);
        LogicalStore.removeStore(string);
    }

    private void handleDDJndiNameRemoved(String string, String string2) {
        if (string2 != null) {
            List<String> list = this._ddJndiNameToLogicalStoreNameListMap.get(string2);
            list.remove(string);
            if (list.size() < 1) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("Stopped tracking DD JNDI name: " + string2);
                }
                this._ddJndiNameToLogicalStoreNameListMap.remove(string2);
                DDInfo dDInfo = this._ddJndiNameToDDInfoMap.remove(string2);
                this._handles.remove(dDInfo.getRegistrationHandle());
                dDInfo.unregister();
            }
        }
    }

    private void handleLogicalStoreAdded(WebServiceLogicalStoreMBean webServiceLogicalStoreMBean, JMSDestinationAvailabilityHelper jMSDestinationAvailabilityHelper) {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Web Services runtime adding LogicalStore " + webServiceLogicalStoreMBean.getName());
        }
        LogicalStoreInfo logicalStoreInfo = new LogicalStoreInfo(webServiceLogicalStoreMBean);
        this._logicalStoreNameToInfoMap.put(webServiceLogicalStoreMBean.getName(), logicalStoreInfo);
        LogicalStore.addStore(webServiceLogicalStoreMBean.getName());
        String string = webServiceLogicalStoreMBean.getRequestBufferingQueueJndiName();
        boolean bl = this.handleDDJndiNameAdded(webServiceLogicalStoreMBean, jMSDestinationAvailabilityHelper, string);
        string = webServiceLogicalStoreMBean.getResponseBufferingQueueJndiName();
        if (!(bl |= this.handleDDJndiNameAdded(webServiceLogicalStoreMBean, jMSDestinationAvailabilityHelper, string))) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("LogicalStore " + webServiceLogicalStoreMBean.getName() + " has NO request/response buffering queue assigned. Physical store directly specified: " + webServiceLogicalStoreMBean.getPhysicalStoreName());
            }
            if (webServiceLogicalStoreMBean.getPhysicalStoreName() == null || webServiceLogicalStoreMBean.getPhysicalStoreName().length() == 0) {
                throw new IllegalArgumentException("No request/response buffering queue or physical store name specified for logical store: " + webServiceLogicalStoreMBean.getName());
            }
            StoreAndServerNamePair storeAndServerNamePair = new StoreAndServerNamePair(webServiceLogicalStoreMBean.getPhysicalStoreName(), _runtimeAccess.getServerName());
            logicalStoreInfo.addPhysicalStore(storeAndServerNamePair);
            this.handlePhysicalStoreAdded(webServiceLogicalStoreMBean.getName(), storeAndServerNamePair);
        }
        logicalStoreInfo._listener = new LogicalStorePropertyChangeListener(webServiceLogicalStoreMBean.getName());
        webServiceLogicalStoreMBean.addPropertyChangeListener(logicalStoreInfo._listener);
    }

    private boolean handleDDJndiNameAdded(WebServiceLogicalStoreMBean webServiceLogicalStoreMBean, JMSDestinationAvailabilityHelper jMSDestinationAvailabilityHelper, String string) {
        Object object;
        if (string != null && string.length() < 1) {
            string = null;
        }
        if (string == null) {
            return false;
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("LogicalStore " + webServiceLogicalStoreMBean.getName() + " has buffering queue JNDI: " + string);
        }
        this.verifyQueueType(string, webServiceLogicalStoreMBean.getName());
        DDInfo dDInfo = this._ddJndiNameToDDInfoMap.get(string);
        if (dDInfo == null) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Started tracking DD JNDI name: " + string);
            }
            dDInfo = new DDInfo(string);
            object = jMSDestinationAvailabilityHelper.register(null, string, this);
            dDInfo.setRegistrationHandle((RegistrationHandle)object);
            this._handles.add((RegistrationHandle)object);
            this._ddJndiNameToDDInfoMap.put(string, dDInfo);
        }
        if ((object = this._ddJndiNameToLogicalStoreNameListMap.get(string)) == null) {
            object = new ArrayList<String>();
            this._ddJndiNameToLogicalStoreNameListMap.put(string, (List<String>)object);
        }
        object.add((String)webServiceLogicalStoreMBean.getName());
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("WSEE runtime registering for JMS destination changes for LogicalStore " + webServiceLogicalStoreMBean.getName() + " and buffering queue JNDI: " + string);
        }
        return true;
    }

    private void verifyQueueType(String string, String string2) {
        try {
            InitialContext initialContext = new InitialContext();
            initialContext.lookup(string);
            if (JMSServerUtilities.findBEDestinationByJNDIName(string) == null) {
                WseePersistLogger.logImproperBufferingQueueType((String)"Weighted Distributed Destination", (String)string, (String)string2);
            }
        }
        catch (NamingException namingException) {
            // empty catch block
        }
    }

    @Override
    public void shutdown() {
        for (RegistrationHandle registrationHandle : this._handles) {
            registrationHandle.unregister();
        }
        LogicalStore.closeAllStores();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getLocalPhysicalStoresForLogicalStore(String string) {
        try {
            Object object;
            this._storeListMapLock.readLock().lock();
            LogicalStoreInfo logicalStoreInfo = this._logicalStoreNameToInfoMap.get(string);
            ArrayList<String> arrayList = new ArrayList<String>();
            if (logicalStoreInfo != null) {
                object = _runtimeAccess.getServerName();
                for (StoreAndServerNamePair storeAndServerNamePair : logicalStoreInfo.getPhysicalStoreList()) {
                    if (!storeAndServerNamePair.getServerName().equals(object)) continue;
                    arrayList.add(storeAndServerNamePair.getPhysStoreName());
                }
            }
            object = arrayList;
            return object;
        }
        finally {
            this._storeListMapLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getServerNameForPhysicalStore(String string) {
        try {
            this._storeListMapLock.readLock().lock();
            String string2 = this._physicalStoreToServerMap.get(string);
            return string2;
        }
        finally {
            this._storeListMapLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onDestinationsAvailable(String string, List<DestinationDetail> list) {
        DDInfo dDInfo;
        List<String> list2;
        try {
            this._storeListMapLock.readLock().lock();
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("WSEE runtime just detected destinations available for queue JNDI: " + string);
            }
            list2 = this._ddJndiNameToLogicalStoreNameListMap.get(string);
            dDInfo = this._ddJndiNameToDDInfoMap.get(string);
        }
        finally {
            this._storeListMapLock.readLock().unlock();
        }
        if (list2 == null || dDInfo == null) {
            return;
        }
        Set<DDMemberInfo> set = this.getDDMemberInfosFromDestinationChange(list);
        dDInfo.addMembers(set);
        for (String string2 : list2) {
            LogicalStoreInfo logicalStoreInfo;
            try {
                this._storeListMapLock.readLock().lock();
                logicalStoreInfo = this._logicalStoreNameToInfoMap.get(string2);
            }
            finally {
                this._storeListMapLock.readLock().unlock();
            }
            for (DDMemberInfo dDMemberInfo : set) {
                boolean bl = false;
                for (StoreAndServerNamePair storeAndServerNamePair : logicalStoreInfo.getPhysicalStoreList()) {
                    if (!storeAndServerNamePair.getPhysStoreName().equals(dDMemberInfo.getPair().getPhysStoreName())) continue;
                    bl = true;
                }
                if (bl) continue;
                this.handlePhysicalStoreAdded(string2, dDMemberInfo.getPair());
            }
        }
        try {
            this._storeListMapLock.writeLock().lock();
            this._lastNotificationTimestamp = System.currentTimeMillis();
            this._physicalStoreToServerMapInitializedCondition.signalAll();
        }
        finally {
            this._storeListMapLock.writeLock().unlock();
        }
        this.notifyServerAddressChange(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handlePhysicalStoreAdded(String string, StoreAndServerNamePair storeAndServerNamePair) {
        Object object;
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("WSEE runtime just detected new physical store added for logical store " + string + ": " + storeAndServerNamePair);
        }
        try {
            this._storeListMapLock.writeLock().lock();
            if (this._physicalStoreToServerMap.containsKey(storeAndServerNamePair.getPhysStoreName())) {
                return;
            }
            this._physicalStoreToServerMap.put(storeAndServerNamePair.getPhysStoreName(), storeAndServerNamePair.getServerName());
            object = this._logicalStoreNameToInfoMap.get(string);
            ((LogicalStoreInfo)object).addPhysicalStore(storeAndServerNamePair);
        }
        finally {
            this._storeListMapLock.writeLock().unlock();
        }
        if (storeAndServerNamePair.getServerName().equals(_runtimeAccess.getServerName())) {
            object = LogicalStore.getLogicalStores(string);
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                LogicalStore logicalStore = (LogicalStore)iterator.next();
                try {
                    logicalStore.addPhysicalStore(storeAndServerNamePair.getPhysStoreName());
                }
                catch (Exception exception) {
                    WseeCoreLogger.logUnexpectedException((String)exception.toString(), (Throwable)exception);
                }
            }
        }
        this.notifyServerAddressChange(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onDestinationsUnavailable(String string, List<DestinationDetail> list) {
        DDInfo dDInfo;
        List<String> list2;
        try {
            this._storeListMapLock.readLock().lock();
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("WSEE runtime just detected destinations UN-available for queue JNDI: " + string);
            }
            list2 = this._ddJndiNameToLogicalStoreNameListMap.get(string);
            dDInfo = this._ddJndiNameToDDInfoMap.get(string);
        }
        finally {
            this._storeListMapLock.readLock().unlock();
        }
        if (list2 == null || dDInfo == null) {
            return;
        }
        Set<DDMemberInfo> set = this.getDDMemberInfosFromDestinationChange(list);
        dDInfo.removeMembers(set);
        for (String string2 : list2) {
            LogicalStoreInfo logicalStoreInfo;
            try {
                this._storeListMapLock.readLock().lock();
                logicalStoreInfo = this._logicalStoreNameToInfoMap.get(string2);
            }
            finally {
                this._storeListMapLock.readLock().unlock();
            }
            for (DDMemberInfo dDMemberInfo : set) {
                boolean bl = false;
                for (StoreAndServerNamePair storeAndServerNamePair : logicalStoreInfo._physicalStoreList) {
                    if (!storeAndServerNamePair.getPhysStoreName().equals(dDMemberInfo.getPair().getPhysStoreName())) continue;
                    bl = true;
                }
                if (!bl) continue;
                this.handlePhysicalStoreRemoved(string2, dDMemberInfo.getPair(), true);
            }
        }
        this.notifyServerAddressChange(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handlePhysicalStoreRemoved(String string, StoreAndServerNamePair storeAndServerNamePair, boolean bl) {
        Object object;
        Object object2;
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("WSEE runtime just detected physical store removed for logical store " + string + ": " + storeAndServerNamePair);
        }
        try {
            this._storeListMapLock.writeLock().lock();
            object2 = this._physicalStoreToServerMap.remove(storeAndServerNamePair.getPhysStoreName());
            if (object2 == null) {
                return;
            }
            object = this._logicalStoreNameToInfoMap.get(string);
            ((LogicalStoreInfo)object).removePhysicalStore(storeAndServerNamePair);
        }
        finally {
            this._storeListMapLock.writeLock().unlock();
        }
        if (bl && storeAndServerNamePair.getServerName().equals(_runtimeAccess.getServerName())) {
            object2 = LogicalStore.getLogicalStores(string);
            object = object2.iterator();
            while (object.hasNext()) {
                LogicalStore logicalStore = (LogicalStore)object.next();
                try {
                    logicalStore.removePhysicalStore(storeAndServerNamePair.getPhysStoreName());
                }
                catch (Exception exception) {
                    WseeCoreLogger.logUnexpectedException((String)exception.toString(), (Throwable)exception);
                }
            }
        }
    }

    @Override
    public void onFailure(String string, Exception exception) {
    }

    private Set<DDMemberInfo> getDDMemberInfosFromDestinationChange(List<DestinationDetail> list) {
        HashSet<DDMemberInfo> hashSet = new HashSet<DDMemberInfo>();
        for (DestinationDetail destinationDetail : list) {
            Object object;
            String string = destinationDetail.getStoreName();
            if (string == null) {
                object = PersistentStoreManager.getManager().getDefaultStore();
                String string2 = string = object != null ? object.getName() : null;
            }
            if (string == null) continue;
            object = destinationDetail.getWLSServerName() != null ? destinationDetail.getWLSServerName() : _runtimeAccess.getServerName();
            StoreAndServerNamePair storeAndServerNamePair = new StoreAndServerNamePair(string, (String)object);
            DDMemberInfo dDMemberInfo = new DDMemberInfo(storeAndServerNamePair, destinationDetail);
            hashSet.add(dDMemberInfo);
        }
        return hashSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, String> getCurrentRoutableIDToServerMap() throws Exception {
        this.ensurePhysicalStoreToServerMapInitialized();
        try {
            this._storeListMapLock.readLock().lock();
            HashMap<String, String> hashMap = new HashMap<String, String>(this._physicalStoreToServerMap);
            return hashMap;
        }
        finally {
            this._storeListMapLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ensurePhysicalStoreToServerMapInitialized() {
        if (!this.needStoreToServerMap()) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.info("LogicalStore configuration for this server doesn't require waiting for a store-to-server map to be initialized. Allowing immediate access to LogicalStores");
            }
            return;
        }
        boolean bl = false;
        boolean bl2 = false;
        try {
            long l;
            this._storeListMapLock.readLock().lock();
            bl = true;
            boolean bl3 = false;
            if (this._lastNotificationTimestamp != -1L && (l = (System.currentTimeMillis() - this._lastNotificationTimestamp) / 1000L) > 20L) {
                bl3 = true;
                this._storeListMapLock.readLock().unlock();
                bl = false;
                if (LOGGER.isLoggable(Level.INFO)) {
                    LOGGER.info("Found " + l + " seconds elapsed time between last notification and ensurePhysicalStoreToServerMapInitialized call. Returning from ensurePhysicalStoreToServerMapInitialized without waiting.");
                }
                return;
            }
            this._storeListMapLock.readLock().unlock();
            bl = false;
            this._storeListMapLock.writeLock().lock();
            bl2 = true;
            while (!bl3) {
                boolean bl4;
                long l2 = l = this._lastNotificationTimestamp == -1L ? 150L : 20L;
                if (LOGGER.isLoggable(Level.INFO)) {
                    LOGGER.info("Blocking current thread " + Thread.currentThread() + " for " + l + " seconds. Waiting for physical store(s) to be detected for any logical store on this server");
                }
                if (bl4 = this._physicalStoreToServerMapInitializedCondition.await(l, TimeUnit.SECONDS)) continue;
                bl3 = true;
            }
            if (LOGGER.isLoggable(Level.INFO)) {
                LOGGER.info("Resuming thread " + Thread.currentThread());
            }
        }
        catch (Exception exception) {
            WseeCoreLogger.logUnexpectedException((String)exception.toString(), (Throwable)exception);
        }
        finally {
            if (bl) {
                this._storeListMapLock.readLock().unlock();
            }
            if (bl2) {
                this._storeListMapLock.writeLock().unlock();
            }
        }
    }

    private boolean needStoreToServerMap() {
        WebServiceMBean webServiceMBean = WebServiceMBeanFactory.getInstance();
        WebServicePersistenceMBean webServicePersistenceMBean = webServiceMBean.getWebServicePersistence();
        if (webServicePersistenceMBean == null || webServicePersistenceMBean.getWebServiceLogicalStores() == null) {
            return false;
        }
        for (WebServiceLogicalStoreMBean webServiceLogicalStoreMBean : webServicePersistenceMBean.getWebServiceLogicalStores()) {
            if (webServiceLogicalStoreMBean.getRequestBufferingQueueJndiName() == null && webServiceLogicalStoreMBean.getResponseBufferingQueueJndiName() == null || webServiceLogicalStoreMBean.getPersistenceStrategy().equals("IN_MEMORY")) continue;
            return true;
        }
        return false;
    }

    private void notifyServerAddressChange(String string) {
        ServerNameMapService.ServerAddressChangeListener[] serverAddressChangeListenerArray;
        for (ServerNameMapService.ServerAddressChangeListener serverAddressChangeListener : serverAddressChangeListenerArray = this._serverAddressChangeListeners.toArray(new ServerNameMapService.ServerAddressChangeListener[this._serverAddressChangeListeners.size()])) {
            serverAddressChangeListener.serverAddressChanged(string, this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String findQueueJndiNameForUnitOfOrder(String string, String string2) {
        DDInfo dDInfo;
        String string3 = null;
        try {
            string3 = WsUtil.getStoreNameFromRoutableUUID(string2);
            if (string3 == null) {
                String string4 = null;
                return string4;
            }
            this._storeListMapLock.readLock().lock();
            dDInfo = this._ddJndiNameToDDInfoMap.get(string);
            if (dDInfo == null) {
                String string5 = null;
                return string5;
            }
        }
        finally {
            this._storeListMapLock.readLock().unlock();
        }
        Set<DDMemberInfo> set = dDInfo.getMembers();
        for (DDMemberInfo dDMemberInfo : set) {
            if (!dDMemberInfo.getPair().getPhysStoreName().equals(string3)) continue;
            return dDMemberInfo.getDestDetail().getJNDIName();
        }
        return null;
    }

    static {
        try {
            HTTP_PROTOCOL = ProtocolManager.findProtocol((String)"http");
            HTTPS_PROTOCOL = ProtocolManager.findProtocol((String)"https");
        }
        catch (Exception exception) {
            WseeCoreLogger.logUnexpectedException((String)exception.toString(), (Throwable)exception);
            throw new RuntimeException(exception.toString(), exception);
        }
        AuthenticatedSubject authenticatedSubject = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
        _runtimeAccess = ManagementService.getRuntimeAccess(authenticatedSubject);
    }

    private static class StoreAndServerNamePair {
        private String _physStoreName;
        private String _serverName;

        private StoreAndServerNamePair(String string, String string2) {
            this._physStoreName = string;
            this._serverName = string2;
        }

        public String getPhysStoreName() {
            return this._physStoreName;
        }

        public void setPhysStoreName(String string) {
            this._physStoreName = string;
        }

        public String getServerName() {
            return this._serverName;
        }

        public void setServerName(String string) {
            this._serverName = string;
        }

        public boolean equals(Object object) {
            if (!(object instanceof StoreAndServerNamePair)) {
                return false;
            }
            StoreAndServerNamePair storeAndServerNamePair = (StoreAndServerNamePair)object;
            return this._physStoreName.equals(storeAndServerNamePair._physStoreName) && this._serverName.equals(storeAndServerNamePair._serverName);
        }

        public int hashCode() {
            StringBuffer stringBuffer = new StringBuffer(this._physStoreName);
            stringBuffer.append(this._serverName);
            return stringBuffer.toString().hashCode();
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Physical store: ").append(this._physStoreName);
            stringBuffer.append(" ");
            stringBuffer.append("Server: ").append(this._serverName);
            return stringBuffer.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LogicalStoreInfo {
        private WebServiceLogicalStoreMBean _mbean;
        private final ReentrantReadWriteLock _physicalStoreListLock = new ReentrantReadWriteLock(false);
        private List<StoreAndServerNamePair> _physicalStoreList;
        public PropertyChangeListener _listener;

        public LogicalStoreInfo(WebServiceLogicalStoreMBean webServiceLogicalStoreMBean) {
            this._mbean = webServiceLogicalStoreMBean;
            this._physicalStoreList = new ArrayList<StoreAndServerNamePair>();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addPhysicalStore(StoreAndServerNamePair storeAndServerNamePair) {
            try {
                this._physicalStoreListLock.writeLock().lock();
                this._physicalStoreList.add(storeAndServerNamePair);
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("Added physical store for server " + storeAndServerNamePair.getServerName() + " PhysicalStore='" + storeAndServerNamePair.getPhysStoreName() + "' Current physical store count: " + this._physicalStoreList.size());
                }
            }
            finally {
                this._physicalStoreListLock.writeLock().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removePhysicalStore(StoreAndServerNamePair storeAndServerNamePair) {
            try {
                this._physicalStoreListLock.writeLock().lock();
                this._physicalStoreList.remove(storeAndServerNamePair);
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("Removed physical store for server " + storeAndServerNamePair.getServerName() + " PhysicalStore='" + storeAndServerNamePair.getPhysStoreName() + "' Current physical store count: " + this._physicalStoreList.size());
                }
            }
            finally {
                this._physicalStoreListLock.writeLock().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public List<StoreAndServerNamePair> getPhysicalStoreList() {
            try {
                this._physicalStoreListLock.readLock().lock();
                ArrayList<StoreAndServerNamePair> arrayList = new ArrayList<StoreAndServerNamePair>(this._physicalStoreList);
                return arrayList;
            }
            finally {
                this._physicalStoreListLock.readLock().unlock();
            }
        }
    }

    private static class DDMemberInfo {
        private StoreAndServerNamePair _pair;
        private DestinationDetail _destDetail;

        private DDMemberInfo(StoreAndServerNamePair storeAndServerNamePair, DestinationDetail destinationDetail) {
            this._pair = storeAndServerNamePair;
            this._destDetail = destinationDetail;
        }

        public StoreAndServerNamePair getPair() {
            return this._pair;
        }

        public DestinationDetail getDestDetail() {
            return this._destDetail;
        }

        public int hashCode() {
            return this._pair.hashCode();
        }

        public boolean equals(Object object) {
            return object instanceof DDMemberInfo && this._pair.equals(object);
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(super.toString());
            stringBuffer.append(" - ");
            stringBuffer.append(this._pair.toString());
            return stringBuffer.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DDInfo {
        private String _jndiName;
        private final ReentrantReadWriteLock _physicalStoreListLock = new ReentrantReadWriteLock(false);
        private Set<DDMemberInfo> _members;
        public RegistrationHandle _registrationHandle;

        public DDInfo(String string) {
            this._jndiName = string;
            this._members = new HashSet<DDMemberInfo>();
        }

        public String getJndiName() {
            return this._jndiName;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Set<DDMemberInfo> getMembers() {
            try {
                this._physicalStoreListLock.readLock().lock();
                HashSet<DDMemberInfo> hashSet = new HashSet<DDMemberInfo>(this._members);
                return hashSet;
            }
            finally {
                this._physicalStoreListLock.readLock().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addMembers(Set<DDMemberInfo> set) {
            try {
                this._physicalStoreListLock.writeLock().lock();
                this._members.addAll(set);
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("DD JNDI Name added members (" + DDInfo.dumpMembers(set) + ") to make current member list (" + DDInfo.dumpMembers(this._members) + ")");
                }
            }
            finally {
                this._physicalStoreListLock.writeLock().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeMembers(Set<DDMemberInfo> set) {
            try {
                this._physicalStoreListLock.writeLock().lock();
                this._members.removeAll(set);
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("DD JNDI Name removed members (" + DDInfo.dumpMembers(set) + ") to make current member list (" + DDInfo.dumpMembers(this._members) + ")");
                }
            }
            finally {
                this._physicalStoreListLock.writeLock().unlock();
            }
        }

        private static String dumpMembers(Set<DDMemberInfo> set) {
            StringBuffer stringBuffer = new StringBuffer();
            for (DDMemberInfo dDMemberInfo : set) {
                stringBuffer.append(dDMemberInfo.getPair());
                stringBuffer.append(",");
            }
            if (stringBuffer.length() > 0) {
                stringBuffer.deleteCharAt(stringBuffer.length() - 1);
            }
            return stringBuffer.toString();
        }

        public RegistrationHandle getRegistrationHandle() {
            return this._registrationHandle;
        }

        public void setRegistrationHandle(RegistrationHandle registrationHandle) {
            this._registrationHandle = registrationHandle;
        }

        public void unregister() {
            if (this._registrationHandle != null) {
                try {
                    this._registrationHandle.unregister();
                }
                catch (Exception exception) {
                    if (LOGGER.isLoggable(Level.SEVERE)) {
                        LOGGER.log(Level.SEVERE, exception.toString(), exception);
                    }
                    WseeCoreLogger.logUnexpectedException((String)exception.toString(), (Throwable)exception);
                }
            }
        }
    }

    private class LogicalStorePropertyChangeListener
    implements PropertyChangeListener {
        private String _logicalStoreName;

        private LogicalStorePropertyChangeListener(String string) {
            this._logicalStoreName = string;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if ("RequestBufferingQueueJndiName".equals(propertyChangeEvent.getPropertyName())) {
                try {
                    JMSStoreRoutableIDMapper.this._storeListMapLock.writeLock().lock();
                    JMSStoreRoutableIDMapper.this.handleLogicalStoreUpdated(this._logicalStoreName, JMSDestinationAvailabilityHelper.getInstance());
                }
                finally {
                    JMSStoreRoutableIDMapper.this._storeListMapLock.writeLock().unlock();
                }
            }
        }
    }

    private class LogicalStoreListPropertyChangeListener
    implements PropertyChangeListener {
        private LogicalStoreListPropertyChangeListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (!"WebServiceLogicalStores".equals(propertyChangeEvent.getPropertyName())) {
                return;
            }
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("JMSStoreRoutableIDMapper detected a change to the logical stores configured on the local server");
            }
            WebServiceLogicalStoreMBean[] webServiceLogicalStoreMBeanArray = (WebServiceLogicalStoreMBean[])propertyChangeEvent.getNewValue();
            try {
                JMSStoreRoutableIDMapper.this._storeListMapLock.writeLock().lock();
                ArrayList<WebServiceLogicalStoreMBean> arrayList = new ArrayList<WebServiceLogicalStoreMBean>();
                ArrayList arrayList2 = new ArrayList(JMSStoreRoutableIDMapper.this._logicalStoreNameToInfoMap.keySet());
                for (WebServiceLogicalStoreMBean webServiceLogicalStoreMBean : webServiceLogicalStoreMBeanArray) {
                    if (!webServiceLogicalStoreMBean.getPersistenceStrategy().equals("LOCAL_ACCESS_ONLY")) continue;
                    arrayList2.remove(webServiceLogicalStoreMBean.getName());
                    if (JMSStoreRoutableIDMapper.this._logicalStoreNameToInfoMap.containsKey(webServiceLogicalStoreMBean.getName())) continue;
                    arrayList.add(webServiceLogicalStoreMBean);
                }
                for (String string : arrayList2) {
                    JMSStoreRoutableIDMapper.this.handleLogicalStoreRemoved(string);
                }
                for (WebServiceLogicalStoreMBean webServiceLogicalStoreMBean : arrayList) {
                    JMSStoreRoutableIDMapper.this.handleLogicalStoreAdded(webServiceLogicalStoreMBean, JMSDestinationAvailabilityHelper.getInstance());
                }
            }
            finally {
                JMSStoreRoutableIDMapper.this._storeListMapLock.writeLock().unlock();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ChangeType {
        ADD,
        REMOVE,
        UPDATE;

    }
}

