/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.runtime;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import weblogic.kernel.KernelStatus;
import weblogic.management.configuration.WebServiceLogicalStoreMBean;
import weblogic.wsee.config.WebServiceMBeanFactory;
import weblogic.wsee.jaxws.cluster.spi.RoutableIDMapServiceRegistry;
import weblogic.wsee.jaxws.cluster.spi.StoreRoutableIDMapService;
import weblogic.wsee.monitoring.WseeRuntimeMBeanDelegate;
import weblogic.wsee.reliability2.ReliabilityService;
import weblogic.wsee.runtime.InMemoryStoreRoutableIDMapper;
import weblogic.wsee.runtime.JMSStoreRoutableIDMapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebServicesRuntime {
    private static final Logger LOGGER = Logger.getLogger(WebServicesRuntime.class.getName());
    private static WebServicesRuntime _instance = new WebServicesRuntime();
    private ReentrantReadWriteLock _runtimeReadyLock = new ReentrantReadWriteLock(false);
    private State _state;
    private boolean _runtimeReady;
    private StoreRoutableIDMapService[] _storeMappers;
    private JMSStoreRoutableIDMapper _jmsStoreRoutableIdMapper;

    public static WebServicesRuntime getInstance() {
        return _instance;
    }

    private WebServicesRuntime() {
        if (KernelStatus.isServer()) {
            this.ctorOnServerLogic();
        } else {
            this.ctorOffServerLogic();
        }
    }

    private void ctorOffServerLogic() {
        this._storeMappers = new StoreRoutableIDMapService[1];
        this._storeMappers[0] = new StandaloneVMRoutableIDMapper();
        this._state = State.STARTED;
        this._runtimeReady = true;
    }

    private void ctorOnServerLogic() {
        this._state = State.INITIAL;
        this._storeMappers = new StoreRoutableIDMapService[2];
        this._jmsStoreRoutableIdMapper = new JMSStoreRoutableIDMapper();
        this._storeMappers[0] = this._jmsStoreRoutableIdMapper;
        this._storeMappers[1] = new InMemoryStoreRoutableIDMapper();
        RoutableIDMapServiceRegistry routableIDMapServiceRegistry = RoutableIDMapServiceRegistry.getInstance();
        for (StoreRoutableIDMapService storeRoutableIDMapService : this._storeMappers) {
            routableIDMapServiceRegistry.addMapper(storeRoutableIDMapService);
        }
        this._runtimeReady = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isStarted() {
        try {
            this._runtimeReadyLock.readLock().lock();
            boolean bl = this._state == State.STARTED;
            return bl;
        }
        finally {
            this._runtimeReadyLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean ensureReady() {
        try {
            boolean bl;
            this._runtimeReadyLock.readLock().lock();
            boolean bl2 = bl = this._state == State.STARTED;
            if (Boolean.TRUE.equals(this._runtimeReady) || !bl) {
                boolean bl3 = bl;
                return bl3;
            }
        }
        finally {
            this._runtimeReadyLock.readLock().unlock();
        }
        if (KernelStatus.isServer()) {
            try {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("WebServicesRuntime.ensureReady is checking with JMSStoreRoutableIDMapper to see if its runtime is ready");
                }
                this._runtimeReadyLock.writeLock().lock();
                this._jmsStoreRoutableIdMapper.ensurePhysicalStoreToServerMapInitialized();
                this._runtimeReady = true;
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("WebServicesRuntime.ensureReady is done. Runtime is ready");
                }
            }
            finally {
                this._runtimeReadyLock.writeLock().unlock();
            }
        }
        return true;
    }

    void startup() {
        block5: {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Web Services runtime STARTING UP");
            }
            this.setState(State.STARTING_UP);
            for (StoreRoutableIDMapService storeRoutableIDMapService : this._storeMappers) {
                storeRoutableIDMapService.startup();
            }
            if (WseeRuntimeMBeanDelegate.isReliableSecureProfileEnabled()) {
                try {
                    ReliabilityService.startup();
                }
                catch (Exception exception) {
                    if (!LOGGER.isLoggable(Level.SEVERE)) break block5;
                    LOGGER.log(Level.SEVERE, exception.toString(), exception);
                }
            }
        }
        this.setState(State.STARTED);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setState(State state) {
        try {
            this._runtimeReadyLock.readLock().lock();
            this._state = state;
        }
        finally {
            this._runtimeReadyLock.readLock().unlock();
        }
    }

    void shutdown() {
        block4: {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Web Services runtime SHUTTING DOWN");
            }
            this.setState(State.SHUTTING_DOWN);
            try {
                ReliabilityService.shutdown();
            }
            catch (Exception exception) {
                if (!LOGGER.isLoggable(Level.SEVERE)) break block4;
                LOGGER.log(Level.SEVERE, exception.toString(), exception);
            }
        }
        for (StoreRoutableIDMapService storeRoutableIDMapService : this._storeMappers) {
            storeRoutableIDMapService.shutdown();
        }
        this.setState(State.SHUTDOWN);
    }

    public List<String> getLocalPhysicalStoresForLogicalStore(String string) {
        List<Object> list = null;
        for (StoreRoutableIDMapService storeRoutableIDMapService : this._storeMappers) {
            list = storeRoutableIDMapService.getLocalPhysicalStoresForLogicalStore(string);
            if (list.isEmpty()) continue;
            return list;
        }
        if (list == null) {
            list = new ArrayList();
        }
        return list;
    }

    public String getServerNameForPhysicalStore(String string) {
        String string2 = null;
        for (StoreRoutableIDMapService storeRoutableIDMapService : this._storeMappers) {
            string2 = storeRoutableIDMapService.getServerNameForPhysicalStore(string);
            if (string2 == null) continue;
            return string2;
        }
        return string2;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class StandaloneVMRoutableIDMapper
    implements StoreRoutableIDMapService {
        private StandaloneVMRoutableIDMapper() {
        }

        @Override
        public void startup() {
        }

        @Override
        public void shutdown() {
        }

        @Override
        public List<String> getLocalPhysicalStoresForLogicalStore(String string) {
            WebServiceLogicalStoreMBean[] webServiceLogicalStoreMBeanArray;
            ArrayList<String> arrayList = new ArrayList<String>();
            for (WebServiceLogicalStoreMBean webServiceLogicalStoreMBean : webServiceLogicalStoreMBeanArray = WebServiceMBeanFactory.getInstance().getWebServicePersistence().getWebServiceLogicalStores()) {
                if (!webServiceLogicalStoreMBean.getName().equals(string)) continue;
                String string2 = webServiceLogicalStoreMBean.getPhysicalStoreName();
                if (string2 != null) {
                    arrayList.add(string2);
                }
                return arrayList;
            }
            return arrayList;
        }

        @Override
        public String getServerNameForPhysicalStore(String string) {
            return null;
        }

        @Override
        public Map<String, String> getCurrentRoutableIDToServerMap() throws Exception {
            return new HashMap<String, String>();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum State {
        INITIAL,
        STARTING_UP,
        STARTED,
        SHUTTING_DOWN,
        SHUTDOWN;

    }
}

