/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.runtime;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.security.AccessController;
import weblogic.management.provider.ManagementService;
import weblogic.management.provider.RuntimeAccess;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.server.ActivatedService;
import weblogic.server.ServiceFailureException;
import weblogic.wsee.WseeCoreLogger;
import weblogic.wsee.runtime.WebServicesRuntime;

public final class WseeService
extends ActivatedService {
    private static RuntimeAccess _runtimeAccess;
    private static boolean _initialized;

    public void stopService() throws ServiceFailureException {
        WseeCoreLogger.logWseeServiceStopping();
        WebServicesRuntime.getInstance().shutdown();
    }

    public void haltService() throws ServiceFailureException {
        WseeCoreLogger.logWseeServiceHalting();
        WebServicesRuntime.getInstance().shutdown();
    }

    public boolean startService() throws ServiceFailureException {
        WseeCoreLogger.logWseeServiceStarting();
        if (_initialized) {
            return true;
        }
        ServerStateChangeListener serverStateChangeListener = new ServerStateChangeListener();
        _runtimeAccess.getServerRuntime().addPropertyChangeListener(serverStateChangeListener);
        return true;
    }

    private static void handleServerUp() {
        WebServicesRuntime.getInstance().startup();
    }

    static {
        AuthenticatedSubject authenticatedSubject = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
        _runtimeAccess = ManagementService.getRuntimeAccess(authenticatedSubject);
        _initialized = false;
    }

    private class ServerStateChangeListener
    implements PropertyChangeListener {
        boolean _serverUp;

        public ServerStateChangeListener() {
            this.interpretState(_runtimeAccess.getServerRuntime().getState());
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if ("State".equals(propertyChangeEvent.getPropertyName())) {
                this.interpretState((String)propertyChangeEvent.getNewValue());
            }
        }

        private void interpretState(String string) {
            if ("RESUMING".equals(string) || "RUNNING".equals(string)) {
                this.setServerUp();
            } else if (!"ADMIN".equals(string)) {
                this.setServerDown();
            }
        }

        private void setServerDown() {
            this._serverUp = false;
        }

        private void setServerUp() {
            if (!this._serverUp) {
                this._serverUp = true;
                WseeService.handleServerUp();
            }
            this._serverUp = true;
        }

        public boolean isServerUp() {
            return this._serverUp;
        }
    }
}

