/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.saaj;

import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import javax.xml.soap.SOAPConnection;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import weblogic.wsee.connection.Connection;
import weblogic.wsee.connection.ConnectionException;
import weblogic.wsee.connection.ConnectionFactory;
import weblogic.wsee.connection.transport.Transport;
import weblogic.wsee.connection.transport.http.HTTPClientTransport;
import weblogic.wsee.message.soap.SoapMessageContext;
import weblogic.xml.saaj.SOAPMessageImpl;

public class SOAPConnectionImpl
extends SOAPConnection {
    private boolean closed = false;

    public SOAPMessage call(SOAPMessage sOAPMessage, Object object) throws SOAPException {
        String string;
        if (this.closed) {
            throw new SOAPException("Connection already closed");
        }
        if (object == null) {
            throw new IllegalArgumentException("Endpoint can not be null");
        }
        if (object instanceof String) {
            string = (String)object;
        } else if (object instanceof URL) {
            string = object.toString();
        } else {
            throw new IllegalArgumentException("Endpoint should be String or URL");
        }
        ConnectionFactory connectionFactory = ConnectionFactory.instance();
        Connection connection = null;
        try {
            connection = string.startsWith("https") ? connectionFactory.createClientConnection("https", SOAPConnectionImpl.getBinding(sOAPMessage)) : connectionFactory.createClientConnection("http", SOAPConnectionImpl.getBinding(sOAPMessage));
        }
        catch (ConnectionException connectionException) {
            throw new SOAPException("Unable to create connection.  Error: ", (Throwable)connectionException);
        }
        SoapMessageContext soapMessageContext = new SoapMessageContext(SOAPConnectionImpl.isSoap12(sOAPMessage));
        soapMessageContext.setProperty("javax.xml.rpc.service.endpoint.address", string);
        soapMessageContext.setMessage(sOAPMessage);
        if (sOAPMessage.getProperty("weblogic.wsee.client.ssladapter") != null) {
            soapMessageContext.setProperty("weblogic.wsee.client.ssladapter", sOAPMessage.getProperty("weblogic.wsee.client.ssladapter"));
        }
        try {
            connection.send(soapMessageContext);
        }
        catch (IOException iOException) {
            throw new SOAPException("Unable to send message.", (Throwable)iOException);
        }
        try {
            Transport transport = connection.getTransport();
            if (transport instanceof HTTPClientTransport && this.confirmOneway(((HTTPClientTransport)transport).getResponseCode())) {
                return null;
            }
            connection.receive(soapMessageContext);
        }
        catch (IOException iOException) {
            throw new SOAPException("Unable to receive message.", (Throwable)iOException);
        }
        return soapMessageContext.getMessage();
    }

    private static boolean isSoap12(SOAPMessage sOAPMessage) throws SOAPException {
        return sOAPMessage.getSOAPPart().getEnvelope().getNamespaceURI().equals("http://www.w3.org/2003/05/soap-envelope");
    }

    private static String getBinding(SOAPMessage sOAPMessage) throws SOAPException {
        return SOAPConnectionImpl.isSoap12(sOAPMessage) ? "SOAP12" : "SOAP11";
    }

    public SOAPMessage get(Object object) throws SOAPException {
        GetSOAPMessageImpl getSOAPMessageImpl = new GetSOAPMessageImpl();
        return this.call((SOAPMessage)getSOAPMessageImpl, object);
    }

    public void close() throws SOAPException {
        if (this.closed) {
            throw new SOAPException("connection already closed");
        }
        this.closed = true;
    }

    private boolean confirmOneway(int n) {
        return n == 202;
    }

    static final class GetSOAPMessageImpl
    extends SOAPMessageImpl {
        GetSOAPMessageImpl() throws SOAPException {
            super("http://www.w3.org/2003/05/soap-envelope");
        }

        public void writeTo(OutputStream outputStream) throws SOAPException, IOException {
        }
    }
}

