/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.security;

import javax.xml.namespace.QName;
import javax.xml.rpc.handler.HandlerInfo;
import javax.xml.rpc.handler.MessageContext;
import javax.xml.rpc.soap.SOAPFaultException;
import weblogic.wsee.handler.WLHandler;
import weblogic.wsee.jaxrpc.soapfault.SOAPFaultUtil;
import weblogic.wsee.message.WlMessageContext;
import weblogic.wsee.message.soap.SoapMessageContext;
import weblogic.wsee.security.AuthorizationContext;
import weblogic.wsee.security.WLAuthorizer;
import weblogic.wsee.util.AccessException;
import weblogic.wsee.ws.WsMethod;

public final class AuthorizationHandler
implements WLHandler {
    private static final QName AUTHENTICATION_FAILURE_11 = new QName("http://schemas.xmlsoap.org/soap/envelope/", "Client.Authentication", "env");
    private static final QName AUTHENTICATION_FAILURE_12 = new QName("http://www.w3.org/2003/05/soap-envelope", "Client.Authentication", "env");
    private String actorOrRole = null;
    private WLAuthorizer authorizer;

    public void init(HandlerInfo handlerInfo) {
    }

    public void destroy() {
    }

    public QName[] getHeaders() {
        return new QName[0];
    }

    public boolean handleRequest(MessageContext messageContext) {
        WlMessageContext wlMessageContext;
        if (this.authorizer == null) {
            this.authorizer = new WLAuthorizer(new AuthorizationContext((String)messageContext.getProperty("weblogic.wsee.application_id"), (String)messageContext.getProperty("weblogic.wsee.context_path"), (String)messageContext.getProperty("weblogic.wsee.security_realm")));
        }
        if (!this.authorizer.isAccessAllowed(wlMessageContext = (WlMessageContext)messageContext)) {
            WsMethod wsMethod = wlMessageContext.getDispatcher().getWsMethod();
            String string = "Access Denied to operation " + wsMethod.getMethodName();
            throw new SOAPFaultException(this.getAuthenticationFailure(((SoapMessageContext)wlMessageContext).isSoap12()), string, this.actorOrRole, SOAPFaultUtil.newDetail((Throwable)new AccessException(string), ((SoapMessageContext)wlMessageContext).isSoap12()));
        }
        return true;
    }

    private QName getAuthenticationFailure(boolean bl) {
        if (bl) {
            return AUTHENTICATION_FAILURE_12;
        }
        return AUTHENTICATION_FAILURE_11;
    }

    public boolean handleResponse(MessageContext messageContext) {
        return true;
    }

    public boolean handleFault(MessageContext messageContext) {
        return true;
    }

    public boolean handleClosure(MessageContext messageContext) {
        return true;
    }
}

