/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.security;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.AuthorizationManager;
import weblogic.security.service.WebServiceResource;
import weblogic.security.spi.Resource;
import weblogic.wsee.handler.DirectInvokeData;
import weblogic.wsee.message.WlMessageContext;
import weblogic.wsee.security.AuthorizationContext;
import weblogic.wsee.security.Authorizer;
import weblogic.wsee.util.ServerSecurityHelper;
import weblogic.wsee.util.Verbose;

public class DirectInvokeAuthorizer
implements Authorizer {
    private final ResourceMap resourceMap = new ResourceMap();
    private AuthorizationManager am;
    private AuthorizationContext authContext;
    private static final boolean verbose = Verbose.isVerbose(DirectInvokeAuthorizer.class);

    public DirectInvokeAuthorizer(AuthorizationContext authorizationContext) {
        this.authContext = authorizationContext;
        this.am = ServerSecurityHelper.getAuthManager(this.authContext.getSecurityRealm());
    }

    public boolean isAccessAllowed(WlMessageContext wlMessageContext) {
        AuthenticatedSubject authenticatedSubject = ServerSecurityHelper.getCurrentSubject();
        Object object = wlMessageContext.getProperty("weblogic.wsee.direct.invoke.data.prop");
        if (object == null || !(object instanceof DirectInvokeData)) {
            return false;
        }
        DirectInvokeData directInvokeData = (DirectInvokeData)object;
        Method method = directInvokeData.getRequest().getMethod();
        String string = wlMessageContext.getDispatcher().getWsdlPort().getName().getLocalPart();
        WebServiceResource webServiceResource = this.getResource(method, string);
        if (verbose) {
            Verbose.log("DirectInvokeAuthorizer got operation " + method.getName() + " and user " + authenticatedSubject + ", using resource " + webServiceResource);
        }
        boolean bl = this.am.isAccessAllowed(authenticatedSubject, (Resource)webServiceResource, null);
        if (verbose) {
            if (bl) {
                Verbose.log("Access granted for subject " + authenticatedSubject + " to resource " + webServiceResource);
            } else {
                Verbose.log("Access denied for subject " + authenticatedSubject + " to resource " + webServiceResource);
            }
        }
        return bl;
    }

    public WebServiceResource getResource(Method method, String string) {
        WebServiceResource webServiceResource = this.lookupResource(method);
        if (webServiceResource == null) {
            webServiceResource = DirectInvokeAuthorizer.createResource(this.authContext, string, method);
            this.cacheResource(method, webServiceResource);
        }
        return webServiceResource;
    }

    private WebServiceResource lookupResource(Method method) {
        return this.resourceMap.get(method);
    }

    private WebServiceResource cacheResource(Method method, WebServiceResource webServiceResource) {
        this.resourceMap.put(method, webServiceResource);
        return webServiceResource;
    }

    private static WebServiceResource createResource(AuthorizationContext authorizationContext, String string, Method method) {
        Class<?>[] classArray;
        String string2 = method.getName();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Class<?> clazz : classArray = method.getParameterTypes()) {
            arrayList.add(clazz.getCanonicalName());
        }
        int n = arrayList.size();
        String[] stringArray = new String[n];
        arrayList.toArray(stringArray);
        WebServiceResource webServiceResource = null;
        if (verbose) {
            Verbose.log("** Args to WebServiceResource");
            Verbose.log("**   methodName = " + string2);
            Verbose.log("**   methodParams = " + stringArray);
        }
        webServiceResource = new WebServiceResource(authorizationContext.getApplicationName(), authorizationContext.getContextPath(), string, string2, stringArray);
        return webServiceResource;
    }

    String getSecurityRealm() {
        return this.authContext.getSecurityRealm();
    }

    protected static class ResourceMap {
        private Map resourceMap = Collections.synchronizedMap(new HashMap());

        protected ResourceMap() {
        }

        protected WebServiceResource get(Method method) {
            return (WebServiceResource)this.resourceMap.get(method);
        }

        protected WebServiceResource put(Method method, WebServiceResource webServiceResource) {
            this.resourceMap.put(method, webServiceResource);
            return webServiceResource;
        }
    }
}

