/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.security;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.security.auth.Subject;
import javax.xml.rpc.handler.soap.SOAPMessageContext;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.AuthorizationManager;
import weblogic.security.service.ContextElement;
import weblogic.security.service.ContextHandler;
import weblogic.security.service.WebServiceResource;
import weblogic.security.spi.Resource;
import weblogic.utils.Debug;
import weblogic.wsee.message.WlMessageContext;
import weblogic.wsee.security.AuthorizationContext;
import weblogic.wsee.security.Authorizer;
import weblogic.wsee.security.configuration.WssConfigurationException;
import weblogic.wsee.security.policy.WssPolicyContext;
import weblogic.wsee.util.ServerSecurityHelper;
import weblogic.wsee.ws.WsMethod;
import weblogic.wsee.ws.WsParameterType;
import weblogic.wsee.ws.dispatch.Dispatcher;
import weblogic.xml.crypto.wss.BinarySecurityTokenHandler;
import weblogic.xml.crypto.wss.SignatureInfo;
import weblogic.xml.crypto.wss.WSSecurityContext;
import weblogic.xml.crypto.wss.WSSecurityException;
import weblogic.xml.crypto.wss.api.BinarySecurityToken;
import weblogic.xml.crypto.wss.provider.SecurityToken;

public class WLAuthorizer
implements Authorizer {
    private final ResourceMap resourceMap = new ResourceMap();
    private AuthorizationManager am;
    private AuthorizationContext authContext;
    private static final String VERBOSE_PROPERTY = "weblogic.wsee.security.verbose";
    private static final String DEBUG_PROPERTY = "weblogic.wsee.security.debug";
    private static final boolean DEBUG = Boolean.getBoolean("weblogic.wsee.security.debug");
    private static final boolean VERBOSE = Boolean.getBoolean("weblogic.wsee.security.verbose");

    public WLAuthorizer(AuthorizationContext authorizationContext) {
        this.authContext = authorizationContext;
        this.am = ServerSecurityHelper.getAuthManager(this.authContext.getSecurityRealm());
    }

    public boolean isAccessAllowed(WlMessageContext wlMessageContext) {
        AuthenticatedSubject authenticatedSubject = ServerSecurityHelper.getCurrentSubject();
        Dispatcher dispatcher = wlMessageContext.getDispatcher();
        WsMethod wsMethod = dispatcher.getWsMethod();
        String string = dispatcher.getWsdlPort().getName().getLocalPart();
        WebServiceContextHandler webServiceContextHandler = new WebServiceContextHandler(wlMessageContext);
        WebServiceResource webServiceResource = this.getResource(wlMessageContext, wsMethod, string, webServiceContextHandler);
        if (VERBOSE) {
            Debug.say((String)("** Authorizer got Operation " + wsMethod.getMethodName() + " and user " + authenticatedSubject));
            Debug.say((String)("** Authorizer using Resource " + webServiceResource));
        }
        if (DEBUG) {
            Debug.assertion((webServiceResource != null ? 1 : 0) != 0, (String)("Failed to retrieve Resource for Operation " + wsMethod));
            Debug.assertion((authenticatedSubject != null ? 1 : 0) != 0, (String)"Failed to retrieve subject for invoke");
        }
        boolean bl = this.am.isAccessAllowed(authenticatedSubject, (Resource)webServiceResource, (ContextHandler)webServiceContextHandler);
        if (VERBOSE) {
            if (bl) {
                Debug.say((String)("** Access granted for subject " + authenticatedSubject + " to Resource " + webServiceResource));
            } else {
                Debug.say((String)("** Access denied for subject " + authenticatedSubject + " to Resource " + webServiceResource));
            }
        }
        return bl;
    }

    public WebServiceResource getResource(WlMessageContext wlMessageContext, WsMethod wsMethod, String string, WebServiceContextHandler webServiceContextHandler) {
        WebServiceResource webServiceResource = this.lookupResource(wsMethod);
        if (webServiceResource == null) {
            if (VERBOSE) {
                Debug.say((String)("** Missed on cache for Operation " + wsMethod.getMethodName()));
            }
            webServiceResource = WLAuthorizer.createResource(wlMessageContext, this.authContext, string, wsMethod, webServiceContextHandler);
            this.cacheResource(wsMethod, webServiceResource);
        } else if (VERBOSE) {
            Debug.say((String)("** Cache hit for Operation " + wsMethod.getMethodName()));
        }
        return webServiceResource;
    }

    private WebServiceResource lookupResource(WsMethod wsMethod) {
        return this.resourceMap.get(wsMethod);
    }

    private WebServiceResource cacheResource(WsMethod wsMethod, WebServiceResource webServiceResource) {
        this.resourceMap.put(wsMethod, webServiceResource);
        return webServiceResource;
    }

    private static WebServiceResource createResource(WlMessageContext wlMessageContext, AuthorizationContext authorizationContext, String string, WsMethod wsMethod, WebServiceContextHandler webServiceContextHandler) {
        String string2;
        if (VERBOSE) {
            Debug.say((String)("** Creating resource for " + wsMethod.getMethodName()));
        }
        if (DEBUG) {
            Debug.assertion((wsMethod != null ? 1 : 0) != 0, (String)"Operation provided WLAuthorizer was null");
        }
        String string3 = wsMethod.getMethodName();
        Iterator iterator = wsMethod.getParameters();
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        while (iterator.hasNext()) {
            WsParameterType wsParameterType = (WsParameterType)iterator.next();
            arrayList2.add(wsParameterType.getJavaType().getCanonicalName());
            string2 = wsParameterType.getName();
            arrayList.add(string2);
            webServiceContextHandler.addParameter(string2, wlMessageContext.getDispatcher());
        }
        int n = arrayList2.size();
        String[] stringArray = new String[n];
        arrayList2.toArray(stringArray);
        String[] stringArray2 = new String[n];
        arrayList.toArray(stringArray2);
        string2 = null;
        if (VERBOSE) {
            Debug.say((String)"** Args to WebServiceResource");
            Debug.say((String)("**   methodName = " + string3));
            Debug.say((String)("**   methodParams = " + stringArray));
            Debug.say((String)("**   paramNames = " + stringArray2));
        }
        string2 = new WebServiceResource(authorizationContext.getApplicationName(), authorizationContext.getContextPath(), string, string3, stringArray);
        if (DEBUG) {
            Debug.assertion((string2 != null ? 1 : 0) != 0, (String)("Failed to create WebServiceResource for " + string3));
        }
        if (VERBOSE) {
            Debug.say((String)("** Created resource " + string2));
        }
        return string2;
    }

    String getSecurityRealm() {
        return this.authContext.getSecurityRealm();
    }

    private static class WebServiceContextHandler
    implements ContextHandler {
        private ArrayList<String> names = new ArrayList();
        private ArrayList<Object> values = new ArrayList();

        WebServiceContextHandler(WlMessageContext wlMessageContext) {
            WssPolicyContext wssPolicyContext;
            WSSecurityContext wSSecurityContext = WSSecurityContext.getSecurityContext(wlMessageContext);
            if (wSSecurityContext != null && (wssPolicyContext = (WssPolicyContext)wlMessageContext.getProperty("weblogic.weblogic.wsee.security.policy.WssPolicyCtx")) != null && wssPolicyContext.getWssConfiguration().isSignatureACLEnabled()) {
                try {
                    BinarySecurityTokenHandler binarySecurityTokenHandler = (BinarySecurityTokenHandler)wssPolicyContext.getWssConfiguration().getTokenHandler("x509", "weblogic.xml.crypto.wss.BinarySecurityTokenHandler");
                    List list = wSSecurityContext.getSecurityTokens("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-x509-token-profile-1.0#X509v3");
                    list.addAll(wSSecurityContext.getSecurityTokens("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-x509-token-profile-1.0#X509v1"));
                    for (BinarySecurityToken binarySecurityToken : list) {
                        Object object;
                        Node node = null;
                        List list2 = wSSecurityContext.getSignatures(binarySecurityToken);
                        Object object2 = list2.iterator();
                        while (object2.hasNext() && (node = WebServiceContextHandler.getSignatureNode((SignatureInfo)(object = (SignatureInfo)object2.next()), wlMessageContext)) == null) {
                        }
                        if (node == null) continue;
                        object2 = "{" + node.getNamespaceURI() + "}" + node.getLocalName();
                        object = "Integrity{" + (String)object2 + "}";
                        Subject subject = binarySecurityTokenHandler.getSubject((SecurityToken)binarySecurityToken, wlMessageContext);
                        if (VERBOSE) {
                            Debug.say((String)("** Add Signature ACL name: " + (String)object));
                            Debug.say((String)("** Add Signature ACL value: " + subject));
                        }
                        this.names.add((String)object);
                        this.values.add(subject);
                    }
                }
                catch (WssConfigurationException wssConfigurationException) {
                }
                catch (WSSecurityException wSSecurityException) {
                    // empty catch block
                }
            }
        }

        public int size() {
            return this.values.size();
        }

        public String[] getNames() {
            return this.names.toArray(new String[0]);
        }

        public final Object getValue(String string) {
            for (int i = 0; i < this.names.size(); ++i) {
                String string2 = this.names.get(i);
                if (!string2.equals(string)) continue;
                return this.values.get(i);
            }
            return null;
        }

        public ContextElement[] getValues(String[] stringArray) {
            ArrayList<ContextElement> arrayList = new ArrayList<ContextElement>();
            for (int i = 0; i < stringArray.length; ++i) {
                String string = stringArray[i];
                Object object = this.getValue(string);
                if (object == null) continue;
                arrayList.add(new ContextElement(string, object));
            }
            return arrayList.toArray(new ContextElement[0]);
        }

        public void addParameter(String string, Dispatcher dispatcher) {
            Map map = dispatcher.getInParams();
            Object v = map.get(string);
            if (v != null) {
                if (VERBOSE) {
                    Debug.say((String)"** Args to ContextHandler");
                    Debug.say((String)("**   paramName = " + string));
                    Debug.say((String)("**   paramValue = " + v));
                }
                this.names.add(string);
                this.values.add(v);
            } else if (VERBOSE) {
                Debug.say((String)("** Can not find param value for param name: " + string));
            }
        }

        private static Node getFirstSigNode(SignatureInfo signatureInfo, Node node) {
            if (signatureInfo.containsNode(node)) {
                return node;
            }
            NodeList nodeList = node.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node2 = nodeList.item(i);
                Node node3 = WebServiceContextHandler.getFirstSigNode(signatureInfo, node2);
                if (node3 == null) continue;
                return node3;
            }
            return null;
        }

        private static Node getSignatureNode(SignatureInfo signatureInfo, WlMessageContext wlMessageContext) {
            Node node = null;
            if (wlMessageContext instanceof SOAPMessageContext) {
                SOAPMessageContext sOAPMessageContext = (SOAPMessageContext)wlMessageContext;
                SOAPMessage sOAPMessage = sOAPMessageContext.getMessage();
                try {
                    node = WebServiceContextHandler.getFirstSigNode(signatureInfo, (Node)sOAPMessage.getSOAPBody());
                    if (node == null) {
                        return WebServiceContextHandler.getFirstSigNode(signatureInfo, (Node)sOAPMessage.getSOAPHeader());
                    }
                }
                catch (SOAPException sOAPException) {
                    // empty catch block
                }
            }
            return node;
        }
    }

    protected static class ResourceMap {
        private Map resourceMap = Collections.synchronizedMap(new HashMap());

        protected ResourceMap() {
        }

        protected WebServiceResource get(WsMethod wsMethod) {
            if (DEBUG) {
                Debug.assertion((wsMethod != null ? 1 : 0) != 0, (String)"WebServiceResource lookup got a null operation");
            }
            return (WebServiceResource)this.resourceMap.get(wsMethod);
        }

        protected WebServiceResource put(WsMethod wsMethod, WebServiceResource webServiceResource) {
            if (DEBUG) {
                Debug.assertion((webServiceResource != null ? 1 : 0) != 0, (String)"WebServiceResource cache got a null resource");
                Debug.assertion((wsMethod != null ? 1 : 0) != 0, (String)"WebServiceResource cache got a null operation");
            }
            this.resourceMap.put(wsMethod, webServiceResource);
            return webServiceResource;
        }
    }
}

