/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.security;

import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import javax.xml.rpc.handler.MessageContext;
import javax.xml.rpc.handler.soap.SOAPMessageContext;
import javax.xml.soap.SOAPException;
import weblogic.kernel.KernelStatus;
import weblogic.security.SSL.TrustManager;
import weblogic.wsee.policy.framework.PolicyAlternative;
import weblogic.wsee.policy.framework.PolicyException;
import weblogic.wsee.security.WssHandler;
import weblogic.wsee.security.bst.PolicyBSTCredentialProvider;
import weblogic.wsee.security.bst.StubPropertyBSTCredProv;
import weblogic.wsee.security.policy.SecurityPolicyAssertionHelper;
import weblogic.wsee.security.saml.SAML2CredentialProvider;
import weblogic.wsee.security.saml.SAMLCredentialProvider;
import weblogic.wsee.security.serviceref.ServiceRefBSTCredProv;
import weblogic.wsee.security.serviceref.ServiceRefTrustManager;
import weblogic.wsee.security.serviceref.ServiceRefUNTCredProv;
import weblogic.wsee.security.wss.SecurityPolicyDriver;
import weblogic.wsee.security.wss.SecurityPolicyException;
import weblogic.wsee.security.wss.SecurityPolicyValidator;
import weblogic.wsee.security.wssc.WSSCCredentialProviderFactory;
import weblogic.xml.crypto.encrypt.api.XMLEncryptionException;
import weblogic.xml.crypto.wss.WSSConstants;
import weblogic.xml.crypto.wss.WSSecurityContext;
import weblogic.xml.crypto.wss.WSSecurityException;
import weblogic.xml.crypto.wss.api.WSSecurityFactory;
import weblogic.xml.crypto.wss.provider.CredentialProvider;
import weblogic.xml.dom.marshal.MarshalException;

public class WssClientHandler
extends WssHandler {
    private boolean autoReset = true;

    public WssClientHandler() {
    }

    public WssClientHandler(boolean bl) {
        this.autoReset = bl;
    }

    protected boolean processRequest(SOAPMessageContext sOAPMessageContext) throws SOAPException, SecurityPolicyException, PolicyException, WSSecurityException {
        PolicyAlternative policyAlternative = WssClientHandler.getRequestPolicyAlternative((MessageContext)sOAPMessageContext);
        PolicyAlternative policyAlternative2 = WssClientHandler.getResponsePolicyAlternative((MessageContext)sOAPMessageContext);
        SecurityPolicyDriver securityPolicyDriver = null;
        securityPolicyDriver = this.getSecurityPolicyDriver(sOAPMessageContext, policyAlternative);
        WssClientHandler.processOutbound(policyAlternative, policyAlternative2, securityPolicyDriver, sOAPMessageContext);
        if (this.autoReset) {
            WSSecurityContext.getSecurityContext((MessageContext)sOAPMessageContext).reset();
        }
        return true;
    }

    protected static void processOutbound(PolicyAlternative policyAlternative, PolicyAlternative policyAlternative2, SecurityPolicyDriver securityPolicyDriver, SOAPMessageContext sOAPMessageContext) throws PolicyException, WSSecurityException, SecurityPolicyException {
        if (policyAlternative == null && policyAlternative2 == null) {
            return;
        }
        try {
            securityPolicyDriver.processOutbound(policyAlternative, policyAlternative2, sOAPMessageContext);
        }
        catch (weblogic.xml.crypto.api.MarshalException marshalException) {
            throw new WSSecurityException(marshalException);
        }
        catch (XMLEncryptionException xMLEncryptionException) {
            throw new WSSecurityException(xMLEncryptionException);
        }
    }

    protected boolean processResponse(SOAPMessageContext sOAPMessageContext) throws PolicyException, SOAPException, SecurityPolicyException, WSSecurityException {
        this.copyEndpointAddress(sOAPMessageContext);
        PolicyAlternative policyAlternative = WssClientHandler.getResponsePolicyAlternative((MessageContext)sOAPMessageContext);
        SecurityPolicyValidator securityPolicyValidator = null;
        securityPolicyValidator = this.getSecurityPolicyValidator(sOAPMessageContext);
        this.processInbound(policyAlternative, securityPolicyValidator, sOAPMessageContext);
        return true;
    }

    protected void fillCredentialProviders(SOAPMessageContext sOAPMessageContext, WSSecurityContext wSSecurityContext, PolicyAlternative policyAlternative) throws WSSecurityException {
        List list;
        CredentialProvider credentialProvider;
        TrustManager trustManager = (TrustManager)sOAPMessageContext.getProperty("weblogic.wsee.security.wss.TrustManager");
        if (trustManager != null) {
            wSSecurityContext.setProperty("weblogic.wsee.security.wss.TrustManager", trustManager);
        } else if (KernelStatus.isServer()) {
            wSSecurityContext.setProperty("weblogic.wsee.security.wss.TrustManager", ServiceRefTrustManager.getInstance());
        }
        List list2 = (List)sOAPMessageContext.getProperty("weblogic.wsee.security.wss.CredentialProviderList");
        if (list2 != null) {
            wSSecurityContext.setCredentialProviders(list2);
        }
        if ((credentialProvider = this.getStubPropCredProv(sOAPMessageContext)) != null) {
            wSSecurityContext.addCredentialProvider(credentialProvider);
        }
        if (KernelStatus.isServer() && (list = this.getServiceRefClientCredProvs()) != null) {
            wSSecurityContext.addCredentialProviders(list);
        }
        if (credentialProvider == null) {
            wSSecurityContext.addCredentialProviders(this.getServerCredProvs(policyAlternative, wSSecurityContext));
        }
        WssClientHandler.addWSSCCredProviders(wSSecurityContext, policyAlternative);
    }

    private static void addWSSCCredProviders(WSSecurityContext wSSecurityContext, PolicyAlternative policyAlternative) {
        String[] stringArray;
        WSSCCredentialProviderFactory wSSCCredentialProviderFactory = WSSCCredentialProviderFactory.getInstance();
        for (String string : stringArray = SecurityPolicyAssertionHelper.getAllSupportedTokenTypes(policyAlternative).toArray(new String[0])) {
            CredentialProvider credentialProvider = wSSCCredentialProviderFactory.getCredentialProvider(string);
            if (credentialProvider == null) continue;
            wSSecurityContext.addCredentialProvider(credentialProvider);
        }
    }

    private CredentialProvider getStubPropCredProv(SOAPMessageContext sOAPMessageContext) throws WSSecurityException {
        X509Certificate x509Certificate = (X509Certificate)sOAPMessageContext.getProperty("weblogic.wsee.security.bst.serverEncryptCert");
        X509Certificate x509Certificate2 = (X509Certificate)sOAPMessageContext.getProperty("weblogic.wsee.security.bst.serverVerifyCert");
        if (x509Certificate == null) {
            if (x509Certificate2 == null) {
                return null;
            }
            throw new WSSecurityException("Invalid to set server's verify certificate but no encryption certificate.");
        }
        return new StubPropertyBSTCredProv(x509Certificate, x509Certificate2);
    }

    private List getServiceRefClientCredProvs() {
        ArrayList<CredentialProvider> arrayList = new ArrayList<CredentialProvider>();
        arrayList.add(new ServiceRefUNTCredProv());
        arrayList.add(new ServiceRefBSTCredProv());
        arrayList.add(new SAMLCredentialProvider());
        arrayList.add(new SAML2CredentialProvider());
        return arrayList;
    }

    private List getServerCredProvs(PolicyAlternative policyAlternative, WSSecurityContext wSSecurityContext) throws WSSecurityException {
        PolicyBSTCredentialProvider policyBSTCredentialProvider = null;
        try {
            policyBSTCredentialProvider = new PolicyBSTCredentialProvider(policyAlternative, wSSecurityContext);
        }
        catch (Exception exception) {
            throw new WSSecurityException("Failed to setup server side credential provider: " + exception.getMessage(), exception);
        }
        ArrayList<PolicyBSTCredentialProvider> arrayList = new ArrayList<PolicyBSTCredentialProvider>();
        arrayList.add(policyBSTCredentialProvider);
        return arrayList;
    }

    protected void processInbound(PolicyAlternative policyAlternative, SecurityPolicyValidator securityPolicyValidator, SOAPMessageContext sOAPMessageContext) throws WSSecurityException, SOAPException, SecurityPolicyException, PolicyException {
        try {
            if (WssClientHandler.hasSecurityHeader(sOAPMessageContext)) {
                this.setupSecurityContext(sOAPMessageContext, null);
                WSSecurityFactory.getInstance();
                WSSecurityFactory.unmarshalAndProcessSecurity(sOAPMessageContext);
            }
            if (policyAlternative != null) {
                securityPolicyValidator.processInbound(policyAlternative, sOAPMessageContext);
            }
        }
        catch (MarshalException marshalException) {
            throw new WSSecurityException(marshalException, WSSConstants.FAILURE_INVALID);
        }
        catch (weblogic.xml.crypto.api.MarshalException marshalException) {
            throw new WSSecurityException(marshalException, WSSConstants.FAILURE_INVALID);
        }
        catch (XMLEncryptionException xMLEncryptionException) {
            throw new WSSecurityException(xMLEncryptionException, WSSConstants.FAILURE_VERIFY_OR_DECRYPT);
        }
    }
}

