/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.security;

import java.util.Iterator;
import weblogic.wsee.handler.HandlerException;
import weblogic.wsee.handler.HandlerList;
import weblogic.wsee.policy.framework.PolicyException;
import weblogic.wsee.policy.runtime.PolicyServer;
import weblogic.wsee.security.configuration.WssConfigurationException;
import weblogic.wsee.security.policy.assertions.SecurityPolicyAssertionFactory;
import weblogic.wsee.ws.WsPort;
import weblogic.wsee.ws.WsService;
import weblogic.wsee.ws.init.WsDeploymentContext;
import weblogic.wsee.ws.init.WsDeploymentException;
import weblogic.wsee.ws.init.WsDeploymentListener;

public abstract class WssDeploymentListener
implements WsDeploymentListener {
    public void process(WsDeploymentContext wsDeploymentContext) throws WsDeploymentException {
        WsService wsService = wsDeploymentContext.getWsService();
        PolicyServer policyServer = wsService.getPolicyServer();
        boolean bl = wsService.isUsingPolicy();
        if (!bl) {
            return;
        }
        Iterator<WsPort> iterator = wsService.getPorts();
        while (iterator.hasNext()) {
            WsPort wsPort = iterator.next();
            try {
                HandlerList handlerList = wsPort.getInternalHandlerList();
                if (SecurityPolicyAssertionFactory.hasSecurityPolicy(wsPort, policyServer)) {
                    this.insertHandler(handlerList);
                    wsService.initWssConfiguration();
                    continue;
                }
                this.removeHandler(handlerList);
            }
            catch (PolicyException policyException) {
                throw new WsDeploymentException("Failed to register SECURITY_HANDLER", policyException);
            }
            catch (HandlerException handlerException) {
                throw new WsDeploymentException("Failed to register SECURITY_HANDLER", handlerException);
            }
            catch (WssConfigurationException wssConfigurationException) {
                throw new WsDeploymentException("Failed to register SECURITY_HANDLER", wssConfigurationException);
            }
        }
    }

    protected abstract void insertHandler(HandlerList var1) throws HandlerException;

    protected abstract void removeHandler(HandlerList var1);
}

