/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.security;

import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.rpc.JAXRPCException;
import javax.xml.rpc.handler.GenericHandler;
import javax.xml.rpc.handler.MessageContext;
import javax.xml.rpc.handler.soap.SOAPMessageContext;
import javax.xml.rpc.soap.SOAPFaultException;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPHeader;
import org.w3c.dom.NodeList;
import weblogic.utils.Debug;
import weblogic.wsee.message.WlMessageContext;
import weblogic.wsee.message.soap.SoapMessageContext;
import weblogic.wsee.policy.framework.NormalizedExpression;
import weblogic.wsee.policy.framework.PolicyAlternative;
import weblogic.wsee.policy.framework.PolicyException;
import weblogic.wsee.policy.runtime.PolicyContext;
import weblogic.wsee.security.configuration.TimestampConfiguration;
import weblogic.wsee.security.configuration.WssConfigurationException;
import weblogic.wsee.security.policy.WssPolicyContext;
import weblogic.wsee.security.util.FaultUtils;
import weblogic.wsee.security.wss.SecurityPolicyDriver;
import weblogic.wsee.security.wss.SecurityPolicyException;
import weblogic.wsee.security.wss.SecurityPolicyValidator;
import weblogic.wsee.security.wss.policy.SecurityPolicyInspectionException;
import weblogic.wsee.ws.WsService;
import weblogic.xml.crypto.wss.SecurityBuilder;
import weblogic.xml.crypto.wss.SecurityBuilderFactory;
import weblogic.xml.crypto.wss.SecurityValidator;
import weblogic.xml.crypto.wss.SecurityValidatorFactory;
import weblogic.xml.crypto.wss.TimestampHandler;
import weblogic.xml.crypto.wss.WSSConstants;
import weblogic.xml.crypto.wss.WSSecurityContext;
import weblogic.xml.crypto.wss.WSSecurityException;
import weblogic.xml.crypto.wss.provider.CredentialProvider;
import weblogic.xml.crypto.wss.provider.SecurityTokenHandler;

public abstract class WssHandler
extends GenericHandler {
    public static final String VERBOSE_PROPERTY = "weblogic.wsee.security.WssHandler";
    public static final boolean VERBOSE = Boolean.getBoolean("weblogic.wsee.security.WssHandler");
    private static QName[] headers = new QName[]{WSSConstants.SECURITY_QNAME};

    public QName[] getHeaders() {
        return headers;
    }

    public boolean handleRequest(MessageContext messageContext) throws JAXRPCException, SOAPFaultException {
        if (VERBOSE) {
            Debug.say((String)(((Object)((Object)this)).getClass() + ".handleRequest"));
        }
        if (!(messageContext instanceof SOAPMessageContext)) {
            return true;
        }
        SOAPMessageContext sOAPMessageContext = (SOAPMessageContext)messageContext;
        this.copyEndpointAddress(sOAPMessageContext);
        Exception exception = null;
        try {
            try {
                this.processRequest(sOAPMessageContext);
            }
            catch (SecurityPolicyException securityPolicyException) {
                exception = securityPolicyException;
                FaultUtils.setSOAPFault(securityPolicyException, (SoapMessageContext)sOAPMessageContext);
                return false;
            }
            catch (PolicyException policyException) {
                exception = policyException;
                FaultUtils.setSOAPFault(policyException, (SoapMessageContext)sOAPMessageContext);
                return false;
            }
            catch (SecurityPolicyInspectionException securityPolicyInspectionException) {
                exception = securityPolicyInspectionException;
                FaultUtils.setSOAPFault(securityPolicyInspectionException, (SoapMessageContext)sOAPMessageContext);
                return false;
            }
            catch (WSSecurityException wSSecurityException) {
                WSSecurityException wSSecurityException2;
                exception = wSSecurityException;
                if (!FaultUtils.isDebug()) {
                    wSSecurityException2 = new WSSecurityException("Unknown exception, internal system processing error.");
                }
                FaultUtils.setSOAPFault(wSSecurityException2, (SoapMessageContext)sOAPMessageContext);
                return false;
            }
            catch (SOAPException sOAPException) {
                throw new JAXRPCException((Throwable)sOAPException);
            }
        }
        catch (SOAPException sOAPException) {
            throw new JAXRPCException((Throwable)exception);
        }
        return true;
    }

    protected void copyEndpointAddress(SOAPMessageContext sOAPMessageContext) {
        String string = (String)sOAPMessageContext.getProperty("javax.xml.rpc.service.endpoint.address");
        sOAPMessageContext.setProperty("weblogic.wsee.security.wss.end_point_url", (Object)string);
    }

    public boolean handleResponse(MessageContext messageContext) throws JAXRPCException {
        if (VERBOSE) {
            Debug.say((String)(((Object)((Object)this)).getClass() + ".handleResponse"));
        }
        if (!(messageContext instanceof SOAPMessageContext)) {
            return true;
        }
        SOAPMessageContext sOAPMessageContext = (SOAPMessageContext)messageContext;
        Exception exception = null;
        try {
            try {
                this.processResponse(sOAPMessageContext);
            }
            catch (SecurityPolicyException securityPolicyException) {
                exception = securityPolicyException;
                WssHandler.setFault(securityPolicyException, sOAPMessageContext);
                return false;
            }
            catch (PolicyException policyException) {
                exception = policyException;
                WssHandler.setFault(policyException, sOAPMessageContext);
                return false;
            }
            catch (WSSecurityException wSSecurityException) {
                exception = wSSecurityException;
                WssHandler.setFault(wSSecurityException, (SoapMessageContext)sOAPMessageContext);
                return false;
            }
            catch (SOAPException sOAPException) {
                throw new JAXRPCException((Throwable)sOAPException);
            }
        }
        catch (SOAPException sOAPException) {
            throw new JAXRPCException((Throwable)exception);
        }
        return true;
    }

    private static void setFault(Exception exception, SOAPMessageContext sOAPMessageContext) throws SOAPException {
        FaultUtils.setSOAPFault(exception, (SoapMessageContext)sOAPMessageContext);
        sOAPMessageContext.setProperty("weblogic.wsee.security.fault", (Object)true);
    }

    protected SecurityPolicyDriver getSecurityPolicyDriver(SOAPMessageContext sOAPMessageContext, PolicyAlternative policyAlternative) throws SOAPException, WSSecurityException {
        WSSecurityContext wSSecurityContext = this.setupSecurityContext(sOAPMessageContext, policyAlternative);
        SecurityBuilder securityBuilder = SecurityBuilderFactory.newSecurityBuilder(wSSecurityContext);
        return new SecurityPolicyDriver(securityBuilder, wSSecurityContext);
    }

    protected SecurityPolicyValidator getSecurityPolicyValidator(SOAPMessageContext sOAPMessageContext) throws SOAPException, WSSecurityException {
        SecurityPolicyValidator securityPolicyValidator;
        WSSecurityContext wSSecurityContext = this.setupSecurityContext(sOAPMessageContext, null);
        SecurityValidator securityValidator = SecurityValidatorFactory.newSecurityValidator(wSSecurityContext);
        WssPolicyContext wssPolicyContext = (WssPolicyContext)sOAPMessageContext.getProperty("weblogic.weblogic.wsee.security.policy.WssPolicyCtx");
        if (wssPolicyContext == null) {
            securityPolicyValidator = new SecurityPolicyValidator(securityValidator);
        } else {
            TimestampConfiguration timestampConfiguration = wssPolicyContext.getWssConfiguration().getTimestampConfig();
            securityPolicyValidator = new SecurityPolicyValidator(securityValidator, timestampConfiguration);
        }
        return securityPolicyValidator;
    }

    protected static PolicyAlternative getResponsePolicyAlternative(MessageContext messageContext) throws PolicyException {
        NormalizedExpression normalizedExpression = PolicyContext.getResponseEffectivePolicy(messageContext);
        return normalizedExpression.getPolicyAlternative();
    }

    protected static PolicyAlternative getRequestPolicyAlternative(MessageContext messageContext) throws PolicyException {
        NormalizedExpression normalizedExpression = PolicyContext.getRequestEffectivePolicy(messageContext);
        return normalizedExpression.getPolicyAlternative();
    }

    protected static boolean hasSecurityHeader(SOAPMessageContext sOAPMessageContext) throws SOAPException {
        SOAPHeader sOAPHeader = sOAPMessageContext.getMessage().getSOAPHeader();
        if (sOAPHeader == null) {
            return false;
        }
        NodeList nodeList = sOAPHeader.getElementsByTagNameNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "Security");
        return nodeList.getLength() != 0;
    }

    protected WSSecurityContext setupSecurityContext(SOAPMessageContext sOAPMessageContext, PolicyAlternative policyAlternative) throws SOAPException, WSSecurityException {
        WSSecurityContext wSSecurityContext = WSSecurityContext.getSecurityContext((MessageContext)sOAPMessageContext);
        if (wSSecurityContext == null) {
            wSSecurityContext = new WSSecurityContext(sOAPMessageContext);
        } else {
            wSSecurityContext.init(sOAPMessageContext);
        }
        this.fillTokenHandlers(sOAPMessageContext, wSSecurityContext);
        this.fillCredentialProviders(sOAPMessageContext, wSSecurityContext, policyAlternative);
        return wSSecurityContext;
    }

    protected void fillCredentialProviders(SOAPMessageContext sOAPMessageContext, WSSecurityContext wSSecurityContext, PolicyAlternative policyAlternative) throws WSSecurityException {
        WssPolicyContext wssPolicyContext = this.getPolicyContext(sOAPMessageContext);
        List list = wssPolicyContext.getWssConfiguration().getCredentialProviders();
        for (CredentialProvider credentialProvider : list) {
            wSSecurityContext.setCredentialProvider(credentialProvider);
        }
    }

    protected void fillTokenHandlers(SOAPMessageContext sOAPMessageContext, WSSecurityContext wSSecurityContext) throws WssConfigurationException {
        Object object2;
        WssPolicyContext wssPolicyContext = this.getPolicyContext(sOAPMessageContext);
        List list = wssPolicyContext.getWssConfiguration().getTokenHandlers();
        for (Object object2 : list) {
            wSSecurityContext.setTokenHandler((SecurityTokenHandler)object2);
        }
        Object object3 = wssPolicyContext.getWssConfiguration().getTimestampConfig();
        if (object3 == null) {
            object3 = new TimestampConfiguration();
        }
        wSSecurityContext.setTimestampHandler((TimestampHandler)object3);
        object2 = wssPolicyContext.getWssConfiguration().getPolicySelectionPreference();
        if (null != object2 && null == sOAPMessageContext.getProperty("weblogic.wsee.policy.selection.preference")) {
            sOAPMessageContext.setProperty("weblogic.wsee.policy.selection.preference", object2);
        }
    }

    private WssPolicyContext getPolicyContext(SOAPMessageContext sOAPMessageContext) {
        WssPolicyContext wssPolicyContext = (WssPolicyContext)sOAPMessageContext.getProperty("weblogic.weblogic.wsee.security.policy.WssPolicyCtx");
        if (wssPolicyContext == null) {
            WlMessageContext wlMessageContext = WlMessageContext.narrow((MessageContext)sOAPMessageContext);
            WsService wsService = wlMessageContext.getDispatcher().getWsPort().getEndpoint().getService();
            wssPolicyContext = wsService.getWssPolicyContext();
            sOAPMessageContext.setProperty("weblogic.weblogic.wsee.security.policy.WssPolicyCtx", (Object)wssPolicyContext);
        }
        return wssPolicyContext;
    }

    protected abstract boolean processRequest(SOAPMessageContext var1) throws SecurityPolicyException, PolicyException, SOAPException, WSSecurityException;

    protected abstract boolean processResponse(SOAPMessageContext var1) throws SecurityPolicyException, PolicyException, SOAPException, WSSecurityException;
}

