/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.security;

import javax.xml.rpc.handler.MessageContext;
import javax.xml.rpc.handler.soap.SOAPMessageContext;
import javax.xml.soap.SOAPException;
import weblogic.wsee.handler.WLHandler;
import weblogic.wsee.message.WlMessageContext;
import weblogic.wsee.policy.framework.PolicyAlternative;
import weblogic.wsee.policy.framework.PolicyException;
import weblogic.wsee.security.WssHandler;
import weblogic.wsee.security.wss.SecurityPolicyDriver;
import weblogic.wsee.security.wss.SecurityPolicyException;
import weblogic.xml.crypto.encrypt.api.XMLEncryptionException;
import weblogic.xml.crypto.wss.WSSConstants;
import weblogic.xml.crypto.wss.WSSecurityContext;
import weblogic.xml.crypto.wss.WSSecurityException;
import weblogic.xml.crypto.wss.api.WSSecurityFactory;
import weblogic.xml.dom.marshal.MarshalException;

public class WssServerHandler
extends WssHandler
implements WLHandler {
    protected boolean processRequest(SOAPMessageContext sOAPMessageContext) throws WSSecurityException, SOAPException, SecurityPolicyException, PolicyException {
        try {
            if (!WssServerHandler.hasSecurityHeader(sOAPMessageContext)) {
                return true;
            }
            this.setupSecurityContext(sOAPMessageContext, null);
            WSSecurityFactory.getInstance();
            WSSecurityFactory.unmarshalAndProcessSecurity(sOAPMessageContext);
        }
        catch (MarshalException marshalException) {
            Throwable throwable = marshalException.getCause();
            if (throwable instanceof WSSecurityException) {
                throw (WSSecurityException)throwable;
            }
            if (throwable instanceof SOAPException) {
                throw (SOAPException)throwable;
            }
            throw new WSSecurityException(marshalException, WSSConstants.FAILURE_INVALID);
        }
        return true;
    }

    protected boolean processResponse(SOAPMessageContext sOAPMessageContext) throws WSSecurityException, SecurityPolicyException, SOAPException, PolicyException {
        WlMessageContext wlMessageContext = WlMessageContext.narrow((MessageContext)sOAPMessageContext);
        if (wlMessageContext.hasFault() || (wlMessageContext.getProperty("weblogic.wsee.queued.invoke") != null || wlMessageContext.getProperty("weblogic.wsee.enable.rm") != null && wlMessageContext.getProperty("weblogic.wsee.async.res") == null) && wlMessageContext.getProperty("weblogic.wsee.reliable.oneway.reply") == null) {
            return true;
        }
        PolicyAlternative policyAlternative = WssServerHandler.getResponsePolicyAlternative((MessageContext)sOAPMessageContext);
        SecurityPolicyDriver securityPolicyDriver = this.getSecurityPolicyDriver(sOAPMessageContext, null);
        try {
            WssServerHandler.processOutbound(policyAlternative, securityPolicyDriver, sOAPMessageContext);
        }
        catch (weblogic.xml.crypto.api.MarshalException marshalException) {
            throw new WSSecurityException(marshalException);
        }
        catch (XMLEncryptionException xMLEncryptionException) {
            throw new WSSecurityException(xMLEncryptionException);
        }
        return true;
    }

    protected static void processOutbound(PolicyAlternative policyAlternative, SecurityPolicyDriver securityPolicyDriver, SOAPMessageContext sOAPMessageContext) throws PolicyException, WSSecurityException, SecurityPolicyException, weblogic.xml.crypto.api.MarshalException, XMLEncryptionException {
        if (policyAlternative == null) {
            return;
        }
        WSSecurityContext.getSecurityContext((MessageContext)sOAPMessageContext).reset();
        securityPolicyDriver.processOutbound(policyAlternative, sOAPMessageContext);
    }

    protected void fillCredentialProviders(SOAPMessageContext sOAPMessageContext, WSSecurityContext wSSecurityContext, PolicyAlternative policyAlternative) throws WSSecurityException {
        super.fillCredentialProviders(sOAPMessageContext, wSSecurityContext, policyAlternative);
    }

    public boolean handleClosure(MessageContext messageContext) {
        WlMessageContext wlMessageContext = WlMessageContext.narrow(messageContext);
        if (wlMessageContext.getProperty("weblogic.wsee.reliable.oneway.reply") != null) {
            return this.handleResponse(messageContext);
        }
        return true;
    }
}

