/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.security;

import javax.xml.rpc.handler.MessageContext;
import javax.xml.rpc.handler.soap.SOAPMessageContext;
import javax.xml.soap.SOAPException;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.wsee.policy.framework.PolicyAlternative;
import weblogic.wsee.policy.framework.PolicyException;
import weblogic.wsee.security.WssServerHandler;
import weblogic.wsee.security.wss.SecurityPolicyException;
import weblogic.wsee.security.wss.SecurityPolicyValidator;
import weblogic.xml.crypto.api.MarshalException;
import weblogic.xml.crypto.encrypt.api.XMLEncryptionException;
import weblogic.xml.crypto.wss.WSSecurityContext;
import weblogic.xml.crypto.wss.WSSecurityException;

public class WssServerPolicyHandler
extends WssServerHandler {
    public boolean processRequest(SOAPMessageContext sOAPMessageContext) throws WSSecurityException, SOAPException, SecurityPolicyException, PolicyException {
        PolicyAlternative policyAlternative = WssServerPolicyHandler.getRequestPolicyAlternative((MessageContext)sOAPMessageContext);
        SecurityPolicyValidator securityPolicyValidator = this.getSecurityPolicyValidator(sOAPMessageContext);
        try {
            this.processInbound(policyAlternative, securityPolicyValidator, sOAPMessageContext);
        }
        catch (XMLEncryptionException xMLEncryptionException) {
            throw new WSSecurityException(xMLEncryptionException);
        }
        catch (MarshalException marshalException) {
            throw new WSSecurityException(marshalException);
        }
        return true;
    }

    public boolean processResponse(SOAPMessageContext sOAPMessageContext) throws WSSecurityException, SecurityPolicyException, SOAPException, PolicyException {
        return true;
    }

    protected void processInbound(PolicyAlternative policyAlternative, SecurityPolicyValidator securityPolicyValidator, SOAPMessageContext sOAPMessageContext) throws WSSecurityException, SOAPException, SecurityPolicyException, XMLEncryptionException, MarshalException, PolicyException {
        WSSecurityContext wSSecurityContext;
        AuthenticatedSubject authenticatedSubject;
        if (policyAlternative != null) {
            securityPolicyValidator.processInbound(policyAlternative, sOAPMessageContext);
        }
        if ((authenticatedSubject = (wSSecurityContext = WSSecurityContext.getSecurityContext((MessageContext)sOAPMessageContext)).getSubject()) != null) {
            this.setSubject(authenticatedSubject, sOAPMessageContext);
        }
    }

    private void setSubject(AuthenticatedSubject authenticatedSubject, SOAPMessageContext sOAPMessageContext) {
        sOAPMessageContext.setProperty("weblogic.wsee.wss.subject", (Object)authenticatedSubject);
    }
}

