/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.security.bst;

import java.io.Serializable;
import java.security.PrivateKey;
import java.security.cert.CertPath;
import java.security.cert.X509Certificate;
import weblogic.security.service.ContextHandler;
import weblogic.wsee.security.bst.BST11CredentialProvider;
import weblogic.wsee.security.util.CertUtils;
import weblogic.xml.crypto.wss.BSTUtils;
import weblogic.xml.crypto.wss.X509Credential;
import weblogic.xml.crypto.wss.provider.Purpose;

public class ClientBSTCredentialProvider
extends BST11CredentialProvider
implements Serializable {
    private X509Credential clientCredential;
    private X509Credential serverPublicCert;

    public ClientBSTCredentialProvider(String string, String string2, String string3, String string4) throws Exception {
        this(string, string2, string3, string4, "JKS", null);
    }

    public ClientBSTCredentialProvider(String string, String string2, String string3, String string4, String string5) throws Exception {
        this(string, string2, string3, string4, string5, null);
    }

    public ClientBSTCredentialProvider(String string, String string2, String string3, String string4, String string5, X509Certificate x509Certificate) throws Exception {
        this((X509Certificate)CertUtils.getCertificate(string, string2, string3, string5).get(0), CertUtils.getPrivateKey(string3, string4, string, string5, string2), x509Certificate);
    }

    public ClientBSTCredentialProvider(String string, String string2) throws Exception {
        this(CertUtils.getCertificate(string), CertUtils.getPKCS8PrivateKey(string2), null);
    }

    public ClientBSTCredentialProvider(String string, String string2, String string3) throws Exception {
        this(CertUtils.getCertificate(string), CertUtils.getPKCS8PrivateKey(string2), CertUtils.getCertificate(string3));
    }

    public ClientBSTCredentialProvider(X509Certificate x509Certificate, PrivateKey privateKey, X509Certificate x509Certificate2) {
        this.clientCredential = new X509Credential(x509Certificate, privateKey);
        if (x509Certificate2 != null) {
            this.serverPublicCert = new X509Credential(x509Certificate2);
        }
    }

    public ClientBSTCredentialProvider(CertPath certPath, PrivateKey privateKey) {
        this.clientCredential = new X509Credential(certPath, privateKey);
    }

    public ClientBSTCredentialProvider(X509Certificate x509Certificate, CertPath certPath, PrivateKey privateKey) {
        this.clientCredential = new X509Credential(certPath, privateKey);
        if (x509Certificate != null) {
            this.serverPublicCert = new X509Credential(x509Certificate);
        }
    }

    public void setServerCertificate(X509Certificate x509Certificate) {
        this.serverPublicCert = x509Certificate != null ? new X509Credential(x509Certificate) : null;
    }

    public Object getCredential(String string, String string2, ContextHandler contextHandler, Purpose purpose) {
        if (this.serverPublicCert != null && (purpose == null || ClientBSTCredentialProvider.isForEncryption(purpose) || ClientBSTCredentialProvider.isForVerification(purpose)) && BSTUtils.matches(this.serverPublicCert, contextHandler)) {
            return this.serverPublicCert;
        }
        if (this.clientCredential != null && (purpose == null || ClientBSTCredentialProvider.isForIdentity(purpose) || ClientBSTCredentialProvider.isForSigning(purpose) || ClientBSTCredentialProvider.isForResponseEncryption(purpose) || ClientBSTCredentialProvider.isForDecryption(purpose)) && (string2 == null || this.clientCredential.getCertificate().getIssuerX500Principal().getName().equals(string2)) && BSTUtils.matches(this.clientCredential, contextHandler)) {
            return this.clientCredential;
        }
        return null;
    }

    public ClientBSTCredentialProvider cloneAndReplaceServerCert(X509Certificate x509Certificate) {
        ClientBSTCredentialProvider clientBSTCredentialProvider = null;
        try {
            clientBSTCredentialProvider = (ClientBSTCredentialProvider)this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            clientBSTCredentialProvider = this.clientCredential != null ? new ClientBSTCredentialProvider(this.clientCredential.getCertificate(), this.clientCredential.getPrivateKey(), x509Certificate) : new ClientBSTCredentialProvider(null, null, x509Certificate);
        }
        clientBSTCredentialProvider.setServerCertificate(x509Certificate);
        return clientBSTCredentialProvider;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[ClientBSTCredentialProvider: clientCred=");
        stringBuffer.append(this.clientCredential != null && this.clientCredential.getCertificate() != null ? this.clientCredential.getCertificate().getSubjectDN() : "none");
        stringBuffer.append(" serverCert=");
        stringBuffer.append(this.serverPublicCert != null && this.serverPublicCert.getCertificate() != null ? this.serverPublicCert.getCertificate().getSubjectDN() : "none");
        stringBuffer.append("]");
        return stringBuffer.toString();
    }
}

