/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.security.bst;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Set;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import weblogic.security.SSL.TrustManager;
import weblogic.security.service.ContextHandler;
import weblogic.utils.encoders.BASE64Decoder;
import weblogic.wsee.policy.framework.PolicyAlternative;
import weblogic.wsee.security.bst.BSTCredentialProvider;
import weblogic.wsee.security.policy.assertions.ConfidentialityAssertion;
import weblogic.wsee.security.policy.assertions.xbeans.ConfidentialityDocument;
import weblogic.wsee.security.policy.assertions.xbeans.KeyInfoType;
import weblogic.wsee.security.policy.assertions.xbeans.SecurityTokenReferenceType;
import weblogic.xml.crypto.utils.DOMUtils;
import weblogic.xml.crypto.wss.BSTUtils;
import weblogic.xml.crypto.wss.WSSecurityContext;
import weblogic.xml.crypto.wss.WSSecurityException;
import weblogic.xml.crypto.wss.X509Credential;
import weblogic.xml.crypto.wss.provider.Purpose;

public class PolicyBSTCredentialProvider
extends BSTCredentialProvider {
    private X509Credential serverCredential = null;

    public PolicyBSTCredentialProvider(PolicyAlternative policyAlternative, WSSecurityContext wSSecurityContext) throws IOException, CertificateException, WSSecurityException {
        if (policyAlternative == null) {
            return;
        }
        Set set = policyAlternative.getAssertions(ConfidentialityAssertion.class);
        block0: for (ConfidentialityAssertion confidentialityAssertion : set) {
            ConfidentialityDocument.Confidentiality confidentiality = confidentialityAssertion.getXbean().getConfidentiality();
            KeyInfoType keyInfoType = confidentiality.getKeyInfo();
            SecurityTokenReferenceType[] securityTokenReferenceTypeArray = keyInfoType.getSecurityTokenReferenceArray();
            for (int i = 0; securityTokenReferenceTypeArray != null && i < securityTokenReferenceTypeArray.length; ++i) {
                NodeList nodeList;
                SecurityTokenReferenceType securityTokenReferenceType = securityTokenReferenceTypeArray[i];
                NodeList nodeList2 = ((Element)securityTokenReferenceType.newDomNode().getFirstChild()).getElementsByTagNameNS("http://www.bea.com/wls90/security/policy", "Embedded");
                if (nodeList2 == null || nodeList2.getLength() <= 0 || (nodeList = ((Element)nodeList2.item(0)).getElementsByTagNameNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "BinarySecurityToken")) == null || nodeList.getLength() <= 0) continue;
                String string = DOMUtils.getText((Element)nodeList.item(0));
                byte[] byArray = new BASE64Decoder().decodeBuffer(string);
                CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
                X509Certificate x509Certificate = (X509Certificate)certificateFactory.generateCertificate(new ByteArrayInputStream(byArray));
                if (!this.isTrusted(x509Certificate, wSSecurityContext)) {
                    throw new WSSecurityException("Server cert not trusted.");
                }
                this.serverCredential = new X509Credential(x509Certificate);
                continue block0;
            }
        }
    }

    public Object getCredential(String string, String string2, ContextHandler contextHandler, Purpose purpose) {
        if (this.serverCredential != null && (purpose == null || PolicyBSTCredentialProvider.isForEncryption(purpose) || PolicyBSTCredentialProvider.isForVerification(purpose)) && BSTUtils.matches(this.serverCredential, contextHandler)) {
            return this.serverCredential;
        }
        return null;
    }

    private boolean isTrusted(X509Certificate x509Certificate, WSSecurityContext wSSecurityContext) throws WSSecurityException {
        TrustManager trustManager = (TrustManager)wSSecurityContext.getProperty("weblogic.wsee.security.wss.TrustManager");
        if (trustManager == null) {
            throw new WSSecurityException("No TrustManager set.");
        }
        X509Certificate[] x509CertificateArray = new X509Certificate[]{x509Certificate};
        return trustManager.certificateCallback(x509CertificateArray, 16);
    }
}

