/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.security.bst;

import java.io.File;
import java.security.AccessController;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.List;
import weblogic.management.provider.ManagementService;
import weblogic.management.provider.RuntimeAccess;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.ContextHandler;
import weblogic.security.service.PrivilegedActions;
import weblogic.security.utils.KeyStoreConfigurationHelper;
import weblogic.security.utils.KeyStoreInfo;
import weblogic.security.utils.KeyStoreUtils;
import weblogic.security.utils.MBeanKeyStoreConfiguration;
import weblogic.wsee.security.bst.BST11CredentialProvider;
import weblogic.wsee.security.configuration.WssConfigurationException;
import weblogic.wsee.util.Verbose;
import weblogic.xml.crypto.utils.CertUtils;
import weblogic.xml.crypto.wss.BSTUtils;
import weblogic.xml.crypto.wss.WssPolicyContextHandler;
import weblogic.xml.crypto.wss.X509Credential;
import weblogic.xml.crypto.wss.provider.Purpose;

public class ServerBSTCredentialProvider
extends BST11CredentialProvider {
    private static X509Credential SSLKeyPairCredential = null;
    private X509Credential credForIntegrity = null;
    private X509Credential credForConfidentiality = null;
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());

    public Object getCredential(String string, String string2, ContextHandler contextHandler, Purpose purpose) {
        if (contextHandler instanceof WssPolicyContextHandler) {
            if (ServerBSTCredentialProvider.isForEncryption(purpose)) {
                return this.credForConfidentiality;
            }
            return null;
        }
        if (ServerBSTCredentialProvider.isForEncryption(purpose)) {
            return null;
        }
        if ((ServerBSTCredentialProvider.isForSigning(purpose) || ServerBSTCredentialProvider.isForIdentity(purpose)) && BSTUtils.matches(this.credForIntegrity, contextHandler)) {
            return this.credForIntegrity;
        }
        if (ServerBSTCredentialProvider.isForDecryption(purpose) && BSTUtils.matches(this.credForConfidentiality, contextHandler)) {
            return this.credForConfidentiality;
        }
        if (ServerBSTCredentialProvider.isForVerification(purpose) && BSTUtils.matches(this.credForIntegrity, contextHandler)) {
            return this.credForIntegrity;
        }
        return null;
    }

    public void initCredentials(WssPolicyContextHandler wssPolicyContextHandler) throws WssConfigurationException {
        KeyStoreConfigurationHelper keyStoreConfigurationHelper = new KeyStoreConfigurationHelper(MBeanKeyStoreConfiguration.getInstance());
        if (SSLKeyPairCredential == null) {
            this.initSSLCredential(keyStoreConfigurationHelper);
        }
        this.credForIntegrity = ServerBSTCredentialProvider.initCredentialFromContext(wssPolicyContextHandler, keyStoreConfigurationHelper, true);
        this.credForConfidentiality = ServerBSTCredentialProvider.initCredentialFromContext(wssPolicyContextHandler, keyStoreConfigurationHelper, false);
    }

    private static X509Credential initCredentialFromContext(WssPolicyContextHandler wssPolicyContextHandler, KeyStoreConfigurationHelper keyStoreConfigurationHelper, boolean bl) throws WssConfigurationException {
        KeyStore keyStore;
        Object object;
        char[] cArray;
        String string;
        char[] cArray2;
        String string2;
        if (bl) {
            string2 = (String)wssPolicyContextHandler.getValue("IntegrityKeyAlias");
            cArray2 = (char[])ServerBSTCredentialProvider.convertToCharArrayObject(wssPolicyContextHandler.getValue("IntegrityKeyPassword"));
            string = (String)wssPolicyContextHandler.getValue("IntegrityKeyStore");
            cArray = (char[])ServerBSTCredentialProvider.convertToCharArrayObject(wssPolicyContextHandler.getValue("IntegrityKeyStorePassword"));
        } else {
            string2 = (String)wssPolicyContextHandler.getValue("ConfidentialityKeyAlias");
            cArray2 = (char[])ServerBSTCredentialProvider.convertToCharArrayObject(wssPolicyContextHandler.getValue("ConfidentialityKeyPassword"));
            string = (String)wssPolicyContextHandler.getValue("ConfidentialityKeyStore");
            cArray = (char[])ServerBSTCredentialProvider.convertToCharArrayObject(wssPolicyContextHandler.getValue("ConfidentialityKeyStorePassword"));
        }
        if (string2 == null) {
            return SSLKeyPairCredential;
        }
        if (cArray2 == null) {
            throw new WssConfigurationException("Must specify private key pass for alias: " + string2);
        }
        if (string == null) {
            object = keyStoreConfigurationHelper.getIdentityKeyStore();
            if (object == null) {
                throw new WssConfigurationException("can't find the keystore of alias: " + string2);
            }
            keyStore = KeyStoreUtils.load(ServerBSTCredentialProvider.getKeyStoreFile(((KeyStoreInfo)object).getFileName()), ((KeyStoreInfo)object).getPassPhrase(), ((KeyStoreInfo)object).getType());
        } else {
            if (cArray == null) {
                throw new WssConfigurationException("Must specify keystore passphase for keystore: " + string);
            }
            keyStore = KeyStoreUtils.load(ServerBSTCredentialProvider.getKeyStoreFile(string), cArray, ServerBSTCredentialProvider.getKeyStoreType(wssPolicyContextHandler));
        }
        object = ServerBSTCredentialProvider.getX509Credential(keyStore, string2, cArray2);
        if (bl && !CertUtils.supportsSign(((X509Credential)object).getCertificate())) {
            throw new WssConfigurationException("Key/Certificate specified for integrity does not support signing.");
        }
        if (!bl && !CertUtils.supportsKeyEncrypt(((X509Credential)object).getCertificate())) {
            throw new WssConfigurationException("Key/Certificate specified for confidentiality does not support key encryption.");
        }
        return object;
    }

    private static String getKeyStoreType(WssPolicyContextHandler wssPolicyContextHandler) {
        String string = (String)wssPolicyContextHandler.getValue("KeyStoreType");
        if (string == null) {
            string = "JKS";
        }
        return string;
    }

    private static X509Credential getX509Credential(KeyStore keyStore, String string, char[] cArray) throws WssConfigurationException {
        try {
            Key key = keyStore.getKey(string, cArray);
            if (!(key instanceof PrivateKey)) {
                throw new WssConfigurationException("Private Key not found");
            }
            Certificate[] certificateArray = keyStore.getCertificateChain(string);
            if (certificateArray == null) {
                throw new WssConfigurationException("Can not find any public key for alias: " + string);
            }
            List<Certificate> list = Arrays.asList(certificateArray);
            if (list.size() < 1) {
                throw new WssConfigurationException("Certificate not found");
            }
            return new X509Credential((X509Certificate)list.get(0), (PrivateKey)key);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new WssConfigurationException(noSuchAlgorithmException);
        }
        catch (UnrecoverableKeyException unrecoverableKeyException) {
            throw new WssConfigurationException(unrecoverableKeyException);
        }
        catch (KeyStoreException keyStoreException) {
            throw new WssConfigurationException(keyStoreException);
        }
    }

    private static File getKeyStoreFile(String string) throws WssConfigurationException {
        File file = new File(string);
        if (!file.exists() && !(file = new File(ManagementService.getRuntimeAccess(kernelId).getServer().getRootDirectory(), string)).exists()) {
            throw new WssConfigurationException("KeyStoreFile does not exist");
        }
        return file;
    }

    private void initSSLCredential(KeyStoreConfigurationHelper keyStoreConfigurationHelper) throws WssConfigurationException {
        Provider[] providerArray;
        KeyStoreInfo keyStoreInfo = keyStoreConfigurationHelper.getIdentityKeyStore();
        if (keyStoreInfo == null) {
            return;
        }
        String string = keyStoreInfo.getFileName();
        if (string == null || string.length() == 0) {
            throw new WssConfigurationException("KeyStoreFilename not supplied");
        }
        File file = ServerBSTCredentialProvider.getKeyStoreFile(string);
        String string2 = keyStoreInfo.getType();
        char[] cArray = keyStoreInfo.getPassPhrase();
        String string3 = keyStoreConfigurationHelper.getIdentityAlias();
        char[] cArray2 = keyStoreConfigurationHelper.getIdentityPrivateKeyPassPhrase();
        if (string3 == null || string3.length() == 0) {
            throw new WssConfigurationException("Certificate Alias not supplied");
        }
        if (cArray2 == null) {
            throw new WssConfigurationException("PassPhrase not supplied");
        }
        if (verbose) {
            Verbose.log("KeyStore File:  " + file.getAbsolutePath());
            Verbose.log("KeyStore Type:  " + string2);
            Verbose.log("KeyStore Alias: " + string3);
            providerArray = Security.getProviders();
            Verbose.log("Security Providers:  ");
            for (int i = 0; i < providerArray.length; ++i) {
                Verbose.log("  " + providerArray[i].getName() + "  " + providerArray[i].getVersion());
            }
        }
        if ((providerArray = KeyStoreUtils.load(file, cArray, string2)) == null) {
            throw new WssConfigurationException("Unable to load KeyStore");
        }
        this.credForIntegrity = SSLKeyPairCredential = ServerBSTCredentialProvider.getX509Credential((KeyStore)providerArray, string3, cArray2);
        this.credForConfidentiality = SSLKeyPairCredential;
    }

    public static boolean isSSLUsingKeyStores() {
        RuntimeAccess runtimeAccess = ManagementService.getRuntimeAccess(kernelId);
        if (runtimeAccess != null) {
            return "KeyStores".equals(runtimeAccess.getServer().getSSL().getIdentityAndTrustLocations());
        }
        return false;
    }

    private static Object convertToCharArrayObject(Object object) {
        if (object instanceof String) {
            return ((String)object).toCharArray();
        }
        return object;
    }
}

