/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.security.bst;

import java.security.cert.X509Certificate;
import weblogic.security.service.ContextHandler;
import weblogic.wsee.security.bst.BSTCredentialProvider;
import weblogic.xml.crypto.wss.BSTUtils;
import weblogic.xml.crypto.wss.X509Credential;
import weblogic.xml.crypto.wss.provider.Purpose;

public class StubPropertyBSTCredProv
extends BSTCredentialProvider {
    public static final String SERVER_VERIFY_CERT = "weblogic.wsee.security.bst.serverVerifyCert";
    public static final String SERVER_ENCRYPT_CERT = "weblogic.wsee.security.bst.serverEncryptCert";
    private X509Credential serverVerifyCred = null;
    private X509Credential serverEncryptCred = null;

    public StubPropertyBSTCredProv(X509Certificate x509Certificate, X509Certificate x509Certificate2) {
        if (x509Certificate == null) {
            throw new IllegalArgumentException("Server encrypt certificate can't be null.");
        }
        this.serverEncryptCred = new X509Credential(x509Certificate);
        this.serverVerifyCred = new X509Credential(x509Certificate2);
    }

    public Object getCredential(String string, String string2, ContextHandler contextHandler, Purpose purpose) {
        if (StubPropertyBSTCredProv.isForEncryption(purpose) && BSTUtils.matches(this.serverEncryptCred, contextHandler)) {
            return this.serverEncryptCred;
        }
        if (this.serverVerifyCred != null && StubPropertyBSTCredProv.isForVerification(purpose) && BSTUtils.matches(this.serverVerifyCred, contextHandler)) {
            return this.serverVerifyCred;
        }
        return null;
    }

    public StubPropertyBSTCredProv cloneAndReplaceServerCert(X509Certificate x509Certificate) {
        if (this.serverVerifyCred != null) {
            return new StubPropertyBSTCredProv(x509Certificate, this.serverVerifyCred.getCertificate());
        }
        return new StubPropertyBSTCredProv(x509Certificate, null);
    }
}

