/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.security.configuration;

import java.security.AccessController;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedHashMap;
import weblogic.management.configuration.ConfigurationPropertyMBean;
import weblogic.management.configuration.DomainMBean;
import weblogic.management.configuration.WebserviceCredentialProviderMBean;
import weblogic.management.configuration.WebserviceSecurityConfigurationMBean;
import weblogic.management.configuration.WebserviceSecurityMBean;
import weblogic.management.configuration.WebserviceSecurityTokenMBean;
import weblogic.management.configuration.WebserviceTimestampMBean;
import weblogic.management.configuration.WebserviceTokenHandlerMBean;
import weblogic.management.provider.ManagementService;
import weblogic.management.provider.RuntimeAccess;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.wsee.security.configuration.MBeanConstants;
import weblogic.xml.crypto.wss.WssPolicyContextHandler;

public final class MBeanHelper {
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());

    public static WebserviceSecurityMBean createDefaultWSMBean(DomainMBean domainMBean) {
        WebserviceSecurityMBean webserviceSecurityMBean = domainMBean.createWebserviceSecurity("default_wss");
        WebserviceTokenHandlerMBean webserviceTokenHandlerMBean = MBeanHelper.createTokenHandlerMBean(webserviceSecurityMBean, "default_ut_handler", "weblogic.xml.crypto.wss.UsernameTokenHandler", "ut", 1);
        WebserviceCredentialProviderMBean webserviceCredentialProviderMBean = MBeanHelper.createCredentialProviderMBean(webserviceSecurityMBean, "default_ut_cp", "weblogic.xml.crypto.wss.UNTCredentialProvider", "ut");
        WebserviceTokenHandlerMBean webserviceTokenHandlerMBean2 = MBeanHelper.createTokenHandlerMBean(webserviceSecurityMBean, "default_x509_handler", "weblogic.xml.crypto.wss.BinarySecurityTokenHandler", "x509", 2);
        ConfigurationPropertyMBean configurationPropertyMBean = MBeanHelper.createConfigPropertyMBean(webserviceTokenHandlerMBean2, "UseX509ForIdentity", "true", false);
        WebserviceCredentialProviderMBean webserviceCredentialProviderMBean2 = MBeanHelper.createCredentialProviderMBean(webserviceSecurityMBean, "default_x509_cp", "weblogic.wsee.security.bst.ServerBSTCredentialProvider", "x509");
        return webserviceSecurityMBean;
    }

    public static WebserviceTokenHandlerMBean createTokenHandlerMBean(WebserviceSecurityMBean webserviceSecurityMBean, String string, String string2, String string3, int n) {
        WebserviceTokenHandlerMBean webserviceTokenHandlerMBean = webserviceSecurityMBean.createWebserviceTokenHandler(string);
        webserviceTokenHandlerMBean.setClassName(string2);
        webserviceTokenHandlerMBean.setTokenType(string3);
        webserviceTokenHandlerMBean.setHandlingOrder(n);
        return webserviceTokenHandlerMBean;
    }

    public static WebserviceCredentialProviderMBean createCredentialProviderMBean(WebserviceSecurityMBean webserviceSecurityMBean, String string, String string2, String string3) {
        WebserviceCredentialProviderMBean webserviceCredentialProviderMBean = webserviceSecurityMBean.createWebserviceCredentialProvider(string);
        webserviceCredentialProviderMBean.setClassName(string2);
        webserviceCredentialProviderMBean.setTokenType(string3);
        return webserviceCredentialProviderMBean;
    }

    public static ConfigurationPropertyMBean createConfigPropertyMBean(WebserviceSecurityConfigurationMBean webserviceSecurityConfigurationMBean, String string, String string2, boolean bl) {
        ConfigurationPropertyMBean configurationPropertyMBean = webserviceSecurityConfigurationMBean.createConfigurationProperty(string);
        if (bl) {
            configurationPropertyMBean.setEncryptValueRequired(true);
            configurationPropertyMBean.setEncryptedValue(string2);
        } else {
            configurationPropertyMBean.setValue(string2);
        }
        return configurationPropertyMBean;
    }

    public static WebserviceSecurityMBean lookupWebserviceSecurityMBean(DomainMBean domainMBean, String string) {
        if (domainMBean == null) {
            return null;
        }
        return domainMBean.lookupWebserviceSecurity(string);
    }

    public static WebserviceSecurityMBean lookupWebserviceSecurityMBean(String string) {
        return MBeanHelper.lookupWebserviceSecurityMBean(MBeanHelper.getDomainMBean(), string);
    }

    public static String[] getTokenHandlerClassNames(WebserviceSecurityMBean webserviceSecurityMBean) {
        OrderedList orderedList = new OrderedList(MBeanConstants.BUILTIN_TOKEN_TYPES, MBeanConstants.BUILTIN_TOKEN_HANDLERS);
        if (webserviceSecurityMBean != null) {
            WebserviceTokenHandlerMBean[] webserviceTokenHandlerMBeanArray = webserviceSecurityMBean.getWebserviceTokenHandlers();
            Arrays.sort(webserviceTokenHandlerMBeanArray, new Comparator(){

                public int compare(Object object, Object object2) {
                    return ((WebserviceTokenHandlerMBean)object).getHandlingOrder() - ((WebserviceTokenHandlerMBean)object2).getHandlingOrder();
                }
            });
            for (int i = 0; i < webserviceTokenHandlerMBeanArray.length; ++i) {
                orderedList.add(webserviceTokenHandlerMBeanArray[i].getTokenType(), webserviceTokenHandlerMBeanArray[i].getClassName());
            }
        }
        return orderedList.getValues();
    }

    public static String[] getTokenHandlerClassNames(DomainMBean domainMBean, String string) {
        return MBeanHelper.getTokenHandlerClassNames(MBeanHelper.lookupWebserviceSecurityMBean(domainMBean, string));
    }

    public static String[] getTokenHandlerClassNames(String string) {
        return MBeanHelper.getTokenHandlerClassNames(MBeanHelper.getDomainMBean(), string);
    }

    public static String[] getCredentialProviderClassNames(WebserviceSecurityMBean webserviceSecurityMBean) {
        OrderedList orderedList = new OrderedList(MBeanConstants.BUILTIN_TOKEN_TYPES, MBeanConstants.BUILTIN_CREDENTIAL_PROVIDERS);
        if (webserviceSecurityMBean != null) {
            WebserviceCredentialProviderMBean[] webserviceCredentialProviderMBeanArray = webserviceSecurityMBean.getWebserviceCredentialProviders();
            for (int i = 0; i < webserviceCredentialProviderMBeanArray.length; ++i) {
                orderedList.add(webserviceCredentialProviderMBeanArray[i].getTokenType(), webserviceCredentialProviderMBeanArray[i].getClassName());
            }
        }
        return orderedList.getValues();
    }

    public static String[] getCredentialProviderClassNames(DomainMBean domainMBean, String string) {
        return MBeanHelper.getCredentialProviderClassNames(MBeanHelper.lookupWebserviceSecurityMBean(domainMBean, string));
    }

    public static String[] getCredentialProviderClassNames(String string) {
        return MBeanHelper.getCredentialProviderClassNames(MBeanHelper.getDomainMBean(), string);
    }

    public static String[] getSecurityTokenClassNames(WebserviceSecurityMBean webserviceSecurityMBean) {
        OrderedList orderedList = new OrderedList(MBeanConstants.BUILTIN_TOKEN_TYPES, MBeanConstants.BUILTIN_TOKENS);
        if (webserviceSecurityMBean != null) {
            WebserviceSecurityTokenMBean[] webserviceSecurityTokenMBeanArray = webserviceSecurityMBean.getWebserviceSecurityTokens();
            for (int i = 0; i < webserviceSecurityTokenMBeanArray.length; ++i) {
                orderedList.add(webserviceSecurityTokenMBeanArray[i].getTokenType(), webserviceSecurityTokenMBeanArray[i].getClassName());
            }
        }
        return orderedList.getValues();
    }

    public static String getCredentialProviderClass(WebserviceSecurityMBean webserviceSecurityMBean, String string, String string2) {
        String string3 = string2;
        if (webserviceSecurityMBean != null) {
            WebserviceCredentialProviderMBean[] webserviceCredentialProviderMBeanArray = webserviceSecurityMBean.getWebserviceCredentialProviders();
            for (int i = 0; i < webserviceCredentialProviderMBeanArray.length; ++i) {
                WebserviceCredentialProviderMBean webserviceCredentialProviderMBean = webserviceCredentialProviderMBeanArray[i];
                if (!webserviceCredentialProviderMBean.getTokenType().equals(string)) continue;
                string3 = webserviceCredentialProviderMBean.getClassName();
                break;
            }
        }
        return string3;
    }

    public static String getTokenHandlerClass(WebserviceSecurityMBean webserviceSecurityMBean, String string, String string2) {
        String string3 = null;
        if (webserviceSecurityMBean != null) {
            WebserviceTokenHandlerMBean[] webserviceTokenHandlerMBeanArray = webserviceSecurityMBean.getWebserviceTokenHandlers();
            for (int i = 0; i < webserviceTokenHandlerMBeanArray.length; ++i) {
                WebserviceTokenHandlerMBean webserviceTokenHandlerMBean = webserviceTokenHandlerMBeanArray[i];
                if (!webserviceTokenHandlerMBean.getTokenType().equals(string)) continue;
                string3 = webserviceTokenHandlerMBean.getClassName();
                break;
            }
        }
        if (string2 != null && string3 == null) {
            string3 = string2;
        }
        if (string3 == null) {
            for (int i = 0; i < MBeanConstants.BUILTIN_TOKEN_TYPES.length; ++i) {
                if (!MBeanConstants.BUILTIN_TOKEN_TYPES[i].equals(string)) continue;
                string3 = MBeanConstants.BUILTIN_TOKEN_HANDLERS[i];
            }
        }
        return string3;
    }

    public static String getSecurityTokenClass(WebserviceSecurityMBean webserviceSecurityMBean, String string, String string2) {
        String string3 = string2;
        WebserviceSecurityTokenMBean[] webserviceSecurityTokenMBeanArray = webserviceSecurityMBean.getWebserviceSecurityTokens();
        for (int i = 0; i < webserviceSecurityTokenMBeanArray.length; ++i) {
            WebserviceSecurityTokenMBean webserviceSecurityTokenMBean = webserviceSecurityTokenMBeanArray[i];
            if (!webserviceSecurityTokenMBean.getTokenType().equals(string)) continue;
            string3 = webserviceSecurityTokenMBean.getClassName();
            break;
        }
        return string3;
    }

    public static Object getConfigPropertyValue(WebserviceSecurityConfigurationMBean webserviceSecurityConfigurationMBean, String string) {
        ConfigurationPropertyMBean configurationPropertyMBean = webserviceSecurityConfigurationMBean.lookupConfigurationProperty(string);
        if (configurationPropertyMBean == null) {
            return null;
        }
        return MBeanHelper.getConfigPropertyValue(configurationPropertyMBean);
    }

    public static Object getTokenHandlerProperty(WebserviceSecurityMBean webserviceSecurityMBean, String string, Object object) {
        Object object2 = null;
        if (webserviceSecurityMBean != null) {
            WebserviceTokenHandlerMBean[] webserviceTokenHandlerMBeanArray = webserviceSecurityMBean.getWebserviceTokenHandlers();
            for (int i = 0; i < webserviceTokenHandlerMBeanArray.length && (object2 = MBeanHelper.getConfigPropertyValue(webserviceTokenHandlerMBeanArray[i], string)) == null; ++i) {
            }
        }
        if (object2 == null) {
            object2 = object;
        }
        return object2;
    }

    public static boolean getTokenHandlerPropertyBoolean(WebserviceSecurityMBean webserviceSecurityMBean, String string, boolean bl) {
        Object object = MBeanHelper.getTokenHandlerProperty(webserviceSecurityMBean, string, null);
        if (object == null) {
            return bl;
        }
        return Boolean.parseBoolean((String)object);
    }

    public static Object getCredentialProviderProperty(WebserviceSecurityMBean webserviceSecurityMBean, String string, Object object) {
        Object object2 = null;
        if (webserviceSecurityMBean != null) {
            WebserviceCredentialProviderMBean[] webserviceCredentialProviderMBeanArray = webserviceSecurityMBean.getWebserviceCredentialProviders();
            for (int i = 0; i < webserviceCredentialProviderMBeanArray.length && (object2 = MBeanHelper.getConfigPropertyValue(webserviceCredentialProviderMBeanArray[i], string)) == null; ++i) {
            }
        }
        if (object2 == null) {
            object2 = object;
        }
        return object2;
    }

    public static Object getCredentialProviderProperty(WebserviceSecurityMBean webserviceSecurityMBean, String string, String string2, Object object) {
        Object object2 = null;
        if (webserviceSecurityMBean != null) {
            WebserviceCredentialProviderMBean[] webserviceCredentialProviderMBeanArray = webserviceSecurityMBean.getWebserviceCredentialProviders();
            for (int i = 0; i < webserviceCredentialProviderMBeanArray.length; ++i) {
                if (!webserviceCredentialProviderMBeanArray[i].getClassName().equals(string)) continue;
                object2 = MBeanHelper.getConfigPropertyValue(webserviceCredentialProviderMBeanArray[i], string2);
                break;
            }
        }
        if (object2 == null) {
            object2 = object;
        }
        return object2;
    }

    public static WebserviceTimestampMBean getTimestampConfig(WebserviceSecurityMBean webserviceSecurityMBean) {
        if (webserviceSecurityMBean != null) {
            return webserviceSecurityMBean.getWebserviceTimestamp();
        }
        return null;
    }

    public static String getDefaultCredentialProviderSTSURI(WebserviceSecurityMBean webserviceSecurityMBean) {
        if (webserviceSecurityMBean != null) {
            return webserviceSecurityMBean.getDefaultCredentialProviderSTSURI();
        }
        return null;
    }

    static DomainMBean getDomainMBean() {
        RuntimeAccess runtimeAccess = ManagementService.getRuntimeAccess(kernelId);
        if (runtimeAccess == null) {
            return null;
        }
        return runtimeAccess.getDomain();
    }

    static void fillConfigProperties(WebserviceSecurityMBean webserviceSecurityMBean, WssPolicyContextHandler wssPolicyContextHandler) {
        if (webserviceSecurityMBean == null) {
            return;
        }
        MBeanHelper.fillConfigProperties(webserviceSecurityMBean.getWebserviceTokenHandlers(), wssPolicyContextHandler);
        MBeanHelper.fillConfigProperties(webserviceSecurityMBean.getWebserviceCredentialProviders(), wssPolicyContextHandler);
    }

    private static void fillConfigProperties(WebserviceSecurityConfigurationMBean[] webserviceSecurityConfigurationMBeanArray, WssPolicyContextHandler wssPolicyContextHandler) {
        for (int i = 0; i < webserviceSecurityConfigurationMBeanArray.length; ++i) {
            ConfigurationPropertyMBean[] configurationPropertyMBeanArray = webserviceSecurityConfigurationMBeanArray[i].getConfigurationProperties();
            for (int j = 0; j < configurationPropertyMBeanArray.length; ++j) {
                ConfigurationPropertyMBean configurationPropertyMBean = configurationPropertyMBeanArray[j];
                wssPolicyContextHandler.addContextElement(configurationPropertyMBean.getName(), MBeanHelper.getConfigPropertyValue(configurationPropertyMBean));
            }
        }
    }

    private static Object getConfigPropertyValue(ConfigurationPropertyMBean configurationPropertyMBean) {
        if (configurationPropertyMBean.isEncryptValueRequired()) {
            String string = configurationPropertyMBean.getEncryptedValue();
            if (string != null && string.length() > 0) {
                return string.toCharArray();
            }
            return null;
        }
        return configurationPropertyMBean.getValue();
    }

    private static class OrderedList {
        private LinkedHashMap customVals = new LinkedHashMap();
        private String[] tokenTypes;
        private String[] defaultVals;

        public OrderedList(String[] stringArray, String[] stringArray2) {
            this.tokenTypes = stringArray;
            this.defaultVals = stringArray2;
        }

        public void add(String string, String string2) {
            if (this.customVals.get(string) != null) {
                throw new IllegalArgumentException("duplicate tokenType: " + string + " found.");
            }
            this.customVals.put(string, string2);
        }

        public String[] getValues() {
            LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
            linkedHashMap.putAll(this.customVals);
            for (int i = 0; i < this.tokenTypes.length; ++i) {
                if (this.customVals.get(this.tokenTypes[i]) != null) continue;
                linkedHashMap.put(this.tokenTypes[i], this.defaultVals[i]);
            }
            return linkedHashMap.values().toArray(new String[0]);
        }
    }
}

