/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.security.configuration;

import java.util.Calendar;
import java.util.GregorianCalendar;
import javax.xml.rpc.soap.SOAPFaultException;
import weblogic.descriptor.BeanUpdateEvent;
import weblogic.descriptor.BeanUpdateFailedException;
import weblogic.descriptor.BeanUpdateListener;
import weblogic.descriptor.BeanUpdateRejectedException;
import weblogic.descriptor.DescriptorBean;
import weblogic.management.configuration.WebserviceTimestampMBean;
import weblogic.xml.crypto.utils.LogUtils;
import weblogic.xml.crypto.wss.TimestampHandler;
import weblogic.xml.crypto.wss.api.Timestamp;

public class TimestampConfiguration
implements TimestampHandler,
BeanUpdateListener {
    public static final String DEBUG_PROPERTY = "weblogic.xml.crypto.wss.debug";
    public static final boolean DEBUG = Boolean.getBoolean("weblogic.xml.crypto.wss.debug");
    public static final String VERBOSE_PROPERTY = "weblogic.xml.crypto.wss.verbose";
    public static final boolean VERBOSE = Boolean.getBoolean("weblogic.xml.crypto.wss.verbose");
    public static final String ASSUME_SYNCHRONIZED_CLOCKS = "weblogic.wsee.security.clock.synchronized";
    public static final String CLOCK_PRECISION = "weblogic.wsee.security.clock.precision";
    private boolean useClockSkew = true;
    public static final String CLOCK_SKEW = "weblogic.wsee.security.clock.skew";
    public static final String LAX_CLOCK_PRECISION = "weblogic.wsee.security.clock.precision.lax";
    public static final String MAX_PROCESSING_DELAY = "weblogic.wsee.security.delay.max";
    public static final String VALIDITY_PERIOD = "weblogic.wsee.security.validity";
    public static final int DEFAULT_VALIDITY = 60;
    public static final long MILLI_PRECISION = 1L;
    public static final long SECOND_PRECISION = 1000L;
    public static final long MINUTE_PRECISION = 60000L;
    public static final long HOUR_PRECISION = 3600000L;
    public static final long DAY_PRECISION = 86400000L;
    public static final long WEEK_PRECISION = 604800000L;
    public static final long MONTH_PRECISION = 2592000000L;
    public static final long YEAR_PRECISION = 31536000000L;
    public static final long DEFAULT_CLOCK_PRECISION = 60000L;
    public static final long DEFAULT_CLOCK_SKEW = 60000L;
    public static final int NO_MAX_PROCESSING_DELAY = -1;
    private boolean clockSynchronized = true;
    private long clockPrecision = 60000L;
    private long clockSkew = 60000L;
    private boolean laxPrecision = false;
    private long maxProcessingDelay = -1L;
    private int validityPeriod = 60;

    public TimestampConfiguration() {
        this(null);
    }

    public TimestampConfiguration(WebserviceTimestampMBean webserviceTimestampMBean) {
        this.init(webserviceTimestampMBean);
        if (webserviceTimestampMBean != null) {
            webserviceTimestampMBean.addBeanUpdateListener(this);
        }
    }

    public void checkExpiration(Calendar calendar, Calendar calendar2) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        this.checkExpiration(gregorianCalendar, calendar, calendar2, -1);
    }

    public void checkExpiration(Calendar calendar, Calendar calendar2, int n) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        this.checkExpiration(gregorianCalendar, calendar, calendar2, n);
    }

    public void checkExpiration(Calendar calendar, Calendar calendar2, Calendar calendar3) {
        this.checkExpiration(calendar, calendar2, calendar3, -1);
    }

    public void checkExpiration(Calendar calendar, Calendar calendar2, Calendar calendar3, int n) {
        long l = calendar.getTimeInMillis();
        if (calendar2 == null) {
            return;
        }
        long l2 = calendar2.getTimeInMillis();
        long l3 = calendar3 != null ? calendar3.getTimeInMillis() : 0L;
        LogUtils.debugWss("*************TIMESTAMP VALIDATION: ");
        LogUtils.debugWss("created = " + calendar2.getTime());
        LogUtils.debugWss("now = " + calendar.getTime());
        if (calendar3 != null) {
            LogUtils.debugWss("expiry = " + calendar3.getTime());
        } else {
            LogUtils.debugWss("expiry not set");
        }
        LogUtils.debugWss("longCreated = " + l2);
        LogUtils.debugWss("longNow = " + l);
        LogUtils.debugWss("clockSkew used = " + this.getClockSkew());
        LogUtils.debugWss("clockSkew = " + this.clockSkew);
        LogUtils.debugWss("clockPrecision = " + this.clockPrecision);
        LogUtils.debugWss("useClockSkew = " + this.useClockSkew);
        LogUtils.debugWss("clockSynchronized = " + this.clockSynchronized);
        LogUtils.debugWss("maxProcessingDelay = " + this.maxProcessingDelay);
        LogUtils.logWss("TIMESTAMP VALIDATION: ");
        LogUtils.logWss("created = " + calendar2.getTime());
        LogUtils.logWss("now = " + calendar.getTime());
        if (calendar3 != null) {
            LogUtils.logWss("expiry = " + calendar3.getTime());
        } else {
            LogUtils.logWss("expiry not set");
        }
        LogUtils.logWss("clockSkew used = " + this.getClockSkew());
        if (!this.clockSynchronized) {
            if (calendar3 != null) {
                throw new SOAPFaultException(EXPIRED_FAULTCODE, "Message includes expiry but clocks are not synchronized", null, null);
            }
        } else {
            long l4;
            if (this.isFreshnessEnforced() && (l4 = l2 + this.getClockSkew() + this.maxProcessingDelay) < l) {
                throw new SOAPFaultException(EXPIRED_FAULTCODE, "Message is too old", null, null);
            }
            if (l + this.getClockSkew() < l2) {
                throw new SOAPFaultException(EXPIRED_FAULTCODE, "Message Created time past the current time even accounting for set clock skew", null, null);
            }
            if (n == -9999) {
                LogUtils.logWss("Bypass timeage check due to message age set to = " + n);
                return;
            }
            if (calendar3 != null && l3 + this.getClockSkew() < l) {
                throw new SOAPFaultException(EXPIRED_FAULTCODE, "Message Expires time has passed", null, null);
            }
            if (n >= 0 && l2 + (long)(n * 1000) + this.getClockSkew() < l) {
                throw new SOAPFaultException(EXPIRED_FAULTCODE, "Message older than allowed MessageAge", null, null);
            }
        }
    }

    private void init(WebserviceTimestampMBean webserviceTimestampMBean) {
        String string;
        if (DEBUG && webserviceTimestampMBean != null) {
            string = webserviceTimestampMBean.getName();
            LogUtils.debugWss("TimestampConfiguration.init");
            LogUtils.debugWss("name = " + string);
            if (webserviceTimestampMBean.getParent() != null) {
                LogUtils.debugWss("wtm.parent.name = " + webserviceTimestampMBean.getParent().getName());
            }
        }
        if ((string = System.getProperty(ASSUME_SYNCHRONIZED_CLOCKS)) != null) {
            this.clockSynchronized = Boolean.parseBoolean(string);
        } else if (webserviceTimestampMBean != null) {
            this.clockSynchronized = webserviceTimestampMBean.isClockSynchronized();
        }
        boolean bl = true;
        boolean bl2 = true;
        string = System.getProperty(CLOCK_PRECISION);
        if (string != null) {
            this.clockPrecision = Long.parseLong(string);
        } else if (webserviceTimestampMBean != null) {
            this.clockPrecision = webserviceTimestampMBean.getClockPrecision();
            if (!webserviceTimestampMBean.isSet("ClockPrecision")) {
                bl = false;
            }
        } else {
            bl = false;
        }
        string = System.getProperty(CLOCK_SKEW);
        if (string != null) {
            this.clockSkew = Long.parseLong(string);
        } else if (webserviceTimestampMBean != null) {
            this.clockSkew = webserviceTimestampMBean.getClockSkew();
            if (!webserviceTimestampMBean.isSet("ClockSkew")) {
                bl2 = false;
            }
        } else {
            bl2 = false;
        }
        if (webserviceTimestampMBean != null) {
            LogUtils.debugWss("isSet.clockSkew = " + webserviceTimestampMBean.isSet("ClockSkew"));
            LogUtils.debugWss("isSet.clockPrecision = " + webserviceTimestampMBean.isSet("ClockPrecision"));
        }
        LogUtils.debugWss("skewSet = " + bl2);
        LogUtils.debugWss("precisionSet = " + bl);
        this.useClockSkew = bl2 || !bl;
        string = System.getProperty(LAX_CLOCK_PRECISION);
        if (string != null) {
            this.laxPrecision = Boolean.parseBoolean(string);
        } else if (webserviceTimestampMBean != null) {
            this.laxPrecision = webserviceTimestampMBean.isLaxPrecision();
        }
        string = System.getProperty(MAX_PROCESSING_DELAY);
        if (string != null) {
            this.maxProcessingDelay = Long.parseLong(string);
        } else if (webserviceTimestampMBean != null) {
            this.maxProcessingDelay = webserviceTimestampMBean.getMaxProcessingDelay();
        }
        string = System.getProperty(VALIDITY_PERIOD);
        if (string != null) {
            this.validityPeriod = Integer.parseInt(string);
        } else if (webserviceTimestampMBean != null) {
            this.validityPeriod = webserviceTimestampMBean.getValidityPeriod();
        }
    }

    public void setMessageAge(int n) {
        this.validityPeriod = n;
    }

    public int getMessageAge() {
        return this.validityPeriod;
    }

    private boolean isFreshnessEnforced() {
        return this.maxProcessingDelay != -1L;
    }

    private long getClockSkew() {
        if (this.useClockSkew) {
            return this.clockSkew;
        }
        return this.clockPrecision;
    }

    public void validate(Calendar calendar) throws SOAPFaultException {
        this.checkExpiration(calendar, null, this.validityPeriod);
    }

    public void validate(Timestamp timestamp, short s) {
        this.checkExpiration(timestamp.getCreated(), timestamp.getExpires(), s);
    }

    public void prepareUpdate(BeanUpdateEvent beanUpdateEvent) throws BeanUpdateRejectedException {
    }

    public void activateUpdate(BeanUpdateEvent beanUpdateEvent) throws BeanUpdateFailedException {
        LogUtils.debugWss("In activateUpdate of Timestamp.");
        DescriptorBean descriptorBean = beanUpdateEvent.getProposedBean();
        LogUtils.debugWss("bean = " + descriptorBean);
        if (descriptorBean instanceof WebserviceTimestampMBean) {
            this.init((WebserviceTimestampMBean)descriptorBean);
        }
    }

    public void rollbackUpdate(BeanUpdateEvent beanUpdateEvent) {
    }
}

