/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.security.configuration;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.xml.rpc.handler.MessageContext;
import weblogic.kernel.KernelStatus;
import weblogic.management.configuration.WebserviceSecurityMBean;
import weblogic.wsee.policy.util.PolicySelectionPreference;
import weblogic.wsee.security.bst.ServerBSTCredentialProvider;
import weblogic.wsee.security.configuration.MBeanConstants;
import weblogic.wsee.security.configuration.MBeanHelper;
import weblogic.wsee.security.configuration.TimestampConfiguration;
import weblogic.wsee.security.configuration.WssConfigurationException;
import weblogic.wsee.security.wssc.utils.WSSCCompatibilityUtil;
import weblogic.xml.crypto.wss.BinarySecurityTokenHandler;
import weblogic.xml.crypto.wss.ClientUNTHandler;
import weblogic.xml.crypto.wss.SecurityUtils;
import weblogic.xml.crypto.wss.UsernameTokenHandler;
import weblogic.xml.crypto.wss.WssPolicyContextHandler;
import weblogic.xml.crypto.wss.api.NonceValidator;
import weblogic.xml.crypto.wss.nonce.NonceValidatorFactory;
import weblogic.xml.crypto.wss.provider.CredentialProvider;
import weblogic.xml.crypto.wss.provider.SecurityTokenHandler;
import weblogic.xml.crypto.wss11.internal.bst.ClientBSTHandler;

public class WssConfiguration {
    public static final String WSS_CONFIGURATION_CTX_PROP = "weblogic.wsee.security.wssconfig";
    private static final String CRED_PROVIDER_SYS_PROP = "weblogic.xml.crypto.wss.provider.CredentialProvider";
    private static final String TOKEN_HANDLER_SYS_PROP = "weblogic.xml.crypto.wss.provider.SecurityTokenHandler";
    public static final String NONCE_VALIDATOR = "weblogic.wsee.security.nonce.validator";
    private volatile boolean inited = false;
    private boolean isServer = true;
    private String mbeanName = null;
    private List tokenHandlers = null;
    private List credProviders = null;
    private List tokens = null;
    private WssPolicyContextHandler wssContextHandler = new WssPolicyContextHandler();
    private Map classNameToInstanceMap = new HashMap();
    private WebserviceSecurityMBean wsm;
    private TimestampConfiguration timestampConfig;
    private static final boolean HEURISTIC_COMPATIBILITY = WSSCCompatibilityUtil.isHeuristicCompatibility();

    public WssConfiguration() {
        this(null, true);
    }

    public WssConfiguration(boolean bl) {
        this(null, bl);
    }

    public WssConfiguration(String string) {
        this(string, true);
    }

    public WssConfiguration(String string, boolean bl) {
        this.mbeanName = string == null ? "default_wss" : string;
        if (bl) {
            this.isServer = true;
        } else {
            try {
                this.isServer = MBeanHelper.getDomainMBean() != null;
            }
            catch (AssertionError assertionError) {
                this.isServer = false;
            }
        }
    }

    public synchronized void init() throws WssConfigurationException {
        if (!this.inited) {
            this.tokenHandlers = this.createInstancesFromSysProp(System.getProperty(TOKEN_HANDLER_SYS_PROP));
            this.credProviders = this.createInstancesFromSysProp(System.getProperty(CRED_PROVIDER_SYS_PROP));
            if (this.isServer) {
                this.wsm = MBeanHelper.lookupWebserviceSecurityMBean(this.mbeanName);
                if (this.wsm == null && !this.mbeanName.equals("default_wss")) {
                    throw new WssConfigurationException("WebserviceSecurityMBean \"" + this.mbeanName + "\" does not exist");
                }
                this.tokenHandlers.addAll(this.createInstancesFromMBean(MBeanHelper.getTokenHandlerClassNames(this.wsm)));
                this.credProviders.addAll(this.createInstancesFromMBean(MBeanHelper.getCredentialProviderClassNames(this.wsm)));
                this.fillContextHandler();
                this.initDefaultConfiguration();
                this.initCompatibility();
            } else {
                this.initClientBuiltInHandlers();
            }
            this.initTimestampConfiguration();
            NonceValidator nonceValidator = NonceValidatorFactory.getInstance(System.getProperty(TOKEN_HANDLER_SYS_PROP), this.timestampConfig);
            this.inited = true;
        }
    }

    public void destroy() {
        if (this.wsm != null && this.timestampConfig != null) {
            this.wsm.getWebserviceTimestamp().removeBeanUpdateListener(this.timestampConfig);
        }
    }

    public TimestampConfiguration getTimestampConfig() {
        return this.timestampConfig;
    }

    public List getTokenHandlers() throws WssConfigurationException {
        this.init();
        return this.tokenHandlers;
    }

    public List getCredentialProviders() throws WssConfigurationException {
        this.init();
        return this.credProviders;
    }

    public List getSupprotedTokens() throws WssConfigurationException {
        this.init();
        if (this.tokens == null) {
            this.initTokens();
        }
        return this.tokens;
    }

    public CredentialProvider getCredentialProvider(String string, String string2) throws WssConfigurationException {
        this.init();
        String string3 = MBeanHelper.getCredentialProviderClass(this.wsm, string, string2);
        if (string3 != null) {
            Object object = WssConfiguration.createInstance(string3);
            if (object instanceof CredentialProvider) {
                return (CredentialProvider)object;
            }
            throw new WssConfigurationException(string3 + " needs to implement weblogic.xml.crypto.wss.provider.CredentialProvider interface");
        }
        return null;
    }

    public SecurityTokenHandler getTokenHandler(String string, String string2) throws WssConfigurationException {
        Object object;
        Object object2;
        this.init();
        if (string2 != null) {
            object2 = this.tokenHandlers.iterator();
            while (object2.hasNext()) {
                object = (SecurityTokenHandler)object2.next();
                if (!object.getClass().getName().equals(string2)) continue;
                return object;
            }
        }
        if ((object2 = MBeanHelper.getTokenHandlerClass(this.wsm, string, string2)) != null) {
            object = WssConfiguration.createInstance((String)object2);
            if (object instanceof SecurityTokenHandler) {
                return (SecurityTokenHandler)object;
            }
            throw new WssConfigurationException((String)object2 + " needs to implement weblogic.xml.crypto.wss.provider.SecurityTokenHandler");
        }
        if (object2 == null) {
            for (SecurityTokenHandler securityTokenHandler : this.tokenHandlers) {
                String[] stringArray;
                for (String string3 : stringArray = securityTokenHandler.getValueTypes()) {
                    if (!string3.equals(string)) continue;
                    return securityTokenHandler;
                }
            }
        }
        return null;
    }

    public void initTokens() throws WssConfigurationException {
        String[] stringArray = MBeanHelper.getSecurityTokenClassNames(this.wsm);
        this.tokens = new ArrayList();
        for (int i = 0; i < stringArray.length; ++i) {
            this.tokens.add(WssConfiguration.createInstance(stringArray[i]));
        }
    }

    public WssPolicyContextHandler getContextHandler() {
        return this.wssContextHandler;
    }

    public boolean isSignatureACLEnabled() {
        return MBeanHelper.getTokenHandlerPropertyBoolean(this.wsm, "UseX509ForIdentity", false);
    }

    public boolean validateHOKNeeded() {
        return MBeanHelper.getTokenHandlerPropertyBoolean(this.wsm, "EnableHoderOfKeyValidation", true);
    }

    public Long getSCTLifeTime() {
        return new Long((String)MBeanHelper.getCredentialProviderProperty(this.wsm, "TokenLifeTime", MBeanConstants.DEFAULT_SCT_TOKEN_LIFE_TIME));
    }

    public String getDKLabel() {
        return (String)MBeanHelper.getCredentialProviderProperty(this.wsm, "Label", null);
    }

    public Integer getDKLength() {
        return new Integer((String)MBeanHelper.getCredentialProviderProperty(this.wsm, "Length", "-1"));
    }

    public String getDefaultSTSURI() {
        return MBeanHelper.getDefaultCredentialProviderSTSURI(this.wsm);
    }

    public String getSTSURI(String string) {
        return (String)MBeanHelper.getCredentialProviderProperty(this.wsm, string, "StsUri", null);
    }

    public String getSTSPolicy(String string) {
        return (String)MBeanHelper.getCredentialProviderProperty(this.wsm, string, "StsPolicy", null);
    }

    public PolicySelectionPreference getPolicySelectionPreference() {
        PolicySelectionPreference policySelectionPreference = null;
        if (this.wsm != null && this.wsm.getPolicySelectionPreference() != null) {
            policySelectionPreference = new PolicySelectionPreference(this.wsm.getPolicySelectionPreference());
        }
        return policySelectionPreference;
    }

    public Boolean getSamlAttributesOnly(MessageContext messageContext) {
        String string = (String)messageContext.getProperty("oracle.contextelement.saml2.AttributeOnly");
        return Boolean.getBoolean(string);
    }

    public String getCompatibilityPreference(MessageContext messageContext) {
        if (HEURISTIC_COMPATIBILITY) {
            return (String)messageContext.getProperty("weblogic.wsee.policy.compat.preference");
        }
        return this.wsm != null ? this.wsm.getCompatibilityPreference() : null;
    }

    public String getCompatibilityPreference() {
        return this.wsm != null ? this.wsm.getCompatibilityPreference() : null;
    }

    public void setCompatibilityPreference(String string, MessageContext messageContext) {
        if (HEURISTIC_COMPATIBILITY) {
            messageContext.setProperty("weblogic.wsee.policy.compat.preference", (Object)string);
        } else if (this.wsm != null) {
            this.wsm.setCompatibilityPreference(string);
        }
    }

    public String getCompatibilityOrderingPreference() {
        return this.wsm != null ? this.wsm.getCompatibilityOrderingPreference() : null;
    }

    public void setCompatibilityOrderingPreference(String string) {
        if (this.wsm != null) {
            this.wsm.setCompatibilityOrderingPreference(string);
        }
    }

    private void fillContextHandler() {
        this.wssContextHandler.addContextElement("com.bea.contextelement.wsee.credentialProviders", this.credProviders);
        this.wssContextHandler.addContextElement("com.bea.contextelement.wsee.tokenHandlers", this.tokenHandlers);
        MBeanHelper.fillConfigProperties(this.wsm, this.wssContextHandler);
    }

    private void initClientBuiltInHandlers() throws WssConfigurationException {
        this.tokenHandlers.add(ClientBSTHandler.getInstance());
        this.tokenHandlers.add(ClientUNTHandler.getInstance());
        this.tokenHandlers.add((SecurityTokenHandler)WssConfiguration.createInstance("weblogic.wsee.security.wssc.v200502.sct.SCTokenHandler"));
        this.tokenHandlers.add((SecurityTokenHandler)WssConfiguration.createInstance("weblogic.wsee.security.wssc.v200502.dk.DKTokenHandler"));
        this.tokenHandlers.add((SecurityTokenHandler)WssConfiguration.createInstance("weblogic.wsee.security.wssc.v13.sct.SCTokenHandler"));
        this.tokenHandlers.add((SecurityTokenHandler)WssConfiguration.createInstance("weblogic.wsee.security.wssc.v13.dk.DKTokenHandler"));
    }

    private void initDefaultConfiguration() throws WssConfigurationException {
        Object object;
        boolean bl;
        Object object2 = this.findInstance("weblogic.xml.crypto.wss.BinarySecurityTokenHandler");
        if (object2 != null && object2 instanceof BinarySecurityTokenHandler) {
            bl = MBeanHelper.getTokenHandlerPropertyBoolean(this.wsm, "UseX509ForIdentity", false);
            this.wssContextHandler.addContextElement("UseX509ForIdentity", new Boolean(bl));
            if (bl && !SecurityUtils.isX509Supported()) {
                throw new WssConfigurationException("Server is not configured to support assert x509 identity but property \" UseX509ForIdentity\" is true");
            }
            ((BinarySecurityTokenHandler)object2).setAuthorizationToken(bl);
        }
        if ((object2 = this.findInstance("weblogic.xml.crypto.wss.UsernameTokenHandler")) != null && object2 instanceof UsernameTokenHandler) {
            bl = MBeanHelper.getTokenHandlerPropertyBoolean(this.wsm, "UsePasswordDigest", false);
            if (bl && !SecurityUtils.isPasswordDigestSupported()) {
                throw new WssConfigurationException("Server is not configured to support password digest but property \" UsePasswordDigest\" is true");
            }
            ((UsernameTokenHandler)object2).setPasswordDigestSupported(bl);
        }
        if (KernelStatus.isServer() && (object = this.findInstance("weblogic.wsee.security.bst.ServerBSTCredentialProvider")) != null && object instanceof ServerBSTCredentialProvider) {
            ((ServerBSTCredentialProvider)object).initCredentials(this.wssContextHandler);
        }
    }

    private void initTimestampConfiguration() {
        this.timestampConfig = new TimestampConfiguration(MBeanHelper.getTimestampConfig(this.wsm));
    }

    private void initCompatibility() {
    }

    private Object findInstance(String string) {
        return this.classNameToInstanceMap.get(string);
    }

    private List createInstancesFromSysProp(String string) throws WssConfigurationException {
        ArrayList arrayList = new ArrayList();
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                this.addInstance(arrayList, string2, WssConfiguration.createInstance(string2));
            }
        }
        return arrayList;
    }

    private void addInstance(List list, String string, Object object) {
        list.add(object);
        this.classNameToInstanceMap.put(string, object);
    }

    private List createInstancesFromMBean(String[] stringArray) throws WssConfigurationException {
        ArrayList arrayList = new ArrayList();
        for (int i = 0; i < stringArray.length; ++i) {
            this.addInstance(arrayList, stringArray[i], WssConfiguration.createInstance(stringArray[i]));
        }
        return arrayList;
    }

    private static Object createInstance(String string) throws WssConfigurationException {
        try {
            return Class.forName(string).newInstance();
        }
        catch (InstantiationException instantiationException) {
            throw new WssConfigurationException("Could not instantiate object of type " + string, instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new WssConfigurationException("Could not instantiate object of type " + string, illegalAccessException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new WssConfigurationException("Could not instantiate object of type " + string, classNotFoundException);
        }
    }
}

