/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.security.policy;

import com.bea.xml.XmlObject;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.rpc.handler.soap.SOAPMessageContext;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import weblogic.wsee.policy.framework.PolicyException;
import weblogic.wsee.security.policy.EncryptionTarget;
import weblogic.wsee.security.policy.MessagePartsEvaluator;
import weblogic.wsee.security.policy.SecurityToken;
import weblogic.wsee.security.policy.XBeanUtils;
import weblogic.wsee.security.policy.assertions.ConfidentialityAssertion;
import weblogic.wsee.security.policy.assertions.xbeans.ConfidentialityDocument;
import weblogic.wsee.security.policy.assertions.xbeans.ConfidentialityTargetType;
import weblogic.wsee.security.policy.assertions.xbeans.SecurityTokenType;
import weblogic.wsee.util.Verbose;
import weblogic.xml.crypto.dsig.api.CanonicalizationMethod;
import weblogic.xml.crypto.encrypt.api.EncryptionMethod;
import weblogic.xml.crypto.encrypt.api.XMLEncryptionFactory;
import weblogic.xml.crypto.encrypt.api.dom.DOMTBEXML;
import weblogic.xml.crypto.wss.WSSecurityException;

public class EncryptionPolicy {
    public static final boolean verbose = Verbose.isVerbose(EncryptionPolicy.class);
    private EncryptionMethod keyWrapMethod = null;
    private CanonicalizationMethod c14nMethod;
    private List validEncryptionTokens = new ArrayList();
    private List encryptionTargets = new ArrayList();

    public EncryptionPolicy(XMLEncryptionFactory xMLEncryptionFactory, SOAPMessageContext sOAPMessageContext, ConfidentialityAssertion confidentialityAssertion) throws PolicyException, WSSecurityException {
        this(xMLEncryptionFactory, sOAPMessageContext, confidentialityAssertion, true);
    }

    public EncryptionPolicy(XMLEncryptionFactory xMLEncryptionFactory, SOAPMessageContext sOAPMessageContext, ConfidentialityAssertion confidentialityAssertion, boolean bl) throws PolicyException, WSSecurityException {
        Object object;
        Object object2;
        Map map = confidentialityAssertion.getNamespaceMap();
        ConfidentialityDocument.Confidentiality confidentiality = confidentialityAssertion.getXbean().getConfidentiality();
        String string = "http://www.w3.org/2001/10/xml-exc-c14n#";
        try {
            if (confidentiality.getKeyWrappingAlgorithm() != null) {
                this.keyWrapMethod = xMLEncryptionFactory.newEncryptionMethod(confidentiality.getKeyWrappingAlgorithm().getURI(), null, null);
            }
            this.c14nMethod = xMLEncryptionFactory.newCanonicalizationMethod(string, null);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new WSSecurityException(invalidAlgorithmParameterException.getMessage(), invalidAlgorithmParameterException);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new WSSecurityException(noSuchAlgorithmException.getMessage(), noSuchAlgorithmException);
        }
        ConfidentialityTargetType[] confidentialityTargetTypeArray = confidentiality.getTargetArray();
        for (int i = 0; i < confidentialityTargetTypeArray.length; ++i) {
            DOMTBEXML dOMTBEXML;
            Object object3;
            Iterator iterator;
            ConfidentialityTargetType confidentialityTargetType = confidentialityTargetTypeArray[i];
            object2 = null;
            try {
                object = confidentialityTargetType.getEncryptionAlgorithm().getURI();
                object2 = xMLEncryptionFactory.newEncryptionMethod((String)object, null, null);
                if (object2 == null) {
                    throw new WSSecurityException((String)object + " is not a supported encryption algorithm.");
                }
            }
            catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
                throw new WSSecurityException(invalidAlgorithmParameterException.getMessage(), invalidAlgorithmParameterException);
            }
            if (!bl) continue;
            object = null;
            MessagePartsEvaluator messagePartsEvaluator = new MessagePartsEvaluator(confidentialityTargetType.getMessageParts(), sOAPMessageContext, map);
            object = confidentialityTargetType.getEncryptContentOnly() ? messagePartsEvaluator.getNodesContent() : messagePartsEvaluator.getNodes();
            if (object == null || object.size() == 0) {
                if (!verbose) continue;
                Verbose.log("MessageParts expression '" + confidentialityTargetType.getMessageParts() + "' did not evaluate to any nodes in the message; target will be skipped");
                continue;
            }
            ArrayList<DOMTBEXML> arrayList = new ArrayList<DOMTBEXML>();
            if (confidentialityTargetType.getEncryptContentOnly()) {
                iterator = object.iterator();
                while (iterator.hasNext()) {
                    object3 = (NodeList)iterator.next();
                    dOMTBEXML = new DOMTBEXML((NodeList)object3, this.c14nMethod);
                    arrayList.add(dOMTBEXML);
                }
            } else {
                iterator = object.iterator();
                while (iterator.hasNext()) {
                    object3 = (Element)iterator.next();
                    dOMTBEXML = new DOMTBEXML((Element)object3, this.c14nMethod);
                    arrayList.add(dOMTBEXML);
                }
            }
            this.encryptionTargets.add(new EncryptionTarget((EncryptionMethod)object2, arrayList));
        }
        SecurityTokenType[] securityTokenTypeArray = confidentiality.getKeyInfo().getSecurityTokenArray();
        for (int i = 0; i < securityTokenTypeArray.length; ++i) {
            object2 = securityTokenTypeArray[i];
            object = new SecurityToken(XBeanUtils.getElement((XmlObject)object2), null, object2.getTokenType(), object2.getIncludeInMessage());
            ((SecurityToken)object).setDerivedFromTokenType(object2.getDerivedFromTokenType());
            this.validEncryptionTokens.add(object);
        }
    }

    public EncryptionMethod getKeyWrapMethod() {
        return this.keyWrapMethod;
    }

    public CanonicalizationMethod getC14nMethod() {
        return this.c14nMethod;
    }

    public List getValidEncryptionTokens() {
        return this.validEncryptionTokens;
    }

    public List getEncryptionTargets() {
        return this.encryptionTargets;
    }
}

