/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.security.policy;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.rpc.handler.MessageContext;
import javax.xml.rpc.handler.soap.SOAPMessageContext;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPHeaderElement;
import javax.xml.soap.SOAPMessage;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import weblogic.wsee.addressing.SetCookieHeader;
import weblogic.wsee.addressing.TimestampHeader;
import weblogic.wsee.policy.framework.DOMUtils;
import weblogic.wsee.policy.framework.PolicyException;
import weblogic.wsee.reliability.headers.AckRequestedHeader;
import weblogic.wsee.reliability.headers.AcknowledgementHeader;
import weblogic.wsee.reliability.headers.SequenceHeader;
import weblogic.wsee.reliability.headers.WsrmHeader;
import weblogic.wsee.security.policy.assertions.xbeans.MessagePartsType;
import weblogic.wsee.security.policy12.assertions.XPath;
import weblogic.wsee.security.wss.plan.fact.MessagePartsTypeFactory;
import weblogic.wsee.util.Verbose;
import weblogic.wsee.wsa.wsaddressing.WSAddressingConstants;
import weblogic.xml.crypto.wss.WSSecurityContext;
import weblogic.xml.dom.Util;
import weblogic.xml.stax.util.NamespaceContextImpl;
import weblogic.xml.xpath.DOMXPath;
import weblogic.xml.xpath.XPathException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessagePartsEvaluator {
    public static final String XPATH_DIALECT = "http://www.w3.org/TR/1999/REC-xpath-19991116";
    public static final String WSEE_PART_DIALECT = "http://schemas.xmlsoap.org/2002/12/wsse#part";
    public static final String WLS_EXTENSION_DIALECT = "http://www.bea.com/wls90/security/policy/wsee#part";
    public static final String[] ALL_DIALECTS = new String[]{"http://www.w3.org/TR/1999/REC-xpath-19991116", "http://schemas.xmlsoap.org/2002/12/wsse#part", "http://www.bea.com/wls90/security/policy/wsee#part"};
    public static final QName WSEE_PART_BODY = new QName("http://schemas.xmlsoap.org/ws/2004/09/policy", "Body");
    public static final QName WSEE_PART_HEADER = new QName("http://schemas.xmlsoap.org/ws/2004/09/policy", "Header");
    public static final QName WLS_PART_SYSTEM_HEADERS = new QName("http://www.bea.com/wls90/security/policy/wsee#part", "SystemHeaders");
    public static final QName WLS_PART_SECURITY_HEADER = new QName("http://www.bea.com/wls90/security/policy/wsee#part", "SecurityHeader");
    public static final QName XPATH_GET_BODY = new QName("http://schemas.xmlsoap.org/ws/2004/09/policy", "GetBody");
    public static final QName XPATH_GET_HEADER = new QName("http://schemas.xmlsoap.org/ws/2004/09/policy", "GetHeader");
    public static final Set WLS_SYSTEM_SOAP_HEADERS;
    private static boolean verbose;
    private MessagePartsType mparts;
    private XPath xpath;
    private SOAPMessage msg;
    private List nodeList;
    private boolean haveEvaluatedExpr = false;
    private Map<String, String> namespaceMap;
    private SOAPMessageContext mctx;

    public MessagePartsEvaluator(MessagePartsType messagePartsType, SOAPMessageContext sOAPMessageContext, Map map) {
        this.mparts = messagePartsType;
        this.namespaceMap = new HashMap<String, String>(map);
        Map<String, String> map2 = DOMUtils.getNamespaceMapping(messagePartsType.newDomNode().getFirstChild());
        this.namespaceMap.putAll(map2);
        this.mctx = sOAPMessageContext;
        this.msg = sOAPMessageContext.getMessage();
    }

    public MessagePartsEvaluator(XPath xPath, SOAPMessageContext sOAPMessageContext, Map map) {
        this.xpath = xPath;
        this.mparts = MessagePartsTypeFactory.newInstance(xPath.getXPathVersion(), xPath.getXPathExpr());
        Map<String, String> map2 = xPath.getXPathNamespaces();
        if (map2.size() > 0) {
            if (verbose) {
                Verbose.log("Using XPath namespaces (size=" + map2.size() + ") to resolve XPath expression: " + xPath.getXPathExpr());
            }
            this.namespaceMap = this.resolveNamespaceVersions(map2, map, xPath.getXPathExpr());
        } else {
            if (verbose) {
                Verbose.log("Using SOAP message namespaces (size=" + map.size() + ") to resolve XPath expression: " + xPath.getXPathExpr());
            }
            this.namespaceMap = map;
        }
        this.mctx = sOAPMessageContext;
        this.msg = sOAPMessageContext.getMessage();
    }

    private Map<String, String> resolveNamespaceVersions(Map<String, String> map, Map<String, String> map2, String string) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            if (entry.getValue().equals("http://schemas.xmlsoap.org/soap/envelope/") && !map2.containsValue("http://schemas.xmlsoap.org/soap/envelope/") && map2.containsValue("http://www.w3.org/2003/05/soap-envelope")) {
                if (verbose) {
                    Verbose.log("Adjusting XPath expression (" + string + ") to use SOAP 1.2 namespace (instead of SOAP 1.1), since the message is SOAP 1.2");
                }
                hashMap.put(entry.getKey(), "http://www.w3.org/2003/05/soap-envelope");
                continue;
            }
            if (entry.getValue().equals("http://www.w3.org/2003/05/soap-envelope") && !map2.containsValue("http://www.w3.org/2003/05/soap-envelope") && map2.containsValue("http://schemas.xmlsoap.org/soap/envelope/")) {
                if (verbose) {
                    Verbose.log("Adjusting XPath expression (" + string + ") to use SOAP 1.1 namespace (instead of SOAP 1.2), since the message is SOAP 1.1");
                }
                hashMap.put(entry.getKey(), "http://schemas.xmlsoap.org/soap/envelope/");
                continue;
            }
            if (entry.getValue().equals("http://schemas.xmlsoap.org/ws/2004/08/addressing") && !map2.containsValue("http://schemas.xmlsoap.org/ws/2004/08/addressing") && map2.containsValue("http://www.w3.org/2005/08/addressing")) {
                if (verbose) {
                    Verbose.log("Adjusting XPath expression (" + string + ") to use WS-Addressing 1.0 namespace (instead of WS-A 2004/08), since the SOAP message uses WS-A 1.0");
                }
                hashMap.put(entry.getKey(), "http://www.w3.org/2005/08/addressing");
                continue;
            }
            if (entry.getValue().equals("http://www.w3.org/2005/08/addressing") && !map2.containsValue("http://www.w3.org/2005/08/addressing") && map2.containsValue("http://schemas.xmlsoap.org/ws/2004/08/addressing")) {
                if (verbose) {
                    Verbose.log("Adjusting XPath expression (" + string + ") to use WS-Addressing 2004/08 namespace (instead of WS-A 1.0), since the SOAP message uses WS-A 2004/08");
                }
                hashMap.put(entry.getKey(), "http://schemas.xmlsoap.org/ws/2004/08/addressing");
                continue;
            }
            hashMap.put(entry.getKey(), entry.getValue());
        }
        return hashMap;
    }

    public List getNodes() throws PolicyException {
        if (!this.haveEvaluatedExpr) {
            this.evalMessagePartsExpr();
        }
        return this.nodeList;
    }

    public List getNodesContent() throws PolicyException {
        if (!this.haveEvaluatedExpr) {
            this.evalMessagePartsExpr();
        }
        if (this.nodeList != null) {
            List list = DOMUtils.computeContent(this.nodeList);
            if (list.size() == 0) {
                throw new PolicyException("No content nodes found, set encryptContentOnly='false' to encrypt the whole node in your policy file");
            }
            return list;
        }
        return null;
    }

    private void evalMessagePartsExpr() throws PolicyException {
        String string = this.mparts.getDialect();
        if (string == null || string.equals("")) {
            string = XPATH_DIALECT;
        }
        Element element = (Element)this.mparts.newDomNode().getFirstChild();
        String string2 = DOMUtils.getTextContent(element, true);
        if (XPATH_DIALECT.equals(string)) {
            if (string2 == null || string2.length() == 0) {
                throw new PolicyException("Missing XPath expression in MessageParts element");
            }
            this.nodeList = this.evalXPath(string2);
            if (this.nodeList != null) {
                for (Node node : this.nodeList) {
                    if (node.getNodeType() == 1) continue;
                    throw new PolicyException("MessagePart expression '" + string2 + " must evaluate only to Element nodes");
                }
            }
        } else if (WSEE_PART_DIALECT.equals(string)) {
            if (string2 == null || string2.length() == 0) {
                throw new PolicyException("Missing WSEE Parts expression in MessageParts element");
            }
            this.nodeList = this.evalWssePartExpr(string2);
        } else if (WLS_EXTENSION_DIALECT.equals(string)) {
            if (string2 == null || string2.length() == 0) {
                throw new PolicyException("Missing WLS Parts expression in MessageParts element");
            }
            this.nodeList = this.evalWLSPartExpr(string2);
        } else {
            throw new PolicyException("Unknown dialect in MessageParts: " + string);
        }
        this.haveEvaluatedExpr = true;
    }

    private List evalXPath(String string) throws PolicyException {
        if (!string.startsWith("wsp:")) {
            try {
                return MessagePartsEvaluator.getNodeListFromXPath((Node)this.msg.getSOAPPart().getEnvelope(), string, this.namespaceMap);
            }
            catch (SOAPException sOAPException) {
                throw new PolicyException("Could not access SOAP Envelope", sOAPException);
            }
        }
        PartsFunction partsFunction = new PartsFunction(string, this.mparts, this.namespaceMap);
        if (XPATH_GET_BODY.equals(partsFunction.getFuncQName())) {
            try {
                return MessagePartsEvaluator.getNodeListFromXPath((Node)this.msg.getSOAPPart().getEnvelope().getBody(), partsFunction.getFuncArgs(), this.namespaceMap);
            }
            catch (SOAPException sOAPException) {
                throw new PolicyException("Could not access SOAP Body", sOAPException);
            }
        }
        if (XPATH_GET_HEADER.equals(partsFunction.getFuncQName())) {
            try {
                String string2 = partsFunction.getFuncArgs();
                int n = string2.indexOf("wsse:Security");
                if (n > -1) {
                    string2 = "." + string2.substring(n + 13, string2.length());
                    return MessagePartsEvaluator.getNodeListFromXPath(this.getSecurityHeaderFromContext(), string2, this.namespaceMap);
                }
                return MessagePartsEvaluator.getNodeListFromXPath((Node)this.msg.getSOAPPart().getEnvelope().getHeader(), string2, this.namespaceMap);
            }
            catch (SOAPException sOAPException) {
                throw new PolicyException("Could not access SOAP Header", sOAPException);
            }
        }
        throw new PolicyException("Could not handle xpath: " + string);
    }

    private static List getNodeListFromXPath(Node node, String string, Map map) throws PolicyException {
        ArrayList<Node> arrayList = new ArrayList<Node>();
        javax.xml.xpath.XPath xPath = XPathFactory.newInstance().newXPath();
        NamespaceContextImpl namespaceContextImpl = new NamespaceContextImpl();
        for (Object object : map.keySet()) {
            namespaceContextImpl.bindNamespace((String)object, (String)map.get(object));
        }
        xPath.setNamespaceContext((NamespaceContext)namespaceContextImpl);
        try {
            Object object;
            object = (NodeList)xPath.evaluate(string, node, XPathConstants.NODESET);
            if (object == null || object.getLength() == 0) {
                return MessagePartsEvaluator.getNodeList(node, string);
            }
            for (int i = 0; i < object.getLength(); ++i) {
                arrayList.add(object.item(i));
            }
        }
        catch (XPathExpressionException xPathExpressionException) {
            return MessagePartsEvaluator.getNodeList(node, string);
        }
        return arrayList;
    }

    private static List getNodeList(Node node, String string) throws PolicyException {
        ArrayList<Node> arrayList = new ArrayList<Node>();
        try {
            DOMXPath dOMXPath = new DOMXPath(string);
            Set set = dOMXPath.evaluateAsNodeset(node);
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                arrayList.add((Node)iterator.next());
            }
        }
        catch (XPathException xPathException) {
            throw new PolicyException("Could not parse XPath expression: " + string, xPathException);
        }
        if (arrayList.size() == 0) {
            throw new PolicyException("Can not resolve Target in MessageParts: " + string);
        }
        return arrayList;
    }

    private List evalWssePartExpr(String string) throws PolicyException {
        ArrayList<SOAPBody> arrayList = new ArrayList<SOAPBody>();
        PartsFunction partsFunction = new PartsFunction(string, this.mparts, this.namespaceMap);
        if (WSEE_PART_BODY.equals(partsFunction.getFuncQName())) {
            if (partsFunction.getFuncArgs().length() > 0) {
                throw new PolicyException("Malformed WSSE Parts 'Body' expression: '" + string + "'");
            }
            arrayList.add(this.getSOAPBody());
        } else if (WSEE_PART_HEADER.equals(partsFunction.getFuncQName())) {
            if (partsFunction.getFuncArgs().length() == 0) {
                throw new PolicyException("Malformed WSSE Parts 'Header' expression: '" + string + "'");
            }
            QName qName = partsFunction.getFuncArgsAsQName();
            arrayList.addAll(this.getSOAPHeaders(qName));
        } else {
            throw new PolicyException("Unrecognized function name in WSSE Message Parts expression: '" + partsFunction + "'");
        }
        if (arrayList.size() == 0) {
            throw new PolicyException("Can not resolve Target in MessageParts: " + string);
        }
        return arrayList;
    }

    private List evalWLSPartExpr(String string) throws PolicyException {
        ArrayList arrayList = new ArrayList();
        PartsFunction partsFunction = new PartsFunction(string, this.mparts, this.namespaceMap);
        if (WLS_PART_SYSTEM_HEADERS.equals(partsFunction.getFuncQName())) {
            if (partsFunction.getFuncArgs().length() > 0) {
                throw new PolicyException("Malformed WLS Parts '" + WLS_PART_SYSTEM_HEADERS.getLocalPart() + "' expression: '" + string + "'");
            }
            arrayList.addAll(this.getSOAPSystemHeaders());
        } else if (WLS_PART_SECURITY_HEADER.equals(partsFunction.getFuncQName())) {
            arrayList.addAll(this.getSecurityHeader(partsFunction.getFuncArgsAsQName()));
        } else {
            throw new PolicyException("Unrecognized function name in WLS Message Parts expression: '" + partsFunction + "'");
        }
        return arrayList;
    }

    private SOAPBody getSOAPBody() throws PolicyException {
        try {
            return this.msg.getSOAPPart().getEnvelope().getBody();
        }
        catch (SOAPException sOAPException) {
            throw new PolicyException("Could not access SOAP Envelope", sOAPException);
        }
    }

    private List getSOAPHeaders(QName qName) throws PolicyException {
        ArrayList<SOAPHeaderElement> arrayList = new ArrayList<SOAPHeaderElement>();
        SOAPHeader sOAPHeader = null;
        try {
            sOAPHeader = this.msg.getSOAPPart().getEnvelope().getHeader();
        }
        catch (SOAPException sOAPException) {
            throw new PolicyException("Could not access SOAP Headers");
        }
        Iterator iterator = sOAPHeader.examineAllHeaderElements();
        while (iterator.hasNext()) {
            SOAPHeaderElement sOAPHeaderElement = (SOAPHeaderElement)iterator.next();
            if (!DOMUtils.equalsQName((Node)sOAPHeaderElement, qName)) continue;
            arrayList.add(sOAPHeaderElement);
        }
        return arrayList;
    }

    private Element getSecurityHeaderFromContext() throws PolicyException {
        Object object;
        Element element = null;
        WSSecurityContext wSSecurityContext = WSSecurityContext.getSecurityContext((MessageContext)this.mctx);
        if (wSSecurityContext != null) {
            element = wSSecurityContext.getSecurityElement();
        }
        if (element == null) {
            object = this.mctx.getMessage();
            try {
                NodeList nodeList = object.getSOAPHeader().getElementsByTagNameNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "Security");
                if (nodeList.getLength() > 0) {
                    element = (Element)nodeList.item(0);
                }
            }
            catch (SOAPException sOAPException) {
                // empty catch block
            }
        }
        if (element == null) {
            if (verbose) {
                object = Util.printNode((Node)this.mctx.getMessage().getSOAPPart());
                throw new PolicyException("Can not retrieve wsee:Security header from the message: " + (String)object);
            }
            throw new PolicyException("Can not retrieve wsee:Security header from the message.");
        }
        return element;
    }

    private Collection getSecurityHeader(QName qName) throws PolicyException {
        ArrayList<Node> arrayList = new ArrayList<Node>();
        Element element = this.getSecurityHeaderFromContext();
        boolean bl = qName.getNamespaceURI() == null || qName.getNamespaceURI().length() == 0;
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1) continue;
            if (bl) {
                if (!node.getLocalName().equals(qName.getLocalPart())) continue;
                arrayList.add(node);
                continue;
            }
            if (!DOMUtils.equalsQName(node, qName)) continue;
            arrayList.add(node);
        }
        if (arrayList.size() == 0) {
            throw new PolicyException("Can not retrieve header: " + qName);
        }
        return arrayList;
    }

    private Collection getSOAPSystemHeaders() throws PolicyException {
        ArrayList<Element> arrayList = new ArrayList<Element>();
        SOAPHeader sOAPHeader = null;
        try {
            sOAPHeader = this.msg.getSOAPPart().getEnvelope().getHeader();
        }
        catch (SOAPException sOAPException) {
            throw new PolicyException("Could not access SOAP Headers");
        }
        for (Node node = sOAPHeader.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (1 != node.getNodeType()) continue;
            Element element = (Element)node;
            for (QName qName : WLS_SYSTEM_SOAP_HEADERS) {
                if (!DOMUtils.equalsQName(element, qName)) continue;
                arrayList.add(element);
            }
        }
        return arrayList;
    }

    static {
        HashSet<QName> hashSet = new HashSet<QName>();
        hashSet.addAll(WsrmHeader.getQNames(AcknowledgementHeader.class));
        hashSet.addAll(WsrmHeader.getQNames(AckRequestedHeader.class));
        hashSet.addAll(WsrmHeader.getQNames(SequenceHeader.class));
        hashSet.add(WSAddressingConstants.WSA_HEADER_ACTION_10);
        hashSet.add(WSAddressingConstants.WSA_HEADER_ACTION);
        hashSet.add(WSAddressingConstants.WSA_HEADER_FAULT_TO_10);
        hashSet.add(WSAddressingConstants.WSA_HEADER_FAULT_TO);
        hashSet.add(WSAddressingConstants.WSA_HEADER_SOURCE_10);
        hashSet.add(WSAddressingConstants.WSA_HEADER_SOURCE);
        hashSet.add(WSAddressingConstants.WSA_HEADER_MESSAGE_ID_10);
        hashSet.add(WSAddressingConstants.WSA_HEADER_MESSAGE_ID);
        hashSet.add(WSAddressingConstants.WSA_HEADER_RELATES_TO_10);
        hashSet.add(WSAddressingConstants.WSA_HEADER_RELATES_TO);
        hashSet.add(WSAddressingConstants.WSA_HEADER_REPLY_TO_10);
        hashSet.add(WSAddressingConstants.WSA_HEADER_REPLY_TO);
        hashSet.add(SetCookieHeader.NAME);
        hashSet.add(TimestampHeader.NAME);
        hashSet.add(WSAddressingConstants.WSA_HEADER_TO_10);
        hashSet.add(WSAddressingConstants.WSA_HEADER_TO);
        WLS_SYSTEM_SOAP_HEADERS = hashSet;
        verbose = Verbose.isVerbose(MessagePartsEvaluator.class);
    }

    private static class PartsFunction {
        private QName funcQName;
        private String funcArgs;
        private Node messageParts;
        private String funcExpr;
        private Map namespaceMap = new HashMap();
        private QName funcArgsAsQName = null;

        public PartsFunction(String string, MessagePartsType messagePartsType, Map map) throws PolicyException {
            this.namespaceMap = map;
            Element element = (Element)messagePartsType.newDomNode().getFirstChild();
            String string2 = string.trim();
            int n = string2.indexOf(40);
            if (n <= 0) {
                throw new PolicyException("Malformed WSEE Parts expression: '" + string + "'");
            }
            String string3 = string2.substring(0, n);
            this.funcQName = DOMUtils.getQNameOf(string3, element, map);
            int n2 = string2.indexOf(41, n);
            if (n2 < 0) {
                throw new PolicyException("Malformed WSEE Parts expression: '" + string + "'");
            }
            this.funcArgs = string2.substring(n + 1, n2);
            if (n2 != string2.length() - 1) {
                String string4 = string2.substring(n2 + 1);
                this.funcArgs = this.funcArgs + string4;
            }
            this.messageParts = element;
            this.funcExpr = string;
            this.funcArgsAsQName = DOMUtils.getQNameOf(this.funcArgs, element, map);
        }

        public QName getFuncQName() {
            return this.funcQName;
        }

        public String getFuncArgs() {
            return this.funcArgs;
        }

        public QName getFuncArgsAsQName() {
            return this.funcArgsAsQName;
        }

        public String toString() {
            return this.funcExpr;
        }
    }
}

