/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.security.policy;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import weblogic.wsee.policy.framework.NormalizedExpression;
import weblogic.wsee.policy.framework.PolicyAlternative;
import weblogic.wsee.policy.framework.PolicyAssertion;
import weblogic.wsee.policy.framework.PolicyException;
import weblogic.wsee.security.policy.assertions.ConfidentialityAssertion;
import weblogic.wsee.security.policy.assertions.IdentityAssertion;
import weblogic.wsee.security.policy.assertions.IntegrityAssertion;
import weblogic.wsee.security.policy.assertions.SecurityPolicyAssertion;
import weblogic.wsee.security.policy.assertions.xbeans.SecurityTokenType;
import weblogic.wsee.security.policy12.assertions.AbstractSupportingTokens;
import weblogic.wsee.security.policy12.assertions.AsymmetricBinding;
import weblogic.wsee.security.policy12.assertions.EncryptedElements;
import weblogic.wsee.security.policy12.assertions.EncryptedParts;
import weblogic.wsee.security.policy12.assertions.QNameParts;
import weblogic.wsee.security.policy12.assertions.RequireDerivedKeys;
import weblogic.wsee.security.policy12.assertions.RequiredParts;
import weblogic.wsee.security.policy12.assertions.SignedElements;
import weblogic.wsee.security.policy12.assertions.SignedParts;
import weblogic.wsee.security.policy12.assertions.SupportingTokens;
import weblogic.wsee.security.policy12.assertions.SymmetricBinding;
import weblogic.wsee.security.policy12.assertions.X509Token;
import weblogic.wsee.security.wssp.AsymmetricBindingInfo;
import weblogic.wsee.security.wssp.SamlTokenAssertion;
import weblogic.wsee.security.wssp.SecurityPolicyAssertionInfo;
import weblogic.wsee.security.wssp.SecurityPolicyAssertionInfoFactory;
import weblogic.wsee.security.wssp.SupportingTokensAssertion;
import weblogic.wsee.security.wssp.TokenAssertion;
import weblogic.wsee.security.wssp.UsernameTokenAssertion;
import weblogic.wsee.util.Verbose;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SecurityPolicyAssertionHelper {
    private static final boolean verbose = Verbose.isVerbose(SecurityPolicyAssertionHelper.class);
    private static final boolean DEBUG = true;

    public static List<String> getAllSupportedTokenTypes(PolicyAlternative policyAlternative) {
        Object object;
        Object object2;
        ArrayList<String> arrayList = new ArrayList<String>();
        if (policyAlternative == null) {
            return arrayList;
        }
        Set set = policyAlternative.getAssertions(IdentityAssertion.class);
        for (SecurityPolicyAssertion securityPolicyAssertion : set) {
            object2 = ((IdentityAssertion)securityPolicyAssertion).getXbean().getIdentity();
            object = object2.getSupportedTokens();
            if (object == null) continue;
            SecurityPolicyAssertionHelper.addTokenType(arrayList, object.getSecurityTokenArray());
        }
        set = policyAlternative.getAssertions(ConfidentialityAssertion.class);
        for (SecurityPolicyAssertion securityPolicyAssertion : set) {
            object2 = ((ConfidentialityAssertion)securityPolicyAssertion).getXbean().getConfidentiality();
            object = object2.getKeyInfo();
            SecurityPolicyAssertionHelper.addTokenType(arrayList, object.getSecurityTokenArray());
        }
        set = policyAlternative.getAssertions(IntegrityAssertion.class);
        for (SecurityPolicyAssertion securityPolicyAssertion : set) {
            object2 = ((IntegrityAssertion)securityPolicyAssertion).getXbean().getIntegrity();
            object = object2.getSupportedTokens();
            if (object == null) continue;
            SecurityPolicyAssertionHelper.addTokenType(arrayList, object.getSecurityTokenArray());
        }
        return arrayList;
    }

    private static void addTokenType(List<String> list, SecurityTokenType[] securityTokenTypeArray) {
        for (SecurityTokenType securityTokenType : securityTokenTypeArray) {
            String string;
            String string2 = securityTokenType.getTokenType();
            if (!list.contains(string2)) {
                list.add(string2);
            }
            if (!securityTokenType.isSetDerivedFromTokenType() || list.contains(string = securityTokenType.getDerivedFromTokenType())) continue;
            list.add(string);
        }
    }

    public static void checkLogicalError(NormalizedExpression normalizedExpression) throws PolicyException {
        if (normalizedExpression.getPolicyAlternatives() == null) {
            return;
        }
        int n = 0;
        for (PolicyAlternative policyAlternative : normalizedExpression.getPolicyAlternatives()) {
            int n2 = SecurityPolicyAssertionHelper.policyLogicalErrorDetector(policyAlternative);
            if (n2 == 0) {
                return;
            }
            n = n2;
        }
        if (!verbose) {
            // empty if block
        }
        Verbose.say("Policy Error code = " + n + " Policy :\n" + normalizedExpression);
        System.err.println("Policy Error code = " + n + " Error Policy :\n" + normalizedExpression);
        throw new PolicyException("Policy logical error found,  error code =" + n);
    }

    public static int policyLogicalErrorDetector(PolicyAlternative policyAlternative) {
        return SecurityPolicyAssertionHelper.policyLogicalErrorDetector(policyAlternative, false);
    }

    public static int policyLogicalErrorDetectorRuntime(PolicyAlternative policyAlternative) {
        return SecurityPolicyAssertionHelper.policyLogicalErrorDetector(policyAlternative, true);
    }

    private static int policyLogicalErrorDetector(PolicyAlternative policyAlternative, boolean bl) {
        if (null == policyAlternative) {
            throw new IllegalArgumentException("Null Policy Alternative");
        }
        if (policyAlternative.isEmpty()) {
            return 0;
        }
        int n = 0;
        if (bl && (n = SecurityPolicyAssertionHelper.checkPartsError(policyAlternative)) != 0) {
            return n;
        }
        SecurityPolicyAssertionInfo securityPolicyAssertionInfo = SecurityPolicyAssertionInfoFactory.getSecurityPolicyAssertionInfo(policyAlternative);
        if (securityPolicyAssertionInfo == null || !securityPolicyAssertionInfo.isMessageSecurityEnabled()) {
            return 0;
        }
        if (bl && (n = SecurityPolicyAssertionHelper.checkTokenInclusion(securityPolicyAssertionInfo.getAsymmetricBindingInfo())) != 0) {
            return n;
        }
        return SecurityPolicyAssertionHelper.checkSamlError(securityPolicyAssertionInfo);
    }

    private static int checkTokenInclusion(AsymmetricBindingInfo asymmetricBindingInfo) {
        if (null == asymmetricBindingInfo) {
            return 0;
        }
        TokenAssertion.TokenInclusion tokenInclusion = null;
        TokenAssertion.TokenInclusion tokenInclusion2 = null;
        if (asymmetricBindingInfo.getRecipientTokenAssertion() != null) {
            if (asymmetricBindingInfo.getRecipientTokenAssertion().getX509TokenAssertion() != null) {
                tokenInclusion2 = asymmetricBindingInfo.getRecipientTokenAssertion().getX509TokenAssertion().getTokenInclusion();
            }
        } else if (asymmetricBindingInfo.getRecipientSignatureTokenAssertion() != null) {
            if (asymmetricBindingInfo.getRecipientSignatureTokenAssertion().getX509TokenAssertion() != null) {
                tokenInclusion2 = asymmetricBindingInfo.getRecipientSignatureTokenAssertion().getX509TokenAssertion().getTokenInclusion();
            }
        } else if (asymmetricBindingInfo.getRecipientEncryptionTokenAssertion() != null && asymmetricBindingInfo.getRecipientEncryptionTokenAssertion().getX509TokenAssertion() != null) {
            tokenInclusion2 = asymmetricBindingInfo.getRecipientEncryptionTokenAssertion().getX509TokenAssertion().getTokenInclusion();
        }
        if (!TokenAssertion.TokenInclusion.TO_INITIATOR_ONLY.equals((Object)tokenInclusion2) && !TokenAssertion.TokenInclusion.TO_RECIPIENT_ONLY.equals((Object)tokenInclusion2)) {
            return 0;
        }
        if (asymmetricBindingInfo.getInitiatorTokenAssertion() != null) {
            if (asymmetricBindingInfo.getInitiatorTokenAssertion().getX509TokenAssertion() != null) {
                tokenInclusion = asymmetricBindingInfo.getInitiatorTokenAssertion().getX509TokenAssertion().getTokenInclusion();
            } else if (asymmetricBindingInfo.getInitiatorTokenAssertion().getSamlTokenAssertion() != null) {
                tokenInclusion = asymmetricBindingInfo.getInitiatorTokenAssertion().getSamlTokenAssertion().getTokenInclusion();
            }
        } else if (asymmetricBindingInfo.getInitiatorSignatureTokenAssertion() != null) {
            if (asymmetricBindingInfo.getInitiatorSignatureTokenAssertion().getX509TokenAssertion() != null) {
                tokenInclusion = asymmetricBindingInfo.getInitiatorSignatureTokenAssertion().getX509TokenAssertion().getTokenInclusion();
            } else if (asymmetricBindingInfo.getInitiatorSignatureTokenAssertion().getSamlTokenAssertion() != null) {
                tokenInclusion = asymmetricBindingInfo.getInitiatorSignatureTokenAssertion().getSamlTokenAssertion().getTokenInclusion();
            }
        } else if (asymmetricBindingInfo.getInitiatorEncryptionTokenAssertion() != null) {
            if (asymmetricBindingInfo.getInitiatorEncryptionTokenAssertion().getX509TokenAssertion() != null) {
                tokenInclusion = asymmetricBindingInfo.getInitiatorEncryptionTokenAssertion().getX509TokenAssertion().getTokenInclusion();
            } else if (asymmetricBindingInfo.getInitiatorEncryptionTokenAssertion().getSamlTokenAssertion() != null) {
                tokenInclusion = asymmetricBindingInfo.getInitiatorEncryptionTokenAssertion().getSamlTokenAssertion().getTokenInclusion();
            }
        }
        if (tokenInclusion.equals((Object)tokenInclusion2)) {
            if (!verbose) {
                // empty if block
            }
            Verbose.say("Inititiator Token = " + (Object)((Object)tokenInclusion) + " and Reciptient Token = " + (Object)((Object)tokenInclusion2));
            return 8642;
        }
        return 0;
    }

    private static int checkSamlError(SecurityPolicyAssertionInfo securityPolicyAssertionInfo) {
        Object object;
        boolean bl = false;
        SupportingTokensAssertion supportingTokensAssertion = securityPolicyAssertionInfo.getSupportingTokensAssertion();
        if (null == supportingTokensAssertion) {
            return 0;
        }
        AsymmetricBindingInfo asymmetricBindingInfo = securityPolicyAssertionInfo.getAsymmetricBindingInfo();
        SamlTokenAssertion samlTokenAssertion = null;
        SamlTokenAssertion samlTokenAssertion2 = null;
        UsernameTokenAssertion usernameTokenAssertion = null;
        if (asymmetricBindingInfo == null) {
            object = securityPolicyAssertionInfo.getSymmetricBindingInfo();
            if (object != null) {
                if (object.getProtectionTokenAssertion() != null) {
                    samlTokenAssertion = object.getProtectionTokenAssertion().getSamlTokenAssertion();
                } else if (object.getSignatureTokenAssertion() != null) {
                    samlTokenAssertion = object.getSignatureTokenAssertion().getSamlTokenAssertion();
                }
            }
        } else {
            object = asymmetricBindingInfo.getInitiatorTokenAssertion();
            if (object != null) {
                samlTokenAssertion = object.getSamlTokenAssertion();
            } else if (asymmetricBindingInfo.getInitiatorSignatureTokenAssertion() != null) {
                samlTokenAssertion = asymmetricBindingInfo.getInitiatorSignatureTokenAssertion().getSamlTokenAssertion();
            }
        }
        object = new ArrayList<TokenAssertion>();
        object.addAll(supportingTokensAssertion.getSignedSupportingTokens());
        object.addAll(supportingTokensAssertion.getSupportingTokens());
        object.addAll(supportingTokensAssertion.getSignedEncryptedSupportingTokens());
        object.addAll(supportingTokensAssertion.getEncryptedSupportingTokens());
        if (object.isEmpty()) {
            return 0;
        }
        for (int i = 0; i < object.size(); ++i) {
            if (object.get(i) instanceof SamlTokenAssertion) {
                samlTokenAssertion2 = (SamlTokenAssertion)object.get(i);
            }
            if (!(object.get(i) instanceof UsernameTokenAssertion)) continue;
            usernameTokenAssertion = (UsernameTokenAssertion)object.get(i);
        }
        if (samlTokenAssertion != null && samlTokenAssertion2 != null) {
            return 8665;
        }
        if ((samlTokenAssertion != null || samlTokenAssertion2 != null) && usernameTokenAssertion != null) {
            return 8628;
        }
        return 0;
    }

    private static int checkPartsError(PolicyAlternative policyAlternative) {
        int n = 0;
        Iterator iterator = null;
        Set set = policyAlternative.getAssertions(RequiredParts.class);
        if (!set.isEmpty()) {
            for (QNameParts qNameParts : set) {
                if (qNameParts.getBody() != null) {
                    if (verbose) {
                        Verbose.log("Invalid policy for required body part");
                    }
                    n = 8416;
                }
                if (qNameParts.getUnknown() == null) continue;
                if (verbose) {
                    Verbose.log("Invalid policy for unknown required parts");
                }
                n = 8418;
            }
        }
        if (!(set = policyAlternative.getAssertions(SignedParts.class)).isEmpty()) {
            for (QNameParts qNameParts : set) {
                if (qNameParts.getUnknown() == null) continue;
                if (verbose) {
                    Verbose.log("Invalid policy for unkown signature part");
                }
                n = 8438;
            }
        }
        if (!(set = policyAlternative.getAssertions(EncryptedParts.class)).isEmpty()) {
            for (QNameParts qNameParts : set) {
                if (qNameParts.getUnknown() == null) continue;
                if (verbose) {
                    Verbose.log("Invalid policy for encryption unknow parts");
                }
                n = 8458;
            }
        }
        return n;
    }

    public static boolean hasOptionalAttribute(PolicyAlternative policyAlternative) {
        if (null == policyAlternative) {
            throw new IllegalArgumentException("Null Policy Alternative");
        }
        if (policyAlternative.isEmpty()) {
            return false;
        }
        Set set = policyAlternative.getAssertions();
        if (set == null || set.isEmpty()) {
            return false;
        }
        for (Object e : set) {
            PolicyAssertion policyAssertion;
            if (e instanceof SymmetricBinding) {
                RequireDerivedKeys requireDerivedKeys;
                X509Token x509Token;
                policyAssertion = (SymmetricBinding)e;
                if (((SymmetricBinding)policyAssertion).getProtectionToken() == null || (x509Token = ((SymmetricBinding)policyAssertion).getProtectionToken().getX509Token()) == null || x509Token.getRequireDerivedKeys() == null || !(requireDerivedKeys = x509Token.getRequireDerivedKeys()).isOptional()) continue;
                return true;
            }
            if (e instanceof SupportingTokens) {
                policyAssertion = (SupportingTokens)e;
                if (((AbstractSupportingTokens)policyAssertion).getX509Token() == null || ((AbstractSupportingTokens)policyAssertion).getX509Token().getRequireDerivedKeys() == null || !((AbstractSupportingTokens)policyAssertion).getX509Token().getRequireDerivedKeys().isOptional()) continue;
                return true;
            }
            if (e instanceof EncryptedParts) {
                policyAssertion = (EncryptedParts)e;
                continue;
            }
            if (!(e instanceof SignedParts)) continue;
            policyAssertion = (SignedParts)e;
        }
        return false;
    }

    public static PolicyAlternative getPolicyAlternativeWithoutOption(PolicyAlternative policyAlternative) {
        if (!SecurityPolicyAssertionHelper.hasOptionalAttribute(policyAlternative)) {
            return null;
        }
        PolicyAlternative policyAlternative2 = policyAlternative.clone();
        if (null == policyAlternative2) {
            return null;
        }
        Set set = policyAlternative2.getAssertions();
        if (set == null || set.isEmpty()) {
            return null;
        }
        for (Object e : set) {
            PolicyAssertion policyAssertion;
            if (e instanceof SymmetricBinding) {
                X509Token x509Token;
                policyAssertion = (SymmetricBinding)e;
                if (((SymmetricBinding)policyAssertion).getProtectionToken() == null || (x509Token = ((SymmetricBinding)policyAssertion).getProtectionToken().getX509Token()) == null || x509Token.getRequireDerivedKeys() == null) continue;
                x509Token.setOptional(false);
                x509Token.getRequireDerivedKeys().setOptional(false);
                continue;
            }
            if (e instanceof AsymmetricBinding) {
                policyAssertion = (AsymmetricBinding)e;
                if (((AsymmetricBinding)policyAssertion).getInitiatorToken() == null || ((AsymmetricBinding)policyAssertion).getInitiatorToken().getX509Token() == null || ((AsymmetricBinding)policyAssertion).getInitiatorToken().getX509Token().getRequireDerivedKeys() == null) continue;
                ((AsymmetricBinding)policyAssertion).getInitiatorToken().getX509Token().setOptional(false);
                ((AsymmetricBinding)policyAssertion).getInitiatorToken().getX509Token().getRequireDerivedKeys().setOptional(false);
                continue;
            }
            if (e instanceof SupportingTokens) {
                policyAssertion = (SupportingTokens)e;
                policyAssertion.setOptional(false);
                if (((AbstractSupportingTokens)policyAssertion).getX509Token() != null && ((AbstractSupportingTokens)policyAssertion).getX509Token().getRequireDerivedKeys() != null) {
                    ((AbstractSupportingTokens)policyAssertion).getX509Token().setOptional(false);
                    ((AbstractSupportingTokens)policyAssertion).getX509Token().getRequireDerivedKeys().setOptional(false);
                    continue;
                }
                if (((AbstractSupportingTokens)policyAssertion).getUsernameToken() != null) {
                    ((AbstractSupportingTokens)policyAssertion).getUsernameToken().setOptional(false);
                    continue;
                }
                if (((AbstractSupportingTokens)policyAssertion).getSamlToken() != null) {
                    ((AbstractSupportingTokens)policyAssertion).getSamlToken().setOptional(false);
                    continue;
                }
                if (((AbstractSupportingTokens)policyAssertion).getSecureConversationToken() == null) continue;
                ((AbstractSupportingTokens)policyAssertion).getSecureConversationToken().setOptional(false);
                continue;
            }
            if (e instanceof EncryptedParts) {
                policyAssertion = (EncryptedParts)e;
                policyAssertion.setOptional(false);
                ((QNameParts)policyAssertion).setBodyOptional(false);
                continue;
            }
            if (e instanceof SignedParts) {
                policyAssertion = (SignedParts)e;
                ((QNameParts)policyAssertion).setBodyOptional(false);
                policyAssertion.setOptional(false);
                continue;
            }
            if (e instanceof EncryptedElements) {
                policyAssertion = (EncryptedElements)e;
                policyAssertion.setOptional(false);
                continue;
            }
            if (!(e instanceof SignedElements)) continue;
            policyAssertion = (SignedElements)e;
            policyAssertion.setOptional(false);
        }
        return policyAlternative2;
    }
}

